# 画面設計書 27-パスワード変更画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「パスワード変更画面」の設計仕様を定義するものである。ログインユーザーが自身のパスワードを変更するための機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、セキュリティ強化のためにユーザーが定期的にパスワードを変更したり、パスワード漏洩が疑われる場合に新しいパスワードを設定できるようにすることを目的としている。現在のパスワードによる認証を必要とし、不正なパスワード変更を防止する設計となっている。

**画面へのアクセス方法**：ログイン後、ユーザー設定画面のPasswordタブからアクセスする。URLパスは `/settings/password/` である。未ログイン状態でアクセスするとログイン画面へリダイレクトされる。

**主要な操作・処理内容**：
1. ログイン認証状態を確認する
2. 現在のパスワード、新しいパスワード、確認用パスワードを入力する
3. 現在のパスワードでユーザーを認証する
4. 新しいパスワードのバリデーション（8文字以上、確認一致）を実行する
5. パスワードをハッシュ化してデータベースを更新する
6. パスワード強度チェック（Ajax）を提供する

**画面遷移**：
- 遷移元：ユーザー設定画面（Passwordタブ）、ナビゲーションメニュー
- 遷移先：ユーザー設定画面（Profileタブ）、購読設定画面（Subscriptionsタブ）、ログイン画面（未認証時）

**権限による表示制御**：ログイン認証が必須。未認証の場合はログイン画面へフォワードされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | パスワード変更 | 主機能 | パスワードの変更処理を実行 |
| 63 | 入力検証 | 補助機能 | パスワード変更フォームのバリデーション |

## 画面種別

編集（パスワード変更フォーム）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /settings/password/ | SettingsController::passwordAction |
| POST | /settings/password/ | SettingsController::passwordAction（フォーム送信） |
| GET | /settings/passwordcheck/?password={password} | SettingsController::passwordcheckAction（Ajax） |

## 入出力項目

### 入力項目（フォーム）

| 項目名 | フィールド名 | データ型 | 必須 | バリデーション | 備考 |
|--------|-------------|---------|------|---------------|------|
| 現在のパスワード | oldpassword | String | はい | 8文字以上、DB認証 | - |
| 新しいパスワード | password | String | はい | 8文字以上 | onblurで強度チェック |
| 確認用パスワード | password2 | String | はい | 8文字以上、passwordと一致 | - |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 変更成功メッセージ | String | "Password Changed" |
| バリデーションエラー | Array | 入力検証エラーメッセージ |
| パスワード強度 | String | 強度レベル（Very weak〜Very strong） |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | h2見出し | "Account Settings: Password" |
| タブ：Profile | リンク | ユーザー設定画面への遷移 |
| タブ：Password | アクティブ状態 | 現在表示中 |
| タブ：Subscriptions | リンク | 購読設定画面への遷移 |
| 変更成功メッセージ | 情報ボックス | "Password Changed" |
| エラーメッセージ | エラーボックス | パスワード認証失敗時のメッセージ |
| Passwordフィールドセット | fieldset | 3つのパスワード入力欄 |
| パスワード強度表示 | ContentPane | passwordResponseエリアに動的表示 |
| 保存ボタン | button | フォーム送信 |
| 検索ボックス | 部分テンプレート | サイト内検索 |
| サイドバーローテーター | 部分テンプレート | 広告・バナー表示 |

## イベント仕様

### 1-画面初期表示

ログイン認証を確認してフォームを表示する。

**処理フロー**：
1. `Zend_Auth::getInstance()->hasIdentity()` で認証確認
2. 未認証の場合は `AuthController::loginAction` へフォワード
3. 空のパスワードフォームを表示

### 2-パスワード変更（フォーム送信）

現在のパスワードで認証し、新しいパスワードを設定する。

**処理フロー**：
1. POSTリクエストを受信
2. oldpasswordでユーザーをDB認証（MD5ハッシュ + salt + サイトキー）
3. 認証失敗時：「Invalid Current Password」エラーを表示
4. 認証成功時：Zend_Filter_Inputでバリデーション実行
5. バリデーション成功時：
   - 新しいsaltを生成（generatepasswordメソッド）
   - パスワードをMD5ハッシュ化（サイトキー + パスワード + salt）
   - usersテーブルのuser_password, user_saltを更新
   - "Password Changed"メッセージを表示
6. バリデーション失敗時：エラーメッセージを表示

### 3-パスワード強度チェック（Ajax）

新しいパスワード入力時にリアルタイムで強度をチェックする。

**処理フロー**：
1. 新しいパスワード入力欄からonblurでAjaxリクエスト
2. CMS_Password_Strengthクラスで強度を計算
3. スコアに応じた強度レベルを返却：
   - 25以下：Very weak password
   - 50以下：Weak password
   - 60以下：Quite strong password
   - 80以下：Strong password
   - 80超：Very strong password

### 4-タブ切替

Profile/Password/Subscriptionsタブをクリックして画面を切り替える。

| タブ | 遷移先URL | 説明 |
|-----|----------|------|
| Profile | /settings/ | ユーザー設定画面 |
| Password | - | 現在の画面（アクティブ） |
| Subscriptions | /settings/subscriptions/ | 購読設定画面 |

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 現在パスワード認証 | users | SELECT | パスワード一致確認 |
| パスワード更新 | users | UPDATE | 新パスワードとsalt更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id | = ログインユーザーID | 認証確認 |
| SELECT | user_password | = MD5(サイトキー + 入力値 + salt) | 現在パスワード確認 |
| SELECT | user_salt | - | ハッシュ計算用 |
| UPDATE | user_password | MD5(サイトキー + 新パスワード + 新salt) | 新ハッシュ値 |
| UPDATE | user_salt | 新規生成(8文字ランダム) | 新salt |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-PWD-001 | 成功 | Password Changed | パスワード変更成功時 |
| MSG-PWD-002 | エラー | Invalid Current Password - the password you entered is incorrect | 現在パスワード認証失敗 |
| MSG-PWD-003 | エラー | Missing Current Password - you did not enter your current password | 現在パスワード未入力 |
| MSG-PWD-004 | エラー | Missing New Password - you did not enter your new password | 新パスワード未入力 |
| MSG-PWD-005 | エラー | Invalid Password - passwords must be at least 8 characters | 新パスワード8文字未満 |
| MSG-PWD-006 | エラー | Missing Password - you did not enter re-enter your new password | 確認パスワード未入力 |
| MSG-PWD-007 | エラー | Invalid Passwords - new passwords don't match | 確認パスワード不一致 |
| MSG-PWD-008 | 警告 | Very weak password | 強度スコア25以下 |
| MSG-PWD-009 | 警告 | Weak password | 強度スコア26-50 |
| MSG-PWD-010 | 情報 | Quite strong password | 強度スコア51-60 |
| MSG-PWD-011 | 情報 | Strong password | 強度スコア61-80 |
| MSG-PWD-012 | 情報 | Very strong password | 強度スコア81以上 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | AuthController::loginActionへフォワード |
| 現在パスワード不一致 | エラーメッセージ表示、posted='N'設定 |
| バリデーションエラー | エラーメッセージ表示、posted='N'設定 |

## 備考

- パスワードはMD5ハッシュ + saltで保存（セキュリティ上、bcrypt等への移行を推奨）
- サイトキーはconfig.iniのsite.keyで設定
- salt生成は57文字の英数字からランダム8文字
- パスワード強度チェックはCMS_Password_Strengthクラスで実装
- Dojoウィジェット（ValidationTextBox, ContentPane）を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パスワード関連のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | users テーブル | DBスキーマ | user_id, user_password, user_salt カラム |

**読解のコツ**: パスワードはMD5(サイトキー + パスワード + salt)形式でハッシュ化されている。

#### Step 2: エントリーポイントを理解する

画面アクセス時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SettingsController.php | `application/modules/default/controllers/SettingsController.php` | passwordAction（176-274行） |

**主要処理フロー**:
1. **178行**: `setRefer()` でリファラー設定
2. **180行**: `Zend_Auth::getInstance()->hasIdentity()` で認証確認
3. **189行**: POSTパラメータからoldpasswordを取得
4. **192-196行**: users SELECTでパスワード認証
5. **201行**: 認証成功判定
6. **207-228行**: バリデーション定義
7. **232行**: バリデーション成功判定
8. **234行**: generatepassword()で新salt生成
9. **237-240行**: 新ハッシュ計算とDB更新
10. **268-271行**: 未認証時のログイン画面フォワード

#### Step 3: ビューテンプレートを理解する

HTML出力の構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | password.phtml | `application/modules/default/views/scripts/settings/password.phtml` | フォーム構成、Ajax強度チェック |

**主要処理フロー**:
- **9-16行**: Dojoモジュールのrequire定義
- **22-24行**: user.js読み込み（パスワード強度チェック用）
- **29行**: h2見出し "Account Settings: Password"
- **32-35行**: タブナビゲーション
- **39-41行**: 変更成功メッセージ表示
- **43-46行**: パスワード認証失敗エラー表示
- **59-69行**: 現在パスワード入力欄
- **71-85行**: 新パスワード入力欄（onblur="passwordCheck"）
- **87-102行**: 確認パスワード入力欄
- **101行**: パスワード強度表示エリア（passwordResponse ContentPane）

#### Step 4: パスワード強度チェックを理解する

Ajax強度チェックのロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SettingsController.php | `application/modules/default/controllers/SettingsController.php` | passwordcheckAction（379-418行） |
| 4-2 | Password/Strength.php | `library/CMS/Password/Strength.php` | 強度計算ロジック（存在する場合） |

**主要処理フロー**:
- **381-382行**: レイアウト・ビュー無効化
- **385行**: パスワードパラメータ取得
- **387-391行**: CMS_Password_Strengthで強度計算
- **393-417行**: スコアに応じたメッセージ出力

### プログラム呼び出し階層図

```
[ブラウザ] /settings/password/
    │
    └─ SettingsController::passwordAction()
           │
           ├─ Zend_Auth::hasIdentity() 確認
           │      │
           │      └─ 未認証 → AuthController::loginAction へフォワード
           │
           ├─ POST? ──Yes──▶ users SELECT（パスワード認証）
           │                        │
           │                        ├─ 認証失敗 → エラーメッセージ
           │                        │
           │                        └─ 認証成功 → バリデーション
           │                                │
           │                                ├─ 成功 → generatepassword()
           │                                │         MD5ハッシュ生成
           │                                │         users UPDATE
           │                                │
           │                                └─ 失敗 → エラーメッセージ
           │
           └─ password.phtml レンダリング

[Ajax] /settings/passwordcheck/?password=xxx
    │
    └─ SettingsController::passwordcheckAction()
           │
           ├─ CMS_Password_Strength 初期化
           │
           ├─ calculateAll()
           │
           └─ スコアに応じたHTML出力
```

### データフロー図

```
[入力]               [処理]                    [出力]

/settings/password/ GET ───▶ passwordAction()
                              │
                              ├─ 認証確認
                              │
                              ▼
                       password.phtml ───▶ パスワード変更フォーム表示

/settings/password/ POST ───▶ passwordAction()
                              │
                              ├─ 現在パスワード ───▶ users SELECT + MD5比較
                              │                          │
                              │                          ├─ 不一致 → エラー
                              │                          │
                              │                          └─ 一致 → 続行
                              │
                              ├─ 新パスワード ───▶ バリデーション
                              │
                              ├─ generatepassword() ───▶ 新salt生成
                              │
                              ├─ MD5(key+pass+salt) ───▶ 新ハッシュ生成
                              │
                              └─ users UPDATE ───▶ "Password Changed"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SettingsController.php | `application/modules/default/controllers/SettingsController.php` | コントローラ | passwordAction, passwordcheckAction処理 |
| password.phtml | `application/modules/default/views/scripts/settings/password.phtml` | ビュー | パスワード変更フォーム表示 |
| Strength.php | `library/CMS/Password/Strength.php` | ライブラリ | パスワード強度計算 |
| user.js | `public/_scripts/default/user.js` | JavaScript | passwordCheck関数、sameCheck関数 |
| RenderMessages.php | `application/modules/default/views/helpers/RenderMessages.php` | ビューヘルパー | エラーメッセージ表示 |
| searchbox.phtml | `application/modules/default/views/scripts/_partials/searchbox.phtml` | 部分テンプレート | 検索ボックス |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | 部分テンプレート | 情報メッセージ表示 |
| config.ini | `application/configs/config.ini` | 設定 | サイトキー（site.key） |
