# 画面設計書 28-購読設定画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「購読設定画面」の設計仕様を定義するものである。ログインユーザーがメーリングリストの購読設定を管理するための機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、サイトが提供するメーリングリスト（ニュースレター、更新通知など）への購読・購読解除を管理することを目的としている。ユーザーが自身の興味に合わせて受信するメールを選択できるようにし、不要なメール配信を避けることでユーザー満足度を向上させる。

**画面へのアクセス方法**：ログイン後、ユーザー設定画面のSubscriptionsタブからアクセスする。URLパスは `/settings/subscriptions/` である。未ログイン状態でアクセスするとログイン画面へリダイレクトされる。

**主要な操作・処理内容**：
1. ログイン認証状態を確認する
2. 公開されているメーリングリストの一覧を取得する
3. 現在の購読状態をチェックボックスで表示する
4. チェックボックスのON/OFFで購読設定を変更する
5. 保存ボタンで設定をデータベースに反映する

**画面遷移**：
- 遷移元：ユーザー設定画面（Subscriptionsタブ）、パスワード変更画面（Subscriptionsタブ）
- 遷移先：ユーザー設定画面（Profileタブ）、パスワード変更画面（Passwordタブ）、ログイン画面（未認証時）

**権限による表示制御**：ログイン認証が必須。未認証の場合はログイン画面へフォワードされる。公開設定（mgroup_open='Y'）のメーリングリストのみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | メール送信 | 主機能 | メール購読の設定を変更 |

## 画面種別

編集（購読設定フォーム）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /settings/subscriptions/ | SettingsController::subscriptionsAction |
| POST | /settings/subscriptions/ | SettingsController::subscriptionsAction（フォーム送信） |

## 入出力項目

### 入力項目（フォーム）

| 項目名 | フィールド名 | データ型 | 必須 | バリデーション | 備考 |
|--------|-------------|---------|------|---------------|------|
| 購読リスト | lists[] | Array[Integer] | いいえ | mgroup_idの配列 | チェックボックス複数選択 |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| メーリングリスト一覧 | Array | 公開グループの一覧 |
| 購読状態 | Boolean | 各グループの購読有無 |
| 更新成功メッセージ | String | "Subscriptions Updated" |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | h2見出し | "Account Settings: Subscriptions" |
| タブ：Profile | リンク | ユーザー設定画面への遷移 |
| タブ：Password | リンク | パスワード変更画面への遷移 |
| タブ：Subscriptions | アクティブ状態 | 現在表示中 |
| 更新成功メッセージ | 情報ボックス | "Subscriptions Updated" |
| Subscriptionsフィールドセット | fieldset | メーリングリスト一覧 |
| グループボックス | div | 各グループのタイトル、説明、チェックボックス |
| 保存ボタン | button | フォーム送信 |
| 検索ボックス | 部分テンプレート | サイト内検索 |
| サイドバーローテーター | 部分テンプレート | 広告・バナー表示 |

## イベント仕様

### 1-画面初期表示

公開メーリングリストと現在の購読状態を表示する。

**処理フロー**：
1. `Zend_Auth::getInstance()->hasIdentity()` で認証確認
2. 未認証の場合は `AuthController::loginAction` へフォワード
3. mail_groupsテーブルからmgroup_open='Y'のリストを取得
4. MSubStatusヘルパーで各グループの購読状態をチェック
5. 購読中のグループはチェック済み・背景色変更で表示

### 2-購読設定更新（フォーム送信）

選択されたグループを購読設定として保存する。

**処理フロー**：
1. POSTリクエストを受信
2. mail_subscriptionsテーブルから現ユーザーのレコードを全削除
3. 選択されたグループ（lists[]配列）を順に新規登録
4. "Subscriptions Updated"メッセージを表示

### 3-グループボックスクリック

グループボックスをクリックするとチェックボックスがトグルされる。

**処理フロー**：
1. div onclickで`toggleCheckbox()`関数呼び出し
2. 対応するチェックボックスの状態を反転
3. 背景色を更新（購読中：黄色系、未購読：通常）

### 4-タブ切替

Profile/Password/Subscriptionsタブをクリックして画面を切り替える。

| タブ | 遷移先URL | 説明 |
|-----|----------|------|
| Profile | /settings/ | ユーザー設定画面 |
| Password | /settings/password/ | パスワード変更画面 |
| Subscriptions | - | 現在の画面（アクティブ） |

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | mail_groups | SELECT | 公開グループ一覧取得 |
| 画面表示 | mail_subscriptions | SELECT | 購読状態確認 |
| 購読更新 | mail_subscriptions | DELETE | 既存購読削除 |
| 購読更新 | mail_subscriptions | INSERT | 新規購読登録 |

### テーブル別更新項目詳細

#### mail_groups (g)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | mgroup_id | - | チェックボックス値として使用 |
| SELECT | mgroup_title | - | グループ見出し表示 |
| SELECT | mgroup_description | - | グループ説明表示 |
| SELECT | mgroup_open | = 'Y' | 公開グループのみ |
| ORDER BY | mgroup_title | ASC | タイトル順ソート |

#### mail_subscriptions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | msub_user | = ログインユーザーID | 購読状態確認（MSubStatus） |
| SELECT | msub_group | = グループID | 購読状態確認 |
| DELETE | msub_user | = ログインユーザーID | 全購読削除 |
| INSERT | msub_group | フォーム選択値 | 新規購読登録 |
| INSERT | msub_user | ログインユーザーID | 新規購読登録 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-SUB-001 | 成功 | Subscriptions Updated | 購読設定更新成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | AuthController::loginActionへフォワード |
| 公開グループなし | 空のフィールドセットが表示される |

## 備考

- 購読更新はDELETE→INSERT方式で実装（差分更新ではない）
- グループボックスクリックでチェックボックストグル（UX向上）
- 購読中グループは黄色系背景（yBGクラス）で視覚的に区別
- Dojoウィジェット（CheckBox）を使用
- MSubStatusヘルパーで購読状態をビューから確認

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メーリングリストと購読のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mail_groups テーブル | DBスキーマ | mgroup_id, mgroup_title, mgroup_description, mgroup_open カラム |
| 1-2 | mail_subscriptions テーブル | DBスキーマ | msub_group, msub_user カラム |

**読解のコツ**: mail_subscriptionsはmail_groups.mgroup_idとusers.user_idの中間テーブル。

#### Step 2: エントリーポイントを理解する

画面アクセス時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SettingsController.php | `application/modules/default/controllers/SettingsController.php` | subscriptionsAction（279-341行） |

**主要処理フロー**:
1. **281行**: `setRefer()` でリファラー設定
2. **284行**: `Zend_Auth::getInstance()->hasIdentity()` で認証確認
3. **286行**: パラメータをビューに渡す
4. **292-295行**: mail_groups SELECTでグループ一覧取得
5. **298行**: listsArrayをビューに渡す
6. **303行**: POST判定
7. **306行**: 既存購読をDELETE
8. **309-323行**: 選択グループをINSERT
9. **335-338行**: 未認証時のログイン画面フォワード

#### Step 3: ビューテンプレートを理解する

HTML出力の構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | subscriptions.phtml | `application/modules/default/views/scripts/settings/subscriptions.phtml` | グループリスト表示、チェックボックス |

**主要処理フロー**:
- **9-18行**: Dojoモジュールのrequire定義
- **31行**: h2見出し "Account Settings: Subscriptions"
- **34-37行**: タブナビゲーション
- **41-43行**: 更新成功メッセージ表示
- **54-61行**: グループループ（listsArrayが0件超の場合）
- **56行**: MSubStatusで購読状態確認、背景色制御
- **57行**: グループタイトル表示
- **58行**: グループ説明表示
- **59行**: チェックボックス（購読中ならchecked）

#### Step 4: 購読状態確認ヘルパーを理解する

MSubStatusヘルパーのロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MSubStatus.php | `application/modules/default/views/helpers/MSubStatus.php` | 購読状態確認ロジック（存在する場合） |

### プログラム呼び出し階層図

```
[ブラウザ] /settings/subscriptions/
    │
    └─ SettingsController::subscriptionsAction()
           │
           ├─ Zend_Auth::hasIdentity() 確認
           │      │
           │      └─ 未認証 → AuthController::loginAction へフォワード
           │
           ├─ mail_groups SELECT（mgroup_open='Y'）
           │
           ├─ POST? ──Yes──▶ mail_subscriptions DELETE（現ユーザー）
           │                        │
           │                        └─ foreach lists[] ───▶ mail_subscriptions INSERT
           │
           └─ subscriptions.phtml レンダリング
                  │
                  ├─ foreach listsArray ───▶ グループ表示
                  │      │
                  │      └─ MSubStatus() ───▶ 購読状態確認
                  │
                  └─ サイドバー表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

/settings/subscriptions/ GET ───▶ subscriptionsAction()
                                    │
                                    ├─ 認証確認
                                    │
                                    ├─ mail_groups SELECT
                                    │
                                    ▼
                             subscriptions.phtml ───▶ グループ一覧表示
                                    │
                                    └─ MSubStatus() ───▶ チェックボックス状態

/settings/subscriptions/ POST ───▶ subscriptionsAction()
                                    │
                                    ├─ mail_subscriptions DELETE
                                    │
                                    ├─ foreach lists[] ───▶ mail_subscriptions INSERT
                                    │
                                    └─ "Subscriptions Updated" 表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SettingsController.php | `application/modules/default/controllers/SettingsController.php` | コントローラ | subscriptionsAction処理 |
| subscriptions.phtml | `application/modules/default/views/scripts/settings/subscriptions.phtml` | ビュー | 購読設定フォーム表示 |
| MSubStatus.php | `application/modules/default/views/helpers/MSubStatus.php` | ビューヘルパー | 購読状態確認 |
| user.js | `public/_scripts/default/user.js` | JavaScript | toggleCheckbox関数 |
| RenderMessages.php | `application/modules/default/views/helpers/RenderMessages.php` | ビューヘルパー | メッセージ表示 |
| RenderRotator.php | `application/modules/default/views/helpers/RenderRotator.php` | ビューヘルパー | ローテーター広告表示 |
| searchbox.phtml | `application/modules/default/views/scripts/_partials/searchbox.phtml` | 部分テンプレート | 検索ボックス |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | 部分テンプレート | 情報メッセージ表示 |
