# 画面設計書 29-404エラー画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「404エラー画面」の設計仕様を定義するものである。リクエストされたリソースが見つからない場合にエラーメッセージを表示する機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、ユーザーがアクセスしようとしたページが存在しない場合（削除済み、URL間違い、リンク切れなど）に、適切なエラーメッセージを表示してユーザーを誘導することを目的としている。ホームページやお問い合わせへのリンクを提供することで、ユーザーがサイトから離脱するのを防ぎ、ユーザーエクスペリエンスを維持する重要な役割を果たす。

**画面へのアクセス方法**：以下の場合に自動的に表示される：
- 存在しないURLにアクセスした場合（Zend Frameworkのエラーハンドラー経由）
- コントローラやアクションが見つからない場合
- 他のコントローラからforwardで転送された場合（記事/ページ/イベントなどが見つからない場合）

**主要な操作・処理内容**：
1. HTTPレスポンスコード404を設定する
2. エラータイトルとメッセージを表示する
3. ホームページへのリンクを提供する
4. お問い合わせページへのリンクを提供する

**画面遷移**：
- 遷移元：任意の存在しないURL、各コントローラからのforward（notfound）
- 遷移先：ホーム画面（リンククリック時）、お問い合わせ画面（リンククリック時）

**権限による表示制御**：本画面は公開画面であり、認証状態に関わらず誰でもアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | アクセス制御 | 主機能 | ページ未検出エラーの表示 |

## 画面種別

エラー（404 Not Found）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /error/notfound/ | ErrorController::notfoundAction |
| GET | (存在しない任意のURL) | ErrorController::errorAction → 404判定 |

## 入出力項目

### 入力項目

本画面に入力項目はない。

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| エラータイトル | String | "We're sorry..." |
| エラーメッセージ | HTML | リソースが見つからない旨の説明とリンク |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| エラータイトル | h2見出し | "We're sorry..." |
| エラーメッセージ | p段落 | "The resource you requested could not be found." |
| 補足メッセージ | p段落 | "It may have been removed or you may have followed a bad link." |
| ホームページリンク | リンク | "Visit our Home Page" |
| お問い合わせリンク | リンク | "Contact us to report a problem" |

## イベント仕様

### 1-直接アクセス（notfoundAction）

他のコントローラからforwardされた場合の処理。

**処理フロー**：
1. setLayout()でmainレイアウトを設定
2. HTTPレスポンスヘッダに「404 Not Found」を設定
3. タイトルとメッセージをビューに設定
4. notfound.phtmlをレンダリング

### 2-自動エラー処理（errorAction）

存在しないコントローラ/アクションへのアクセス時の処理。

**処理フロー**：
1. setLayout()でmainレイアウトを設定
2. error_handlerパラメータからエラー情報を取得
3. エラータイプを判定：
   - EXCEPTION_NO_CONTROLLER / EXCEPTION_NO_ACTION → 404エラー
   - その他 → アプリケーションエラー
4. 404の場合：HTTPレスポンスヘッダに「404 Not Found」を設定
5. タイトルとメッセージをビューに設定
6. error.phtmlをレンダリング（notfound.phtmlと同一構造）

### 3-ホームページリンククリック

ホームページへ遷移する。

**遷移先URL**: `/`

### 4-お問い合わせリンククリック

お問い合わせ画面へ遷移する。

**遷移先URL**: `/contact/`

## データベース更新仕様

### 操作別データベース影響一覧

本画面ではデータベース操作は行わない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-404-001 | エラー | We're sorry... | 常に表示（タイトル） |
| MSG-404-002 | エラー | The resource you requested could not be found. | 常に表示 |
| MSG-404-003 | エラー | It may have been removed or you may have followed a bad link. | 常に表示 |

## 例外処理

本画面自体がエラー処理のための画面であり、追加の例外処理は行わない。

## 備考

- HTTPレスポンスコード404をsetRawHeaderで明示的に設定
- error.phtmlとnotfound.phtmlは同一のテンプレート構造
- mainレイアウトを使用してサイト共通のヘッダー・フッターを表示
- エラーボックスはclass="error"でスタイリング

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

エラー発生時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ErrorController.php | `application/modules/default/controllers/ErrorController.php` | notfoundAction（55-64行）、errorAction（24-49行） |

**主要処理フロー（notfoundAction）**:
1. **57行**: `setLayout()` でmainレイアウト設定
2. **58行**: `getResponse()->setRawHeader('HTTP/1.1 404 Not Found')` でHTTPステータス設定
3. **59-63行**: タイトルとメッセージをビューに設定

**主要処理フロー（errorAction）**:
1. **26行**: `setLayout()` でmainレイアウト設定
2. **27行**: `$this->_getParam('error_handler')` でエラー情報取得
3. **28-38行**: エラータイプ判定（EXCEPTION_NO_CONTROLLER / EXCEPTION_NO_ACTION）
4. **32行**: 404の場合、HTTPステータス設定

#### Step 2: ビューテンプレートを理解する

HTML出力の構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notfound.phtml | `application/modules/default/views/scripts/error/notfound.phtml` | エラーメッセージ表示 |
| 2-2 | error.phtml | `application/modules/default/views/scripts/error/error.phtml` | 共通エラーテンプレート |

**主要処理フロー**:
- **10行**: ページタイトル設定（動的）
- **11行**: プレースホルダーにタイトル設定
- **15行**: errorクラスのdivでエラーボックス表示
- **16行**: h2でエラータイトル表示
- **17-19行**: メッセージ表示（条件付き）

#### Step 3: エラーハンドラー設定を理解する

Zend Frameworkのエラーハンドラー設定を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | application.ini | `application/configs/application.ini` | エラーハンドラー設定（存在する場合） |

### プログラム呼び出し階層図

```
[存在しないURLへのアクセス]
    │
    └─ Zend_Controller_Plugin_ErrorHandler
           │
           ├─ EXCEPTION_NO_CONTROLLER / EXCEPTION_NO_ACTION
           │      │
           │      └─ ErrorController::errorAction()
           │             │
           │             ├─ setLayout('main')
           │             │
           │             ├─ setRawHeader('HTTP/1.1 404 Not Found')
           │             │
           │             └─ error.phtml レンダリング
           │
           └─ その他のエラー → システムエラー表示

[コントローラからのforward('notfound')]
    │
    └─ ErrorController::notfoundAction()
           │
           ├─ setLayout('main')
           │
           ├─ setRawHeader('HTTP/1.1 404 Not Found')
           │
           └─ notfound.phtml レンダリング
```

### データフロー図

```
[入力]               [処理]                    [出力]

存在しないURL ───▶ ErrorHandler Plugin
                      │
                      ├─ エラータイプ判定
                      │
                      ├─ 404? ──Yes──▶ errorAction()
                      │                    │
                      │                    ├─ HTTPステータス設定
                      │                    │
                      │                    └─ error.phtml ───▶ 404エラー表示
                      │
                      └─ No ──▶ システムエラー表示

forward('notfound') ───▶ notfoundAction()
                              │
                              ├─ HTTPステータス設定
                              │
                              └─ notfound.phtml ───▶ 404エラー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ErrorController.php | `application/modules/default/controllers/ErrorController.php` | コントローラ | notfoundAction, errorAction処理 |
| notfound.phtml | `application/modules/default/views/scripts/error/notfound.phtml` | ビュー | 404エラー表示（forward用） |
| error.phtml | `application/modules/default/views/scripts/error/error.phtml` | ビュー | エラー表示（ErrorHandler用） |
| Action/Error.php | `library/CMS/Controller/Action/Error.php` | 基底クラス | ErrorController基底クラス（存在する場合） |
| main.phtml | `application/modules/default/layouts/scripts/main.phtml` | レイアウト | サイト共通レイアウト |
| common.js | `public/_scripts/default/common.js` | JavaScript | サイト共通処理 |
| screen.css | `public/_styles/default/screen.css` | CSS | スタイルシート（.errorクラス） |
