# 画面設計書 3-検索結果画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおける検索結果画面の設計仕様を定義する。Zend Lucene検索エンジンを使用した全文検索結果を表示し、ユーザーが目的のコンテンツにアクセスできるようにする。

### 本画面の処理概要

**業務上の目的・背景**：検索結果画面は、サイト内のコンテンツを効率的に発見するための重要な機能を提供する。ユーザーがキーワードを入力すると、Lucene検索エンジンによる全文検索が実行され、関連性の高いコンテンツが一覧表示される。これにより、大量のコンテンツの中から目的の情報を迅速に見つけるという業務課題を解決する。

**画面へのアクセス方法**：ホーム画面やサイドバーの検索ボックスからキーワードを入力して検索を実行。URLは`/index/search?query={keyword}`。

**主要な操作・処理内容**：
1. 検索クエリをLucene検索エンジンで処理
2. 公開日がフィルタリングされた検索結果を表示（現在日時以前のコンテンツのみ）
3. 検索結果のページネーション（1ページ6件、ページ範囲5）
4. 検索結果の各項目からコンテンツ詳細画面への遷移
5. 検索キーワードの再編集と再検索
6. タグボックスによる関連コンテンツへのナビゲーション

**画面遷移**：
- 遷移元：ホーム画面（検索ボックス）、各画面のサイドバー検索ボックス
- 遷移先：記事詳細画面、ページ詳細画面、イベント詳細画面、ホーム画面、お問い合わせ画面

**権限による表示制御**：
- 本画面は認証状態に関わらず同一の表示内容
- 検索対象は公開済みコンテンツのみ（検索インデックス登録時に制御）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 60 | 検索インデックス更新 | 主機能 | Lucene検索エンジンによる全文検索 |
| 62 | ページネーション | 補助機能 | 検索結果のページ送り処理 |

## 画面種別

一覧（検索結果型）

## URL/ルーティング

- URL: `/index/search` または `/search/`
- コントローラー: `IndexController`
- アクション: `searchAction`
- モジュール: `default`
- クエリパラメータ: `query` (検索キーワード), `page` (ページ番号)

## 入出力項目

### 入力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| query | 入力 | string | はい | 検索キーワード |
| page | 入力 | int | いいえ | ページ番号（デフォルト:1） |

### 出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| hits | 出力 | Zend_Paginator | - | 検索結果（ページネーション付き） |
| query | 出力 | string | - | 表示用検索キーワード |
| page | 出力 | int | - | 現在のページ番号 |

## 表示項目

### 検索結果一覧（hits）

| 項目名 | データ型 | 表示形式 | 説明 |
|--------|---------|---------|------|
| title | string | リンク付きテキスト | コンテンツタイトル |
| url | string | リンクURL | コンテンツへのURL |
| details | string | テキスト | 著者・日付等の詳細情報 |
| stub | string | HTML | コンテンツの概要文 |

### サイドバー

| 項目名 | 説明 |
|--------|------|
| 検索ボックス | 検索キーワード再編集用（現在のクエリがプリセット） |
| タグボックス | タグクラウド表示 |

## イベント仕様

### 1-検索結果タイトルクリック

検索結果のタイトルをクリックすると、該当コンテンツの詳細画面へ遷移する。

- 遷移先: `{hit.url}`（記事、ページ、イベント等のURL）
- 処理: リンククリックによるページ遷移

### 2-View pageクリック

「View page」リンクをクリックすると、該当コンテンツの詳細画面へ遷移する。

- 遷移先: `{baseUrl}{hit.url}`
- 処理: リンククリックによるページ遷移

### 3-ページネーション操作

ページ番号や前後ボタンをクリックすると、該当ページの検索結果を表示する。

- 遷移先: `/index/search?query={query}&page={page}`
- 処理: paginationControlヘルパーによるページ遷移

### 4-再検索

サイドバーの検索ボックスでキーワードを変更して検索を実行する。

- 遷移先: `/index/search?query={new_keyword}`

### 5-ホームページへ戻る

結果が0件の場合、「Visit our Home Page」リンクからホームへ遷移する。

- 遷移先: `/`

### 6-お問い合わせ

結果が0件の場合、「Contact us」リンクからお問い合わせ画面へ遷移する。

- 遷移先: `/contact/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 検索実行 | - | - | Luceneインデックスから検索（DBアクセスなし） |

### 備考

本画面ではデータベースへの直接アクセスは行わない。検索はZend_Search_Luceneによるインデックス検索で実行される。

**インデックスファイルパス**: `{search.syspath}site-index`（search.iniで設定）

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | エラー | No results were found for '{query}' | 検索結果が0件（キーワードあり）の場合 |
| MSG-002 | エラー | You did not enter a search query! | 検索キーワードが空の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| queryパラメータ未設定 | 404エラー画面へ転送 |
| Luceneインデックスオープンエラー | システムエラー画面へ遷移 |

## 備考

- 検索エンジンはZend_Search_Luceneを使用
- 検索クエリはフレーズ検索（Zend_Search_Lucene_Search_Query_Phrase）で構成
- スロップ値は3に設定（単語間の許容距離）
- 日付フィルタにより、公開日が現在日時以前のコンテンツのみが検索対象
- 検索キーワードはHTMLタグがストリップされる（strip_tags）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Lucene検索インデックスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | - | `{search.syspath}site-index` | Luceneインデックスのフィールド構成（key, date, title, url, details, stub, contents） |

**読解のコツ**: 検索インデックスは記事・ページ・イベント等の公開時に自動更新される。各ドキュメントにはkey, date, title, url, details, stub, contentsフィールドが含まれる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IndexController.php | `application/modules/default/controllers/IndexController.php` | searchAction()メソッド（63-117行目） |

**主要処理フロー**:
1. **65行目**: 検索クエリを取得しHTMLタグをストリップ
2. **67-76行目**: queryが設定されている場合のみ処理続行、未設定なら404へ
3. **79行目**: Luceneインデックスをオープン
4. **81行目**: 検索キーワードを小文字化
5. **83行目**: キーワードをスペースで分割
6. **85-91行目**: フレーズクエリを構築（スロップ3）
7. **93-94行目**: 日付範囲クエリを追加（現在日時以前）
8. **96-97行目**: ブールクエリに両条件を追加
9. **99行目**: 検索実行
10. **101-108行目**: Paginatorでページネーション設定（6件/ページ）

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | search.phtml | `application/modules/default/views/scripts/index/search.phtml` | メインテンプレート。検索結果一覧とエラー表示 |

**主要処理フロー**:
- **33-54行目**: 検索結果がある場合、foreach文で各hitを表示
- **38行目**: hit.urlでリンク生成、hit.titleでタイトル表示
- **42行目**: hit.stubで概要表示
- **51行目**: paginationControlでページネーション表示
- **55-69行目**: 検索結果が0件の場合のエラーメッセージとリンク

### プログラム呼び出し階層図

```
HTTP Request (/index/search?query=keyword)
    |
    +-- IndexController::preDispatch() [継承元: CMS_Controller_Action_Default]
    |
    +-- IndexController::searchAction()
            |
            +-- strip_tags(query) - クエリサニタイズ
            +-- Zend_Search_Lucene::open() - インデックスオープン
            |       |
            |       +-- site-index ディレクトリ
            |
            +-- Zend_Search_Lucene_Search_Query_Phrase - フレーズクエリ構築
            +-- Zend_Search_Lucene_Search_Query_Range - 日付範囲クエリ
            +-- Zend_Search_Lucene_Search_Query_Boolean - 複合クエリ
            +-- $index->find($query) - 検索実行
            +-- Zend_Paginator::factory() - ページネーション
            +-- ビュー変数設定 (hits, query, page)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト  ───▶ IndexController      ───▶ search.phtml
(query=keyword)      ::searchAction()          |
                           |                   +──▶ 検索結果一覧
                           |                   |     (foreach hits)
                      Lucene検索               +──▶ paginationControl
                           |                   |     (ページネーション)
                           ▼                   +──▶ searchbox.phtml
                      site-index               +──▶ TBox()
                     (Luceneインデックス)           (タグボックス)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IndexController.php | `application/modules/default/controllers/IndexController.php` | ソース | 検索結果画面のコントローラー |
| search.phtml | `application/modules/default/views/scripts/index/search.phtml` | テンプレート | 検索結果画面のメインビュー |
| search.phtml | `application/modules/default/views/scripts/_pagination/search.phtml` | テンプレート | 検索結果用ページネーション |
| searchbox.phtml | `application/modules/default/views/scripts/_partials/searchbox.phtml` | テンプレート | 検索ボックス |
| search.ini | `application/configs/search.ini` | 設定 | 検索インデックスパス設定 |
