# 画面設計書 30-システムエラー画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「システムエラー画面」の設計仕様を定義するものである。アプリケーション実行中に予期しないエラーが発生した場合にエラーメッセージを表示する機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、データベース接続エラー、PHPの例外発生、設定ミスなど、アプリケーションレベルでのエラーが発生した場合に、ユーザーに適切な情報を提供することを目的としている。エラーの詳細情報（開発環境のみ）を表示しつつ、ホームページやお問い合わせへのリンクを提供することで、ユーザーが問題を報告できるようにする。

**画面へのアクセス方法**：以下の場合に自動的に表示される：
- PHPで例外がスローされた場合
- データベース接続エラーが発生した場合
- その他のアプリケーションエラーが発生した場合
- Zend Frameworkのエラーハンドラーで捕捉されたエラー

**主要な操作・処理内容**：
1. エラー情報を取得してタイトルとメッセージを設定する
2. エラーの詳細メッセージを表示する（例外のgetMessage()）
3. ホームページへのリンクを提供する
4. お問い合わせページへのリンクを提供する

**画面遷移**：
- 遷移元：任意のエラー発生元（自動遷移）
- 遷移先：ホーム画面（リンククリック時）、お問い合わせ画面（リンククリック時）

**権限による表示制御**：本画面は公開画面であり、認証状態に関わらず誰でもアクセス可能。ただし、エラー詳細情報の表示レベルは環境設定に依存する場合がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | アクセス制御 | 主機能 | システムエラーの表示 |

## 画面種別

エラー（システムエラー / 500 Internal Server Error相当）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /error/error/ | ErrorController::errorAction |
| GET | (エラー発生時のURL) | ErrorController::errorAction（自動転送） |

## 入出力項目

### 入力項目

本画面に入力項目はない。

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| エラータイトル | String | "This is embarrassing..." |
| エラー説明 | String | "The application has encountered the following error:" |
| エラー詳細 | String | 例外のメッセージ（$exception->GetMessage()） |
| ホームページリンク | HTML | ホームへのリンク |
| お問い合わせリンク | HTML | 問題報告用リンク |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| エラータイトル | h2見出し | "This is embarrassing..." |
| エラー説明 | p段落 | "The application has encountered the following error:" |
| エラー詳細 | p段落 | 例外メッセージをエスケープせずに表示 |
| ホームページリンク | リンク | "Visit our Home Page" |
| お問い合わせリンク | リンク | "Contact us to report a problem" |

## イベント仕様

### 1-システムエラー表示（errorAction）

アプリケーションエラー発生時の処理。

**処理フロー**：
1. setLayout()でmainレイアウトを設定
2. error_handlerパラメータからエラー情報を取得
3. エラータイプを判定：
   - EXCEPTION_NO_CONTROLLER / EXCEPTION_NO_ACTION → 404エラー（別処理）
   - default → システムエラー（本画面）
4. タイトル「This is embarrassing...」を設定
5. エラーメッセージに例外の詳細を含めてビューに設定
6. error.phtmlをレンダリング

### 2-ホームページリンククリック

ホームページへ遷移する。

**遷移先URL**: `/`

### 3-お問い合わせリンククリック

お問い合わせ画面へ遷移する。

**遷移先URL**: `/contact/`

## データベース更新仕様

### 操作別データベース影響一覧

本画面ではデータベース操作は行わない（データベースエラー時にはDB接続自体が失敗している可能性があるため）。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-ERR-001 | エラー | This is embarrassing... | システムエラー時（タイトル） |
| MSG-ERR-002 | エラー | The application has encountered the following error: | システムエラー時 |
| MSG-ERR-003 | エラー | {例外メッセージ} | 動的（$errors->exception->GetMessage()） |

## 例外処理

本画面自体がエラー処理のための画面であり、追加の例外処理は行わない。ただし、この画面のレンダリング自体でエラーが発生した場合は、PHPのデフォルトエラーハンドラーに委譲される。

## 備考

- 404エラーと異なり、HTTPステータスコードは変更しない（500ではなく、発生状況に依存）
- 例外メッセージはGetMessage()で取得し、HTMLとして出力される（XSSリスクに注意）
- 本番環境では例外メッセージの表示を制限することを推奨
- mainレイアウトを使用してサイト共通のヘッダー・フッターを表示
- エラーボックスはclass="error"でスタイリング

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

エラー発生時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ErrorController.php | `application/modules/default/controllers/ErrorController.php` | errorAction（24-49行） |

**主要処理フロー（errorAction - システムエラー分岐）**:
1. **26行**: `setLayout()` でmainレイアウト設定
2. **27行**: `$this->_getParam('error_handler')` でエラー情報取得
3. **28行**: `switch ($errors->type)` でエラータイプ判定
4. **29-38行**: EXCEPTION_NO_CONTROLLER / EXCEPTION_NO_ACTION → 404処理
5. **39-47行**: default（その他のエラー） → システムエラー処理
6. **42行**: タイトル「This is embarrassing...」設定
7. **43-46行**: 例外メッセージを含むHTMLを生成

#### Step 2: ビューテンプレートを理解する

HTML出力の構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | error.phtml | `application/modules/default/views/scripts/error/error.phtml` | エラーメッセージ表示 |

**主要処理フロー**:
- **10行**: ページタイトル設定（動的：$this->title）
- **11行**: プレースホルダーにタイトル設定
- **15行**: errorクラスのdivでエラーボックス表示
- **16行**: h2でエラータイトル表示
- **17-19行**: メッセージ表示（$this->messageが存在する場合）

#### Step 3: エラーハンドラー設定を理解する

Zend Frameworkのエラーハンドラー設定を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | application.ini | `application/configs/application.ini` | エラー表示設定（display_errors等） |
| 3-2 | initializer.php | `application/initializer.php` | エラーハンドラー初期化（存在する場合） |

### プログラム呼び出し階層図

```
[アプリケーションエラー発生]
    │
    └─ PHP例外スロー / エラー発生
           │
           └─ Zend_Controller_Plugin_ErrorHandler
                  │
                  └─ ErrorController::errorAction()
                         │
                         ├─ setLayout('main')
                         │
                         ├─ $errors = $this->_getParam('error_handler')
                         │
                         ├─ switch ($errors->type)
                         │      │
                         │      ├─ EXCEPTION_NO_CONTROLLER → 404処理
                         │      │
                         │      ├─ EXCEPTION_NO_ACTION → 404処理
                         │      │
                         │      └─ default → システムエラー処理
                         │             │
                         │             ├─ title = "This is embarrassing..."
                         │             │
                         │             └─ message = 例外メッセージ含むHTML
                         │
                         └─ error.phtml レンダリング
```

### データフロー図

```
[入力]               [処理]                    [出力]

PHPエラー/例外 ───▶ ErrorHandler Plugin
                      │
                      ├─ error_handler設定
                      │
                      ▼
               errorAction()
                      │
                      ├─ エラータイプ判定
                      │
                      ├─ システムエラー?
                      │      │
                      │      └─ Yes ───▶ title = "This is embarrassing..."
                      │                  message = 例外詳細
                      │
                      └─ error.phtml ───▶ システムエラー表示
                             │
                             ├─ エラータイトル
                             │
                             ├─ エラー説明
                             │
                             ├─ 例外メッセージ
                             │
                             └─ ナビゲーションリンク
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ErrorController.php | `application/modules/default/controllers/ErrorController.php` | コントローラ | errorAction処理 |
| error.phtml | `application/modules/default/views/scripts/error/error.phtml` | ビュー | エラーメッセージ表示 |
| Action/Error.php | `library/CMS/Controller/Action/Error.php` | 基底クラス | ErrorController基底クラス（存在する場合） |
| main.phtml | `application/modules/default/layouts/scripts/main.phtml` | レイアウト | サイト共通レイアウト |
| application.ini | `application/configs/application.ini` | 設定 | エラー表示設定 |
| initializer.php | `application/initializer.php` | 初期化 | エラーハンドラー設定（存在する場合） |
| common.js | `public/_scripts/default/common.js` | JavaScript | サイト共通処理 |
| screen.css | `public/_styles/default/screen.css` | CSS | スタイルシート（.errorクラス） |
