# 画面設計書 31-サイト閉鎖画面

## 概要

本ドキュメントは、Legacy CMSにおけるサイト閉鎖画面（Site Temporarily Unavailable）の設計仕様を定義します。

### 本画面の処理概要

サイト閉鎖画面は、システムメンテナンス時やサイト一時停止時にユーザーに対して表示されるエラーページです。

**業務上の目的・背景**：サイト運営において、システムメンテナンスや緊急停止が必要な場合に、ユーザーに対して適切なメッセージを表示し、サイトが一時的に利用できないことを通知するために本画面が必要です。これにより、ユーザーに対する適切な情報提供とサービス品質の維持が可能となります。

**画面へのアクセス方法**：この画面は、設定ファイル（config.ini）でサイトステータスが「closed」に設定されている場合に、システムによって自動的に表示されます。ユーザーが任意のURLにアクセスした際に、サイト閉鎖状態であればこの画面にリダイレクトされます。

**主要な操作・処理内容**：
1. 設定ファイルからサイトステータスを読み込む
2. サイト名とカスタムメッセージを画面に表示する
3. ユーザーに対してサイト一時停止の旨を通知する

**画面遷移**：この画面からは他の画面への遷移機能は提供されません。サイトが再開されると、通常のホーム画面やログイン画面が表示されるようになります。

**権限による表示制御**：本画面は認証不要であり、すべてのユーザーに対して同一の内容が表示されます。管理者権限を持つユーザーも同様にこの画面が表示されます（管理画面へのアクセスも制限される可能性があります）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | アクセス制御 | 主機能 | メンテナンス中表示の制御 |

## 画面種別

エラー / 情報表示

## URL/ルーティング

- URL: `/error/closed/`
- モジュール: default
- コントローラ: error
- アクション: closed

## 入出力項目

本画面は入力項目を持ちません。

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 | 取得元 |
|--------|--------|----------|------|--------|
| タイトル | title | 文字列 | "Site Temporarily Unavailable" | 固定値 |
| メッセージ | message | 文字列 | カスタムメンテナンスメッセージ | config.ini (status.status.message) |

## イベント仕様

### 1-画面表示

画面表示時に以下の処理が実行されます：

1. ErrorController::closedAction() が呼び出される
2. Zend_Registryインスタンスを取得
3. config.iniからステータス設定を読み込む
4. レイアウトを'main'に設定
5. ビューにタイトル「Site Temporarily Unavailable」を設定
6. 設定ファイルのメッセージをビューに設定
7. closed.phtmlテンプレートをレンダリング

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースへのアクセスを行いません。設定ファイル（config.ini）からの読み取りのみを行います。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベースアクセスなし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | Site Temporarily Unavailable | 常時（タイトルとして表示） |
| MSG-002 | 情報 | (config.iniで設定されたメッセージ) | 常時（本文として表示） |

## 例外処理

| 例外種別 | 条件 | 処理内容 |
|---------|------|---------|
| 設定ファイル読み込みエラー | config.iniが存在しない/読み込めない場合 | システムエラー画面へ遷移 |

## 備考

- サイトの閉鎖/再開は、管理者がconfig.iniファイルのstatusセクションを編集することで制御される
- この画面はCAPTCHA認証やフォーム入力を必要としない純粋な情報表示画面である
- Dojoツールキット（dijit.form.Form, dijit.form.Button, dijit.form.TextBox）がロードされるが、本画面では使用されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

設定ファイルの構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.ini | `application/configs/config.ini` | statusセクションのmessage設定を確認 |

**読解のコツ**: Zend_Config_Iniクラスを使用してINI形式の設定ファイルが読み込まれる。セクション名が配列のキーとなる。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラアクションを特定します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ErrorController.php | `application/modules/default/controllers/ErrorController.php` | closedAction()メソッドの実装を確認 |

**主要処理フロー**:
1. **70-71行目**: closedAction()メソッドの開始
2. **72-73行目**: Zend_Registryインスタンスの取得
3. **75-77行目**: config.iniからステータス設定を読み込み、registryに設定
4. **79行目**: setLayout()でレイアウトを'main'に変更
5. **80行目**: ビューのタイトルを設定
6. **81行目**: registryからメッセージを取得しビューに設定

#### Step 3: ビューテンプレートを理解する

画面表示の詳細を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | closed.phtml | `application/modules/default/views/scripts/error/closed.phtml` | HTMLテンプレートの構造を確認 |

**主要処理フロー**:
- **9-12行目**: Dojoツールキットの読み込みスクリプト定義
- **14-19行目**: ヘッダー設定（タイトル、CSS、JavaScript）
- **21-31行目**: エラーメッセージ表示エリアのHTML構造

### プログラム呼び出し階層図

```
closedAction() [ErrorController.php:70-82]
    │
    ├─ Zend_Registry::getInstance()
    │      └─ レジストリインスタンス取得
    │
    ├─ new Zend_Config_Ini('../application/configs/config.ini', array('status'))
    │      └─ 設定ファイル読み込み
    │
    ├─ setLayout() [ErrorController.php:12-16]
    │      └─ _helper->layout->setLayout('main')
    │
    └─ View rendering [closed.phtml]
           └─ HTML出力
```

### データフロー図

```
[入力]                    [処理]                         [出力]

config.ini ───────▶ Zend_Config_Ini ───────▶ $registry->status
(status.message)          読み込み

$registry->status ──▶ closedAction() ──────▶ $this->view->message
                         処理

$this->view ──────────▶ closed.phtml ──────▶ HTML出力
                         レンダリング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ErrorController.php | `application/modules/default/controllers/ErrorController.php` | コントローラ | エラー処理の制御 |
| closed.phtml | `application/modules/default/views/scripts/error/closed.phtml` | ビュー | 画面テンプレート |
| config.ini | `application/configs/config.ini` | 設定 | サイトステータス設定 |
| CMS_Controller_Action_Error | `library/CMS/Controller/Action/Error.php` | 基底クラス | エラーコントローラの親クラス |
| main.phtml | `application/layouts/scripts/main.phtml` | レイアウト | メインレイアウトテンプレート |
