# 画面設計書 32-管理ダッシュボード

## 概要

本ドキュメントは、Legacy CMSにおける管理ダッシュボード画面の設計仕様を定義します。

### 本画面の処理概要

管理ダッシュボードは、管理画面のトップページとして機能し、各管理機能へのクイックアクセスと統計サマリーを提供します。

**業務上の目的・背景**：管理者がCMSにログインした際の最初の画面として、サイト全体の状況を一目で把握できるようにすることが目的です。記事数、コメント数、イベント数、メール数、ページ数、ローテーター数、ユーザー数などの統計情報を表示し、管理者が効率的にサイト運営を行えるようサポートします。

**画面へのアクセス方法**：管理者がログイン後に自動的にリダイレクトされる画面です。また、管理画面のナビゲーションから「Dashboard」リンクをクリックすることでアクセスできます。URL直接入力（/admin/）でもアクセス可能です。

**主要な操作・処理内容**：
1. 各コンテンツ種別（記事、コメント、イベント、メール、ページ、ローテーター、ユーザー）の統計情報を表示
2. 各管理機能へのショートカットリンクを提供
3. 権限に基づいた表示制御（ユーザーのロールに応じて表示項目が変化）

**画面遷移**：
- 遷移元：管理者ログイン画面（ログイン成功後）
- 遷移先：記事管理画面、コメント管理画面、イベント管理画面、メール管理画面、ページ管理画面、ローテーター管理画面、ユーザー管理画面

**権限による表示制御**：ACL（アクセス制御リスト）に基づき、ユーザーのロールに応じて表示されるダッシュボードアイテムが制御されます。例えば、記事管理権限（aarticles）がない場合、Articlesセクションは非表示となります。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | アクセス制御 | 主機能 | 管理者権限チェックとダッシュボード表示 |
| 5 | 記事一覧表示 | 補助機能 | 最近の記事サマリーを表示 |
| 21 | イベント一覧表示 | 補助機能 | 最近のイベントサマリーを表示 |

## 画面種別

ダッシュボード / トップページ

## URL/ルーティング

- URL: `/admin/` または `/admin/index/`
- モジュール: admin
- コントローラ: index
- アクション: index

## 入出力項目

本画面は入力項目を持ちません。

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 | 取得元 | 表示条件 |
|--------|--------|----------|------|--------|---------|
| 記事統計 | aStats | HTML | 記事数などの統計情報 | ビューヘルパー aStats() | aarticles権限 |
| コメント統計 | cStats | HTML | コメント数などの統計情報 | ビューヘルパー cStats() | gcomments権限 |
| イベント統計 | eStats | HTML | イベント数などの統計情報 | ビューヘルパー eStats() | eevents権限 |
| メール統計 | mStats | HTML | メール数などの統計情報 | ビューヘルパー mStats() | mmail権限 |
| ページ統計 | pStats | HTML | ページ数などの統計情報 | ビューヘルパー pStats() | ppages権限 |
| ローテーター統計 | rotStats | HTML | ローテーター数などの統計情報 | ビューヘルパー rotStats() | rotrotators権限 |
| ユーザー統計 | uStats | HTML | ユーザー数などの統計情報 | ビューヘルパー uStats() | uusers権限 |

## イベント仕様

### 1-画面表示

1. CMS_Controller_Action_Admin::preDispatch() で認証チェック
2. ACLでgadmin権限を確認
3. Admin_IndexController::indexAction() が呼び出される
4. レイアウトを'admin'に設定
5. ビューテンプレートがレンダリングされ、各統計ヘルパーが呼び出される

### 2-管理機能リンククリック

各ダッシュボードアイテムのリンクをクリックすると、対応する管理画面に遷移します：

- Articles → /admin/articles/
- Comments → /admin/comments/
- Events → /admin/events/
- Venues → /admin/events/venues/
- Mail → /admin/mail/
- Pages → /admin/pages/
- Rotators → /admin/rotators/
- Users → /admin/users/

## データベース更新仕様

### 操作別データベース影響一覧

本画面は参照のみを行い、データベースの更新は行いません。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 統計情報取得 | articles | SELECT | 記事数カウント |
| 統計情報取得 | comments | SELECT | コメント数カウント |
| 統計情報取得 | events | SELECT | イベント数カウント |
| 統計情報取得 | mail | SELECT | メール数カウント |
| 統計情報取得 | pages | SELECT | ページ数カウント |
| 統計情報取得 | rotators | SELECT | ローテーター数カウント |
| 統計情報取得 | users | SELECT | ユーザー数カウント |

## メッセージ仕様

本画面に固有のメッセージはありません。

## 例外処理

| 例外種別 | 条件 | 処理内容 |
|---------|------|---------|
| 認証エラー | 未ログイン状態でアクセス | ログイン画面へリダイレクト |
| 権限エラー | gadmin権限がない | 権限エラー画面へフォワード |

## 備考

- ダッシュボードの統計情報は各ビューヘルパー（aStats, cStats, eStats, mStats, pStats, rotStats, uStats）で生成される
- 表示される項目はACLに基づいてユーザーロールごとに動的に制御される
- Dojoツールキット（dojo.parser）が使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ACL（アクセス制御リスト）の構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CMS_Acl_Factory | `library/CMS/Acl/Factory.php` | ACLの生成とリソース定義を確認 |

**読解のコツ**: Zend_Aclを使用したロールベースのアクセス制御が実装されている。リソース名の命名規則を理解することが重要。

#### Step 2: エントリーポイントを理解する

認証と権限チェックの流れを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CMS_Controller_Action_Admin | `library/CMS/Controller/Action/Admin.php` | preDispatch()での認証・ACLチェック |
| 2-2 | Admin_IndexController.php | `application/modules/admin/controllers/IndexController.php` | indexAction()の実装 |

**主要処理フロー（CMS_Controller_Action_Admin）**:
1. **46-48行目**: Zend_Auth::hasIdentity()で認証チェック
2. **49-50行目**: 認証済みの場合、ユーザー情報をビューに渡す
3. **51-53行目**: CMS_Acl_Factoryで ACLを生成
4. **54-56行目**: gadmin権限チェック、なければ権限エラー画面へ
5. **57-58行目**: 未認証の場合、ログイン画面へリダイレクト

**主要処理フロー（Admin_IndexController）**:
1. **10-14行目**: init()でレジストリ取得とレイアウト設定
2. **19-21行目**: indexAction()でレイアウトを'admin'に設定

#### Step 3: ビューテンプレートを理解する

画面表示と権限制御の詳細を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.phtml | `application/modules/admin/views/scripts/index/index.phtml` | ダッシュボードのHTML構造とACL制御 |

**主要処理フロー**:
- **24-30行目**: 記事セクション（aarticles権限でガード）
- **31-37行目**: コメントセクション（gcomments権限でガード）
- **38-44行目**: イベントセクション（eevents権限、evenues権限）
- **45-51行目**: メールセクション（mmail権限でガード）
- **52-58行目**: ページセクション（ppages権限でガード）
- **59-65行目**: ローテーターセクション（rotrotators権限でガード）
- **66-72行目**: ユーザーセクション（uusers権限でガード）

### プログラム呼び出し階層図

```
HTTP Request (/admin/)
    │
    ├─ CMS_Controller_Action_Admin::preDispatch()
    │      │
    │      ├─ Zend_Auth::hasIdentity() [認証チェック]
    │      │
    │      ├─ CMS_Acl_Factory::createGlobalAcl() [ACL生成]
    │      │
    │      └─ $acl->isAllowed() [gadmin権限チェック]
    │
    └─ Admin_IndexController::indexAction()
           │
           └─ setLayout('admin')
                  │
                  └─ View rendering [index.phtml]
                         │
                         ├─ $this->acl->isAllowed() [各セクションの権限チェック]
                         │
                         ├─ $this->aStats() [記事統計]
                         ├─ $this->cStats() [コメント統計]
                         ├─ $this->eStats() [イベント統計]
                         ├─ $this->mStats() [メール統計]
                         ├─ $this->pStats() [ページ統計]
                         ├─ $this->rotStats() [ローテーター統計]
                         └─ $this->uStats() [ユーザー統計]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Session (user) ────────▶ preDispatch() ─────────▶ $view->user
                              │
                              ▼
                         CMS_Acl_Factory ────────▶ $view->acl
                              │
                              ▼
Database ─────────────▶ Stats View Helpers ─────▶ 各統計HTML
(articles, comments,
 events, etc.)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IndexController.php | `application/modules/admin/controllers/IndexController.php` | コントローラ | ダッシュボードの制御 |
| index.phtml | `application/modules/admin/views/scripts/index/index.phtml` | ビュー | ダッシュボードテンプレート |
| CMS_Controller_Action_Admin | `library/CMS/Controller/Action/Admin.php` | 基底クラス | 認証・ACLチェック |
| CMS_Acl_Factory | `library/CMS/Acl/Factory.php` | ACL | アクセス制御リスト生成 |
| admin.phtml | `application/layouts/scripts/admin.phtml` | レイアウト | 管理画面レイアウト |
| aStats (View Helper) | `application/views/helpers/AStats.php` | ヘルパー | 記事統計生成 |
| cStats (View Helper) | `application/views/helpers/CStats.php` | ヘルパー | コメント統計生成 |
| eStats (View Helper) | `application/views/helpers/EStats.php` | ヘルパー | イベント統計生成 |
| mStats (View Helper) | `application/views/helpers/MStats.php` | ヘルパー | メール統計生成 |
| pStats (View Helper) | `application/views/helpers/PStats.php` | ヘルパー | ページ統計生成 |
| rotStats (View Helper) | `application/views/helpers/RotStats.php` | ヘルパー | ローテーター統計生成 |
| uStats (View Helper) | `application/views/helpers/UStats.php` | ヘルパー | ユーザー統計生成 |
