# 画面設計書 33-管理者ログイン画面

## 概要

本ドキュメントは、Legacy CMSにおける管理者ログイン画面の設計仕様を定義します。

### 本画面の処理概要

管理者ログイン画面は、CMSの管理機能にアクセスするための認証画面です。メールアドレスとパスワードによる認証を行い、認証成功時に管理ダッシュボードへ遷移します。

**業務上の目的・背景**：CMS管理機能へのアクセスを制御し、認証されたユーザーのみが管理操作を行えるようにするためのセキュリティゲートです。ログイン情報の記憶機能（Remember me）により、継続的な管理作業を効率化します。

**画面へのアクセス方法**：
1. ブラウザで直接 `/admin/auth/login/` にアクセス
2. 管理画面の任意のURLに未認証状態でアクセスした場合に自動リダイレクト
3. ログアウト後のリダイレクト先

**主要な操作・処理内容**：
1. メールアドレスとパスワードの入力
2. 「Remember me」チェックボックスによるログイン情報の保存選択
3. ログインボタン押下による認証処理
4. パスワードリセット画面へのリンク

**画面遷移**：
- 遷移元：管理画面（未認証時）、ログアウト処理後
- 遷移先：管理ダッシュボード（認証成功時）、パスワードリセット画面

**権限による表示制御**：本画面は認証前の画面のため、権限による表示制御はありません。既にログイン済みの場合は、管理ダッシュボードへ自動リダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ログイン | 主機能 | 管理者認証処理を実行 |
| 63 | 入力検証 | 補助機能 | ログインフォームのバリデーション |

## 画面種別

認証 / フォーム入力

## URL/ルーティング

- URL: `/admin/auth/login/`
- モジュール: admin
- コントローラ: auth
- アクション: login

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | バリデーション | 説明 |
|--------|--------|----------|------|---------------|------|
| メールアドレス | email | 文字列 | Yes | NotEmpty, EmailAddress | ログイン用メールアドレス |
| パスワード | password | 文字列 | Yes | NotEmpty, StringLength(min:4) | ログインパスワード |
| Remember me | remember | 真偽値 | No | - | ログイン情報をCookieに保存 |

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| エラーメッセージ | messages | 配列 | バリデーションエラーや認証エラー時に表示 |
| メールアドレス初期値 | email | 文字列 | Cookie保存時または入力エラー時の再表示用 |

## イベント仕様

### 1-画面初期表示

1. Admin_AuthController::preDispatch() が呼び出される
2. 既に認証済みの場合、管理ダッシュボードへリダイレクト
3. loginAction() で画面表示
4. Cookieにログイン情報が保存されている場合、フォームに自動入力

### 2-ログインボタン押下

1. フォームがPOSTされる
2. Zend_Filter_Inputによる入力バリデーション実行
   - email: StringTrim, StringToLower フィルタ
   - email: NotEmpty, EmailAddress バリデータ
   - password: NotEmpty, StringLength(4) バリデータ
3. バリデーション成功時、Zend_Auth_Adapter_DbTableで認証実行
   - usersテーブルからuser_email, user_passwordで照合
   - パスワードはMD5(サイトキー + 入力パスワード + ソルト)でハッシュ化
   - user_status = 'active' 条件でフィルタ
4. 認証成功時：
   - Zend_Auth storageにユーザー情報を保存
   - 「Remember me」チェック時はCookieに情報保存（3ヶ月有効）
   - 管理ダッシュボードへリダイレクト
5. 認証失敗時：
   - FAILURE_IDENTITY_NOT_FOUND: メールアドレスが見つからない
   - FAILURE_CREDENTIAL_INVALID: パスワードが不正
   - エラーメッセージを表示し、入力済みのメールアドレスを保持

### 3-パスワードリセットリンククリック

パスワードリセット画面（/admin/auth/password/）へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログイン認証 | users | SELECT | メールアドレスとパスワードで照合 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_email | 入力されたメールアドレスと一致 | 認証識別子 |
| SELECT | user_password | MD5ハッシュ値と一致 | 認証クレデンシャル |
| SELECT | user_status | 'active' | アクティブユーザーのみ |
| SELECT | user_salt | パスワードハッシュ計算に使用 | セキュリティ強化 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | エラー | E-mail address is required | メールアドレス未入力 |
| MSG-002 | エラー | Invalid e-mail address | メールアドレス形式不正 |
| MSG-003 | エラー | Password is required | パスワード未入力 |
| MSG-004 | エラー | Password must be at least 4 characters long | パスワード文字数不足 |
| MSG-005 | エラー | Not Found | メールアドレスが登録されていない |
| MSG-006 | エラー | Invalid | パスワードが一致しない |

## 例外処理

| 例外種別 | 条件 | 処理内容 |
|---------|------|---------|
| 認証失敗 | ID不一致 | "Not Found"メッセージを表示 |
| 認証失敗 | パスワード不一致 | "Invalid"メッセージを表示 |
| 予期しない認証エラー | その他のZend_Auth_Resultコード | Exception throw |

## 備考

- パスワードはMD5でハッシュ化（サイトキー + パスワード + ユーザー固有ソルト）
- Cookie有効期限は約3ヶ月（7889231秒）
- Dojoツールキットを使用したフォームUI（dijit.form.ValidationTextBox, dijit.form.Button, dijit.form.CheckBox）
- Cookieドメインはサイト設定（site.cookie）から取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーテーブルの構造と認証方式を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | users テーブル | データベーススキーマ | user_email, user_password, user_salt, user_statusカラム |

**読解のコツ**: パスワードはMD5(site_key + password + user_salt)でハッシュ化されている。Zend_Auth_Adapter_DbTableの第5引数がこの計算式を定義。

#### Step 2: エントリーポイントを理解する

認証コントローラの流れを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_AuthController.php | `application/modules/admin/controllers/AuthController.php` | preDispatch(), loginAction()の実装 |

**主要処理フロー（preDispatch）**:
1. **42-49行目**: preDispatch()で認証状態チェック
2. **44-48行目**: 認証済みかつlogout以外のアクションなら、ダッシュボードへリダイレクト
3. **50-56行目**: 未認証かつlogoutアクションなら、ログイン画面へリダイレクト

**主要処理フロー（loginAction）**:
1. **59-70行目**: レイアウト設定とリファラーページの取得
2. **71行目**: POSTリクエストの判定
3. **73-101行目**: フィルタとバリデータの定義
4. **103行目**: Zend_Filter_Inputでバリデーション実行
5. **108-116行目**: 認証成功時の処理
6. **109-115行目**: Zend_Auth_Adapter_DbTableの設定
7. **117-119行目**: user_status = 'active' 条件追加
8. **121-122行目**: 認証識別子とクレデンシャル設定
9. **126-136行目**: 認証成功時のCookie設定とリダイレクト
10. **139-151行目**: 認証失敗時のエラーハンドリング

#### Step 3: ビューテンプレートを理解する

フォームUIの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | login.phtml | `application/modules/admin/views/scripts/auth/login.phtml` | フォーム構造とDojo Widget |

**主要処理フロー**:
- **9-16行目**: Dojoモジュールのロード設定
- **26行目**: RenderMessagesでエラーメッセージ表示
- **30-98行目**: Cookie有無による条件分岐（フォームの初期値設定）
- **33-43行目**: メールアドレス入力フィールド（ValidationTextBox）
- **47-56行目**: パスワード入力フィールド（ValidationTextBox）
- **60-62行目**: ログインボタンとRemember meチェックボックス

### プログラム呼び出し階層図

```
HTTP Request (/admin/auth/login/)
    │
    ├─ Admin_AuthController::preDispatch()
    │      │
    │      └─ Zend_Auth::hasIdentity() [認証状態チェック]
    │              │
    │              └─ 認証済み → redirect to dashboard
    │
    └─ Admin_AuthController::loginAction()
           │
           ├─ setLayout('admin-auth')
           │
           ├─ [GET] View rendering
           │
           └─ [POST]
                  │
                  ├─ Zend_Filter_Input [バリデーション]
                  │
                  ├─ Zend_Auth_Adapter_DbTable [認証]
                  │      │
                  │      └─ SELECT from users WHERE user_email = ?
                  │         AND user_password = MD5(...)
                  │         AND user_status = 'active'
                  │
                  ├─ [成功]
                  │      ├─ Zend_Auth storage write
                  │      ├─ Cookie設定（Remember me時）
                  │      └─ redirect to dashboard
                  │
                  └─ [失敗]
                         └─ エラーメッセージ設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

email, password ────▶ Zend_Filter_Input ─────▶ バリデーション結果
                              │
                              ▼
                         [成功]
                              │
                              ▼
users テーブル ─────▶ Zend_Auth_Adapter_DbTable ──▶ 認証結果
                              │
                              ▼
                         [成功]
                              │
                              ├─▶ Zend_Auth Storage (Session)
                              │
                              └─▶ Cookie (Remember me時)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/admin/controllers/AuthController.php` | コントローラ | 認証処理の制御 |
| login.phtml | `application/modules/admin/views/scripts/auth/login.phtml` | ビュー | ログインフォームテンプレート |
| CMS_Controller_Action_Auth | `library/CMS/Controller/Action/Auth.php` | 基底クラス | 認証コントローラの親クラス |
| admin-auth.phtml | `application/layouts/scripts/admin-auth.phtml` | レイアウト | 認証画面用レイアウト |
| RenderMessages (View Helper) | `application/views/helpers/RenderMessages.php` | ヘルパー | エラーメッセージ表示 |
