# 画面設計書 34-管理者パスワード変更画面

## 概要

本ドキュメントは、Legacy CMSにおける管理者パスワード変更画面（パスワードリセット）の設計仕様を定義します。

### 本画面の処理概要

管理者パスワード変更画面は、パスワードを忘れた管理者がメールアドレスを入力して新しいパスワードをメールで受け取るための画面です。

**業務上の目的・背景**：管理者がパスワードを忘れた場合に、セキュアな方法でパスワードをリセットできるようにする機能です。登録されたメールアドレスに新しいパスワードを送信することで、本人確認とパスワード再発行を同時に実現します。

**画面へのアクセス方法**：
1. ログイン画面の「Forgotten your password?」リンクをクリック
2. 直接URLにアクセス（/admin/auth/password/）

**主要な操作・処理内容**：
1. メールアドレスの入力
2. リセットボタン押下による処理実行
3. データベースでユーザー存在確認
4. 新しいパスワードの自動生成
5. パスワードのハッシュ化とデータベース更新
6. 新パスワードをメールで送信

**画面遷移**：
- 遷移元：管理者ログイン画面
- 遷移先：同画面（処理完了メッセージ表示）、ログイン画面（リンクから）

**権限による表示制御**：本画面は認証前の画面のため、権限による表示制御はありません。既にログイン済みの場合は、管理ダッシュボードへ自動リダイレクトされます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | パスワード変更 | 主機能 | 管理者パスワードの変更処理 |
| 63 | 入力検証 | 補助機能 | パスワード変更フォームのバリデーション |

## 画面種別

認証 / フォーム入力

## URL/ルーティング

- URL: `/admin/auth/password/`
- モジュール: admin
- コントローラ: auth
- アクション: password

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | バリデーション | 説明 |
|--------|--------|----------|------|---------------|------|
| メールアドレス | email | 文字列 | Yes | NotEmpty, EmailAddress, RecordExists | パスワードリセット対象のメールアドレス |

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| エラーメッセージ | messages | 配列 | バリデーションエラー時に表示 |
| 完了メッセージ | - | 文字列 | パスワードリセット成功時に表示 |

## イベント仕様

### 1-画面初期表示

1. Admin_AuthController::preDispatch() が呼び出される
2. 既に認証済みの場合、管理ダッシュボードへリダイレクト
3. passwordAction() で画面表示
4. $this->view->posted = 'N' を設定

### 2-パスワードリセットボタン押下

1. フォームがPOSTされる
2. Zend_Filter_Inputによる入力バリデーション実行
   - email: StringTrim, StringToLower フィルタ
   - email: NotEmpty, EmailAddress バリデータ
   - email: Zend_Validate_Db_RecordExists バリデータ（usersテーブル、user_emailカラム）
3. バリデーション成功時：
   - usersテーブルからユーザー情報とプロフィールを取得
   - generatePassword() で8文字のランダムパスワード生成
   - 新しいソルトも生成
   - パスワードをMD5(サイトキー + パスワード + ソルト)でハッシュ化
   - usersテーブルのuser_password, user_saltを更新
   - 新パスワードをメールで送信
   - $this->view->posted = 'Y' を設定し、完了メッセージを表示
4. バリデーション失敗時：
   - エラーメッセージを表示
   - $this->view->posted = 'N' を設定

### 3-ログインリンククリック

ログイン画面（/admin/auth/login/）へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ユーザー存在確認 | users | SELECT | メールアドレスでユーザー検索 |
| ユーザー情報取得 | users, users_profiles | SELECT | パスワードリセット対象ユーザーの情報取得 |
| パスワード更新 | users | UPDATE | 新パスワードとソルトを更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_email | 入力されたメールアドレスと一致 | ユーザー存在確認 |
| SELECT | user_id | - | 更新対象の特定 |
| UPDATE | user_password | MD5(site_key + new_password + salt) | 新パスワードのハッシュ |
| UPDATE | user_salt | 8文字のランダム文字列 | 新しいソルト |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | エラー | Missing E-mail Address - you did not enter an e-mail address | メールアドレス未入力 |
| MSG-002 | エラー | Invalid E-mail Address | メールアドレス形式不正 |
| MSG-003 | エラー | Invalid E-mail Address - entered e-mail address is not associated with an existing account | メールアドレスが登録されていない |
| MSG-004 | 情報 | Your password has been reset - You should shortly receive an e-mail containing your new password. | パスワードリセット成功 |

## 例外処理

| 例外種別 | 条件 | 処理内容 |
|---------|------|---------|
| レコード未存在 | メールアドレスがusersテーブルに存在しない | エラーメッセージを表示 |
| メール送信失敗 | SMTP接続失敗など | 例外がスローされる可能性 |

## 備考

- パスワード生成は8文字のランダム英数字（0, 1, I, O, l を除外して可読性を向上）
- 新パスワードは平文でメール送信される
- メール送信にはZend_Mailを使用
- メールのFrom/Reply-Toはサイト設定から取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーテーブルとプロフィールテーブルの構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | users, users_profiles テーブル | データベーススキーマ | user_email, user_password, user_salt, upro_first, upro_last |

**読解のコツ**: usersとusers_profilesはuser_id/upro_useridで結合される。メール送信時に名前を取得するためにJOINが必要。

#### Step 2: エントリーポイントを理解する

パスワードリセット処理の流れを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_AuthController.php | `application/modules/admin/controllers/AuthController.php` | passwordAction(), generatePassword() |

**主要処理フロー（passwordAction）**:
1. **171-173行目**: passwordAction()開始、レイアウト設定
2. **175行目**: POSTリクエスト判定
3. **179-192行目**: バリデータ定義（NotEmpty, EmailAddress, RecordExists）
4. **194行目**: Zend_Filter_Inputでバリデーション実行
5. **196行目**: バリデーション成功判定
6. **198-210行目**: ユーザー情報の取得（users + users_profilesのJOIN）
7. **212-213行目**: generatePassword()で新パスワードとソルト生成
8. **215-219行目**: パスワードデータの作成
9. **222行目**: usersテーブル更新
10. **224-235行目**: Zend_Mailでパスワード送信メール作成・送信
11. **237行目**: posted = 'Y'で完了状態を設定

**主要処理フロー（generatePassword）**:
1. **25-27行目**: 使用文字セット定義（0, 1, I, O, l除外）
2. **28行目**: srand()で乱数初期化
3. **32-36行目**: 8文字のランダム文字列生成

#### Step 3: ビューテンプレートを理解する

フォームUIと完了メッセージの表示を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | password.phtml | `application/modules/admin/views/scripts/auth/password.phtml` | フォーム構造と条件分岐 |

**主要処理フロー**:
- **9-16行目**: Dojoモジュールのロード設定
- **26行目**: RenderMessagesでエラーメッセージ表示
- **28-30行目**: posted = 'Y'時の完了メッセージ表示
- **32-54行目**: パスワードリセットフォーム
- **36-46行目**: メールアドレス入力フィールド（ValidationTextBox）
- **51行目**: ログイン画面へのリンク

### プログラム呼び出し階層図

```
HTTP Request (/admin/auth/password/)
    │
    ├─ Admin_AuthController::preDispatch()
    │      │
    │      └─ Zend_Auth::hasIdentity() [認証状態チェック]
    │              │
    │              └─ 認証済み → redirect to dashboard
    │
    └─ Admin_AuthController::passwordAction()
           │
           ├─ setLayout('admin-auth')
           │
           ├─ [GET] View rendering (posted = 'N')
           │
           └─ [POST]
                  │
                  ├─ Zend_Filter_Input [バリデーション]
                  │      │
                  │      └─ Zend_Validate_Db_RecordExists
                  │             │
                  │             └─ SELECT from users WHERE user_email = ?
                  │
                  ├─ [バリデーション成功]
                  │      │
                  │      ├─ SELECT from users JOIN users_profiles
                  │      │
                  │      ├─ generatePassword() [パスワード生成]
                  │      │
                  │      ├─ UPDATE users SET user_password, user_salt
                  │      │
                  │      └─ Zend_Mail::send() [メール送信]
                  │
                  └─ [バリデーション失敗]
                         └─ エラーメッセージ設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

email ────────────────▶ Zend_Filter_Input ─────▶ バリデーション結果
                              │
                              ▼
                         [バリデーション成功]
                              │
                              ▼
users テーブル ─────────▶ SELECT (user_email) ───▶ ユーザー情報
                              │
                              ▼
                         generatePassword()
                              │
                              ├─▶ 新パスワード（平文）
                              └─▶ 新ソルト
                              │
                              ▼
                         MD5ハッシュ化
                              │
                              ▼
users テーブル ◀─────── UPDATE ───────────────▶ パスワード更新完了
                              │
                              ▼
                         Zend_Mail ─────────────▶ パスワード通知メール
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/admin/controllers/AuthController.php` | コントローラ | パスワードリセット処理 |
| password.phtml | `application/modules/admin/views/scripts/auth/password.phtml` | ビュー | パスワードリセットフォーム |
| CMS_Controller_Action_Auth | `library/CMS/Controller/Action/Auth.php` | 基底クラス | 認証コントローラの親クラス |
| admin-auth.phtml | `application/layouts/scripts/admin-auth.phtml` | レイアウト | 認証画面用レイアウト |
| info.phtml | `application/modules/admin/views/scripts/_partials/info.phtml` | パーシャル | 完了メッセージ表示 |
| RenderMessages (View Helper) | `application/views/helpers/RenderMessages.php` | ヘルパー | エラーメッセージ表示 |
