# 画面設計書 35-記事管理画面

## 概要

本ドキュメントは、Legacy CMSにおける記事管理画面の設計仕様を定義します。

### 本画面の処理概要

記事管理画面は、CMS内の記事を一覧表示し、検索・フィルタリング・ソート機能を提供する管理者向けの画面です。記事の編集、削除、新規作成への導線を提供します。

**業務上の目的・背景**：コンテンツ管理の中核機能として、管理者が効率的に記事を管理できるようにすることが目的です。大量の記事がある場合でも、カテゴリ、著者、日付などでフィルタリングし、目的の記事を素早く見つけられるようにします。

**画面へのアクセス方法**：
1. 管理ダッシュボードの「Articles」リンクをクリック
2. 直接URL（/admin/articles/ または /admin/articles/manage/）にアクセス

**主要な操作・処理内容**：
1. 記事一覧の表示（ページネーション付き）
2. カテゴリ、著者、ソート条件によるフィルタリング
3. 記事の新規作成ダイアログ表示
4. カテゴリの新規作成ダイアログ表示
5. 記事の編集画面への遷移
6. 記事の削除（確認ダイアログ付き）
7. カテゴリの編集・削除（コンテキストメニュー）

**画面遷移**：
- 遷移元：管理ダッシュボード
- 遷移先：記事編集画面、記事新規作成ダイアログ、記事詳細画面、カテゴリ管理ダイアログ

**権限による表示制御**：
- aarticles権限：画面へのアクセス自体を制御
- aarticlenew権限：「New Article」ボタンの表示
- acategorynew権限：「New Category」ボタンの表示
- acategoryedit権限：カテゴリ編集メニューの表示
- acategorydelete権限：カテゴリ削除メニューの表示
- aarticledelete権限：記事削除リンクの表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 記事一覧表示 | 主機能 | 管理用の記事一覧を表示 |
| 62 | ページネーション | 補助機能 | 記事一覧のページ送り処理 |
| 61 | アクセス制御 | 補助機能 | 管理者権限チェック |
| 8 | 記事削除 | 遷移先機能 | 記事削除ダイアログへの遷移 |

## 画面種別

一覧 / 管理

## URL/ルーティング

- URL: `/admin/articles/` または `/admin/articles/manage/`
- モジュール: admin
- コントローラ: articles
- アクション: manage（indexはmanageへリダイレクト）

## 入出力項目

### 入力項目（フィルタパラメータ）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ページ番号 | page | 整数 | No | 表示するページ番号 |
| カテゴリID | category | 整数 | No | カテゴリでフィルタ |
| 著者ID | author | 整数 | No | 著者でフィルタ |
| ソート項目 | sort | 文字列 | No | article/author/category/date |
| ソート順 | order | 文字列 | No | asc/desc |

## 表示項目

### 記事一覧

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 記事タイトル | article_title | 文字列 | 記事のタイトル |
| ステータス | article_status | 文字列 | published/draft |
| 著者名 | user_alias | 文字列 | 記事の著者 |
| カテゴリ名 | acat_title | 文字列 | 記事のカテゴリ |
| 日時 | article_published/article_edit | 日時 | 公開日または最終編集日 |

### カテゴリ一覧

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| カテゴリ名 | acat_title | 文字列 | カテゴリのタイトル |
| 記事数 | - | 整数 | カテゴリ内の記事数 |

## イベント仕様

### 1-画面初期表示

1. CMS_Controller_Action_Admin::preDispatch()で認証・ACLチェック
2. Admin_ArticlesController::manageAction()が呼び出される
3. aarticles権限チェック（なければ権限エラー画面へ）
4. Articles::getFilter()でフィルタパラメータを解析
5. Articles::fetchArticles()でページネーション付き記事一覧を取得
6. Articles::fetchCategories()でカテゴリ一覧を取得
7. ビューにデータを渡してレンダリング

### 2-フィルタタグクリック

アクティブなフィルタ（著者、カテゴリ、ソート、順序）のタグをクリックすると、そのフィルタを解除して再検索します。

### 3-カラムヘッダークリック

テーブルのカラムヘッダー（Article, Author, Category, Date）をクリックすると、そのカラムでソートします。既にソート中の場合は昇順/降順を切り替えます。

### 4-New Articleボタン押下

Ajaxダイアログで記事新規作成フォームを表示します（getDialog関数）。

### 5-New Categoryボタン押下

Ajaxダイアログでカテゴリ新規作成フォームを表示します。

### 6-記事タイトルクリック

記事編集画面（/admin/articles/edit/id/{id}）へ遷移します。

### 7-Deleteリンククリック

削除確認ダイアログを表示し、確認後にArticles::deleteArticle()を実行します。

### 8-カテゴリコンテキストメニュー

カテゴリタグを右クリックすると、Edit/Deleteメニューが表示されます（dijit.Menu）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 記事一覧表示 | articles, articles_categories, users | SELECT | 記事一覧取得（JOIN） |
| カテゴリ一覧表示 | articles_categories | SELECT | カテゴリ一覧取得 |
| カテゴリ記事数表示 | articles | SELECT | カテゴリ別記事数カウント |
| 記事削除 | articles | DELETE | 指定記事を削除 |
| 記事削除 | tags_slaves | DELETE | 記事に関連するタグを削除 |
| 記事削除 | comments | DELETE | 記事に関連するコメントを削除 |
| 記事削除 | Luceneインデックス | DELETE | 検索インデックスから削除 |

### テーブル別更新項目詳細

#### articles（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | article_id | - | 記事ID |
| SELECT | article_title | - | タイトル |
| SELECT | article_status | - | ステータス |
| SELECT | article_published | - | 公開日 |
| SELECT | article_edit | - | 最終編集日 |
| SELECT | article_user | = author パラメータ | 著者フィルタ |
| SELECT | article_category | = category パラメータ | カテゴリフィルタ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | No Articles! | 記事が0件の場合 |
| MSG-002 | 情報 | No Categories! | カテゴリが0件の場合 |
| MSG-003 | 情報 | No active filter | フィルタが未設定の場合 |
| MSG-004 | 確認 | Are you sure you want to delete this article? | 記事削除確認 |
| MSG-005 | 完了 | Article Deleted | 記事削除完了 |

## 例外処理

| 例外種別 | 条件 | 処理内容 |
|---------|------|---------|
| 権限エラー | aarticles権限がない | 権限エラー画面へフォワード |
| 削除権限エラー | aarticledelete権限がない | 権限エラー画面へフォワード |

## 備考

- ページネーションは1ページ15件、5ページ分のリンク表示
- Dojoツールキットを使用（dijit.Dialog, dijit.Menu, dijit.form.Button等）
- カテゴリID=1はデフォルトカテゴリのため削除不可
- 削除時はタグ、コメント、検索インデックスも連動削除

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

記事関連テーブルの構造を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Articles モデル | `application/models/Articles.php` | テーブル構造とリレーション |

**読解のコツ**: articles, articles_categories, usersの3テーブルがJOINされる。ページネーションはZend_Paginatorを使用。

#### Step 2: エントリーポイントを理解する

コントローラの処理フローを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | manageAction()の実装 |

**主要処理フロー（manageAction）**:
1. **30行目**: manageAction()開始
2. **32行目**: aarticles権限チェック
3. **34-35行目**: ページネーション設定（15件/ページ、5ページ範囲）
4. **37行目**: リクエストパラメータ取得
5. **39行目**: Articlesモデルインスタンス化
6. **41行目**: getFilter()でフィルタ情報取得
7. **42行目**: fetchArticles()で記事一覧取得
8. **43行目**: fetchCategories()でカテゴリ一覧取得

#### Step 3: モデル層を理解する

データ取得ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Articles.php | `application/models/Articles.php` | getFilter(), fetchArticles(), fetchCategories() |

**主要処理フロー（fetchArticles）**:
- **101-162行目**: 記事取得とページネーション
- **109-111行目**: articles, articles_categories, usersのJOIN
- **114-120行目**: author, categoryフィルタ適用
- **122-136行目**: ソート条件適用
- **156-159行目**: Zend_Paginatorでページネーション

#### Step 4: ビューテンプレートを理解する

画面UIと権限制御を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | manage.phtml | `application/modules/admin/views/scripts/articles/manage.phtml` | テーブル構造とACL制御 |

**主要処理フロー**:
- **32-44行目**: Functions fieldset（New Article, New Categoryボタン）
- **49-58行目**: Filter fieldset（アクティブフィルタ表示）
- **64-81行目**: Categories fieldset（カテゴリ一覧とコンテキストメニュー）
- **83-149行目**: 記事一覧テーブル
- **151-158行目**: ページネーション

### プログラム呼び出し階層図

```
HTTP Request (/admin/articles/manage/)
    │
    ├─ CMS_Controller_Action_Admin::preDispatch()
    │      └─ 認証・gadmin権限チェック
    │
    └─ Admin_ArticlesController::manageAction()
           │
           ├─ $acl->isAllowed('aarticles') [権限チェック]
           │
           ├─ Articles::getFilter($params)
           │      └─ フィルタパラメータ解析
           │
           ├─ Articles::fetchArticles($params)
           │      │
           │      ├─ SELECT from articles
           │      │   JOIN articles_categories
           │      │   JOIN users
           │      │   WHERE category = ? AND author = ?
           │      │   ORDER BY ?
           │      │
           │      └─ Zend_Paginator::factory()
           │
           ├─ Articles::fetchCategories()
           │      └─ SELECT from articles_categories ORDER BY title
           │
           └─ View rendering [manage.phtml]
                  │
                  ├─ ACL checks for buttons
                  ├─ Filter tags display
                  ├─ Category list with context menu
                  ├─ Article table
                  └─ Pagination controls
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Request params ────────▶ getFilter() ──────────▶ $view->filter
(page, category,
 author, sort, order)

                         fetchArticles()
                              │
articles テーブル ─────▶   JOIN ────────────▶ $view->articlesArray
articles_categories ──▶   +WHERE            (Paginator)
users ────────────────▶   +ORDER BY

articles_categories ──▶ fetchCategories() ──▶ $view->categoryArray
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | コントローラ | 記事管理の制御 |
| manage.phtml | `application/modules/admin/views/scripts/articles/manage.phtml` | ビュー | 記事一覧テンプレート |
| Articles.php | `application/models/Articles.php` | モデル | 記事データの操作 |
| CMS_Controller_Action_Admin | `library/CMS/Controller/Action/Admin.php` | 基底クラス | 認証・ACLチェック |
| default.phtml | `application/views/scripts/_pagination/default.phtml` | パーシャル | ページネーション表示 |
| admin.phtml | `application/layouts/scripts/admin.phtml` | レイアウト | 管理画面レイアウト |
| ACatCount (View Helper) | `application/views/helpers/ACatCount.php` | ヘルパー | カテゴリ別記事数表示 |
