# 画面設計書 37-記事新規作成画面

## 概要

本ドキュメントは、Legacy CMSにおける記事新規作成画面（ダイアログ）の設計仕様を定義します。

### 本画面の処理概要

記事新規作成画面は、新しい記事の基本情報（タイトル、カテゴリ）を入力し、記事レコードを作成するためのAjaxダイアログです。作成後は記事編集画面へ遷移します。

**業務上の目的・背景**：記事コンテンツを作成する際の最初のステップとして、記事の基本情報を登録する機能です。詳細な編集は記事編集画面で行う設計となっており、シンプルな入力で素早く記事を作成開始できます。

**画面へのアクセス方法**：
1. 記事管理画面の「New Article」ボタンをクリック
2. Ajaxダイアログとして表示される

**主要な操作・処理内容**：
1. 記事タイトルの入力
2. カテゴリの選択
3. Createボタンで記事作成
4. 作成成功後、記事編集画面へ遷移

**画面遷移**：
- 遷移元：記事管理画面（ダイアログとして）
- 遷移先：記事編集画面（Continue押下時）

**権限による表示制御**：
- aarticles + aarticlenew権限：画面へのアクセス

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | 記事新規作成 | 主機能 | 新規記事の作成処理 |
| 63 | 入力検証 | 補助機能 | 記事フォームのバリデーション |
| 60 | 検索インデックス更新 | 補助機能 | 保存時に検索インデックスを更新 |
| 64 | Ajaxダイアログ | 補助機能 | アセット選択などのダイアログ表示 |

## 画面種別

登録 / モーダルダイアログ

## URL/ルーティング

- URL: `/admin/articles/new/`
- モジュール: admin
- コントローラ: articles
- アクション: new
- 表示方式: Ajaxダイアログ（dijit.Dialog）

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | バリデーション | 説明 |
|--------|--------|----------|------|---------------|------|
| タイトル | articletitle | 文字列 | Yes | NotEmpty | 記事タイトル |
| カテゴリ | articlecategory | 整数 | Yes | NotEmpty | カテゴリID |

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| エラーメッセージ | messages | 配列 | バリデーションエラー時に表示 |

## イベント仕様

### 1-ダイアログ表示

1. 記事管理画面でNew ArticleボタンをクリックするとgetDialog()が呼び出される
2. /admin/articles/new/ にAjaxリクエスト
3. Admin_ArticlesController::newAction()が呼び出される
4. aarticles + aarticlenew権限チェック
5. レイアウト無効化
6. posted = 'N' を設定してフォーム表示

### 2-Createボタン押下

1. doDialog()でフォームデータをAjax送信
2. newAction()がPOSTリクエストを処理
3. バリデーション実行（articletitle, articlecategory必須）
4. バリデーション成功時：
   - Articles::newArticle()で新規記事作成
   - 現在のログインユーザーを著者として設定
   - 作成日と編集日を現在日時で設定
   - 「Article Created」メッセージと「Continue」ボタンを表示
5. バリデーション失敗時：
   - エラーメッセージを表示
   - 入力値を保持してフォーム再表示

### 3-Continueボタン押下

goTo()で記事編集画面（/admin/articles/edit/id/{新規ID}）へ遷移します。

### 4-Cancelボタン押下

dijit.byId('ajaxDialog').hide()でダイアログを閉じます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 記事作成 | articles | INSERT | 新規記事レコード作成 |

### テーブル別更新項目詳細

#### articles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | article_title | フォーム入力値 | タイトル |
| INSERT | article_category | フォーム入力値 | カテゴリID |
| INSERT | article_user | ログインユーザーのuser_id | 著者 |
| INSERT | article_date | NOW() | 作成日時 |
| INSERT | article_edit | NOW() | 編集日時 |
| INSERT | article_status | 'draft' (デフォルト) | ステータス |
| INSERT | article_intro | NULL (デフォルト) | ティーザー |
| INSERT | article_content | NULL (デフォルト) | 本文 |
| INSERT | article_comments | 'N' (デフォルト) | コメント許可 |
| INSERT | article_moderate | 'N' (デフォルト) | モデレート |
| INSERT | article_sticky | 'N' (デフォルト) | スティッキー |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | エラー | Title is required | タイトル未入力 |
| MSG-002 | エラー | Category is required | カテゴリ未選択 |
| MSG-003 | 完了 | Article Created | 記事作成成功 |

## 例外処理

| 例外種別 | 条件 | 処理内容 |
|---------|------|---------|
| 権限エラー | aarticles/aarticlenew権限なし | 権限エラー画面へフォワード |
| バリデーションエラー | 必須項目未入力 | エラーメッセージ表示、フォーム再表示 |
| パラメータ不正 | titleまたはcategoryが不正 | Exception throw |

## 備考

- ダイアログはAjaxで読み込まれ、レイアウトは無効化される
- 新規作成時はステータスが'draft'となり、公開には別途Publish操作が必要
- 作成直後は本文が空のため、Continue押下後に編集画面で内容を入力する
- 記事IDはlastInsertId()で取得

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

記事テーブルのINSERT時の必須項目を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Articles モデル | `application/models/Articles.php` | newArticle()のパラメータ |

**読解のコツ**: INSERTされる項目はtitle, category, user, date, editのみ。その他はデフォルト値またはNULL。

#### Step 2: エントリーポイントを理解する

コントローラの新規作成処理フローを把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | newAction() |

**主要処理フロー（newAction）**:
1. **336-338行目**: newAction()開始
2. **338行目**: aarticles + aarticlenew権限チェック
3. **340行目**: レイアウト無効化
4. **342行目**: POSTリクエスト判定
5. **344-359行目**: バリデータ定義
6. **361行目**: Zend_Filter_Inputでバリデーション
7. **363行目**: バリデーション成功判定
8. **365-370行目**: Articles::newArticle()呼び出し
9. **372-377行目**: 成功メッセージとContinueボタン出力
10. **376行目**: lastInsertId()で新規IDを取得し編集画面URLを生成

#### Step 3: モデル層を理解する

記事INSERT処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Articles.php | `application/models/Articles.php` | newArticle() |

**主要処理フロー（newArticle）**:
- **222-237行目**: 新規記事作成処理
- **224行目**: パラメータバリデーション
- **225-231行目**: INSERTデータ配列作成
- **226行目**: article_title
- **227行目**: article_category
- **228行目**: article_user
- **229行目**: article_date = NOW()
- **230行目**: article_edit = NOW()
- **233行目**: DBへのINSERT実行

#### Step 4: ビューテンプレートを理解する

ダイアログフォームの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new.phtml | `application/modules/admin/views/scripts/articles/new.phtml` | フォーム構造 |

**主要処理フロー（new.phtml）**:
- **9行目**: posted = 'N'時の条件分岐でフォーム表示
- **10行目**: RenderMessagesでエラーメッセージ表示
- **11行目**: フォーム開始（doDialog()でサブミット）
- **12-26行目**: タイトル入力（ValidationTextBox）
- **27-38行目**: カテゴリ選択（FilteringSelect）
- **40-46行目**: Createボタン（doDialog呼び出し）
- **47-52行目**: Cancelボタン（ダイアログ非表示）

### プログラム呼び出し階層図

```
JavaScript: getDialog('/admin/articles/new/', 'New Article')
    │
    └─ Ajax GET to /admin/articles/new/
           │
           └─ Admin_ArticlesController::newAction()
                  │
                  ├─ $acl->isAllowed('aarticles', 'aarticlenew')
                  │
                  ├─ [GET]
                  │      └─ posted = 'N' → フォーム表示
                  │
                  └─ [POST via doDialog()]
                         │
                         ├─ Zend_Filter_Input [バリデーション]
                         │
                         ├─ [バリデーション成功]
                         │      │
                         │      ├─ Articles::newArticle()
                         │      │      └─ INSERT into articles
                         │      │
                         │      ├─ $registry->db->lastInsertId()
                         │      │
                         │      └─ "Article Created" + Continueボタン
                         │             │
                         │             └─ goTo('/admin/articles/edit/id/{id}')
                         │
                         └─ [バリデーション失敗]
                                └─ エラーメッセージ + フォーム再表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

[ダイアログ表示時]
(なし) ─────────────────▶ newAction() [GET] ────▶ フォームHTML
                              │
                              └─ posted = 'N'

[フォーム送信時]
articletitle, ──────────▶ newAction() [POST]
articlecategory               │
                              ├─ Zend_Filter_Input [バリデーション]
                              │
                              └─ [成功時]
                                    │
                                    ├─ newArticle(title, category, author)
                                    │      │
                                    │      └─ INSERT into articles
                                    │
                                    ├─ lastInsertId() → 新規ID
                                    │
                                    └─ "Article Created" HTML
                                           + Continueボタン(edit画面URL)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | コントローラ | 記事新規作成の制御 |
| new.phtml | `application/modules/admin/views/scripts/articles/new.phtml` | ビュー | 新規作成フォームテンプレート |
| Articles.php | `application/models/Articles.php` | モデル | 記事データの操作 |
| acatselect (View Helper) | `application/views/helpers/Acatselect.php` | ヘルパー | カテゴリ選択オプション生成 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog(), doDialog(), goTo()関数 |
