# 画面設計書 38-記事詳細画面

## 概要

本ドキュメントは、Legacy CMSにおける記事詳細画面（管理画面用）の設計仕様を定義します。

### 本画面の処理概要

記事詳細画面は、記事編集画面の上部にAjaxで読み込まれるパーシャルビューで、記事のメタ情報と操作ボタンを表示します。

**業務上の目的・背景**：記事編集画面において、記事の基本情報（著者、ステータス、作成日、公開日、最終編集日）を常に表示し、保存・削除・公開などの主要操作へのアクセスを提供することが目的です。この情報は編集フォームとは独立して表示され、フォーム内容に関係なく現在の記事状態を確認できます。

**画面へのアクセス方法**：
1. 記事編集画面（edit.phtml）の読み込み時にAjaxで自動取得
2. dijit.layout.ContentPaneのhref属性で/admin/articles/details?id={id}を指定

**主要な操作・処理内容**：
1. 記事の著者名、ステータス、日時情報の表示
2. Saveボタン：記事の保存
3. Deleteボタン：記事の削除（権限による表示制御）
4. Publishボタン：記事の公開（下書き状態かつ権限による表示制御）
5. Articles...ボタン：記事管理画面への遷移

**画面遷移**：
- 遷移元：記事編集画面（Ajax読み込み）
- 遷移先：なし（ボタン操作はダイアログ表示または画面遷移）

**権限による表示制御**：
- aarticles + aarticleedit権限：画面へのアクセス
- aarticledelete権限：「Delete」ボタンの表示
- aarticlepublish権限：「Publish」ボタンの表示（かつarticle_status != 'published'）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 記事一覧表示 | 主機能 | 記事の詳細情報を表示 |
| 44 | コメント一覧表示 | 補助機能 | 記事のコメントを表示 |
| 49 | タグ一覧表示 | 補助機能 | 記事のタグを表示 |
| 54 | 添付ファイル一覧表示 | 補助機能 | 記事の添付ファイルを表示 |

## 画面種別

詳細 / パーシャルビュー

## URL/ルーティング

- URL: `/admin/articles/details?id={id}` または `/admin/articles/details/id/{id}`
- モジュール: admin
- コントローラ: articles
- アクション: details
- 表示方式: Ajaxパーシャル（レイアウト無効）

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 記事ID | id | 整数 | Yes | 表示対象の記事ID |

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 | 表示条件 |
|--------|--------|----------|------|---------|
| 著者名 | user_alias | 文字列 | 記事作成者の名前 | 常時 |
| ステータス | article_status | 文字列 | published/draft（先頭大文字化） | 常時 |
| 作成日 | article_date | 日時 | 記事作成日時（d/m/Y H:i形式） | 常時 |
| 公開日 | article_published | 日時 | 記事公開日時（d/m/Y H:i形式） | ステータスがpublishedの場合 |
| 最終編集日 | article_edit | 日時 | 最終更新日時（d/m/Y H:i形式） | 常時 |

## イベント仕様

### 1-画面表示

1. 記事編集画面のContentPaneがhref指定でAjaxリクエスト
2. Admin_ArticlesController::detailsAction()が呼び出される
3. aarticles + aarticleedit権限チェック
4. レイアウト無効化
5. Articles::fetchArticle()で記事データ取得
6. ビューにデータを渡してレンダリング

### 2-Saveボタン押下

1. FCKeditorの内容を更新（MyFCKObject.UpdateEditorFormValue()）
2. postDialog()でeditFormをAjax送信
3. /admin/articles/save/id/{id}/にPOST
4. 結果をダイアログに表示

### 3-Deleteボタン押下

1. getDialog()で削除確認ダイアログを表示
2. /admin/articles/delete/id/{id}/にリクエスト
3. 確認後に削除処理実行

### 4-Publishボタン押下

1. FCKeditorの内容を更新
2. getDialog()で公開確認ダイアログを表示
3. /admin/articles/publish/id/{id}/にリクエスト
4. 確認後に公開処理実行

### 5-Articles...ボタン押下

goTo()で記事管理画面（/admin/articles/）へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | articles, articles_categories, users | SELECT | 記事詳細情報取得 |

### テーブル別更新項目詳細

本画面自体はSELECTのみを行います。ボタン操作による更新は、それぞれのアクション（save, delete, publish）で処理されます。

## メッセージ仕様

本画面に固有のメッセージはありません。ボタン操作時のメッセージは各アクションで定義されています。

## 例外処理

| 例外種別 | 条件 | 処理内容 |
|---------|------|---------|
| 権限エラー | aarticles/aarticleedit権限なし | 権限エラー画面へフォワード |

## 備考

- ContentPaneによるAjax読み込みのため、レイアウトは無効
- MakeDateビューヘルパーで日時フォーマット
- FCKeditorとの連携のため、保存前にUpdateEditorFormValue()を呼び出す必要がある
- Publishボタンはステータスがpublished以外の場合のみ表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

記事詳細表示に必要な項目を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Articles モデル | `application/models/Articles.php` | fetchArticle()の戻り値 |

**読解のコツ**: fetchArticle()はarticles, articles_categories, usersをJOINした結果を返す。

#### Step 2: エントリーポイントを理解する

コントローラの詳細表示処理を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | detailsAction() |

**主要処理フロー（detailsAction）**:
1. **315-317行目**: detailsAction()開始
2. **317行目**: aarticles + aarticleedit権限チェック
3. **319行目**: レイアウト無効化
4. **321行目**: パラメータから記事ID取得
5. **323-324行目**: Articles::fetchArticle()で記事取得

#### Step 3: ビューテンプレートを理解する

詳細表示とボタンの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | details.phtml | `application/modules/admin/views/scripts/articles/details.phtml` | 表示項目と権限制御 |

**主要処理フロー（details.phtml）**:
- **14-29行目**: Details fieldset（左側）
- **20行目**: 著者名表示（user_alias）
- **21行目**: ステータス表示（ucwords()で先頭大文字化）
- **22-28行目**: 日時情報（dates span内）
- **23行目**: 作成日（MakeDateヘルパー）
- **24-26行目**: 公開日（ステータスがpublishedの場合のみ）
- **27行目**: 最終編集日
- **32-46行目**: Functions fieldset（右側）
- **38行目**: Saveボタン（FCKeditor更新 + postDialog）
- **39行目**: Deleteボタン（aarticledelete権限チェック）
- **40-42行目**: Publishボタン（article_status != 'published' かつ aarticlepublish権限）
- **43行目**: Articles...ボタン（goTo）

### プログラム呼び出し階層図

```
edit.phtml
    │
    └─ dijit.layout.ContentPane (href="/admin/articles/details?id={id}")
           │
           └─ Ajax GET
                  │
                  └─ Admin_ArticlesController::detailsAction()
                         │
                         ├─ $acl->isAllowed('aarticles', 'aarticleedit')
                         │
                         ├─ _helper->layout->disableLayout()
                         │
                         ├─ Articles::fetchArticle($id)
                         │      └─ SELECT from articles JOIN categories JOIN users
                         │
                         └─ View rendering [details.phtml]
                                │
                                ├─ Details fieldset
                                │      ├─ Author: {user_alias}
                                │      ├─ Status: {article_status}
                                │      ├─ Created: {article_date}
                                │      ├─ Published: {article_published} (if published)
                                │      └─ Last Edited: {article_edit}
                                │
                                └─ Functions fieldset
                                       ├─ Save button → postDialog()
                                       ├─ Delete button → getDialog() [if aarticledelete]
                                       ├─ Publish button → getDialog() [if draft & aarticlepublish]
                                       └─ Articles... button → goTo()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

記事ID ────────────────▶ detailsAction()
                              │
                              └─ fetchArticle($id)
                                    │
articles テーブル ───────▶   JOIN ───────────▶ $view->articleArray
articles_categories ────▶                          │
users ──────────────────▶                          ▼

                                             details.phtml
                                                   │
                                                   ├─▶ 著者名
                                                   ├─▶ ステータス
                                                   ├─▶ 作成日
                                                   ├─▶ 公開日（条件付き）
                                                   └─▶ 最終編集日
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | コントローラ | 詳細表示の制御 |
| details.phtml | `application/modules/admin/views/scripts/articles/details.phtml` | ビュー | 詳細表示テンプレート |
| Articles.php | `application/models/Articles.php` | モデル | 記事データの取得 |
| MakeDate (View Helper) | `application/views/helpers/MakeDate.php` | ヘルパー | 日時フォーマット |
| common.js | `public/_scripts/admin/common.js` | JavaScript | postDialog(), getDialog(), goTo()関数 |
