# 画面設計書 4-お問い合わせ画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおけるお問い合わせ画面の設計仕様を定義する。CAPTCHA認証付きのコンタクトフォームを提供し、ユーザーからの問い合わせをメールで受け付ける。

### 本画面の処理概要

**業務上の目的・背景**：お問い合わせ画面は、サイト訪問者がサイト運営者に連絡を取るための重要なコミュニケーションチャネルを提供する。スパム対策としてCAPTCHA認証を実装し、自動送信を防止しながら、正規ユーザーからの問い合わせを確実に受け付ける。これにより、顧客サポートや問い合わせ対応という業務課題を解決する。

**画面へのアクセス方法**：ホーム画面やナビゲーションメニューの「Contact」リンクからアクセス。URLは`/contact/`または`/index/contact`。

**主要な操作・処理内容**：
1. お問い合わせフォームの表示（名前、メールアドレス、件名、本文）
2. CAPTCHA画像の生成と表示
3. フォーム入力値のバリデーション
4. CAPTCHA認証の検証
5. お問い合わせ内容のメール送信
6. 送信完了メッセージの表示
7. Google Maps APIによる所在地地図表示

**画面遷移**：
- 遷移元：ホーム画面、グローバルナビゲーション、検索結果画面（0件時）
- 遷移先：送信完了後は同一画面に完了メッセージ表示

**権限による表示制御**：
- 本画面は認証状態に関わらず同一の表示内容
- 全ユーザー（未認証含む）が利用可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 63 | 入力検証 | 主機能 | フォーム入力値のバリデーション |
| 59 | メール送信 | 補助機能 | お問い合わせ内容をメール送信 |

## 画面種別

入力（フォーム型）

## URL/ルーティング

- URL: `/contact/` または `/index/contact`
- コントローラー: `IndexController`
- アクション: `contactAction`
- モジュール: `default`
- HTTPメソッド: GET（表示）/ POST（送信）

## 入出力項目

### 入力項目

| 項目名 | 入力/出力 | データ型 | 必須 | バリデーション | 説明 |
|--------|----------|---------|------|---------------|------|
| name | 入力 | string | はい | 3文字以上 | 送信者名 |
| email | 入力 | string | はい | メールアドレス形式 | 送信者メールアドレス |
| subject | 入力 | string | はい | 必須入力 | 件名 |
| message | 入力 | string | はい | 必須入力 | 本文 |
| captcha[input] | 入力 | string | はい | CAPTCHA検証 | 認証コード入力 |
| captcha[id] | 入力 | hidden | はい | - | CAPTCHA識別ID |

### 出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| posted | 出力 | string | - | 送信完了フラグ（'Y'） |
| messages | 出力 | array | - | バリデーションエラーメッセージ |
| captcha | 出力 | Zend_Captcha_Image | - | CAPTCHA画像オブジェクト |
| id | 出力 | string | - | 生成されたCAPTCHA ID |

## 表示項目

### フォーム項目

| 項目名 | 表示形式 | プレースホルダー/説明 |
|--------|---------|---------------------|
| Name | テキストボックス（幅220px） | 送信者名入力 |
| E-mail address | テキストボックス（幅306px） | メールアドレス入力 |
| Subject | テキストボックス（幅556px） | 件名入力 |
| Message | テキストエリア（幅556px） | 本文入力 |
| CAPTCHA画像 | 画像（180x60px） | 認証用画像 |
| Verification Code | テキストボックス（幅100px） | 認証コード入力 |

### サイドバー

| 項目名 | 説明 |
|--------|------|
| 検索ボックス | サイト内検索フォーム |
| Google Map | 所在地の地図表示 |
| 連絡先情報 | 住所、電話番号、メールアドレス |

## イベント仕様

### 1-フォーム送信（Send Message）

「Send Message」ボタンをクリックすると、フォームがPOST送信され、バリデーション後にメールが送信される。

- 送信先: `/contact/`（同一URL）
- 処理フロー:
  1. 入力値のバリデーション
  2. CAPTCHA認証の検証
  3. バリデーション成功時、メール送信
  4. 完了メッセージ表示

### 2-検索実行

サイドバーの検索ボックスでキーワードを入力して検索を実行する。

- 遷移先: `/index/search?query={keyword}`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

### 備考

本画面ではデータベースへの更新は行わない。お問い合わせ内容はメールで送信される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 成功 | Your message has been sent. | メール送信成功時 |
| MSG-002 | エラー | Missing Name - you must enter your name | 名前未入力時 |
| MSG-003 | エラー | Missing E-mail Address - you did not enter an e-mail address | メールアドレス未入力時 |
| MSG-004 | エラー | Invalid E-mail Address | メールアドレス形式不正時 |
| MSG-005 | エラー | Missing Subject - you did not enter a message subject | 件名未入力時 |
| MSG-006 | エラー | Missing Message - you did not enter a message | 本文未入力時 |
| MSG-007 | エラー | Invalid Verification Code - you must enter the code exactly as displayed | CAPTCHA認証失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| バリデーションエラー | フォームに入力値を保持し、エラーメッセージを表示 |
| CAPTCHA認証失敗 | 新しいCAPTCHAを生成し、エラーメッセージを表示 |
| メール送信失敗 | システムエラー画面へ遷移（Zend_Mailの例外） |

## 備考

- CAPTCHA設定：wordLen=7, fontSize=22, 画像サイズ180x60, dotNoiseLevel=35, lineNoiseLevel=2
- CAPTCHA画像は`./_captcha/images/`に生成
- 使用フォント：Envy Code R.ttf
- メール送信先はsite.iniのemail, recipient設定を使用
- Dojo Toolkitのフォームウィジェット使用（ValidationTextBox, SimpleTextarea）
- Google Maps APIで地図表示（JavaScript必要）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

本画面ではデータベースを使用しないが、メール送信の宛先設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | site.ini | `application/configs/site.ini` | site.email, site.recipientの設定 |

**読解のコツ**: Zend_Registryを通じて設定値にアクセスする。$registry->site->site->emailのような形式。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IndexController.php | `application/modules/default/controllers/IndexController.php` | contactAction()メソッド（122-215行目） |

**主要処理フロー**:
1. **124行目**: setRefer()でセッションに現在URLを保存
2. **126-136行目**: Zend_Captcha_Imageオブジェクトを生成
3. **140行目**: POSTリクエストの判定
4. **144-177行目**: フィルターとバリデーターの定義
5. **179行目**: Zend_Filter_Inputでバリデーション実行
6. **181行目**: バリデーション成功かつCAPTCHA認証成功の判定
7. **184-192行目**: Zend_Mailでメール送信
8. **197行目**: posted = 'Y'でビューに送信完了を通知
9. **199-209行目**: バリデーション失敗時、エラーメッセージと入力値をビューに設定
10. **214行目**: 新しいCAPTCHA IDを生成

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | contact.phtml | `application/modules/default/views/scripts/index/contact.phtml` | メインテンプレート。フォームとサイドバーの配置 |

**主要処理フロー**:
- **34行目**: RenderMessages()でエラーメッセージ表示
- **36-39行目**: posted == 'Y'の場合、送信完了メッセージ表示
- **45-134行目**: Dojoフォームウィジェットを使用したフォーム
- **109行目**: $this->captcha->render()でCAPTCHA画像表示
- **146-148行目**: Google Maps用のdiv（JavaScript必要）
- **154-170行目**: 連絡先情報テーブル

### プログラム呼び出し階層図

```
HTTP Request (/contact/)
    |
    +-- IndexController::preDispatch() [継承元: CMS_Controller_Action_Default]
    |
    +-- IndexController::contactAction()
            |
            +-- setRefer() - セッション保存
            +-- Zend_Captcha_Image生成
            |
            +-- [POST時のみ]
            |       |
            |       +-- Zend_Filter_Input - バリデーション
            |       |       |
            |       |       +-- StringTrim, StripTagsフィルター
            |       |       +-- NotEmpty, EmailAddressバリデーター
            |       |
            |       +-- captcha->isValid() - CAPTCHA検証
            |       |
            |       +-- [成功時] Zend_Mail::send()
            |       |       |
            |       |       +-- setBodyText() - 本文設定
            |       |       +-- setFrom() - 送信元設定
            |       |       +-- addTo() - 送信先設定
            |       |       +-- setSubject() - 件名設定
            |       |
            |       +-- [失敗時] エラーメッセージ設定
            |
            +-- captcha->generate() - 新CAPTCHA ID生成
            +-- ビュー変数設定
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム送信    ───▶ IndexController      ───▶ contact.phtml
(POST)               ::contactAction()         |
  |                        |                   +──▶ 成功メッセージ
  +-- name                 |                   |    または
  +-- email           バリデーション            +──▶ エラーメッセージ
  +-- subject              |                   |    + フォーム再表示
  +-- message              |                   |
  +-- captcha         CAPTCHA検証              +──▶ CAPTCHA画像
                           |                   +──▶ 地図（Google Maps）
                      メール送信               +──▶ 連絡先情報
                           |
                           ▼
                      site.email
                     (受信者アドレス)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IndexController.php | `application/modules/default/controllers/IndexController.php` | ソース | お問い合わせ画面のコントローラー |
| contact.phtml | `application/modules/default/views/scripts/index/contact.phtml` | テンプレート | お問い合わせ画面のメインビュー |
| contact.js | `_scripts/default/contact.js` | JavaScript | Google Maps初期化等 |
| searchbox.phtml | `application/modules/default/views/scripts/_partials/searchbox.phtml` | テンプレート | 検索ボックス |
| site.ini | `application/configs/site.ini` | 設定 | メール送信先等の設定 |
| Envy Code R.ttf | `_captcha/fonts/Envy Code R.ttf` | フォント | CAPTCHA用フォント |
