# 画面設計書 40-記事カテゴリ新規作成画面

## 概要

本ドキュメントは、Legacy CMSにおける記事カテゴリ新規作成画面の設計仕様を定義します。

### 本画面の処理概要

記事カテゴリ新規作成画面は、新しい記事カテゴリを作成するためのAjaxダイアログです。記事管理画面の「New Category」ボタンから呼び出されます。

**業務上の目的・背景**：記事をカテゴリ別に分類・管理するための基盤機能として、新しいカテゴリを追加する機能です。サイトのコンテンツ構成に応じて柔軟にカテゴリを追加できます。

**画面へのアクセス方法**：
1. 記事管理画面の「New Category」ボタンをクリック
2. Ajaxダイアログとして表示される

**主要な操作・処理内容**：
1. カテゴリタイトルの入力
2. Createボタンでカテゴリ作成
3. 作成成功後、ダイアログを閉じて画面リロード

**画面遷移**：
- 遷移元：記事管理画面（ダイアログとして）
- 遷移先：なし（ダイアログ閉じて記事管理画面をリロード）

**権限による表示制御**：
- aarticles + acategorynew権限：画面へのアクセス

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | 記事カテゴリ管理 | 主機能 | 新規カテゴリの作成処理 |
| 63 | 入力検証 | 補助機能 | カテゴリフォームのバリデーション |

## 画面種別

登録 / モーダルダイアログ

## URL/ルーティング

- URL: `/admin/articles/categorynew/`
- モジュール: admin
- コントローラ: articles
- アクション: categorynew
- 表示方式: Ajaxダイアログ（dijit.Dialog）

## 入出力項目

### 入力項目

| 項目名 | 項目ID | データ型 | 必須 | バリデーション | 説明 |
|--------|--------|----------|------|---------------|------|
| カテゴリタイトル | categorytitle | 文字列 | Yes | NotEmpty, Alnum(空白許可), 重複チェック | カテゴリ名 |

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| エラーメッセージ | messages | 配列 | バリデーションエラー時に表示 |

## イベント仕様

### 1-ダイアログ表示

1. 記事管理画面でNew CategoryボタンをクリックするとgetDialog()が呼び出される
2. /admin/articles/categorynew/ にAjaxリクエスト
3. Admin_ArticlesController::categorynewAction()が呼び出される
4. aarticles + acategorynew権限チェック
5. レイアウト無効化
6. posted = 'N' を設定してフォーム表示

### 2-Createボタン押下

1. doDialog()でフォームデータをAjax送信
2. categorynewAction()がPOSTリクエストを処理
3. バリデーション実行：
   - NotEmpty: タイトル必須
   - Alnum(true): 英数字と空白のみ許可
   - NoRecordExists: 同名カテゴリの重複チェック
4. バリデーション成功時：
   - Articles::newCategory()で新規カテゴリ作成
   - 「Category Created」メッセージと「Close」ボタンを表示
   - Closeボタン押下で画面リロード
5. バリデーション失敗時：
   - エラーメッセージを表示
   - 入力値を保持してフォーム再表示

### 3-Cancelボタン押下

dijit.byId('ajaxDialog').hide()でダイアログを閉じます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| カテゴリ作成 | articles_categories | INSERT | 新規カテゴリレコード作成 |

### テーブル別更新項目詳細

#### articles_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | acat_title | フォーム入力値 | カテゴリタイトル |
| INSERT | acat_id | AUTO_INCREMENT | 自動採番 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | エラー | Title is required | タイトル未入力 |
| MSG-002 | エラー | Invalid Title | 英数字以外の文字が含まれる |
| MSG-003 | エラー | Category Already Exists | 同名カテゴリが既に存在 |
| MSG-004 | 完了 | Category Created | カテゴリ作成成功 |

## 例外処理

| 例外種別 | 条件 | 処理内容 |
|---------|------|---------|
| 権限エラー | aarticles/acategorynew権限なし | 権限エラー画面へフォワード |
| バリデーションエラー | 入力値不正 | エラーメッセージ表示、フォーム再表示 |
| パラメータ不正 | titleがNULL | Exception throw |

## 備考

- カテゴリIDは自動採番（AUTO_INCREMENT）
- Alnum(true)で空白を許可している
- 新規作成時のCloseボタンは画面リロード（location.reload(true)）を実行
- 重複チェックはテーブル全体に対して実行

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カテゴリテーブルのINSERT時の項目を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Articles モデル | `application/models/Articles.php` | newCategory()のパラメータ |

**読解のコツ**: INSERTされる項目はacat_titleのみ。acat_idはAUTO_INCREMENTで自動採番。

#### Step 2: エントリーポイントを理解する

コントローラの新規カテゴリ作成処理を把握します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Admin_ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | categorynewAction() |

**主要処理フロー（categorynewAction）**:
1. **465-467行目**: categorynewAction()開始
2. **467行目**: aarticles + acategorynew権限チェック
3. **469行目**: レイアウト無効化
4. **471行目**: POSTリクエスト判定
5. **477-484行目**: バリデータ定義（NotEmpty, Alnum, NoRecordExists）
6. **486行目**: Zend_Filter_Inputでバリデーション
7. **488行目**: バリデーション成功判定
8. **490-492行目**: Articles::newCategory()呼び出し
9. **494-499行目**: 成功メッセージとCloseボタン出力

#### Step 3: モデル層を理解する

カテゴリINSERT処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Articles.php | `application/models/Articles.php` | newCategory() |

**主要処理フロー（newCategory）**:
- **243-254行目**: 新規カテゴリ作成処理
- **245行目**: タイトルのNULLチェック
- **246-248行目**: INSERTデータ配列作成
- **247行目**: acat_title = 入力値
- **250行目**: DBへのINSERT実行

#### Step 4: ビューテンプレートを理解する

新規作成フォームの構造を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | categorynew.phtml | `application/modules/admin/views/scripts/articles/categorynew.phtml` | フォーム構造 |

**主要処理フロー（categorynew.phtml）**:
- **9行目**: posted = 'N'時の条件分岐でフォーム表示
- **10行目**: RenderMessagesでエラーメッセージ表示
- **11行目**: フォーム開始（doDialog()でサブミット）
- **12-26行目**: タイトル入力（ValidationTextBox）
- **29-34行目**: Createボタン（doDialog呼び出し）
- **35-40行目**: Cancelボタン（ダイアログ非表示）

### プログラム呼び出し階層図

```
記事管理画面 [manage.phtml]
    │
    └─ New Categoryボタン
           │
           └─ getDialog('/admin/articles/categorynew/', 'New Category')
                  │
                  └─ Admin_ArticlesController::categorynewAction()
                         │
                         ├─ $acl->isAllowed('aarticles', 'acategorynew')
                         │
                         ├─ [GET]
                         │      └─ posted = 'N' → フォーム表示
                         │
                         └─ [POST via doDialog()]
                                │
                                ├─ Zend_Filter_Input [バリデーション]
                                │      └─ NoRecordExists (全カテゴリ対象)
                                │
                                ├─ [バリデーション成功]
                                │      │
                                │      ├─ Articles::newCategory()
                                │      │      └─ INSERT into articles_categories
                                │      │
                                │      └─ "Category Created" + Closeボタン
                                │             │
                                │             └─ location.reload(true)
                                │
                                └─ [バリデーション失敗]
                                       └─ エラーメッセージ + フォーム再表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

[ダイアログ表示時]
(なし) ─────────────────▶ categorynewAction() [GET] ──▶ フォームHTML
                              │
                              └─ posted = 'N'

[フォーム送信時]
categorytitle ──────────▶ categorynewAction() [POST]
                              │
                              ├─ Zend_Filter_Input [バリデーション]
                              │      │
                              │      └─ NoRecordExists (articles_categories)
                              │
                              └─ [成功時]
                                    │
                                    └─ newCategory(title)
                                           │
articles_categories ◀──── INSERT ──────▶ "Category Created" HTML
                                              + Closeボタン
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | コントローラ | カテゴリ新規作成の制御 |
| categorynew.phtml | `application/modules/admin/views/scripts/articles/categorynew.phtml` | ビュー | カテゴリ新規作成フォーム |
| Articles.php | `application/models/Articles.php` | モデル | カテゴリデータの操作 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog(), doDialog()関数 |
