# 画面設計書 41-ユーザー管理画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるユーザー管理画面の設計仕様を定義する。本画面は登録ユーザーの一覧表示、検索、フィルタリング機能を提供し、ユーザー管理業務の中核となる画面である。

### 本画面の処理概要

本画面は、システムに登録されている全ユーザーを一覧形式で表示し、管理者がユーザーを効率的に管理できる機能を提供する。

**業務上の目的・背景**：管理者がシステム内のユーザーアカウントを効率的に管理するために必要な画面である。ユーザーの追加、編集、ステータス変更などの操作の起点となり、ユーザー管理業務の効率化を実現する。また、ロールベースのアクセス制御によりユーザーを分類管理することで、権限管理の基盤を提供する。

**画面へのアクセス方法**：管理画面ログイン後、サイドメニューから「Users」を選択、または管理ダッシュボードからユーザー管理リンクをクリックすることでアクセスする。URLは `/admin/users/manage/` である。

**主要な操作・処理内容**：
1. ユーザー一覧の閲覧（名前、エイリアス、メールアドレス、ロール、更新日を表示）
2. 検索機能によるユーザーの絞り込み（名前、エイリアス、メールアドレスで検索可能）
3. ステータス別フィルタリング（Active/Inactive/Suspended）
4. ロール別フィルタリング（各ロールに属するユーザーの絞り込み）
5. 新規ユーザー作成ダイアログの表示（権限があれば）
6. 新規ロール作成ダイアログの表示（権限があれば）
7. ユーザー編集画面への遷移
8. ロール編集画面への遷移（コンテキストメニューから）
9. ロール削除確認画面への遷移（コンテキストメニューから）
10. ユーザーへのメール送信ダイアログ表示（権限があれば）

**画面遷移**：
- 遷移元：管理ダッシュボード、サイドメニュー
- 遷移先：ユーザー編集画面(edit)、ユーザー新規作成画面(new)、ロール管理画面(role)、ロール新規作成画面(rolenew)、ロール削除確認画面(roledelete)、メール送信画面(mailuser)

**権限による表示制御**：
- `uusers`権限：画面へのアクセス可否を制御
- `unewuser`権限：「New User」ボタンの表示/非表示
- `urolenew`権限：「New Role」ボタンの表示/非表示
- `uroledelete`権限：ロール削除メニューの表示/非表示（role_id > 3のロールのみ削除可能）
- `mmailnew`権限：メール送信リンクの表示/非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 16 | ユーザー一覧表示 | 主機能 | ユーザー一覧を表示 |
| 62 | ページネーション | 補助機能 | ユーザー一覧のページ送り処理 |
| 61 | アクセス制御 | 補助機能 | 管理者権限チェック |

## 画面種別

一覧

## URL/ルーティング

| 項目 | 値 |
|------|------|
| URL | `/admin/users/manage/` |
| HTTPメソッド | GET |
| モジュール | admin |
| コントローラー | users |
| アクション | manage |

## 入出力項目

### GETパラメータ（入力）

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| query | string | 任意 | 検索クエリ（名前、エイリアス、メールアドレス） |
| role | int | 任意 | ロールIDによるフィルタ |
| status | string | 任意 | ステータスによるフィルタ（active/inactive/suspended） |
| page | int | 任意 | ページ番号（デフォルト: 1） |

## 表示項目

### ユーザー一覧テーブル

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| ステータスアイコン | 緑旗(active)/黄旗(inactive)/赤旗(suspended) | users.user_status |
| 名前 | 姓名（リンク付き） | users_profiles.upro_first, upro_last |
| エイリアス | ユーザーエイリアス | users.user_alias |
| メールアドレス | メールアドレス（クリック時メール送信ダイアログ） | users.user_email |
| ロール | ロール名（リンク付き） | users_roles.role_title |
| 日付 | 最終更新日 | users_profiles.upro_date |

### アカウントステータスカウント

| 項目名 | 説明 |
|--------|------|
| Active | アクティブなユーザー数 |
| Inactive | 非アクティブなユーザー数 |
| Suspended | 停止中のユーザー数 |

### ロール一覧

| 項目名 | 説明 |
|--------|------|
| ロール名 | 各ロールに属するユーザー数を括弧内に表示 |

## イベント仕様

### 1-検索実行

**トリガー**: 検索フォームのGoボタン押下

**処理フロー**:
1. 入力されたクエリをGETパラメータとして送信
2. manageActionにて検索条件に基づきユーザーを取得
3. 検索結果を一覧に表示

### 2-新規ユーザー作成

**トリガー**: 「New User」ボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/users/new/`をAjaxダイアログで表示
3. ユーザー新規作成フォームをダイアログ内に表示

### 3-新規ロール作成

**トリガー**: 「New Role」ボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/users/rolenew/`をAjaxダイアログで表示
3. ロール新規作成フォームをダイアログ内に表示

### 4-ステータスフィルタ適用

**トリガー**: ステータスラベル（Active/Inactive/Suspended）クリック

**処理フロー**:
1. statusパラメータを付与してページをリロード
2. 指定ステータスのユーザーのみ表示

### 5-ロールフィルタ適用

**トリガー**: ロール名クリック

**処理フロー**:
1. roleパラメータを付与してページをリロード
2. 指定ロールのユーザーのみ表示

### 6-ユーザー編集画面遷移

**トリガー**: ユーザー名クリックまたはEditリンククリック

**処理フロー**:
1. `/admin/users/edit/id/{user_id}/`へ画面遷移

### 7-ロール編集画面遷移

**トリガー**: ロール名の右クリックメニューから「Edit」選択

**処理フロー**:
1. goTo関数を呼び出し
2. `/admin/users/role/id/{role_id}/`へ画面遷移

### 8-ロール削除確認

**トリガー**: ロール名の右クリックメニューから「Delete」選択

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/users/roledelete/id/{role_id}/`をAjaxダイアログで表示

### 9-メール送信ダイアログ表示

**トリガー**: メールアドレスクリックまたは「Send E-mail」リンククリック

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/mail/mailuser/id/{user_id}/`をAjaxダイアログで表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | users, users_profiles, users_roles | SELECT | ユーザー情報の取得 |
| 検索実行 | users, users_profiles, users_roles | SELECT | 条件に合致するユーザー情報の取得 |

### テーブル別更新項目詳細

#### usersテーブル（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id, user_alias, user_email, user_role, user_status | 全件または条件付き | フィルタ条件に応じて動的に変化 |

#### users_profilesテーブル（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | upro_first, upro_last, upro_date | upro_userid = user_id | ユーザーテーブルとJOIN |

#### users_rolesテーブル（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | role_id, role_title | role_id = user_role または role_id != 2 | Guestロール(id=2)は除外 |

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|--------------|----------|--------------|
| 情報 | ユーザーが0件の場合 | No Users! |
| 情報 | フィルタ未設定時 | No active filter |
| 情報 | ロールが0件の場合 | No Roles! |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| uusers権限なし | privileges画面へ転送（権限エラー画面） |
| データベース接続エラー | システムエラー画面を表示 |

## 備考

- 1ページあたりの表示件数は15件
- ページネーションの表示範囲は5ページ
- ユーザー一覧は姓（upro_last）でASCソート
- ロール一覧はタイトル（role_title）でASCソート
- Guestロール（role_id=2）はロール一覧に表示されない
- システム既定ロール（role_id <= 3）は削除不可
- Dojo Toolkitを使用したUIウィジェット（ダイアログ、ドロップダウン、フィルタリングセレクト等）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ユーザー関連のデータベース構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（L347-361）、users_profilesテーブル（L457-477）、users_rolesテーブル（L576-581）の構造を確認 |

**読解のコツ**: usersテーブルはuser_roleカラムでusers_rolesと、user_idでusers_profilesと関連付けられている。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | manageAction（L72-204）がメイン処理 |

**主要処理フロー**:
1. **L74**: ACL権限チェック（uusers権限）
2. **L81-85**: GETパラメータ取得（role, status, query）
3. **L94-178**: 検索条件に応じたSQLクエリ構築
4. **L181-187**: Paginatorオブジェクト作成と設定
5. **L190-196**: ロール一覧取得

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | manage.phtml | `application/modules/admin/views/scripts/users/manage.phtml` | 画面レイアウトとDojoウィジェット定義 |

**主要処理フロー**:
- **L9-19**: Dojoモジュールのrequire
- **L36-66**: Functions fieldset（検索、新規ユーザー、新規ロールボタン）
- **L89-120**: ステータスとロールのフィルタリング領域
- **L122-161**: ユーザー一覧テーブル
- **L163-170**: ページネーション

### プログラム呼び出し階層図

```
/admin/users/manage/ (HTTP Request)
    │
    ├─ Admin_UsersController::manageAction()
    │      ├─ ACL権限チェック (view->acl->isAllowed)
    │      ├─ getRole() - ロール名取得
    │      ├─ Zend_Db_Select - SQLクエリ構築
    │      └─ Zend_Paginator::factory() - ページネーション
    │
    └─ manage.phtml (View)
           ├─ UStatusCount (View Helper) - ステータス別カウント
           ├─ URoleCount (View Helper) - ロール別カウント
           ├─ cycle (View Helper) - 行の交互表示
           ├─ MakeDate (View Helper) - 日付フォーマット
           └─ paginationControl (View Helper) - ページネーション表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GETパラメータ ────────▶ UsersController     ────────▶ manage.phtml
(query, role,           ::manageAction()              (HTML)
status, page)                 │
                              │
                              ▼
                    ┌─────────────────┐
                    │  MySQL DB       │
                    │  - users        │
                    │  - users_profiles│
                    │  - users_roles  │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | ユーザー管理の全アクションを定義 |
| manage.phtml | `application/modules/admin/views/scripts/users/manage.phtml` | ビュー | ユーザー管理画面のテンプレート |
| admin.phtml | `application/layouts/scripts/admin.phtml` | レイアウト | 管理画面共通レイアウト |
| CMS_Controller_Action_Admin | `library/CMS/Controller/Action/Admin.php` | 基底クラス | 管理コントローラー基底クラス |
| database.sql | `database.sql` | SQL | データベーススキーマ定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | 共通JavaScript関数（getDialog, goTo, toggleVis等） |
| template.css | `public/_styles/admin/template.css` | CSS | 管理画面共通スタイル |
