# 画面設計書 42-ユーザー編集画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるユーザー編集画面の設計仕様を定義する。本画面は既存ユーザーの詳細情報を編集する機能を提供し、ユーザー個人情報・認証情報・購読設定の管理を行う。

### 本画面の処理概要

本画面は、特定のユーザーアカウントの詳細情報を編集するためのフォームを提供する。個人情報、連絡先情報、所属組織情報、メール購読設定を管理できる。

**業務上の目的・背景**：管理者が既存ユーザーの情報を更新・修正するために必要な画面である。ユーザープロフィール情報の変更、ロールの変更、購読設定の変更など、ユーザーアカウントの維持管理業務を支援する。ユーザー情報の正確性を維持し、適切な権限管理を行うための基盤となる。

**画面へのアクセス方法**：ユーザー管理画面（manage）からユーザー名をクリック、または編集リンクをクリックすることでアクセスする。URLは `/admin/users/edit/id/{user_id}/` である。

**主要な操作・処理内容**：
1. ユーザー基本情報の編集（姓名、エイリアス、ロール）
2. 個人情報の編集（性別、生年月日）
3. 連絡先情報の編集（メールアドレス、電話番号）
4. 所属組織情報の編集（組織名、役職）
5. 住所情報の編集（住所、市区町村、国、郵便番号）
6. メール購読設定の変更
7. ユーザー情報の保存
8. アカウントステータスの変更（有効化/停止）
9. パスワードリセット
10. ユーザー管理画面への戻り

**画面遷移**：
- 遷移元：ユーザー管理画面(manage)
- 遷移先：ユーザー管理画面(manage)、コメント管理画面（該当ユーザーのコメント一覧）

**権限による表示制御**：
- `uusers`権限：画面へのアクセス可否を制御
- `uview`権限：ユーザー詳細情報閲覧可否
- `uedit`権限：保存ボタンの表示/非表示
- `ustatus`権限：アカウントステータス変更ボタンの表示/非表示
- `upassword`権限：パスワードリセットボタンの表示/非表示
- `gcomments`権限：コメントリンクの表示/非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 18 | ユーザー編集 | 主機能 | ユーザー情報の編集・更新処理 |
| 63 | 入力検証 | 補助機能 | ユーザーフォームのバリデーション |

## 画面種別

編集

## URL/ルーティング

| 項目 | 値 |
|------|------|
| URL | `/admin/users/edit/id/{user_id}/` |
| HTTPメソッド | GET（表示）、POST（保存はsaveAction経由） |
| モジュール | admin |
| コントローラー | users |
| アクション | edit |

## 入出力項目

### GETパラメータ（入力）

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | int | 必須 | 編集対象ユーザーID |

### POSTパラメータ（保存時・saveAction）

| パラメータ名 | 型 | 必須 | バリデーション | 説明 |
|-------------|-----|------|--------------|------|
| first | string | 必須 | NotEmpty | 名 |
| last | string | 必須 | NotEmpty | 姓 |
| alias | string | 必須 | NotEmpty, Alnum, 重複チェック | エイリアス |
| email | string | 必須 | NotEmpty, EmailAddress, 重複チェック | メールアドレス |
| role | int | 必須 | NotEmpty, Digits | ロールID |
| country | string | 必須 | NotEmpty | 国コード |
| gender | string | 任意 | - | 性別（N/F/M） |
| dob | string | 任意 | - | 生年月日（YYYY-MM-DD） |
| organisation | string | 任意 | - | 組織名 |
| position | string | 任意 | - | 役職 |
| address | string | 任意 | - | 住所 |
| city | string | 任意 | - | 市区町村 |
| phone | string | 任意 | - | 電話番号 |
| postcode | string | 任意 | - | 郵便番号 |
| lists[] | array | 任意 | - | 購読リストID配列 |

## 表示項目

### Identityセクション

| 項目名 | 入力形式 | データソース |
|--------|----------|--------------|
| First Name | テキスト（必須） | users_profiles.upro_first |
| Last Name | テキスト（必須） | users_profiles.upro_last |
| Alias | テキスト（必須） | users.user_alias |
| Role | ドロップダウン（必須） | users.user_role -> users_roles |

### Personalセクション

| 項目名 | 入力形式 | データソース |
|--------|----------|--------------|
| Gender | ドロップダウン | users_profiles.upro_gender |
| Date of Birth | テキスト（YYYY-MM-DD形式） | users_profiles.upro_dob |

### Contactセクション

| 項目名 | 入力形式 | データソース |
|--------|----------|--------------|
| E-mail Address | テキスト（必須） | users.user_email |
| Phone Number | テキスト | users_profiles.upro_phone |

### Organisationセクション

| 項目名 | 入力形式 | データソース |
|--------|----------|--------------|
| Organisation | テキスト | users_profiles.upro_organisation |
| Position | テキスト | users_profiles.upro_position |

### Locationセクション

| 項目名 | 入力形式 | データソース |
|--------|----------|--------------|
| Address | テキストエリア | users_profiles.upro_address |
| City | テキスト | users_profiles.upro_city |
| Country | ドロップダウン（必須） | users_profiles.upro_country |
| Postcode | テキスト | users_profiles.upro_postcode |

### Subscriptionsタブ

| 項目名 | 入力形式 | データソース |
|--------|----------|--------------|
| 購読リスト | チェックボックスリスト | mail_groups, mail_subscriptions |

### 詳細セクション（details.phtml）

| 項目名 | 表示内容 |
|--------|----------|
| Account Created | アカウント作成日 |
| Account Status | アカウントステータス |
| Last Updated | 最終更新日 |
| Comments | 該当ユーザーのコメント数（リンク） |

## イベント仕様

### 1-保存実行

**トリガー**: Saveボタン押下

**処理フロー**:
1. postDialog関数を呼び出し
2. editFormの内容を`/admin/users/save/id/{user_id}/`へPOST
3. バリデーション実行（saveAction内）
4. 成功時：usersテーブルとusers_profilesテーブルを更新
5. 購読設定を再構築（既存削除→新規挿入）
6. 結果をダイアログで表示

### 2-アカウント有効化/停止

**トリガー**: Activate Account / Suspend Accountボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/users/status/id/{user_id}/status/{new_status}/`をAjaxダイアログで表示
3. 確認後、ステータス変更実行

### 3-パスワードリセット

**トリガー**: Reset Passwordボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/users/password/id/{user_id}/`をAjaxダイアログで表示
3. 確認後、新パスワード生成・メール送信

### 4-ユーザー管理画面へ戻る

**トリガー**: Users...ボタン押下

**処理フロー**:
1. goTo関数を呼び出し
2. `/admin/users/`へ画面遷移

### 5-購読設定変更

**トリガー**: 購読リストのチェックボックス変更

**処理フロー**:
1. チェックボックス状態が変更される
2. 保存時にlists[]パラメータとして送信される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | users, users_profiles, users_roles | SELECT | ユーザー情報の取得 |
| 画面表示 | mail_groups | SELECT | 購読リスト一覧取得 |
| 保存実行 | users | UPDATE | ユーザー基本情報更新 |
| 保存実行 | users_profiles | UPDATE | プロフィール情報更新 |
| 保存実行 | mail_subscriptions | DELETE/INSERT | 購読設定再構築 |

### テーブル別更新項目詳細

#### usersテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | user_alias | フォーム入力値 | 重複チェックあり |
| UPDATE | user_email | フォーム入力値 | 重複チェックあり |
| UPDATE | user_role | フォーム入力値 | - |

#### users_profilesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | upro_first | フォーム入力値 | - |
| UPDATE | upro_last | フォーム入力値 | - |
| UPDATE | upro_country | フォーム入力値 | - |
| UPDATE | upro_gender | フォーム入力値 | N/F/M |
| UPDATE | upro_dob | フォーム入力値 | YYYY-MM-DD形式 |
| UPDATE | upro_organisation | フォーム入力値 | - |
| UPDATE | upro_position | フォーム入力値 | - |
| UPDATE | upro_address | フォーム入力値 | - |
| UPDATE | upro_city | フォーム入力値 | - |
| UPDATE | upro_phone | フォーム入力値 | - |
| UPDATE | upro_postcode | フォーム入力値 | - |
| UPDATE | upro_date | NOW() | 自動更新 |

#### mail_subscriptionsテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | msub_user = {user_id} | 既存購読を全削除 |
| INSERT | msub_group, msub_user | 選択されたリストID, ユーザーID | 新規購読挿入 |

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|--------------|----------|--------------|
| 成功 | 保存成功時 | User Saved |
| エラー | First name空 | First name is required |
| エラー | Last name空 | Last name is required |
| エラー | Alias空 | Alias is required |
| エラー | Alias不正 | Invalid Alias |
| エラー | Alias重複 | Alias in use |
| エラー | Email空 | E-mail Address is required |
| エラー | Email不正 | Invalid E-mail Address |
| エラー | Email重複 | E-mail Address in use |
| エラー | Role空 | Role is required |
| エラー | Role不正 | Invalid Role |
| エラー | Country空 | Country is required |
| エラー | ID未指定 | User Not Specified! |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| uusers権限なし | privileges画面へ転送（権限エラー画面） |
| uview権限なし | privileges画面へ転送（権限エラー画面） |
| 指定IDのユーザー不存在 | manage画面へリダイレクト |
| データベース接続エラー | システムエラー画面を表示 |

## 備考

- タブコンテナ形式（Userタブ、Membershipタブ（メンバーの場合）、Subscriptionsタブ）
- Membershipタブはuser_member = 'Y'の場合のみ表示
- 購読リストはopen/closedのステータスあり（アイコンで表示）
- 郵便番号バリデーションは英国形式（regExp設定あり）
- 詳細情報はdetailsActionから非同期で読み込み
- 自分自身のアカウントはステータス変更不可
- Dojo Toolkitを使用したUIウィジェット

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル、users_profilesテーブル、mail_groups、mail_subscriptionsの構造 |

**読解のコツ**: mail_subscriptionsテーブルがusersとmail_groupsの中間テーブルとなっている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | editAction（L513-553）とsaveAction（L345-507） |

**主要処理フロー（editAction）**:
1. **L515**: ACL権限チェック（uusers, uview権限）
2. **L519**: GETパラメータからuser_id取得
3. **L525-530**: ユーザー情報をJOINして取得
4. **L538-543**: 購読リスト一覧を取得

**主要処理フロー（saveAction）**:
1. **L347**: ACL権限チェック（uusers, uedit権限）
2. **L356-409**: バリデーションルール定義
3. **L416-445**: users/users_profilesテーブル更新
4. **L447-467**: 購読設定の再構築

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.phtml | `application/modules/admin/views/scripts/users/edit.phtml` | 編集フォームのレイアウトとフィールド定義 |
| 3-2 | details.phtml | `application/modules/admin/views/scripts/users/details.phtml` | 詳細情報とアクションボタン |

**主要処理フロー（edit.phtml）**:
- **L9-26**: Dojoモジュールのrequire
- **L39**: details.phtmlの非同期読み込み
- **L43-274**: Userタブ（Identity, Personal, Contact, Organisation, Location）
- **L280-295**: Subscriptionsタブ

### プログラム呼び出し階層図

```
/admin/users/edit/id/{user_id}/ (HTTP Request)
    │
    ├─ Admin_UsersController::editAction()
    │      ├─ ACL権限チェック
    │      ├─ ユーザー情報取得（users + profiles + roles JOIN）
    │      └─ 購読リスト取得（mail_groups）
    │
    └─ edit.phtml (View)
           │
           ├─ details.phtml (Ajax読み込み)
           │      ├─ ユーザー詳細情報表示
           │      ├─ Save/Status/Password/Usersボタン
           │      └─ Commentsリンク
           │
           ├─ URoleSelect (View Helper)
           ├─ countriesOptions (View Helper)
           └─ MSubStatusAll (View Helper)

保存時:
/admin/users/save/id/{user_id}/ (POST)
    │
    └─ Admin_UsersController::saveAction()
           ├─ バリデーション実行
           ├─ usersテーブル更新
           ├─ users_profilesテーブル更新
           └─ mail_subscriptions更新
```

### データフロー図

```
[入力]                    [処理]                         [出力]

user_id (GET) ────────▶ UsersController     ────────▶ edit.phtml
                        ::editAction()                 (HTML Form)
                              │
                              ▼
                    ┌─────────────────┐
                    │  MySQL DB       │
                    │  - users        │
                    │  - users_profiles│
                    │  - users_roles  │
                    │  - mail_groups  │
                    └─────────────────┘

フォーム送信 ────────▶ UsersController     ────────▶ Ajax Response
(POST)                 ::saveAction()               (成功/エラー)
                              │
                              ▼
                    ┌─────────────────┐
                    │  MySQL DB       │
                    │  UPDATE users   │
                    │  UPDATE profiles│
                    │  DELETE/INSERT  │
                    │  subscriptions  │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | edit, save, details, status, passwordアクション |
| edit.phtml | `application/modules/admin/views/scripts/users/edit.phtml` | ビュー | 編集フォームテンプレート |
| details.phtml | `application/modules/admin/views/scripts/users/details.phtml` | ビュー | 詳細情報・アクションボタン |
| database.sql | `database.sql` | SQL | テーブル定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | postDialog, getDialog, goTo等 |
