# 画面設計書 43-ユーザー新規作成画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるユーザー新規作成画面の設計仕様を定義する。本画面はAjaxダイアログとして表示され、新規ユーザーアカウントを作成する機能を提供する。

### 本画面の処理概要

本画面は、システムに新しいユーザーアカウントを追加するためのフォームをAjaxダイアログとして提供する。基本的なユーザー情報を入力し、アカウント作成後に自動生成されたパスワードがメールで送信される。

**業務上の目的・背景**：管理者が新規ユーザーを迅速に登録するために必要な画面である。ユーザー管理画面からダイアログとして呼び出されるため、画面遷移なしに効率的にユーザー登録が行える。登録完了後は自動的にパスワードがメール送信されるため、管理者がパスワードを手動で伝える必要がない。

**画面へのアクセス方法**：ユーザー管理画面（manage）の「New User」ボタンをクリックすることで、Ajaxダイアログとして表示される。URLは `/admin/users/new/` である。

**主要な操作・処理内容**：
1. メールアドレスの入力（必須、重複チェックあり）
2. エイリアスの入力（必須、重複チェックあり）
3. 姓名の入力（必須）
4. 国の選択（必須）
5. ロールの選択（必須）
6. アカウント作成の実行
7. ダイアログのキャンセル

**画面遷移**：
- 遷移元：ユーザー管理画面(manage)のダイアログ呼び出し
- 遷移先：ダイアログを閉じてユーザー管理画面に戻る

**権限による表示制御**：
- `uusers`権限：ダイアログ表示可否を制御
- `unewuser`権限：新規ユーザー作成機能の実行可否を制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | ユーザー新規作成 | 主機能 | 新規ユーザーの作成処理 |
| 63 | 入力検証 | 補助機能 | ユーザーフォームのバリデーション |

## 画面種別

登録（Ajaxダイアログ）

## URL/ルーティング

| 項目 | 値 |
|------|------|
| URL | `/admin/users/new/` |
| HTTPメソッド | GET（表示）、POST（登録） |
| モジュール | admin |
| コントローラー | users |
| アクション | new |

## 入出力項目

### POSTパラメータ（登録時）

| パラメータ名 | 型 | 必須 | バリデーション | 説明 |
|-------------|-----|------|--------------|------|
| email | string | 必須 | NotEmpty, EmailAddress, 重複チェック | メールアドレス |
| alias | string | 必須 | NotEmpty, Alnum, 重複チェック, 3文字以上 | エイリアス |
| first | string | 必須 | NotEmpty, 英字のみ, 3文字以上 | 名 |
| last | string | 必須 | NotEmpty, 英字のみ, 3文字以上 | 姓 |
| country | string | 必須 | NotEmpty | 国コード |
| role | int | 必須 | NotEmpty, Digits | ロールID |

## 表示項目

### フォームフィールド

| 項目名 | 入力形式 | バリデーション | 備考 |
|--------|----------|--------------|------|
| E-mail Address | テキスト（必須） | メールアドレス形式、重複チェック | 幅260px |
| Alias | テキスト（必須） | 英数字、3文字以上、重複チェック | 幅260px、リアルタイムチェック可能 |
| First Name | テキスト（必須） | 英字・ハイフン・アポストロフィ・スペースのみ | 幅260px |
| Last Name | テキスト（必須） | 英字・ハイフン・アポストロフィ・スペースのみ | 幅260px |
| Country | ドロップダウン（必須） | - | 幅260px |
| Role | ドロップダウン（必須） | - | 幅140px |

## イベント仕様

### 1-ユーザー作成実行

**トリガー**: Createボタン押下

**処理フロー**:
1. doDialog関数を呼び出し
2. newuserFormの内容を`/admin/users/new/`へPOST
3. バリデーション実行
4. 成功時：
   - ランダムパスワード生成
   - usersテーブルにレコード挿入
   - users_profilesテーブルにレコード挿入
   - 新規ユーザーにメール送信（アカウント情報・パスワード）
5. 結果をダイアログ内に表示

### 2-キャンセル

**トリガー**: Cancelボタン押下

**処理フロー**:
1. dijit.byId('ajaxDialog').hide()を呼び出し
2. ダイアログを閉じる

### 3-エイリアスリアルタイムチェック

**トリガー**: エイリアス入力フィールドの変更

**処理フロー**:
1. ContentPaneのaliasResponseでリアルタイム結果表示（構造上の準備あり）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成実行 | users | INSERT | 新規ユーザーレコード挿入 |
| 作成実行 | users_profiles | INSERT | 新規プロフィールレコード挿入 |

### テーブル別更新項目詳細

#### usersテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_alias | フォーム入力値 | 重複チェック済み |
| INSERT | user_email | フォーム入力値 | 重複チェック済み |
| INSERT | user_role | フォーム入力値 | - |
| INSERT | user_password | md5(ランダムパスワード) | - |
| INSERT | user_key | md5(email + password) | - |
| INSERT | user_date | NOW() | - |
| INSERT | user_mailformat | 'text' | 固定値 |
| INSERT | user_status | 'active' | 固定値（即時有効） |

#### users_profilesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | upro_userid | 直前のINSERT ID | - |
| INSERT | upro_first | フォーム入力値 | - |
| INSERT | upro_last | フォーム入力値 | - |
| INSERT | upro_country | フォーム入力値 | - |
| INSERT | upro_date | NOW() | - |

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|--------------|----------|--------------|
| 成功 | 作成成功時 | User account created / The user has been sent an e-mail with their account details. |
| エラー | Email空 | E-mail Address is required |
| エラー | Email不正 | Invalid E-mail Address |
| エラー | Email重複 | Invalid E-mail Address - e-mail address in use |
| エラー | Alias空 | Alias is required |
| エラー | Alias不正 | Invalid Alias |
| エラー | Alias重複 | Invalid Alias - alias in use |
| エラー | First Name空 | First Name is required |
| エラー | First Name不正 | Invalid First Name |
| エラー | Last Name空 | Last Name is required |
| エラー | Last Name不正 | Invalid Last Name |
| エラー | Country空 | Country is required |
| エラー | Role空 | Role is required |
| エラー | Role不正 | Invalid Role |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| uusers権限なし | privileges画面へ転送（権限エラー画面） |
| unewuser権限なし | privileges画面へ転送（権限エラー画面） |
| データベース接続エラー | システムエラー画面を表示 |
| メール送信エラー | （エラーハンドリング未確認） |

## 備考

- Ajaxダイアログとして表示される
- パスワードは8文字のランダム生成（英数字）
- 新規作成されたアカウントは即座にactive状態
- メールフォーマットはデフォルトでtext
- 作成完了後にCloseボタンでダイアログを閉じる
- エラー発生時はフォームを再表示し、入力値を保持

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（L347-361）、users_profilesテーブル（L457-477）の構造 |

**読解のコツ**: user_password、user_key、user_salt等のセキュリティ関連カラムに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | newAction（L590-746）がメイン処理 |

**主要処理フロー**:
1. **L592**: ACL権限チェック（uusers, unewuser権限）
2. **L599-652**: バリデーションルール定義
3. **L656-660**: パスワード生成とキー生成
4. **L663-672**: usersテーブルINSERT
5. **L677-689**: users_profilesテーブルINSERT
6. **L691-705**: メール送信処理

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.phtml | `application/modules/admin/views/scripts/users/new.phtml` | 新規作成フォームのレイアウト |

**主要処理フロー**:
- **L9**: posted='N'の場合のみフォーム表示
- **L10**: エラーメッセージ表示
- **L11-122**: フォームフィールド定義
- **L109-120**: 作成/キャンセルボタン

### プログラム呼び出し階層図

```
ユーザー管理画面からNew Userボタン押下
    │
    ├─ getDialog('/admin/users/new/', 'New User')
    │
    └─ Admin_UsersController::newAction()
           │
           ├─ GET時: posted='N'でフォーム表示
           │
           └─ POST時:
                  ├─ バリデーション実行
                  ├─ createRandomPassword()
                  ├─ users INSERT
                  ├─ users_profiles INSERT
                  └─ Zend_Mail送信
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Ajaxダイアログ表示 ────▶ UsersController     ────────▶ new.phtml
                        ::newAction()                  (フォーム)
                              │
                              ▼
フォーム送信 ─────────▶ バリデーション
(POST)                       │
                              ▼
                    ┌─────────────────┐
                    │  成功時         │
                    │  - users INSERT │
                    │  - profiles INSERT│
                    │  - メール送信    │
                    └─────────────────┘
                              │
                              ▼
                    完了メッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | newActionの実装 |
| new.phtml | `application/modules/admin/views/scripts/users/new.phtml` | ビュー | 新規作成フォーム |
| database.sql | `database.sql` | SQL | テーブル定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog関数 |
