# 画面設計書 44-ユーザー詳細画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるユーザー詳細画面の設計仕様を定義する。本画面はユーザー編集画面に組み込まれるAjaxコンテンツとして表示され、ユーザーのアカウント情報と操作ボタンを提供する。

### 本画面の処理概要

本画面は、ユーザー編集画面（edit.phtml）の右サイドバーにAjaxで読み込まれ、ユーザーアカウントの詳細情報表示と主要操作ボタンを提供する。

**業務上の目的・背景**：ユーザー編集画面において、常に参照可能な形でユーザーの重要情報と操作ボタンを表示するために必要な画面部品である。保存、ステータス変更、パスワードリセットなどの主要操作を一箇所に集約し、効率的なユーザー管理を支援する。

**画面へのアクセス方法**：ユーザー編集画面（edit）からAjaxで自動読み込みされる。URLは `/admin/users/details/id/{user_id}/` である。

**主要な操作・処理内容**：
1. ユーザーアカウント情報の表示（作成日、ステータス、更新日）
2. ユーザーのコメント数表示とコメント管理画面へのリンク
3. ユーザー情報保存ボタン（editFormのPOST）
4. アカウントステータス変更ボタン（有効化/停止）
5. パスワードリセットボタン
6. ユーザー管理画面への戻りボタン

**画面遷移**：
- 遷移元：ユーザー編集画面(edit)からのAjax読み込み
- 遷移先：コメント管理画面、ステータス変更ダイアログ、パスワードリセットダイアログ

**権限による表示制御**：
- `uedit`権限：保存ボタンの表示/非表示
- `ustatus`権限：ステータス変更ボタンの表示/非表示（自分自身は変更不可）
- `upassword`権限：パスワードリセットボタンの表示/非表示
- `gcomments`権限：コメントリンクの表示/非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ユーザー詳細表示 | 主機能 | ユーザー詳細情報の表示 |

## 画面種別

詳細（Ajax部品）

## URL/ルーティング

| 項目 | 値 |
|------|------|
| URL | `/admin/users/details/id/{user_id}/` |
| HTTPメソッド | GET |
| モジュール | admin |
| コントローラー | users |
| アクション | details |

## 入出力項目

### GETパラメータ（入力）

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | int | 必須 | 詳細表示対象ユーザーID |

## 表示項目

### Detailsセクション

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| Account Created | アカウント作成日時（フォーマット済み） | users.user_date |
| Account Status | アカウントステータス（Active/Inactive/Suspended） | users.user_status |
| Last Updated | 最終更新日時（フォーマット済み） | users_profiles.upro_date |
| Comments | ユーザーのコメント数（リンク付き） | commentsテーブルから集計 |

### Functionsセクション（アクションボタン）

| ボタン名 | 表示条件 | アクション |
|----------|----------|----------|
| Save | uedit権限あり | editFormをPOST送信 |
| Activate Account | ustatus権限あり かつ ステータス=inactive/suspended かつ 自分以外 | ステータス変更ダイアログ表示 |
| Suspend Account | ustatus権限あり かつ ステータス=active/inactive かつ 自分以外 | ステータス変更ダイアログ表示 |
| Reset Password | upassword権限あり | パスワードリセットダイアログ表示 |
| Users... | 常時表示 | ユーザー管理画面へ遷移 |

## イベント仕様

### 1-保存実行

**トリガー**: Saveボタン押下

**処理フロー**:
1. postDialog関数を呼び出し
2. 'editForm'の内容を`/admin/users/save/id/{user_id}/`へPOST
3. 保存結果をAjaxダイアログで表示

### 2-アカウント有効化

**トリガー**: Activate Accountボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/users/status/id/{user_id}/status/active/`をAjaxダイアログで表示
3. 確認後、statusActionでステータス更新

### 3-アカウント停止

**トリガー**: Suspend Accountボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/users/status/id/{user_id}/status/suspended/`をAjaxダイアログで表示
3. 確認後、statusActionでステータス更新

### 4-パスワードリセット

**トリガー**: Reset Passwordボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/users/password/id/{user_id}/`をAjaxダイアログで表示
3. 確認後、新パスワード生成・メール送信

### 5-ユーザー管理画面へ戻る

**トリガー**: Users...ボタン押下

**処理フロー**:
1. goTo関数を呼び出し
2. `/admin/users/`へ画面遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | users, users_profiles | SELECT | ユーザー情報の取得 |
| 画面表示 | comments | SELECT COUNT | コメント数の集計 |

### テーブル別更新項目詳細

#### usersテーブル（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id, user_date, user_status | user_id = パラメータ | - |

#### users_profilesテーブル（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | upro_date | upro_userid = user_id | JOIN取得 |

#### commentsテーブル（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT COUNT | - | comment_user = user_id | コメント数集計 |

## メッセージ仕様

この画面自体にはメッセージ表示はなく、呼び出し元のダイアログで表示される。

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| uusers権限なし | privileges画面へ転送 |
| uview権限なし | privileges画面へ転送 |
| ユーザーが存在しない | 空のレスポンスを返却 |

## 備考

- layoutは無効化される（Ajax部品として機能）
- 編集画面の右サイドバーContentPaneに動的読み込み
- 自分自身のアカウントステータスは変更できない（ボタン非表示）
- ステータスに応じてActivate/Suspendボタンの表示切り替え
- コメント数が0でもリンクは表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | detailsAction（L555-588）がメイン処理 |

**主要処理フロー**:
1. **L557**: ACL権限チェック（uusers, uview権限）
2. **L559**: layoutの無効化（Ajax部品として機能）
3. **L563-570**: ユーザー情報取得（users + profiles JOIN）
4. **L574-580**: コメント数の集計

#### Step 2: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | details.phtml | `application/modules/admin/views/scripts/users/details.phtml` | 詳細表示とボタン定義 |

**主要処理フロー**:
- **L4-15**: Detailsセクション（アカウント情報）
- **L16-22**: Commentsリンク（gcomments権限で制御）
- **L24-46**: Functionsセクション（操作ボタン）

### プログラム呼び出し階層図

```
ユーザー編集画面からAjax読み込み
    │
    └─ Admin_UsersController::detailsAction()
           │
           ├─ ACL権限チェック
           ├─ ユーザー情報取得
           ├─ コメント数集計
           │
           └─ details.phtml (View)
                  ├─ Detailsセクション表示
                  │      ├─ Account Created
                  │      ├─ Account Status
                  │      ├─ Last Updated
                  │      └─ Comments (リンク)
                  │
                  └─ Functionsセクション
                         ├─ Save (uedit権限)
                         ├─ Activate/Suspend (ustatus権限)
                         ├─ Reset Password (upassword権限)
                         └─ Users...
```

### データフロー図

```
[入力]                    [処理]                         [出力]

user_id (GET) ────────▶ UsersController     ────────▶ details.phtml
                        ::detailsAction()              (HTML)
                              │
                              ▼
                    ┌─────────────────┐
                    │  MySQL DB       │
                    │  - users        │
                    │  - users_profiles│
                    │  - comments     │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | detailsActionの実装 |
| details.phtml | `application/modules/admin/views/scripts/users/details.phtml` | ビュー | 詳細表示テンプレート |
| edit.phtml | `application/modules/admin/views/scripts/users/edit.phtml` | ビュー | 詳細画面の呼び出し元 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | postDialog, getDialog, goTo関数 |
