# 画面設計書 45-ロール管理画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるロール管理画面（ロール編集画面）の設計仕様を定義する。本画面はロールの基本情報編集と権限（リソース）設定を管理する機能を提供する。

### 本画面の処理概要

本画面は、特定のロール（役割）の設定を編集するためのフォームを提供する。ロール名、識別色の設定に加えて、各モジュールごとの権限（リソースアクセス）を設定できる。

**業務上の目的・背景**：管理者がシステム内の各ロールに割り当てる権限を細かく制御するために必要な画面である。ロールベースアクセス制御（RBAC）の設定を行い、ユーザーに適切な権限を付与するための基盤となる。組織内の役割分担に応じた権限設定を実現する。

**画面へのアクセス方法**：ユーザー管理画面（manage）のロール一覧からロール名をクリック、または右クリックメニューから「Edit」を選択することでアクセスする。URLは `/admin/users/role/id/{role_id}/` である。

**主要な操作・処理内容**：
1. ロール基本情報の編集（タイトル、識別色）
2. モジュール別権限設定（チェックボックスでリソースアクセスを設定）
3. ロール設定の保存
4. ロールの削除（システム既定ロール以外）
5. ユーザー管理画面への戻り

**画面遷移**：
- 遷移元：ユーザー管理画面(manage)
- 遷移先：ユーザー管理画面(manage)、ロール削除確認画面(roledelete)

**権限による表示制御**：
- `uusers`権限：画面へのアクセス可否を制御
- `uroleedit`権限：ロール編集機能の実行可否を制御
- `uroledelete`権限：削除ボタンの表示/非表示（role_id > 3のロールのみ削除可能）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | ロール管理 | 主機能 | ロール設定の編集・更新処理 |

## 画面種別

編集

## URL/ルーティング

| 項目 | 値 |
|------|------|
| URL | `/admin/users/role/id/{role_id}/` |
| HTTPメソッド | GET（表示）、POST（保存はrolesaveAction経由） |
| モジュール | admin |
| コントローラー | users |
| アクション | role |

## 入出力項目

### GETパラメータ（入力）

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | int | 必須 | 編集対象ロールID |

### POSTパラメータ（保存時・rolesaveAction）

| パラメータ名 | 型 | 必須 | バリデーション | 説明 |
|-------------|-----|------|--------------|------|
| title | string | 必須 | NotEmpty | ロール名 |
| colour | string | 必須 | NotEmpty | 識別色（HTMLカラーコード） |
| resources[] | array | 任意 | - | 選択されたリソースID配列 |

## 表示項目

### Roleセクション（Identity）

| 項目名 | 入力形式 | データソース |
|--------|----------|--------------|
| Title | テキスト（必須） | users_roles.role_title |
| Colour | カラーパレット | users_roles.role_colour |

### Resources/Permissionsタブ

#### Globalタブ

| グループ | 表示項目 | データソース |
|----------|----------|--------------|
| administration | Control Panel アクセス権限 | users_resources |
| comments | Comments モジュール権限 | users_resources |
| rotators | Rotators モジュール権限 | users_resources |

#### Articlesタブ

| グループ | 表示項目 | データソース |
|----------|----------|--------------|
| global | Articles モジュールアクセス | users_resources |
| articles | 記事関連権限（CRUD） | users_resources |
| categories | カテゴリ関連権限（CRUD） | users_resources |

#### Eventsタブ

| グループ | 表示項目 | データソース |
|----------|----------|--------------|
| global | Events モジュールアクセス | users_resources |
| events | イベント関連権限（CRUD） | users_resources |
| categories | カテゴリ関連権限（CRUD） | users_resources |
| venues | 会場関連権限（CRUD） | users_resources |

#### Resourcesタブ

| グループ | 表示項目 | データソース |
|----------|----------|--------------|
| global | Resources モジュールアクセス | users_resources |
| resources | リソース関連権限（CRUD） | users_resources |
| categories | カテゴリ関連権限（CRUD） | users_resources |
| brands | ブランド関連権限（CRUD） | users_resources |

#### Pagesタブ

| グループ | 表示項目 | データソース |
|----------|----------|--------------|
| global | Pages モジュールアクセス | users_resources |
| pages | ページ関連権限（CRUD） | users_resources |

#### Assetsタブ

| グループ | 表示項目 | データソース |
|----------|----------|--------------|
| global | Assets ストアアクセス | users_resources |
| assets | アセット関連権限（CRUD） | users_resources |
| folders | フォルダ関連権限（CRUD） | users_resources |

#### Mailタブ

| グループ | 表示項目 | データソース |
|----------|----------|--------------|
| global | Mail モジュールアクセス | users_resources |
| mail | メール関連権限（CRUD） | users_resources |
| mailing lists | メーリングリスト関連権限（CRUD） | users_resources |

#### Usersタブ

| グループ | 表示項目 | データソース |
|----------|----------|--------------|
| global | Users モジュールアクセス | users_resources |
| users | ユーザー関連権限（CRUD） | users_resources |
| roles | ロール関連権限（CRUD） | users_resources |

### 詳細セクション（roledetails.phtml）

| 項目名 | 表示内容 |
|--------|----------|
| Role ID | ロールID |
| Role Members | このロールに属するユーザー数 |

## イベント仕様

### 1-保存実行

**トリガー**: Saveボタン押下

**処理フロー**:
1. postDialog関数を呼び出し
2. roleFormの内容を`/admin/users/rolesave/id/{role_id}/`へPOST
3. バリデーション実行（rolesaveAction内）
4. 成功時：
   - users_rolesテーブル更新
   - users_privileges全削除→再挿入（権限再構築）
5. 結果をダイアログで表示

### 2-ロール削除

**トリガー**: Deleteボタン押下（role_id > 3の場合のみ表示）

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/users/roledelete/id/{role_id}/`をAjaxダイアログで表示

### 3-ユーザー管理画面へ戻る

**トリガー**: Users...ボタン押下

**処理フロー**:
1. goTo関数を呼び出し
2. `/admin/users/`へ画面遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | users_roles | SELECT | ロール情報の取得 |
| 画面表示 | users_resources | SELECT | リソース一覧取得 |
| 画面表示 | users_privileges | SELECT | 現在の権限設定取得 |
| 画面表示 | users | SELECT COUNT | ロール所属ユーザー数 |
| 保存実行 | users_roles | UPDATE | ロール基本情報更新 |
| 保存実行 | users_privileges | DELETE/INSERT | 権限設定再構築 |

### テーブル別更新項目詳細

#### users_rolesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | role_title | フォーム入力値 | - |
| UPDATE | role_colour | フォーム入力値 | HTMLカラーコード |

#### users_privilegesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | prv_role = {role_id} | 既存権限を全削除 |
| INSERT | prv_resource, prv_role | リソース名, ロールID | 選択された権限を挿入 |

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|--------------|----------|--------------|
| 成功 | 保存成功時 | Role Saved |
| エラー | Title空 | Title is required |
| エラー | Colour空 | Colour is required |
| エラー | ID未指定 | Role Not Specified! |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| uusers権限なし | privileges画面へ転送 |
| uroleedit権限なし | privileges画面へ転送 |
| 指定IDのロール不存在 | manage画面へリダイレクト |
| データベース接続エラー | システムエラー画面を表示 |

## 備考

- タブコンテナ形式（Role（Identity）タブ、Global/Articles/Events等のResourcesタブ）
- 識別色はDojoの色パレットウィジェットで選択
- システム既定ロール（User:1, Guest:2, Administrator:3）は削除不可
- リソースはモジュール（res_module）とグループ（res_group）で整理
- 各リソースには説明文（res_description）が表示される
- 権限設定は「全削除→再挿入」方式で更新
- 詳細情報はroledetailsActionから非同期読み込み

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | users_rolesテーブル（L576-581）、users_privilegesテーブル（L367-372）、users_resourcesテーブル（L483-491）の構造 |

**読解のコツ**: users_privilegesがロール（prv_role）とリソース（prv_resource）の紐付けテーブルとなっている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | roleAction（L206-232）とrolesaveAction（L234-340） |

**主要処理フロー（roleAction）**:
1. **L208**: ACL権限チェック（uusers, uroleedit権限）
2. **L213-218**: ロール情報取得
3. **L221-226**: リソース一覧取得（モジュール別ソート）

**主要処理フロー（rolesaveAction）**:
1. **L236**: ACL権限チェック
2. **L246-259**: バリデーション
3. **L270-276**: ロール基本情報更新
4. **L279-299**: 権限設定の再構築

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | role.phtml | `application/modules/admin/views/scripts/users/role.phtml` | ロール編集フォームとリソースタブ |
| 3-2 | roledetails.phtml | `application/modules/admin/views/scripts/users/roledetails.phtml` | ロール詳細情報とアクションボタン |

### プログラム呼び出し階層図

```
/admin/users/role/id/{role_id}/ (HTTP Request)
    │
    ├─ Admin_UsersController::roleAction()
    │      ├─ ACL権限チェック
    │      ├─ ロール情報取得
    │      └─ リソース一覧取得
    │
    └─ role.phtml (View)
           │
           ├─ roledetails.phtml (Ajax読み込み)
           │      ├─ ロール詳細情報表示
           │      ├─ Save/Delete/Usersボタン
           │      └─ URolePrivileges (View Helper)
           │
           ├─ Roleタブ（Identity）
           │      ├─ Title入力
           │      └─ Colour選択（パレット）
           │
           └─ Resources/Permissionsタブ
                  └─ モジュール別チェックボックス

保存時:
/admin/users/rolesave/id/{role_id}/ (POST)
    │
    └─ Admin_UsersController::rolesaveAction()
           ├─ バリデーション
           ├─ users_roles更新
           └─ users_privileges再構築
```

### データフロー図

```
[入力]                    [処理]                         [出力]

role_id (GET) ────────▶ UsersController     ────────▶ role.phtml
                        ::roleAction()                 (HTML Form)
                              │
                              ▼
                    ┌─────────────────┐
                    │  MySQL DB       │
                    │  - users_roles  │
                    │  - users_resources│
                    │  - users_privileges│
                    └─────────────────┘

フォーム送信 ────────▶ UsersController     ────────▶ Ajax Response
(POST)                 ::rolesaveAction()            (成功/エラー)
                              │
                              ▼
                    ┌─────────────────┐
                    │  UPDATE roles   │
                    │  DELETE/INSERT  │
                    │  privileges     │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | role, rolesave, roledetailsアクション |
| role.phtml | `application/modules/admin/views/scripts/users/role.phtml` | ビュー | ロール編集フォーム |
| roledetails.phtml | `application/modules/admin/views/scripts/users/roledetails.phtml` | ビュー | ロール詳細・アクションボタン |
| database.sql | `database.sql` | SQL | テーブル定義 |
