# 画面設計書 46-ロール新規作成画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるロール新規作成画面の設計仕様を定義する。本画面はAjaxダイアログとして表示され、新規ロール（役割）を作成する機能を提供する。

### 本画面の処理概要

本画面は、システムに新しいロール（役割）を追加するためのフォームをAjaxダイアログとして提供する。ロール名を入力し、作成後はロール管理画面に遷移して詳細設定を行う。

**業務上の目的・背景**：管理者が新しいユーザーロール（役割）を作成するために必要な画面である。組織構造の変更や新しい権限グループの追加に対応するために使用される。作成後はロール管理画面で詳細な権限設定を行う2段階のワークフローを採用している。

**画面へのアクセス方法**：ユーザー管理画面（manage）の「New Role」ボタンをクリックすることで、Ajaxダイアログとして表示される。URLは `/admin/users/rolenew/` である。

**主要な操作・処理内容**：
1. ロール名（タイトル）の入力（必須、重複チェックあり）
2. ロール作成の実行
3. ダイアログのキャンセル
4. 作成完了後、ロール管理画面へ遷移（Continue）

**画面遷移**：
- 遷移元：ユーザー管理画面(manage)のダイアログ呼び出し
- 遷移先：ロール管理画面(role)（Continue後）、またはダイアログを閉じてユーザー管理画面に戻る

**権限による表示制御**：
- `uusers`権限：ダイアログ表示可否を制御
- `urolenew`権限：新規ロール作成機能の実行可否を制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | ロール新規作成 | 主機能 | 新規ロールの作成処理 |

## 画面種別

登録（Ajaxダイアログ）

## URL/ルーティング

| 項目 | 値 |
|------|------|
| URL | `/admin/users/rolenew/` |
| HTTPメソッド | GET（表示）、POST（登録） |
| モジュール | admin |
| コントローラー | users |
| アクション | rolenew |

## 入出力項目

### POSTパラメータ（登録時）

| パラメータ名 | 型 | 必須 | バリデーション | 説明 |
|-------------|-----|------|--------------|------|
| roletitle | string | 必須 | NotEmpty, Alnum(空白許可), 重複チェック | ロール名 |

## 表示項目

### フォームフィールド

| 項目名 | 入力形式 | バリデーション | 備考 |
|--------|----------|--------------|------|
| Title | テキスト（必須） | 英数字・空白、重複チェック | 幅190px |

## イベント仕様

### 1-ロール作成実行

**トリガー**: Createボタン押下

**処理フロー**:
1. doDialog関数を呼び出し
2. newroleFormの内容を`/admin/users/rolenew/`へPOST
3. バリデーション実行
4. 成功時：
   - users_rolesテーブルにレコード挿入（タイトルとデフォルト色）
   - 成功メッセージとContinueボタンを表示
5. エラー時：
   - エラーメッセージを表示
   - フォームを再表示（入力値保持）

### 2-キャンセル

**トリガー**: Cancelボタン押下

**処理フロー**:
1. dijit.byId('ajaxDialog').hide()を呼び出し
2. ダイアログを閉じる

### 3-ロール管理画面へ遷移

**トリガー**: Continueボタン押下（作成成功後）

**処理フロー**:
1. goTo関数を呼び出し
2. `/admin/users/role/id/{new_role_id}/`へ画面遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成実行 | users_roles | INSERT | 新規ロールレコード挿入 |

### テーブル別更新項目詳細

#### users_rolesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | role_title | フォーム入力値 | 重複チェック済み |
| INSERT | role_colour | '#FFFFFF' | 固定値（白） |

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|--------------|----------|--------------|
| 成功 | 作成成功時 | Role Created |
| エラー | Title空 | Title is required |
| エラー | Title不正 | Invalid Title |
| エラー | Title重複 | Title in use |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| uusers権限なし | privileges画面へ転送 |
| urolenew権限なし | privileges画面へ転送 |
| データベース接続エラー | システムエラー画面を表示 |

## 備考

- Ajaxダイアログとして表示される
- デフォルト識別色は白（#FFFFFF）で設定される
- 作成直後のロールには権限が一切設定されていない
- 作成完了後はContinueボタンでロール管理画面に遷移し、権限設定を行う
- ロール名は既存ロールと重複不可
- 作成されるロールのIDは自動採番（role_id > 3になる）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | users_rolesテーブル（L576-581）の構造 |

**読解のコツ**: role_id, role_title, role_colourの3カラムのみのシンプルなテーブル構造。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | rolenewAction（L749-818）がメイン処理 |

**主要処理フロー**:
1. **L751**: ACL権限チェック（uusers, urolenew権限）
2. **L754**: layoutの無効化（Ajax部品として機能）
3. **L758-772**: バリデーションルール定義
4. **L778-785**: users_rolesテーブルINSERT
5. **L787-794**: 成功メッセージとContinueボタン出力

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rolenew.phtml | `application/modules/admin/views/scripts/users/rolenew.phtml` | 新規作成フォームのレイアウト |

**主要処理フロー**:
- **L7-8**: posted='N'の場合のみフォーム表示
- **L9**: エラーメッセージ表示
- **L10-40**: フォームフィールドとボタン定義

### プログラム呼び出し階層図

```
ユーザー管理画面からNew Roleボタン押下
    │
    ├─ getDialog('/admin/users/rolenew/', 'New Role')
    │
    └─ Admin_UsersController::rolenewAction()
           │
           ├─ GET時: posted='N'でフォーム表示
           │
           └─ POST時:
                  ├─ バリデーション実行
                  │     ├─ NotEmpty
                  │     ├─ Alnum（空白許可）
                  │     └─ NoRecordExists（重複チェック）
                  │
                  ├─ users_roles INSERT
                  │     ├─ role_title = 入力値
                  │     └─ role_colour = '#FFFFFF'
                  │
                  └─ 成功メッセージ + Continueボタン出力
                         │
                         └─ goTo('/admin/users/role/id/{new_id}/')
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Ajaxダイアログ表示 ────▶ UsersController     ────────▶ rolenew.phtml
                        ::rolenewAction()              (フォーム)
                              │
                              ▼
フォーム送信 ─────────▶ バリデーション
(POST)                       │
                              ├─ 成功
                              │      ▼
                              │  ┌─────────────────┐
                              │  │ users_roles     │
                              │  │ INSERT          │
                              │  └─────────────────┘
                              │      │
                              │      ▼
                              │  成功メッセージ
                              │  + Continueボタン
                              │      │
                              │      ▼
                              │  ロール管理画面へ
                              │
                              └─ 失敗
                                     ▼
                                 エラーメッセージ
                                 + フォーム再表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | rolenewActionの実装 |
| rolenew.phtml | `application/modules/admin/views/scripts/users/rolenew.phtml` | ビュー | 新規作成フォーム |
| database.sql | `database.sql` | SQL | テーブル定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog, goTo関数 |
