# 画面設計書 47-ロール削除確認画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるロール削除確認画面の設計仕様を定義する。本画面はAjaxダイアログとして表示され、ロールの削除確認と実行機能を提供する。

### 本画面の処理概要

本画面は、ロール（役割）を削除する前に確認を求めるダイアログを表示し、確認後に削除処理を実行する。削除されたロールに属していたユーザーはデフォルトの「User」ロールに移行される。

**業務上の目的・背景**：管理者がロールを誤って削除することを防ぎ、削除による影響を認識させるために必要な確認画面である。削除時には該当ロールに所属するユーザーを「User」ロール（role_id=1）に自動移行させ、データ整合性を保つ。

**画面へのアクセス方法**：ユーザー管理画面（manage）のロール一覧から右クリックメニューで「Delete」を選択、またはロール管理画面（role）の「Delete」ボタンをクリックすることで、Ajaxダイアログとして表示される。URLは `/admin/users/roledelete/id/{role_id}/` である。

**主要な操作・処理内容**：
1. 削除確認メッセージの表示
2. 削除の実行（Delete）
3. 削除のキャンセル（Cancel/Close）

**画面遷移**：
- 遷移元：ユーザー管理画面(manage)、ロール管理画面(role)のダイアログ呼び出し
- 遷移先：ダイアログを閉じて元の画面に戻る（削除成功時は画面リロード）

**権限による表示制御**：
- `uusers`権限：ダイアログ表示可否を制御
- `uroledelete`権限：ロール削除機能の実行可否を制御
- システム既定ロール（role_id <= 3）は削除不可（呼び出し元で制御）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | ロール削除 | 主機能 | ロールの削除処理 |

## 画面種別

確認（Ajaxダイアログ）

## URL/ルーティング

| 項目 | 値 |
|------|------|
| URL | `/admin/users/roledelete/id/{role_id}/` |
| HTTPメソッド | GET（確認表示）、GET+confirm=1（削除実行） |
| モジュール | admin |
| コントローラー | users |
| アクション | roledelete |

## 入出力項目

### GETパラメータ（入力）

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | int | 必須 | 削除対象ロールID |
| confirm | int | 任意 | 確認フラグ（1=削除実行） |

## 表示項目

### 確認画面（confirm未指定時）

| 項目名 | 表示内容 |
|--------|----------|
| 確認メッセージ | "Are you sure you want to delete this role?" |
| Deleteボタン | 削除実行（confirm=1で再呼び出し） |
| Cancelボタン | ダイアログを閉じる |

### 完了画面（confirm=1時）

| 項目名 | 表示内容 |
|--------|----------|
| 完了メッセージ | "Role Deleted" |
| Closeボタン | ダイアログを閉じて画面リロード |

## イベント仕様

### 1-削除確認表示

**トリガー**: getDialog呼び出し（confirm未指定）

**処理フロー**:
1. confirm=1なしでroledeleteActionが呼び出される
2. 確認メッセージとDelete/Cancelボタンを表示

### 2-削除実行

**トリガー**: Deleteボタン押下

**処理フロー**:
1. getDialog関数を呼び出し（confirm=1付き）
2. `/admin/users/roledelete/id/{role_id}/confirm/1/`を呼び出し
3. 削除処理実行：
   - 該当ロールに属するユーザーをUser（role_id=1）に移行
   - users_privilegesから該当ロールの権限設定を削除
   - users_rolesから該当ロールを削除
4. 完了メッセージとCloseボタンを表示

### 3-キャンセル

**トリガー**: Cancelボタン押下

**処理フロー**:
1. dijit.byId('ajaxDialog').hide()を呼び出し
2. ダイアログを閉じる

### 4-完了後クローズ

**トリガー**: Closeボタン押下（削除完了後）

**処理フロー**:
1. dijit.byId('ajaxDialog').hide()を呼び出し
2. location.reload(true)で画面リロード

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除実行 | users | UPDATE | 該当ロールのユーザーをUser(1)に移行 |
| 削除実行 | users_privileges | DELETE | 該当ロールの権限設定を削除 |
| 削除実行 | users_roles | DELETE | ロールレコードを削除 |

### テーブル別更新項目詳細

#### usersテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | user_role | 1 (User) | WHERE user_role = 削除対象role_id |

#### users_privilegesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE prv_role = 削除対象role_id | 権限設定を全削除 |

#### users_rolesテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE role_id = 削除対象role_id | ロールレコード削除 |

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|--------------|----------|--------------|
| 確認 | 削除確認時 | Are you sure you want to delete this role? |
| 成功 | 削除成功時 | Role Deleted |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| uusers権限なし | privileges画面へ転送 |
| uroledelete権限なし | privileges画面へ転送 |
| role_idが未設定またはシステム既定ロール | （呼び出し元で制御、このアクションには到達しない） |
| データベース接続エラー | システムエラー画面を表示 |

## 備考

- Ajaxダイアログとして表示される
- レイアウトとビューレンダラーは無効化（直接echo出力）
- システム既定ロール（User:1, Guest:2, Administrator:3）は削除不可（呼び出し元で制御）
- 削除前にユーザー移行処理を行うため、孤児ユーザーは発生しない
- 削除完了後は画面リロードで一覧を更新

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | users_rolesテーブル（L576-581）、users_privilegesテーブル（L367-372）、usersテーブル（L347-361）の構造と関連 |

**読解のコツ**: users.user_roleがusers_roles.role_idを参照する外部キー的関係。users_privilegesはロールごとの権限設定。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UsersController.php | `application/modules/admin/controllers/UsersController.php` | roledeleteAction（L820-867）がメイン処理 |

**主要処理フロー**:
1. **L822**: ACL権限チェック（uusers, uroledelete権限）
2. **L825-826**: layout/viewRenderer無効化
3. **L829-830**: パラメータ取得（confirm, role_id）
4. **L833-852**: confirm=1時の削除処理
   - **L836-843**: ユーザーをUser(1)に移行
   - **L846**: users_privilegesから権限削除
   - **L849**: users_rolesからロール削除
5. **L854-861**: confirm未設定時の確認画面出力

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | manage.phtml | `application/modules/admin/views/scripts/users/manage.phtml` | ロール一覧での削除メニュー（L107） |
| 3-2 | roledetails.phtml | `application/modules/admin/views/scripts/users/roledetails.phtml` | ロール編集画面での削除ボタン（L19-21） |

### プログラム呼び出し階層図

```
ユーザー管理画面またはロール管理画面からDelete選択
    │
    ├─ getDialog('/admin/users/roledelete/id/{role_id}/', 'Delete Role')
    │
    └─ Admin_UsersController::roledeleteAction()
           │
           ├─ confirm未設定時: 確認画面出力
           │      ├─ 確認メッセージ
           │      ├─ Deleteボタン（confirm=1で再呼び出し）
           │      └─ Cancelボタン
           │
           └─ confirm=1時: 削除処理実行
                  │
                  ├─ users UPDATE (user_role = 1)
                  │      WHERE user_role = {role_id}
                  │
                  ├─ users_privileges DELETE
                  │      WHERE prv_role = {role_id}
                  │
                  ├─ users_roles DELETE
                  │      WHERE role_id = {role_id}
                  │
                  └─ 完了メッセージ + Closeボタン
                         │
                         └─ location.reload(true)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

role_id (GET) ────────▶ UsersController     ────────▶ 確認画面
                        ::roledeleteAction()          (HTML出力)
                              │
                              │ (confirm=1)
                              ▼
                    ┌─────────────────┐
                    │  MySQL DB       │
                    │  1. users UPDATE│
                    │  2. privileges  │
                    │     DELETE      │
                    │  3. roles DELETE│
                    └─────────────────┘
                              │
                              ▼
                         完了画面
                         (HTML出力)
                              │
                              ▼
                    location.reload(true)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| UsersController.php | `application/modules/admin/controllers/UsersController.php` | コントローラー | roledeleteActionの実装 |
| manage.phtml | `application/modules/admin/views/scripts/users/manage.phtml` | ビュー | 削除メニューの呼び出し元 |
| roledetails.phtml | `application/modules/admin/views/scripts/users/roledetails.phtml` | ビュー | 削除ボタンの呼び出し元 |
| database.sql | `database.sql` | SQL | テーブル定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog関数 |
