# 画面設計書 48-イベント管理画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるイベント管理画面の設計仕様を定義する。本画面は登録イベントの一覧表示、検索、フィルタリング機能を提供し、イベント管理業務の中核となる画面である。

### 本画面の処理概要

本画面は、システムに登録されている全イベントを一覧形式で表示し、管理者がイベントを効率的に管理できる機能を提供する。

**業務上の目的・背景**：管理者がシステム内のイベント情報を効率的に管理するために必要な画面である。イベントの追加、編集、削除、公開などの操作の起点となり、イベント管理業務の効率化を実現する。カテゴリと会場によるフィルタリングにより、大量のイベント情報の中から目的のイベントを素早く見つけることができる。

**画面へのアクセス方法**：管理画面ログイン後、サイドメニューから「Events」を選択、または管理ダッシュボードからイベント管理リンクをクリックすることでアクセスする。URLは `/admin/events/manage/` である。

**主要な操作・処理内容**：
1. イベント一覧の閲覧（タイトル、カテゴリ、会場、日時を表示）
2. カテゴリ別フィルタリング
3. 会場別フィルタリング
4. カテゴリと会場の複合フィルタリング
5. 新規イベント作成ダイアログの表示（権限があれば）
6. 新規カテゴリ作成ダイアログの表示（権限があれば）
7. 新規会場作成ダイアログの表示（権限があれば）
8. イベント編集画面への遷移
9. カテゴリ編集画面への遷移
10. 会場編集画面への遷移
11. イベント削除確認ダイアログ表示（権限があれば）

**画面遷移**：
- 遷移元：管理ダッシュボード、サイドメニュー
- 遷移先：イベント編集画面(edit)、イベント新規作成画面(new/new2)、カテゴリ編集画面(category)、会場編集画面(venue)、会場一覧画面(venues)

**権限による表示制御**：
- `eevents`権限：画面へのアクセス可否を制御
- `eeventnew`権限：「New Event」ボタンの表示/非表示
- `ecategorynew`権限：「New Category」ボタンの表示/非表示
- `evenuenew`権限：「New Venue」ボタンの表示/非表示
- `eeventdelete`権限：イベント削除リンクの表示/非表示
- `eeventedit`権限：イベント編集リンクの有効化

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | イベント一覧表示 | 主機能 | イベント一覧を表示 |
| 62 | ページネーション | 補助機能 | イベント一覧のページ送り処理 |
| 61 | アクセス制御 | 補助機能 | 管理者権限チェック |

## 画面種別

一覧

## URL/ルーティング

| 項目 | 値 |
|------|------|
| URL | `/admin/events/manage/` |
| HTTPメソッド | GET |
| モジュール | admin |
| コントローラー | events |
| アクション | manage |

## 入出力項目

### GETパラメータ（入力）

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| category | int | 任意 | カテゴリIDによるフィルタ |
| venue | int | 任意 | 会場IDによるフィルタ |
| page | int | 任意 | ページ番号（デフォルト: 1） |

## 表示項目

### イベント一覧テーブル

| 項目名 | 表示内容 | データソース |
|--------|----------|--------------|
| ステータスアイコン | 緑旗(published)/黄旗(draft) | events.event_status |
| タイトル | イベントタイトル（リンク付き） | events.event_title |
| カテゴリ | カテゴリ名 | events_categories.ecat_title |
| 会場 | 会場名（市区町村） | events_venues.venue_title, venue_city |
| 日時 | 開始日時〜終了日時 | events.event_date, event_end |

### カテゴリ一覧

| 項目名 | 説明 |
|--------|------|
| カテゴリ名 | 各カテゴリに属するイベント数を括弧内に表示（リンク付き） |

### 会場一覧

| 項目名 | 説明 |
|--------|------|
| 会場名 | 各会場で開催されるイベント数を括弧内に表示（リンク付き） |
| More... | 会場一覧画面へのリンク |

## イベント仕様

### 1-新規イベント作成

**トリガー**: 「New Event」ボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/events/new/`をAjaxダイアログで表示
3. イベント新規作成フォーム（Step1：カテゴリ・会場選択）を表示

### 2-新規カテゴリ作成

**トリガー**: 「New Category」ボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/events/categorynew/`をAjaxダイアログで表示
3. カテゴリ新規作成フォームを表示

### 3-新規会場作成

**トリガー**: 「New Venue」ボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/events/venuenew/`をAjaxダイアログで表示
3. 会場新規作成フォームを表示

### 4-カテゴリフィルタ適用

**トリガー**: カテゴリ名クリック

**処理フロー**:
1. categoryパラメータを付与してページをリロード
2. 指定カテゴリのイベントのみ表示

### 5-会場フィルタ適用

**トリガー**: 会場名クリック

**処理フロー**:
1. venueパラメータを付与してページをリロード
2. 指定会場のイベントのみ表示

### 6-イベント編集画面遷移

**トリガー**: イベントタイトルクリックまたはEditリンククリック

**処理フロー**:
1. `/admin/events/edit/id/{event_id}/`へ画面遷移

### 7-イベント削除確認

**トリガー**: 削除アイコンクリック

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/events/delete/id/{event_id}/`をAjaxダイアログで表示

### 8-カテゴリ編集画面遷移

**トリガー**: カテゴリ名の右クリックメニューから「Edit」選択

**処理フロー**:
1. goTo関数を呼び出し
2. `/admin/events/category/id/{category_id}/`へ画面遷移

### 9-会場編集画面遷移

**トリガー**: 会場名の右クリックメニューから「Edit」選択

**処理フロー**:
1. goTo関数を呼び出し
2. `/admin/events/venue/id/{venue_id}/`へ画面遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | events, events_categories, events_venues | SELECT | イベント情報の取得 |
| フィルタ適用 | events, events_categories, events_venues | SELECT | 条件に合致するイベント情報の取得 |

### テーブル別更新項目詳細

#### eventsテーブル（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id, event_title, event_date, event_end, event_status, event_category, event_venue | 全件または条件付き | フィルタ条件に応じて動的に変化 |

#### events_categoriesテーブル（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_id, ecat_title | event_category = ecat_id | JOIN取得 |

#### events_venuesテーブル（参照のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id, venue_title, venue_city | event_venue = venue_id | JOIN取得 |

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|--------------|----------|--------------|
| 情報 | イベントが0件の場合 | No Events! |
| 情報 | フィルタ未設定時 | No active filter |
| 情報 | カテゴリが0件の場合 | No Categories! |
| 情報 | 会場が0件の場合 | No Venues! |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| eevents権限なし | privileges画面へ転送（権限エラー画面） |
| データベース接続エラー | システムエラー画面を表示 |

## 備考

- 1ページあたりの表示件数は15件
- ページネーションの表示範囲は5ページ
- イベント一覧は開始日（event_date）でDESCソート（新しい順）
- 会場表示は「会場名（市区町村）」形式、ただしデフォルト会場（venue_id=1）は会場名のみ
- カテゴリ一覧・会場一覧はサイドバーに表示
- イベント日時はEDate関数で整形（同日の場合は時間のみ表示）
- Dojo Toolkitを使用したUIウィジェット

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | eventsテーブル（L103-119）、events_categoriesテーブル（L125-134）、events_venuesテーブル（L140-155）の構造 |

**読解のコツ**: eventsテーブルはevent_categoryでcategoriesと、event_venueでvenuesと関連付けられている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | manageAction（L123-194）がメイン処理 |

**主要処理フロー**:
1. **L125**: ACL権限チェック（eevents権限）
2. **L133-134**: GETパラメータ取得（category, venue）
3. **L144-177**: フィルタ条件に応じたSQLクエリ構築
4. **L180-183**: Paginatorオブジェクト作成と設定

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | 画面レイアウトとDojoウィジェット定義 |

**主要処理フロー**:
- **L8-21**: Dojoモジュールのrequire
- **L35-67**: Functions fieldset（検索、新規イベント、新規カテゴリ、新規会場ボタン）
- **L71-127**: カテゴリと会場のフィルタリング領域
- **L130-176**: イベント一覧テーブル
- **L178-185**: ページネーション

### プログラム呼び出し階層図

```
/admin/events/manage/ (HTTP Request)
    │
    ├─ Admin_EventsController::manageAction()
    │      ├─ ACL権限チェック (view->acl->isAllowed)
    │      ├─ getVenue() - 会場名取得
    │      ├─ getCategory() - カテゴリ名取得
    │      ├─ Zend_Db_Select - SQLクエリ構築
    │      └─ Zend_Paginator::factory() - ページネーション
    │
    └─ manage.phtml (View)
           ├─ ECategoryCount (View Helper) - カテゴリ別カウント
           ├─ EVenueCount (View Helper) - 会場別カウント
           ├─ cycle (View Helper) - 行の交互表示
           ├─ EDate (View Helper) - 日時フォーマット
           └─ paginationControl (View Helper) - ページネーション表示
```

### データフロー図

```
[入力]                    [処理]                         [出力]

GETパラメータ ────────▶ EventsController    ────────▶ manage.phtml
(category, venue,       ::manageAction()              (HTML)
page)                         │
                              │
                              ▼
                    ┌─────────────────┐
                    │  MySQL DB       │
                    │  - events       │
                    │  - categories   │
                    │  - venues       │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | コントローラー | イベント管理の全アクションを定義 |
| manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | ビュー | イベント管理画面のテンプレート |
| admin.phtml | `application/layouts/scripts/admin.phtml` | レイアウト | 管理画面共通レイアウト |
| database.sql | `database.sql` | SQL | データベーススキーマ定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | 共通JavaScript関数 |
