# 画面設計書 49-イベント編集画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるイベント編集画面の設計仕様を定義する。本画面は既存イベントの詳細情報を編集する機能を提供し、イベント情報、コメント設定、公開ステータスの管理を行う。

### 本画面の処理概要

本画面は、特定のイベントの詳細情報を編集するためのフォームを提供する。イベント基本情報、開催日時、会場、カテゴリ、説明文、URL情報、コメント設定を管理できる。

**業務上の目的・背景**：管理者が既存イベントの情報を更新・修正するために必要な画面である。イベントの内容変更、開催日時の変更、公開/非公開の切り替えなど、イベント管理業務の中核となる。正確なイベント情報を維持し、来場者に適切な情報を提供するための基盤となる。

**画面へのアクセス方法**：イベント管理画面（manage）からイベントタイトルをクリック、または編集リンクをクリックすることでアクセスする。URLは `/admin/events/edit/id/{event_id}/` である。

**主要な操作・処理内容**：
1. イベント基本情報の編集（タイトル、カテゴリ、会場）
2. 開催日時の編集（開始日時、終了日時）
3. イベント説明文の編集（WYSIWYGエディタ）
4. 関連URL情報の編集（イベントURL、チケットURL）
5. コメント設定（コメント許可、モデレート有効化）
6. イベント情報の保存
7. イベントの公開（publish）
8. イベントの削除
9. イベント管理画面への戻り

**画面遷移**：
- 遷移元：イベント管理画面(manage)、イベント新規作成画面(new2)
- 遷移先：イベント管理画面(manage)

**権限による表示制御**：
- `eevents`権限：画面へのアクセス可否を制御
- `eeventedit`権限：編集機能の実行可否、Saveボタンの表示/非表示
- `eeventpublish`権限：Publishボタンの表示/非表示
- `eeventdelete`権限：Deleteボタンの表示/非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | イベント編集 | 主機能 | イベント情報の編集・更新処理 |
| 63 | 入力検証 | 補助機能 | イベントフォームのバリデーション |

## 画面種別

編集

## URL/ルーティング

| 項目 | 値 |
|------|------|
| URL | `/admin/events/edit/id/{event_id}/` |
| HTTPメソッド | GET（表示）、POST（保存はsaveAction経由） |
| モジュール | admin |
| コントローラー | events |
| アクション | edit |

## 入出力項目

### GETパラメータ（入力）

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| id | int | 必須 | 編集対象イベントID |

### POSTパラメータ（保存時・saveAction）

| パラメータ名 | 型 | 必須 | バリデーション | 説明 |
|-------------|-----|------|--------------|------|
| title | string | 必須 | NotEmpty | イベントタイトル |
| category | int | 必須 | NotEmpty | カテゴリID |
| venue | int | 必須 | NotEmpty | 会場ID |
| datestart | string | 必須 | NotEmpty | 開始日（YYYY-MM-DD） |
| timestart | string | 必須 | NotEmpty | 開始時刻（HH:MM） |
| dateend | string | 任意 | - | 終了日（YYYY-MM-DD） |
| timeend | string | 任意 | - | 終了時刻（HH:MM） |
| description | string | 必須 | NotEmpty | イベント説明 |
| url | string | 任意 | - | イベントURL |
| ticket | string | 任意 | - | チケットURL |
| comments | string | 任意 | - | コメント許可（Y/N） |
| moderate | string | 任意 | - | モデレート有効（Y/N） |

## 表示項目

### Eventタブ

| 項目名 | 入力形式 | データソース |
|--------|----------|--------------|
| Title | テキスト（必須） | events.event_title |
| Category | ドロップダウン（必須） | events.event_category -> events_categories |
| Venue | FilteringSelect（必須） | events.event_venue -> events_venues |
| Date Start | 日付ピッカー（必須） | events.event_date |
| Time Start | 時刻ピッカー（必須） | events.event_date |
| Date End | 日付ピッカー | events.event_end |
| Time End | 時刻ピッカー | events.event_end |
| Description | WYSIWYGエディタ（必須） | events.event_description |
| Event URL | テキスト | events.event_url |
| Tickets URL | テキスト | events.event_tickets |
| Allow Comments | チェックボックス | events.event_comments |
| Moderate Comments | チェックボックス | events.event_moderate |

### 詳細セクション（details.phtml）

| 項目名 | 表示内容 |
|--------|----------|
| Event Created | イベント作成日時 |
| Event Status | イベントステータス（draft/published） |
| Event Published | 公開日時（公開済みの場合） |
| Created By | 作成者名 |

## イベント仕様

### 1-保存実行

**トリガー**: Saveボタン押下

**処理フロー**:
1. postDialog関数を呼び出し
2. editFormの内容を`/admin/events/save/id/{event_id}/`へPOST
3. バリデーション実行（saveAction内）
4. 成功時：eventsテーブルを更新
5. 公開済みの場合：検索インデックスを更新
6. 結果をダイアログで表示

### 2-公開実行

**トリガー**: Publishボタン押下

**処理フロー**:
1. postDialog関数を呼び出し
2. editFormの内容を`/admin/events/publish/id/{event_id}/`へPOST
3. バリデーション実行
4. 成功時：
   - eventsテーブルを更新（status=published, published日時設定）
   - 検索インデックスに追加
5. 結果をダイアログで表示

### 3-イベント削除

**トリガー**: Deleteボタン押下

**処理フロー**:
1. getDialog関数を呼び出し
2. `/admin/events/delete/id/{event_id}/`をAjaxダイアログで表示
3. 確認後、イベント削除実行

### 4-イベント管理画面へ戻る

**トリガー**: Events...ボタン押下

**処理フロー**:
1. goTo関数を呼び出し
2. `/admin/events/`へ画面遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | events, events_categories, events_venues, users | SELECT | イベント情報の取得 |
| 保存実行 | events | UPDATE | イベント情報更新 |
| 公開実行 | events | UPDATE | イベント情報更新（status変更含む） |

### テーブル別更新項目詳細

#### eventsテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | event_title | フォーム入力値 | - |
| UPDATE | event_category | フォーム入力値 | - |
| UPDATE | event_venue | フォーム入力値 | - |
| UPDATE | event_date | フォーム入力値（日時結合） | YYYY-MM-DD HH:MM:SS形式 |
| UPDATE | event_end | フォーム入力値（日時結合） | YYYY-MM-DD HH:MM:SS形式 |
| UPDATE | event_description | フォーム入力値 | html_entity_decode処理 |
| UPDATE | event_user | 現在のユーザーID | 編集者 |
| UPDATE | event_url | フォーム入力値 | - |
| UPDATE | event_tickets | フォーム入力値 | - |
| UPDATE | event_comments | Y/N | チェック状態 |
| UPDATE | event_moderate | Y/N | チェック状態 |
| UPDATE（公開時） | event_published | NOW() | 公開時のみ |
| UPDATE（公開時） | event_status | 'published' | 公開時のみ |

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|--------------|----------|--------------|
| 成功 | 保存成功時 | Event Saved |
| 成功 | 公開成功時 | Event Published |
| エラー | Title空 | Title is required |
| エラー | Category空 | Category is required |
| エラー | Venue空 | Venue is required |
| エラー | Start Date空 | Start Date is required |
| エラー | Start Time空 | Start Time is required |
| エラー | Description空 | Description is required |
| エラー | ID未指定 | Event Not Specified! |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| eevents権限なし | privileges画面へ転送 |
| eeventedit権限なし | privileges画面へ転送 |
| 指定IDのイベント不存在 | manage画面へリダイレクト |
| データベース接続エラー | システムエラー画面を表示 |

## 備考

- タブコンテナ形式（Eventタブ）
- WYSIWYGエディタ（TinyMCE）を使用
- 日付・時刻はDojoのDateTextBox/TimeTextBoxウィジェットを使用
- 会場はFilteringSelectで入力補完対応
- 詳細情報はdetailsActionから非同期で読み込み
- 公開済みイベントは検索インデックスが自動更新される
- コメント設定のデフォルトはY（許可）、モデレートはN（無効）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | eventsテーブル（L103-119）の構造、event_status, event_publishedフィールドに注目 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | editAction（L625-658）、saveAction（L257-444）、publishAction（L449-620） |

**主要処理フロー（editAction）**:
1. **L627**: ACL権限チェック（eevents, eeventedit権限）
2. **L631**: GETパラメータからevent_id取得
3. **L637-641**: イベント情報をJOIN取得

**主要処理フロー（saveAction）**:
1. **L259**: ACL権限チェック
2. **L287-332**: バリデーションルール定義
3. **L347-359**: eventsテーブル更新
4. **L376-401**: 公開済みの場合、検索インデックス更新

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | edit.phtml | `application/modules/admin/views/scripts/events/edit.phtml` | 編集フォームのレイアウト、Dojoウィジェット、TinyMCE設定 |
| 3-2 | details.phtml | `application/modules/admin/views/scripts/events/details.phtml` | 詳細情報とアクションボタン |

### プログラム呼び出し階層図

```
/admin/events/edit/id/{event_id}/ (HTTP Request)
    │
    ├─ Admin_EventsController::editAction()
    │      ├─ ACL権限チェック
    │      └─ イベント情報取得（events + users JOIN）
    │
    └─ edit.phtml (View)
           │
           ├─ details.phtml (Ajax読み込み)
           │      ├─ イベント詳細情報表示
           │      └─ Save/Publish/Delete/Eventsボタン
           │
           ├─ ECategorySelect (View Helper)
           ├─ EVenueSelect (View Helper)
           └─ TinyMCE (JavaScript)

保存時:
/admin/events/save/id/{event_id}/ (POST)
    │
    └─ Admin_EventsController::saveAction()
           ├─ バリデーション実行
           ├─ eventsテーブル更新
           └─ 検索インデックス更新（公開済みの場合）

公開時:
/admin/events/publish/id/{event_id}/ (POST)
    │
    └─ Admin_EventsController::publishAction()
           ├─ バリデーション実行
           ├─ eventsテーブル更新（status=published）
           └─ 検索インデックス追加
```

### データフロー図

```
[入力]                    [処理]                         [出力]

event_id (GET) ───────▶ EventsController    ────────▶ edit.phtml
                        ::editAction()                 (HTML Form)
                              │
                              ▼
                    ┌─────────────────┐
                    │  MySQL DB       │
                    │  - events       │
                    │  - categories   │
                    │  - venues       │
                    │  - users        │
                    └─────────────────┘

フォーム送信 ────────▶ EventsController    ────────▶ Ajax Response
(POST)                 ::saveAction()               (成功/エラー)
                              │
                              ▼
                    ┌─────────────────┐
                    │  MySQL DB       │
                    │  UPDATE events  │
                    └─────────────────┘
                              │
                              ▼（公開済みの場合）
                    ┌─────────────────┐
                    │  Search Index   │
                    │  update         │
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | コントローラー | edit, save, publish, details, deleteアクション |
| edit.phtml | `application/modules/admin/views/scripts/events/edit.phtml` | ビュー | 編集フォームテンプレート |
| details.phtml | `application/modules/admin/views/scripts/events/details.phtml` | ビュー | 詳細情報・アクションボタン |
| database.sql | `database.sql` | SQL | テーブル定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | postDialog, getDialog, goTo等 |
