# 画面設計書 5-ログイン画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおけるログイン画面の設計仕様を定義する。ユーザー認証機能を提供し、認証後のセッション管理と「Remember me」機能を実装する。

### 本画面の処理概要

**業務上の目的・背景**：ログイン画面は、登録ユーザーがサイトの会員専用機能にアクセスするための認証ゲートウェイを提供する。コメント投稿、ユーザー設定変更、購読管理などの機能を利用するには認証が必要である。セキュアな認証処理とユーザビリティ向上のための「Remember me」機能を実装し、ユーザーエクスペリエンスとセキュリティのバランスを取る。

**画面へのアクセス方法**：ホーム画面のログインリンク、保護されたページへのアクセス時の自動リダイレクト、またはナビゲーションメニューからアクセス。URLは`/auth/login`。

**主要な操作・処理内容**：
1. ログインフォームの表示（メールアドレス、パスワード）
2. 「Remember me」チェックボックスによるログイン情報の保持
3. フォーム入力値のバリデーション
4. Zend_Auth_Adapter_DbTableによるデータベース認証
5. 認証成功時のセッション開始とリダイレクト
6. 認証失敗時のエラーメッセージ表示
7. アカウント有効化完了後のメッセージ表示

**画面遷移**：
- 遷移元：ホーム画面、ユーザー登録画面、パスワードリセット画面、アカウント有効化画面、保護ページ
- 遷移先：元のページ（referPage）、ホーム画面、パスワードリセット画面

**権限による表示制御**：
- 既にログイン済みの場合、ホーム画面へリダイレクト
- ログアウトアクション以外は未認証ユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | ログイン | 主機能 | ユーザー認証処理を実行 |
| 63 | 入力検証 | 補助機能 | ログインフォームのバリデーション |

## 画面種別

入力（認証フォーム型）

## URL/ルーティング

- URL: `/auth/login`
- コントローラー: `AuthController`
- アクション: `loginAction`
- モジュール: `default`
- HTTPメソッド: GET（表示）/ POST（認証）
- クエリパラメータ: `method`（'activated'でアカウント有効化完了メッセージ表示）

## 入出力項目

### 入力項目

| 項目名 | 入力/出力 | データ型 | 必須 | バリデーション | 説明 |
|--------|----------|---------|------|---------------|------|
| email | 入力 | string | はい | メールアドレス形式 | ログインメールアドレス |
| password | 入力 | string | はい | 4文字以上 | パスワード |
| remember | 入力 | checkbox | いいえ | - | ログイン情報記憶フラグ |

### 出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| messages | 出力 | array | - | バリデーション/認証エラーメッセージ |
| email | 出力 | string | - | エラー時の入力値保持 |
| method | 出力 | string | - | 遷移元情報（'activated'等） |
| referPage | 出力 | string | - | 認証後のリダイレクト先URL |

## 表示項目

### フォーム項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| E-mail address | テキストボックス | ログインメールアドレス（Cookie保存時はプリセット） |
| Password | パスワードボックス | パスワード（Cookie保存時はプリセット） |
| Remember me? | チェックボックス | ログイン情報をCookieに保存 |
| Login | ボタン | ログイン実行 |
| Forgotten your password? | リンク | パスワードリセット画面へ遷移 |

### サイドバー

| 項目名 | 説明 |
|--------|------|
| noaccountbox | 新規登録案内ボックス |

## イベント仕様

### 1-ログイン実行

「Login」ボタンをクリックすると、フォームがPOST送信され、認証処理が実行される。

- 送信先: `/auth/login/`
- 処理フロー:
  1. 入力値のバリデーション
  2. Zend_Auth_Adapter_DbTableで認証
  3. 認証成功時、セッション開始、Cookie設定（Remember me時）、リダイレクト
  4. 認証失敗時、エラーメッセージ表示

### 2-パスワードリセットリンク

「Forgotten your password?」リンクをクリックすると、パスワードリセット画面へ遷移する。

- 遷移先: `/auth/password`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 認証処理 | users | SELECT | ユーザー認証情報を取得 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_email, user_password, user_salt | user_email = {入力email} AND user_status = 'active' | 認証アダプタ経由 |

**認証クエリ条件**:
- `user_email`: 入力メールアドレスと一致
- `user_password`: MD5(site.key + 入力パスワード + user_salt)
- `user_status`: 'active'のみ

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 成功 | Account Activated - you can now login to your account | method='activated'時 |
| MSG-002 | エラー | E-mail address is required | メールアドレス未入力時 |
| MSG-003 | エラー | Invalid e-mail address | メールアドレス形式不正時 |
| MSG-004 | エラー | Password is required | パスワード未入力時 |
| MSG-005 | エラー | Password must be at least 4 characters long | パスワード4文字未満時 |
| MSG-006 | エラー | Unable to authenticate identity | 認証失敗時（メールアドレス不一致） |
| MSG-007 | エラー | Unable to authenticate identity | 認証失敗時（パスワード不一致） |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| バリデーションエラー | フォームにメールアドレスを保持し、エラーメッセージを表示 |
| 認証失敗（ユーザー未存在） | "Unable to authenticate identity"メッセージ表示 |
| 認証失敗（パスワード不一致） | "Unable to authenticate identity"メッセージ表示 |
| 認証失敗（アカウント非アクティブ） | 認証失敗として処理（明示的エラーなし） |

## 備考

- パスワードはMD5ハッシュ化（site.key + password + user_salt）
- 「Remember me」有効時、loginEmail/loginPassword Cookieを約3ヶ月（7889231秒）保持
- 認証成功後、元のページ（$_SESSION['curPage']）へリダイレクト
- 既認証ユーザーは本画面にアクセスできず、ホームへリダイレクト
- Dojo Toolkitのフォームウィジェット使用（ValidationTextBox, CheckBox）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、認証に使用されるユーザーデータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（347-361行目）のuser_email, user_password, user_salt, user_statusカラム |

**読解のコツ**: パスワードはMD5(site.key + password + salt)形式で保存。user_statusが'active'でないとログイン不可。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AuthController.php | `application/modules/default/controllers/AuthController.php` | loginAction()メソッド（54-158行目） |

**主要処理フロー**:
1. **57-61行目**: referPageを取得（ログイン後のリダイレクト先）
2. **67行目**: POSTリクエスト判定
3. **69-97行目**: フィルター、バリデーター定義
4. **99行目**: Zend_Filter_Inputでバリデーション
5. **104行目**: バリデーション成功時、認証開始
6. **105-111行目**: Zend_Auth_Adapter_DbTable設定（パスワードハッシュ式含む）
7. **114-115行目**: SELECT条件追加（user_status='active'）
8. **122行目**: 認証実行
9. **124-134行目**: 認証成功時、Cookie設定とリダイレクト
10. **136-148行目**: 認証失敗時、エラーコードに応じたメッセージ設定

#### Step 3: 前処理（preDispatch）を理解する

AuthController固有の前処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AuthController.php | `application/modules/default/controllers/AuthController.php` | preDispatch()メソッド（20-35行目） |

**主要処理フロー**:
- **22-27行目**: 認証済みユーザーがlogout以外にアクセスした場合、ホームへリダイレクト
- **28-33行目**: 未認証ユーザーがlogoutにアクセスした場合、loginへリダイレクト

#### Step 4: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | login.phtml | `application/modules/default/views/scripts/auth/login.phtml` | メインテンプレート。フォームとエラー表示 |

**主要処理フロー**:
- **30行目**: RenderMessages()でエラーメッセージ表示
- **32-34行目**: method='activated'時のメッセージ表示
- **40-67行目**: Cookie保存済み時のフォーム（値がプリセット、Remember meチェック済み）
- **72-104行目**: 通常時のフォーム

### プログラム呼び出し階層図

```
HTTP Request (/auth/login)
    |
    +-- AuthController::preDispatch()
    |       |
    |       +-- 認証状態チェック
    |       +-- [認証済み] ホームへリダイレクト
    |
    +-- AuthController::loginAction()
            |
            +-- $_SESSION['curPage']取得 - リダイレクト先決定
            +-- method パラメータ取得
            |
            +-- [POST時]
            |       |
            |       +-- Zend_Filter_Input - バリデーション
            |       |
            |       +-- [バリデーション成功]
            |       |       |
            |       |       +-- Zend_Auth_Adapter_DbTable設定
            |       |       |       |
            |       |       |       +-- users テーブル
            |       |       |       +-- user_email カラム
            |       |       |       +-- user_password カラム
            |       |       |       +-- MD5ハッシュ式
            |       |       |
            |       |       +-- SELECT WHERE user_status='active'追加
            |       |       +-- Zend_Auth::authenticate()
            |       |       |
            |       |       +-- [成功] セッション保存、Cookie設定、リダイレクト
            |       |       +-- [失敗] エラーメッセージ設定
            |       |
            |       +-- [バリデーション失敗] エラーメッセージ設定
            |
            +-- ビューレンダリング
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム送信    ───▶ AuthController       ───▶ login.phtml
(POST)               ::loginAction()           |
  |                        |                   +──▶ 成功: リダイレクト
  +-- email           バリデーション            |    (referPage)
  +-- password             |                   +──▶ 失敗: エラー表示
  +-- remember        Zend_Auth認証                 + フォーム再表示
                           |
                           ▼
                        users
                      テーブル
                           |
                           ▼
                      セッション保存
                      Cookie設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/default/controllers/AuthController.php` | ソース | 認証関連のコントローラー |
| login.phtml | `application/modules/default/views/scripts/auth/login.phtml` | テンプレート | ログイン画面のメインビュー |
| noaccountbox.phtml | `application/modules/default/views/scripts/_partials/noaccountbox.phtml` | テンプレート | 新規登録案内ボックス |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | テンプレート | 情報メッセージ表示 |
| database.sql | `database.sql` | スキーマ | usersテーブル定義 |
| site.ini | `application/configs/site.ini` | 設定 | site.key（パスワードハッシュ用）、cookie設定 |
