# 画面設計書 50-イベント新規作成画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるイベント新規作成画面の設計仕様を定義する。本画面は2段階のAjaxダイアログとして表示され、新規イベントを作成する機能を提供する。

### 本画面の処理概要

本画面は、システムに新しいイベントを追加するための2段階フォームをAjaxダイアログとして提供する。Step1でカテゴリと会場を選択し、Step2でイベント詳細（タイトル、日時）を入力する。作成完了後はイベント編集画面に遷移して詳細設定を行う。

**業務上の目的・背景**：管理者が新規イベントを迅速に登録するために必要な画面である。2段階のワークフローにより、カテゴリに応じたデフォルト会場やデフォルト説明文が自動設定されるため、入力の効率化が図られている。

**画面へのアクセス方法**：イベント管理画面（manage）の「New Event」ボタンをクリックすることで、Ajaxダイアログとして表示される。Step1のURLは `/admin/events/new/`、Step2のURLは `/admin/events/new2/` である。

**主要な操作・処理内容**：
Step1:
1. 会場の選択（任意、未選択の場合はカテゴリのデフォルト会場を使用）
2. カテゴリの選択（必須）
3. Step2への進行（Continue）
4. ダイアログのキャンセル

Step2:
1. イベントタイトルの入力（必須）
2. 開始日の入力（必須）
3. 開始時刻の入力（必須）
4. イベント作成の実行
5. ダイアログのキャンセル
6. 作成完了後、イベント編集画面へ遷移（Continue）

**画面遷移**：
- 遷移元：イベント管理画面(manage)のダイアログ呼び出し
- 遷移先：イベント編集画面(edit)（Continue後）、またはダイアログを閉じてイベント管理画面に戻る

**権限による表示制御**：
- `eevents`権限：ダイアログ表示可否を制御
- `eeventnew`権限：新規イベント作成機能の実行可否を制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 25 | イベント新規作成 | 主機能 | 新規イベントの作成処理 |
| 63 | 入力検証 | 補助機能 | イベントフォームのバリデーション |

## 画面種別

登録（Ajaxダイアログ・2段階）

## URL/ルーティング

### Step1

| 項目 | 値 |
|------|------|
| URL | `/admin/events/new/` |
| HTTPメソッド | GET（表示）、POST（Step2へ） |
| モジュール | admin |
| コントローラー | events |
| アクション | new |

### Step2

| 項目 | 値 |
|------|------|
| URL | `/admin/events/new2/` |
| HTTPメソッド | GET（表示）、POST（登録） |
| モジュール | admin |
| コントローラー | events |
| アクション | new2 |

## 入出力項目

### Step1 POSTパラメータ

| パラメータ名 | 型 | 必須 | バリデーション | 説明 |
|-------------|-----|------|--------------|------|
| eventvenue | int | 必須 | NotEmpty | 会場ID（0=カテゴリデフォルト） |
| eventcategory | int | 必須 | NotEmpty | カテゴリID |

### Step2 GETパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| category | int | 必須 | カテゴリID（Step1から引継ぎ） |
| venue | int | 必須 | 会場ID（Step1から引継ぎ） |

### Step2 POSTパラメータ

| パラメータ名 | 型 | 必須 | バリデーション | 説明 |
|-------------|-----|------|--------------|------|
| eventtitle | string | 必須 | NotEmpty | イベントタイトル |
| eventvenue | int | 必須 | NotEmpty | 会場ID |
| eventcategory | int | 必須 | NotEmpty | カテゴリID |
| eventdatestart | string | 必須 | NotEmpty | 開始日（YYYY-MM-DD） |
| eventtimestart | string | 必須 | NotEmpty | 開始時刻（HH:MM） |

## 表示項目

### Step1フォームフィールド

| 項目名 | 入力形式 | バリデーション | 備考 |
|--------|----------|--------------|------|
| Venue | FilteringSelect | 必須（0可） | 幅280px、0=Default Venue |
| Category | FilteringSelect（必須） | 必須 | 幅280px |

### Step2フォームフィールド

| 項目名 | 入力形式 | バリデーション | 備考 |
|--------|----------|--------------|------|
| Name | テキスト（必須） | 必須 | 幅280px |
| Date Start | 日付ピッカー（必須） | 必須 | - |
| Time Start | 時刻ピッカー（必須） | 必須 | - |

## イベント仕様

### Step1: Continue

**トリガー**: Continueボタン押下

**処理フロー**:
1. doDialog関数を呼び出し
2. newFormの内容を`/admin/events/new/`へPOST
3. バリデーション実行
4. 成功時：Step2へリダイレクト（venue, categoryパラメータ付き）
5. エラー時：フォームを再表示（入力値保持）

### Step1: Cancel

**トリガー**: Cancelボタン押下

**処理フロー**:
1. dijit.byId('ajaxDialog').hide()を呼び出し
2. ダイアログを閉じる

### Step2: Create

**トリガー**: Createボタン押下

**処理フロー**:
1. doDialog関数を呼び出し
2. new2Formの内容を`/admin/events/new2/`へPOST
3. バリデーション実行
4. 成功時：
   - 会場決定（venue=0の場合はカテゴリのデフォルト会場を使用）
   - 開始日時をフォーマット
   - 終了日時を自動設定（開始の2時間後）
   - カテゴリのデフォルト説明文を取得
   - eventsテーブルにレコード挿入
   - 成功メッセージとContinueボタンを表示
5. エラー時：フォームを再表示（入力値保持）

### Step2: Cancel

**トリガー**: Cancelボタン押下

**処理フロー**:
1. dijit.byId('ajaxDialog').hide()を呼び出し
2. ダイアログを閉じる

### Step2: Continue（作成成功後）

**トリガー**: Continueボタン押下（作成成功後）

**処理フロー**:
1. goTo関数を呼び出し
2. `/admin/events/edit/id/{new_event_id}/`へ画面遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Step2表示 | events_categories | SELECT | カテゴリ情報取得（デフォルト設定用） |
| 作成実行 | events | INSERT | 新規イベントレコード挿入 |

### テーブル別更新項目詳細

#### eventsテーブル

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | event_title | フォーム入力値 | - |
| INSERT | event_category | フォーム入力値 | - |
| INSERT | event_venue | フォーム入力値またはカテゴリデフォルト | venue=0の場合はecat_venueを使用 |
| INSERT | event_description | カテゴリデフォルト説明文 | ecat_default |
| INSERT | event_date | フォーム入力値（日時結合） | YYYY-MM-DD HH:MM:SS形式 |
| INSERT | event_end | 開始+2時間 | 自動計算 |
| INSERT | event_user | 現在のユーザーID | 作成者 |
| INSERT | event_status | 'draft' | 固定値（デフォルト） |

## メッセージ仕様

| メッセージ種別 | 表示条件 | メッセージ内容 |
|--------------|----------|--------------|
| 成功 | 作成成功時 | Event Created |
| エラー(Step1) | Venue空 | Venue is required |
| エラー(Step1) | Category空 | Category is required |
| エラー(Step2) | Name空 | Name is required |
| エラー(Step2) | Venue空 | Venue is required |
| エラー(Step2) | Category空 | Category is required |
| エラー(Step2) | Start Date空 | Start Date is required |
| エラー(Step2) | Start Time空 | Start Time is required |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| eevents権限なし | privileges画面へ転送 |
| eeventnew権限なし | privileges画面へ転送 |
| データベース接続エラー | システムエラー画面を表示 |

## 備考

- 2段階のAjaxダイアログとして表示される
- Step1でカテゴリを選択すると、そのカテゴリのデフォルト会場とデフォルト説明文が適用される
- 会場に「Default Venue」（venue=0）を選択すると、カテゴリのデフォルト会場（ecat_venue）が使用される
- 終了日時は開始日時の2時間後に自動設定される
- 作成されるイベントはdraft状態（未公開）
- 作成完了後はContinueボタンでイベント編集画面に遷移し、詳細設定を行う
- FilteringSelectで会場・カテゴリの入力補完に対応

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | eventsテーブル（L103-119）、events_categoriesテーブル（L125-134）のecat_venue, ecat_defaultフィールドに注目 |

**読解のコツ**: events_categoriesのecat_venueがデフォルト会場、ecat_defaultがデフォルト説明文として使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | newAction（L696-757）とnew2Action（L762-877）がメイン処理 |

**主要処理フロー（newAction）**:
1. **L698**: ACL権限チェック（eevents, eeventnew権限）
2. **L699**: layoutの無効化（Ajax部品として機能）
3. **L707-718**: バリデーションルール定義（venue, category）
4. **L724-731**: 成功時、Step2へリダイレクト

**主要処理フロー（new2Action）**:
1. **L764**: ACL権限チェック
2. **L767-769**: GETパラメータ取得（category, venue）
3. **L777-803**: バリデーションルール定義
4. **L812-815**: カテゴリ情報取得
5. **L822-824**: 終了日時の自動計算（開始+2時間）
6. **L826-830**: 会場決定（venue=0の場合はカテゴリデフォルト）
7. **L833-841**: eventsテーブルINSERT

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.phtml | `application/modules/admin/views/scripts/events/new.phtml` | Step1フォームのレイアウト |
| 3-2 | new2.phtml | `application/modules/admin/views/scripts/events/new2.phtml` | Step2フォームのレイアウト |

### プログラム呼び出し階層図

```
イベント管理画面からNew Eventボタン押下
    │
    ├─ getDialog('/admin/events/new/', 'New Event')
    │
    └─ Admin_EventsController::newAction() [Step1]
           │
           ├─ GET時: posted='N'でフォーム表示
           │
           └─ POST時:
                  ├─ バリデーション実行
                  └─ 成功: redirector -> new2Action
                            │
                            └─ Admin_EventsController::new2Action() [Step2]
                                   │
                                   ├─ GET時: posted='N'でフォーム表示
                                   │
                                   └─ POST時:
                                          ├─ バリデーション実行
                                          ├─ カテゴリ情報取得
                                          ├─ 会場決定
                                          ├─ 日時計算
                                          ├─ events INSERT
                                          │     ├─ event_title
                                          │     ├─ event_category
                                          │     ├─ event_venue
                                          │     ├─ event_description = ecat_default
                                          │     ├─ event_date
                                          │     ├─ event_end = date + 2h
                                          │     └─ event_user
                                          │
                                          └─ 成功メッセージ + Continueボタン
                                                 │
                                                 └─ goTo('/admin/events/edit/id/{new_id}/')
```

### データフロー図

```
[Step1 入力]              [処理]                      [Step2 入力]

venue, category ─────▶ newAction       ─────▶ redirector
(POST)                  バリデーション           (GET + params)
                              │
                              ▼
                    ┌─────────────────┐
                    │ new2Action      │◀───── title, datestart,
                    │ カテゴリ情報取得 │         timestart
                    │ 会場決定        │         (POST)
                    │ 終了日時計算    │
                    └─────────────────┘
                              │
                              ▼
                    ┌─────────────────┐
                    │ events INSERT   │
                    │ - title         │
                    │ - category      │
                    │ - venue         │
                    │ - description   │
                    │ - date/end      │
                    │ - user          │
                    └─────────────────┘
                              │
                              ▼
                    成功メッセージ
                    + Continueボタン
                              │
                              ▼
                    イベント編集画面へ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | コントローラー | new, new2アクションの実装 |
| new.phtml | `application/modules/admin/views/scripts/events/new.phtml` | ビュー | Step1フォーム |
| new2.phtml | `application/modules/admin/views/scripts/events/new2.phtml` | ビュー | Step2フォーム |
| database.sql | `database.sql` | SQL | テーブル定義 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog, goTo関数 |
