# 画面設計書 51-イベント詳細画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるイベント詳細画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：管理者がイベント情報の詳細を確認し、編集・削除・公開などの操作を行うための画面である。イベント管理業務において、登録済みイベントの内容確認や状態管理は必須の機能であり、本画面はそのための中核的なインターフェースを提供する。

**画面へのアクセス方法**：管理画面のイベント管理画面（イベント一覧）からイベント編集画面に遷移すると、詳細情報はAjaxで非同期に読み込まれる。具体的にはイベント編集画面（/admin/events/edit/id/{event_id}）内のContentPaneとして表示される。

**主要な操作・処理内容**：
1. イベントのステータス（draft/published）と著者名を確認する
2. 「Publish」ボタンでイベントを公開状態に変更する（未公開時のみ表示）
3. 「Save」または「Save Draft」ボタンでイベント内容を保存する
4. 「Delete」ボタンでイベントを削除する（権限が必要）
5. 「Events...」ボタンでイベント管理画面に戻る

**画面遷移**：
- 遷移元: イベント管理画面（/admin/events/manage）からイベント編集画面へ遷移し、その中で本詳細情報が読み込まれる
- 遷移先: イベント管理画面（/admin/events/）への遷移が可能

**権限による表示制御**：
- 「Publish」ボタン: イベントが未公開状態かつeeventpublish権限を持つ場合のみ表示
- 「Delete」ボタン: eeventdelete権限を持つ場合のみ表示
- 画面自体へのアクセス: eeventsおよびeeventedit権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 主機能 | イベントの詳細情報を表示 |
| 44 | コメント一覧表示 | 補助機能 | イベントのコメントを表示 |
| 49 | タグ一覧表示 | 補助機能 | イベントのタグを表示 |

## 画面種別

詳細（イベント編集画面の部分ビュー）

## URL/ルーティング

- URL: `/admin/events/details`
- パラメータ: `id` - イベントID
- アクション: `Admin_EventsController::detailsAction()`
- 読み込み方式: Ajaxによる非同期読み込み（ContentPane）

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 |
|--------|-------------|---------|------|------|
| イベントID | id | integer | 必須 | 詳細を表示するイベントのID |

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 著者名 | string | イベントを作成したユーザーのエイリアス名 |
| ステータス | string | イベントの公開状態（draft/published） |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| Author | イベント作成者のエイリアス名 | user_alias |
| Status | イベントのステータス（Draft/Published） | event_statusを先頭大文字化 |

## イベント仕様

### 1-Publishボタン押下

イベントを公開状態に変更する処理を開始する。

- 表示条件: イベントが未公開状態（event_status != 'published'）かつ、ユーザーがeeventpublish権限を持つ場合
- 動作: Ajaxダイアログを表示し、公開確認と公開処理を実行
- 遷移先: `/admin/events/publish/id/{event_id}/`
- 処理: 編集フォームの内容を含めて公開処理を実行

### 2-Saveボタン押下

イベントの編集内容を保存する。

- 表示テキスト: 未公開時は「Save Draft」、公開時は「Save」
- 動作: 編集フォームの内容をAjax POSTで送信し、保存処理を実行
- 遷移先: `/admin/events/save/id/{event_id}/`
- 処理: FCKeditorの値を更新後、フォームデータを送信

### 3-Deleteボタン押下

イベントを削除する処理を開始する。

- 表示条件: ユーザーがeeventdelete権限を持つ場合
- 動作: Ajaxダイアログで削除確認を表示
- 遷移先: `/admin/events/delete/id/{event_id}/`
- 処理: 確認後、イベントと関連コメント、検索インデックスを削除

### 4-Events...ボタン押下

イベント管理画面に戻る。

- 動作: `/admin/events/`に画面遷移
- 処理: イベント一覧画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | events | SELECT | イベント情報を取得 |
| 詳細表示 | users | SELECT | 著者情報を取得 |

### テーブル別更新項目詳細

#### eventsテーブル（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id | WHERE条件 | パラメータidで指定 |
| SELECT | event_status | 表示用 | ステータス表示に使用 |

#### usersテーブル（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_alias | 表示用 | 著者名として表示 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 情報 | Event Saved | 保存処理成功時 |
| 情報 | Event Published | 公開処理成功時 |
| 情報 | Event Deleted | 削除処理成功時 |
| 確認 | Are you sure you want to delete this event? | 削除ボタン押下時 |
| 確認 | Are you sure you want to publish this event? | 公開ボタン押下時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| イベントが存在しない | 上位の編集画面でイベント管理画面にリダイレクト |
| 権限不足 | 権限エラー画面（privileges）にフォワード |
| バリデーションエラー | エラーメッセージを表示し、ダイアログ内で通知 |

## 備考

- 本画面はイベント編集画面（/admin/events/edit/id/{id}）の一部として、ContentPaneによりAjaxで非同期読み込みされる
- Dojo Toolkitのdijit.form.Buttonウィジェットを使用してボタンを表示
- FCKeditorとの連携があり、保存時にはMyFCKObject.UpdateEditorFormValue()でエディタの値を同期

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベントデータと著者情報の構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | details.phtml | `application/modules/admin/views/scripts/events/details.phtml` | 表示に使用されるeventArray配列の構造を確認 |

**読解のコツ**: eventArrayは連想配列で、eventsテーブルとusersテーブルをJOINした結果が格納される。event_status、user_aliasなどのキーでアクセスする。

#### Step 2: エントリーポイントを理解する

コントローラのdetailsActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | detailsAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **663-665行目**: 権限チェック（eeventsとeeventedit）
2. **667行目**: レイアウトを無効化（Ajaxレスポンスのため）
3. **669行目**: イベントIDパラメータを取得
4. **671-682行目**: イベント情報をDBから取得
5. **684行目**: ビューにイベント情報を渡す

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | details.phtml | `application/modules/admin/views/scripts/events/details.phtml` | 表示ロジックと権限による表示制御を確認 |

**主要処理フロー**:
- **15行目**: 著者名の表示（$this->eventArray['user_alias']）
- **16行目**: ステータスの表示（ucwordsで先頭大文字化）
- **26-28行目**: Publishボタンの条件付き表示
- **29行目**: Save/Save Draftボタン
- **30行目**: Deleteボタンの条件付き表示
- **31行目**: Events...ボタン

### プログラム呼び出し階層図

```
Ajaxリクエスト (/admin/events/details?id={id})
    │
    └─ Admin_EventsController::detailsAction()
           │
           ├─ ACL権限チェック (eevents, eeventedit)
           │
           ├─ Zend_Db_Select (events + users JOIN)
           │      └─ DB検索処理
           │
           └─ ビューレンダリング
                  └─ details.phtml
```

### データフロー図

```
[入力]                [処理]                       [出力]

リクエスト          EventsController            HTMLレスポンス
(id=イベントID) ──▶ detailsAction() ──▶         (詳細パネル)
                        │
                        ▼
                   eventsテーブル
                   usersテーブル
                   (JOIN検索)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | ソース | イベント関連アクションのコントローラ |
| details.phtml | `application/modules/admin/views/scripts/events/details.phtml` | テンプレート | イベント詳細表示のビュー |
| edit.phtml | `application/modules/admin/views/scripts/events/edit.phtml` | テンプレート | イベント編集画面（本詳細を読み込む親画面） |
| CMS_Controller_Action_Admin | `library/CMS/Controller/Action/Admin.php` | ソース | 管理画面コントローラの基底クラス |
| common.js | `_scripts/admin/common.js` | JavaScript | 共通JavaScript関数（getDialog, postDialog等） |
