# 画面設計書 52-イベントカテゴリ管理画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるイベントカテゴリ管理画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：イベントを分類・整理するためのカテゴリを管理する画面である。イベントを効率的に管理するためには、適切なカテゴリ分類が不可欠であり、本画面ではカテゴリの一覧表示、編集、削除操作を提供する。

**画面へのアクセス方法**：管理画面のイベント管理画面（/admin/events/manage）から、カテゴリ一覧エリアとして表示される。本画面はAjaxによる部分ビューとして、イベント管理画面内のContentPaneに読み込まれる。

**主要な操作・処理内容**：
1. 登録済みイベントカテゴリを一覧表示する
2. 各カテゴリ名をクリックして、そのカテゴリに属するイベント一覧を表示
3. 右クリックコンテキストメニューからカテゴリの編集・削除を実行
4. カテゴリごとの登録イベント数を表示

**画面遷移**：
- 遷移元: イベント管理画面（/admin/events/manage）内に部分ビューとして表示
- 遷移先:
  - カテゴリ名クリック: カテゴリ別イベント一覧（/admin/events/manage?category={id}）
  - 編集メニュー: イベントカテゴリ編集画面（/admin/events/category/id/{id}）
  - 削除メニュー: 削除確認ダイアログ

**権限による表示制御**：
- 「Delete」メニュー: カテゴリIDが1以外かつecategorydelete権限を持つ場合のみ表示（デフォルトカテゴリは削除不可）
- 「Edit」メニュー: ecategoryedit権限を持つ場合のみ表示
- 画面自体へのアクセス: eevents権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | イベントカテゴリ管理 | 主機能 | イベントカテゴリ一覧を表示 |
| 61 | アクセス制御 | 補助機能 | 管理者権限チェック |

## 画面種別

一覧（イベント管理画面の部分ビュー）

## URL/ルーティング

- URL: `/admin/events/categories`
- アクション: `Admin_EventsController::categoriesAction()`
- 読み込み方式: Ajaxによる非同期読み込み（ContentPane）

## 入出力項目

### 入力パラメータ

なし（単純な一覧取得）

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| カテゴリID | integer | イベントカテゴリの識別ID |
| カテゴリ名 | string | カテゴリのタイトル |
| ステータス | string | カテゴリの公開状態（draft/published） |
| イベント数 | integer | カテゴリに属するイベントの件数 |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| カテゴリ名 | ecat_title | HTMLエスケープ処理済み |
| イベント数 | count | ECatCountビューヘルパーで計算 |
| ステータス | ecat_status | 公開時はリンク表示、非公開時はテキストのみ |

## イベント仕様

### 1-カテゴリ名クリック（公開カテゴリの場合）

カテゴリに属するイベント一覧を表示する。

- 表示条件: カテゴリが公開状態（ecat_status == 'published'）の場合
- 動作: カテゴリIDをパラメータとしてイベント一覧画面に遷移
- 遷移先: `/admin/events/manage?category={ecat_id}`

### 2-コンテキストメニュー「Delete」

カテゴリを削除する処理を開始する。

- 表示条件: カテゴリIDが1以外かつecategorydelete権限を持つ場合
- 動作: Ajaxダイアログで削除確認を表示
- 遷移先: `/admin/events/categorydelete/id/{ecat_id}/`
- 処理: 確認後、カテゴリを削除し、所属イベントをデフォルトカテゴリに移動

### 3-コンテキストメニュー「Edit」

カテゴリ編集画面に遷移する。

- 表示条件: ecategoryedit権限を持つ場合
- 動作: カテゴリ編集画面に画面遷移
- 遷移先: `/admin/events/category/id/{ecat_id}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| カテゴリ一覧表示 | events_categories | SELECT | 全カテゴリ情報を取得 |
| イベント数表示 | events | SELECT (COUNT) | カテゴリ別イベント数を集計 |

### テーブル別更新項目詳細

#### events_categoriesテーブル（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_id | 全件 | カテゴリID |
| SELECT | ecat_title | 全件 | カテゴリ名 |
| SELECT | ecat_status | 全件 | 公開状態 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 情報 | No Categories! | カテゴリが1件も存在しない場合 |
| 確認 | Are you sure you want to delete this category? | 削除メニュー選択時 |
| 成功 | Category Deleted | 削除処理成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| カテゴリが存在しない | 「No Categories!」メッセージを表示 |
| 権限不足 | 権限エラー画面（privileges）にフォワード |
| デフォルトカテゴリ削除試行 | 削除メニューが表示されないため操作不可 |

## 備考

- 本画面はイベント管理画面（/admin/events/manage）のFieldset内に表示される部分ビュー
- Dojo Toolkitのdijit.Menuを使用した右クリックコンテキストメニューを実装
- カテゴリIDが1のものはシステムデフォルトカテゴリとして削除不可
- カテゴリ削除時、所属イベントは自動的にデフォルトカテゴリ（ID=1）に移動される
- カテゴリ名の横に括弧付きでイベント数を表示（例：「スポーツ (5)」）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カテゴリデータの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | categories.phtml | `application/modules/admin/views/scripts/events/categories.phtml` | categoryArrayの構造（ecat_id, ecat_title, ecat_status）を確認 |

**読解のコツ**: categoryArrayは連想配列の配列で、events_categoriesテーブルの全レコードが格納される。foreachでループしながら各カテゴリを表示する。

#### Step 2: エントリーポイントを理解する

コントローラのcategoriesActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | categoriesAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **884行目**: 権限チェック（eevents）
2. **886行目**: レイアウトを無効化（Ajaxレスポンスのため）
3. **889行目**: レジストリからDB接続取得
4. **892-894行目**: events_categoriesテーブルから全件取得（タイトル順）
5. **897行目**: ビューにカテゴリ配列を渡す

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | categories.phtml | `application/modules/admin/views/scripts/events/categories.phtml` | 表示ロジックとコンテキストメニューの実装を確認 |

**主要処理フロー**:
- **9-28行目**: カテゴリが存在する場合のループ処理
- **11-18行目**: 公開カテゴリの表示（リンク付き）
- **19-27行目**: 非公開カテゴリの表示（リンクなし）
- **13-18行目**: コンテキストメニューの定義（Delete, Edit）
- **29-30行目**: カテゴリが存在しない場合の表示

### プログラム呼び出し階層図

```
Ajaxリクエスト (/admin/events/categories)
    │
    └─ Admin_EventsController::categoriesAction()
           │
           ├─ ACL権限チェック (eevents)
           │
           ├─ Zend_Db_Select (events_categories)
           │      └─ ORDER BY ecat_title ASC
           │
           └─ ビューレンダリング
                  └─ categories.phtml
                         │
                         └─ ECatCountビューヘルパー
                                └─ イベント数をカウント
```

### データフロー図

```
[入力]                [処理]                       [出力]

Ajaxリクエスト      EventsController            HTMLレスポンス
    ──────────▶    categoriesAction() ──▶      (カテゴリ一覧)
                        │
                        ▼
                events_categories
                   テーブル
                (全件取得・タイトル順)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | ソース | イベント関連アクションのコントローラ |
| categories.phtml | `application/modules/admin/views/scripts/events/categories.phtml` | テンプレート | カテゴリ一覧表示のビュー |
| manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | テンプレート | イベント管理画面（本画面を読み込む親画面） |
| ECatCount.php | `application/views/helpers/ECatCount.php` | ソース | カテゴリ別イベント数カウントのビューヘルパー |
