# 画面設計書 53-イベントカテゴリ詳細画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるイベントカテゴリ詳細画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：イベントカテゴリの詳細情報（ステータス）を表示し、保存・削除・公開などの操作ボタンを提供する画面である。カテゴリ編集画面内の部分ビューとして表示され、カテゴリの状態確認と主要操作へのアクセスポイントとなる。

**画面へのアクセス方法**：イベントカテゴリ編集画面（/admin/events/category/id/{id}）に遷移すると、本詳細画面がContentPaneとしてAjaxで非同期に読み込まれる。直接URLアクセスも可能だが、通常はカテゴリ編集画面の一部として表示される。

**主要な操作・処理内容**：
1. カテゴリのステータス（draft/published）を確認する
2. 「Save」ボタンでカテゴリ情報を保存する
3. 「Delete」ボタンでカテゴリを削除する（権限が必要、デフォルトカテゴリは削除不可）
4. 「Publish」ボタンでカテゴリを公開状態に変更する（未公開時のみ表示）
5. 「Events...」ボタンでイベント管理画面に戻る

**画面遷移**：
- 遷移元: イベントカテゴリ編集画面（/admin/events/category/id/{id}）内にAjax読み込み
- 遷移先: イベント管理画面（/admin/events/）への遷移が可能

**権限による表示制御**：
- 「Delete」ボタン: カテゴリIDが1以外かつecategorydelete権限を持つ場合のみ表示
- 「Publish」ボタン: カテゴリが未公開状態かつecategorypublish権限を持つ場合のみ表示
- 画面自体へのアクセス: eeventsおよびecategoryedit権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | イベントカテゴリ管理 | 主機能 | カテゴリの詳細情報を表示 |

## 画面種別

詳細（イベントカテゴリ編集画面の部分ビュー）

## URL/ルーティング

- URL: `/admin/events/categorydetails`
- パラメータ: `id` - カテゴリID
- アクション: `Admin_EventsController::categorydetailsAction()`
- 読み込み方式: Ajaxによる非同期読み込み（ContentPane）

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 |
|--------|-------------|---------|------|------|
| カテゴリID | id | integer | 必須 | 詳細を表示するカテゴリのID |

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ステータス | string | カテゴリの公開状態（draft/published） |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| Status | カテゴリのステータス（Draft/Published） | ecat_statusを先頭大文字化 |

## イベント仕様

### 1-Saveボタン押下

カテゴリの編集内容を保存する。

- 動作: 編集フォームの内容をAjax POSTで送信し、保存処理を実行
- 遷移先: `/admin/events/categorysave/id/{ecat_id}/`
- 処理: FCKeditorの値を更新後、フォームデータを送信

### 2-Deleteボタン押下

カテゴリを削除する処理を開始する。

- 表示条件: カテゴリIDが1以外かつecategorydelete権限を持つ場合
- 動作: Ajaxダイアログで削除確認を表示
- 遷移先: `/admin/events/categorydelete/id/{ecat_id}/`
- 処理: 確認後、カテゴリを削除し、所属イベントをデフォルトカテゴリに移動

### 3-Publishボタン押下

カテゴリを公開状態に変更する処理を開始する。

- 表示条件: カテゴリが未公開状態（ecat_status != 'published'）かつecategorypublish権限を持つ場合
- 動作: Ajaxダイアログを表示し、公開確認と公開処理を実行
- 遷移先: `/admin/events/categorypublish/id/{ecat_id}/`
- 処理: 編集フォームの内容を含めて公開処理を実行

### 4-Events...ボタン押下

イベント管理画面に戻る。

- 動作: `/admin/events/`に画面遷移
- 処理: イベント一覧画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | events_categories | SELECT | カテゴリ情報を取得 |

### テーブル別更新項目詳細

#### events_categoriesテーブル（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_id | WHERE条件 | パラメータidで指定 |
| SELECT | ecat_status | 表示用 | ステータス表示に使用 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 情報 | Category Saved | 保存処理成功時 |
| 情報 | Category Published | 公開処理成功時 |
| 情報 | Category Deleted | 削除処理成功時 |
| 確認 | Are you sure you want to delete this category? | 削除ボタン押下時 |
| 確認 | Are you sure you want to publish this category? | 公開ボタン押下時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| カテゴリが存在しない | 上位のカテゴリ編集画面でイベント管理画面にリダイレクト |
| 権限不足 | 権限エラー画面（privileges）にフォワード |
| バリデーションエラー | エラーメッセージを表示し、ダイアログ内で通知 |
| カテゴリ未指定 | 「Category Not Specified!」エラーメッセージを表示 |

## 備考

- 本画面はイベントカテゴリ編集画面（/admin/events/category/id/{id}）の一部として、ContentPaneによりAjaxで非同期読み込みされる
- Dojo Toolkitのdijit.form.Buttonウィジェットを使用してボタンを表示
- FCKeditorとの連携があり、保存・公開時にはMyFCKObject.UpdateEditorFormValue()でエディタの値を同期
- カテゴリIDが1のものはシステムデフォルトカテゴリとして削除不可

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カテゴリデータの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | categorydetails.phtml | `application/modules/admin/views/scripts/events/categorydetails.phtml` | categoryArrayの構造（ecat_id, ecat_status）を確認 |

**読解のコツ**: categoryArrayは連想配列で、events_categoriesテーブルの1レコードが格納される。ecat_id、ecat_statusなどのキーでアクセスする。

#### Step 2: エントリーポイントを理解する

コントローラのcategorydetailsActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | categorydetailsAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **949行目**: 権限チェック（eeventsとecategoryedit）
2. **951行目**: レイアウトを無効化（Ajaxレスポンスのため）
3. **953行目**: カテゴリIDパラメータを取得
4. **956-962行目**: カテゴリ情報をDBから取得
5. **967行目**: ビューにカテゴリ情報を渡す

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | categorydetails.phtml | `application/modules/admin/views/scripts/events/categorydetails.phtml` | 表示ロジックと権限による表示制御を確認 |

**主要処理フロー**:
- **15行目**: ステータスの表示（ucwordsで先頭大文字化）
- **25行目**: Saveボタン
- **26-28行目**: Deleteボタンの条件付き表示
- **29-31行目**: Publishボタンの条件付き表示
- **32行目**: Events...ボタン

### プログラム呼び出し階層図

```
Ajaxリクエスト (/admin/events/categorydetails?id={id})
    │
    └─ Admin_EventsController::categorydetailsAction()
           │
           ├─ ACL権限チェック (eevents, ecategoryedit)
           │
           ├─ Zend_Db_Select (events_categories)
           │      └─ DB検索処理
           │
           └─ ビューレンダリング
                  └─ categorydetails.phtml
```

### データフロー図

```
[入力]                [処理]                          [出力]

リクエスト          EventsController               HTMLレスポンス
(id=カテゴリID) ──▶ categorydetailsAction() ──▶   (詳細パネル)
                        │
                        ▼
               events_categories
                   テーブル
                (ID指定で1件取得)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | ソース | イベント関連アクションのコントローラ |
| categorydetails.phtml | `application/modules/admin/views/scripts/events/categorydetails.phtml` | テンプレート | カテゴリ詳細表示のビュー |
| category.phtml | `application/modules/admin/views/scripts/events/category.phtml` | テンプレート | カテゴリ編集画面（本詳細を読み込む親画面） |
| common.js | `_scripts/admin/common.js` | JavaScript | 共通JavaScript関数（getDialog, postDialog, goTo等） |
