# 画面設計書 54-イベントカテゴリ新規作成画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるイベントカテゴリ新規作成画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：新しいイベントカテゴリを作成するためのダイアログ画面である。イベントを効率的に分類・管理するためには、適切なカテゴリの追加が必要であり、本画面はその入口となる。

**画面へのアクセス方法**：イベント管理画面（/admin/events/manage）の「New Category」ボタンをクリックすると、Ajaxダイアログとして本画面が表示される。

**主要な操作・処理内容**：
1. カテゴリタイトルを入力する
2. 「Create」ボタンで新規カテゴリを作成
3. 「Cancel」ボタンでダイアログを閉じる
4. 作成成功後、カテゴリ編集画面への「Continue」ボタンが表示される

**画面遷移**：
- 遷移元: イベント管理画面（/admin/events/manage）のNew Categoryボタン
- 遷移先: 作成成功後、イベントカテゴリ編集画面（/admin/events/category/id/{新規ID}）へ遷移可能

**権限による表示制御**：
- 画面自体へのアクセス: eeventsおよびecategorynew権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | イベントカテゴリ管理 | 主機能 | 新規カテゴリの作成処理 |
| 63 | 入力検証 | 補助機能 | カテゴリフォームのバリデーション |

## 画面種別

登録（Ajaxダイアログ）

## URL/ルーティング

- URL: `/admin/events/categorynew`
- アクション: `Admin_EventsController::categorynewAction()`
- 表示方式: Ajaxダイアログ（dijit.Dialog）

## 入出力項目

### 入力項目

| 項目名 | パラメータ名 | データ型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|-------------|---------|------|--------|---------------|------|
| カテゴリタイトル | categorytitle | string | 必須 | - | NotEmpty, Alnum, Db_NoRecordExists | カテゴリの名前 |

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 作成結果 | HTML | 成功時は完了メッセージとContinueボタン |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| Title入力フィールド | テキスト入力 | ValidationTextBox使用、必須入力 |

## イベント仕様

### 1-Createボタン押下

新規カテゴリを作成する。

- 動作: フォームデータをAjax POSTで送信し、作成処理を実行
- 処理:
  1. 入力値のバリデーション（必須、英数字、重複チェック）
  2. events_categoriesテーブルにINSERT
  3. 成功時は完了メッセージとContinueボタンを表示
  4. エラー時はエラーメッセージを表示しフォームを再表示

### 2-Cancelボタン押下

ダイアログを閉じる。

- 動作: Ajaxダイアログ（ajaxDialog）を非表示にする
- 処理: dijit.byId('ajaxDialog').hide()を実行

### 3-Continueボタン押下（作成成功後）

カテゴリ編集画面に遷移する。

- 表示条件: カテゴリ作成が成功した場合
- 動作: カテゴリ編集画面に画面遷移
- 遷移先: `/admin/events/category/id/{新規カテゴリID}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| カテゴリ作成 | events_categories | INSERT | 新規カテゴリを追加 |
| 重複チェック | events_categories | SELECT | タイトルの重複確認 |

### テーブル別更新項目詳細

#### events_categoriesテーブル（INSERT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | ecat_title | 入力されたタイトル | 必須 |
| INSERT | ecat_venue | '1' | デフォルト会場ID固定 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 成功 | Category Created | カテゴリ作成成功時 |
| エラー | Title is required | タイトル未入力時 |
| エラー | Invalid Title | タイトルが英数字以外を含む場合 |
| エラー | Category Already Exists | 同名のカテゴリが既に存在する場合 |
| プロンプト | Input a title | タイトル入力フィールドのプロンプト |
| エラー | Invalid title | タイトルが不正な場合のフィールドエラー |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 権限エラー画面（privileges）にフォワード |
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |
| 重複タイトル | 「Category Already Exists」エラーを表示 |

## 備考

- 本画面はAjaxダイアログとして表示され、イベント管理画面の上にオーバーレイ表示される
- Dojo Toolkitのdijit.form.ValidationTextBoxを使用してクライアント側バリデーションも実施
- タイトルは英数字のみ許可（Zend_Validate_Alnum(true)でスペースも許可）
- 作成時、デフォルト会場として会場ID=1が自動設定される
- 作成完了後は画面がContinueボタンに切り替わり、カテゴリ編集画面への遷移を促す

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

入力フォームと作成されるデータの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | categorynew.phtml | `application/modules/admin/views/scripts/events/categorynew.phtml` | フォーム構造とバリデーション設定を確認 |

**読解のコツ**: 入力項目はcategorytitleのみで、ValidationTextBoxによるクライアント側バリデーションが設定されている。

#### Step 2: エントリーポイントを理解する

コントローラのcategorynewActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | categorynewAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **1051行目**: 権限チェック（eeventsとecategorynew）
2. **1053行目**: レイアウトを無効化（Ajaxダイアログのため）
3. **1055行目**: POSTリクエストかどうかを確認
4. **1061-1068行目**: バリデーション設定（NotEmpty, Alnum, Db_NoRecordExists）
5. **1073-1091行目**: バリデーション成功時、DBにINSERTして成功メッセージを表示
6. **1093-1100行目**: バリデーション失敗時、エラーメッセージとともにフォームを再表示

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | categorynew.phtml | `application/modules/admin/views/scripts/events/categorynew.phtml` | フォーム表示とボタン動作を確認 |

**主要処理フロー**:
- **9行目**: POSTされていない場合のみフォームを表示
- **10行目**: エラーメッセージの表示（RenderMessages）
- **11-42行目**: フォーム本体
- **14-25行目**: ValidationTextBoxによるタイトル入力フィールド
- **29-34行目**: Createボタン
- **35-40行目**: Cancelボタン

### プログラム呼び出し階層図

```
Ajaxリクエスト (/admin/events/categorynew)
    │
    └─ Admin_EventsController::categorynewAction()
           │
           ├─ ACL権限チェック (eevents, ecategorynew)
           │
           ├─ POSTの場合
           │      │
           │      ├─ Zend_Filter_Input (バリデーション)
           │      │      ├─ NotEmpty
           │      │      ├─ Alnum
           │      │      └─ Db_NoRecordExists
           │      │
           │      └─ バリデーション成功時
           │             └─ DB INSERT (events_categories)
           │
           └─ ビューレンダリング
                  └─ categorynew.phtml
```

### データフロー図

```
[入力]                [処理]                       [出力]

フォームPOST         EventsController            HTMLレスポンス
(categorytitle) ──▶ categorynewAction() ──▶    (成功/エラー)
                        │
                        ▼
                 バリデーション
                        │
                        ▼ (成功時)
               events_categories
                   テーブル
                  (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | ソース | イベント関連アクションのコントローラ |
| categorynew.phtml | `application/modules/admin/views/scripts/events/categorynew.phtml` | テンプレート | カテゴリ新規作成フォームのビュー |
| manage.phtml | `application/modules/admin/views/scripts/events/manage.phtml` | テンプレート | イベント管理画面（本画面を呼び出す親画面） |
| common.js | `_scripts/admin/common.js` | JavaScript | 共通JavaScript関数（doDialog, goTo等） |
