# 画面設計書 55-イベントカテゴリ編集画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるイベントカテゴリ編集画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：既存のイベントカテゴリの詳細情報を編集するための画面である。カテゴリのタイトル、説明文、デフォルト会場、デフォルトイベント説明などを設定でき、イベント管理の効率化に貢献する。

**画面へのアクセス方法**：イベント管理画面（/admin/events/manage）のカテゴリ一覧から、コンテキストメニューの「Edit」を選択するか、カテゴリ新規作成後のContinueボタンから遷移する。

**主要な操作・処理内容**：
1. カテゴリのタイトルを編集する
2. Teaser（短い説明文）を編集する（FCKeditor使用）
3. Description（詳細説明文）を編集する（FCKeditor使用）
4. デフォルト会場を選択する
5. デフォルトイベント説明を編集する（FCKeditor使用）
6. 保存・削除・公開操作は詳細パネルから実行

**画面遷移**：
- 遷移元: イベント管理画面（/admin/events/manage）のカテゴリコンテキストメニュー、カテゴリ新規作成画面からの遷移
- 遷移先: イベント管理画面（/admin/events/）への遷移が可能

**権限による表示制御**：
- 画面自体へのアクセス: eeventsおよびecategoryedit権限が必要
- 操作ボタンは詳細パネル（categorydetails）側で権限制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | イベントカテゴリ管理 | 主機能 | カテゴリの編集・更新処理 |
| 63 | 入力検証 | 補助機能 | カテゴリフォームのバリデーション |

## 画面種別

編集

## URL/ルーティング

- URL: `/admin/events/category/id/{カテゴリID}`
- パラメータ: `id` - カテゴリID
- アクション: `Admin_EventsController::categoryAction()`

## 入出力項目

### 入力項目

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 | 入力方式 |
|--------|-------------|---------|------|------|---------|
| タイトル | title | string | 必須 | カテゴリの名前 | ValidationTextBox |
| Teaser | description | string | 必須 | 短い説明文 | FCKeditor |
| Description | content | string | 必須 | 詳細説明文 | FCKeditor |
| デフォルト会場 | venue | integer | 任意 | 新規イベント作成時のデフォルト会場 | FilteringSelect |
| デフォルトイベント説明 | default | string | 任意 | 新規イベント作成時のデフォルト説明文 | FCKeditor |

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| カテゴリ情報 | array | カテゴリの全項目（ecat_*） |
| 会場一覧 | array | 選択可能な会場リスト |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| Title | カテゴリタイトル | ecat_title |
| Teaser | 短い説明文 | ecat_description、FCKeditor |
| Description | 詳細説明文 | ecat_content、FCKeditor |
| Default Venue | デフォルト会場 | ecat_venue、ドロップダウン |
| Default Event Description | デフォルトイベント説明 | ecat_default、FCKeditor |

## イベント仕様

### 1-保存ボタン押下（詳細パネル経由）

カテゴリの編集内容を保存する。

- 動作: editFormの内容をAjax POSTで送信し、保存処理を実行
- 遷移先: `/admin/events/categorysave/id/{ecat_id}/`
- 処理: FCKeditorの値を更新後、フォームデータを送信
- バリデーション:
  - title: 必須
  - description (Teaser): 必須
  - content (Description): 必須
  - venue: 任意
  - default: 任意

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | events_categories | SELECT | カテゴリ情報を取得 |
| 画面表示 | events_venues | SELECT | 会場一覧を取得（ドロップダウン用） |
| 保存 | events_categories | UPDATE | カテゴリ情報を更新 |

### テーブル別更新項目詳細

#### events_categoriesテーブル（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_id | WHERE条件 | パラメータidで指定 |
| SELECT | ecat_title | 表示用 | タイトル |
| SELECT | ecat_description | 表示用 | Teaser |
| SELECT | ecat_content | 表示用 | Description |
| SELECT | ecat_venue | 表示用 | デフォルト会場ID |
| SELECT | ecat_default | 表示用 | デフォルトイベント説明 |

#### events_categoriesテーブル（UPDATE - 保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | ecat_title | 入力されたタイトル | 必須 |
| UPDATE | ecat_description | 入力されたTeaser | HTMLデコード処理 |
| UPDATE | ecat_content | 入力されたDescription | HTMLデコード処理 |
| UPDATE | ecat_venue | 選択された会場ID | - |
| UPDATE | ecat_default | 入力されたデフォルト説明 | HTMLデコード処理 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 成功 | Category Saved | 保存処理成功時 |
| エラー | Title is required | タイトル未入力時 |
| エラー | Teaser is required | Teaser未入力時 |
| エラー | Description is required | Description未入力時 |
| エラー | Category Not Specified! | カテゴリID未指定時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| カテゴリが存在しない | イベント管理画面（/admin/events/manage）にリダイレクト |
| 権限不足 | 権限エラー画面（privileges）にフォワード |
| バリデーションエラー | エラーメッセージを表示し、ダイアログ内で通知 |

## 備考

- 画面はタブ構成（Category、Defaults）で、2つのタブで項目がグループ化されている
- 「Category」タブ: Title、Teaser、Description
- 「Defaults」タブ: Default Venue、Default Event Description
- FCKeditorを複数インスタンス使用（description、content、default）
- 操作ボタン（Save、Delete、Publish、Events...）は詳細パネル（categorydetails）としてAjax読み込み
- カテゴリが存在しない場合は自動的にイベント管理画面にリダイレクト

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カテゴリデータと会場データの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | category.phtml | `application/modules/admin/views/scripts/events/category.phtml` | categoryArrayの構造を確認 |

**読解のコツ**: categoryArrayは連想配列で、events_categoriesテーブルの1レコードが格納される。ecat_id、ecat_title、ecat_description、ecat_content、ecat_venue、ecat_defaultなどのキーでアクセスする。

#### Step 2: エントリーポイントを理解する

コントローラのcategoryActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | categoryAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **912行目**: 権限チェック（eeventsとecategoryedit）
2. **914行目**: レイアウトを設定
3. **916行目**: カテゴリIDパラメータを取得
4. **919-925行目**: カテゴリ情報をDBから取得
5. **930行目**: ビューにカテゴリ情報を渡す
6. **932-933行目**: カテゴリが存在しない場合、イベント管理画面にリダイレクト

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | category.phtml | `application/modules/admin/views/scripts/events/category.phtml` | フォーム構造とFCKeditor設定を確認 |

**主要処理フロー**:
- **9-31行目**: Dojoモジュールの読み込みとJavaScript設定
- **33-34行目**: FCKeditorのインクルード
- **35行目**: Ajaxダイアログ定義
- **37行目**: 詳細パネル（categorydetails）のAjax読み込み
- **39-120行目**: 編集フォーム（editForm）
- **41-89行目**: 「Category」タブ（Title、Teaser、Description）
- **91-118行目**: 「Defaults」タブ（Default Venue、Default Event Description）

### プログラム呼び出し階層図

```
リクエスト (/admin/events/category/id/{id})
    │
    └─ Admin_EventsController::categoryAction()
           │
           ├─ ACL権限チェック (eevents, ecategoryedit)
           │
           ├─ setLayout() (adminレイアウト設定)
           │
           ├─ Zend_Db_Select (events_categories)
           │      └─ DB検索処理
           │
           └─ ビューレンダリング
                  └─ category.phtml
                         │
                         ├─ categorydetails (Ajax読み込み)
                         │
                         └─ FCKeditor (3インスタンス)
```

### データフロー図

```
[入力]                [処理]                       [出力]

リクエスト          EventsController            HTML画面
(id=カテゴリID) ──▶ categoryAction() ──▶       (編集フォーム)
                        │
                        ▼
               events_categories                  │
                   テーブル                        │
                (ID指定で1件取得)                  │
                                                  ▼
                                            categorydetails
                                            (Ajaxで追加読み込み)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | ソース | イベント関連アクションのコントローラ |
| category.phtml | `application/modules/admin/views/scripts/events/category.phtml` | テンプレート | カテゴリ編集フォームのビュー |
| categorydetails.phtml | `application/modules/admin/views/scripts/events/categorydetails.phtml` | テンプレート | カテゴリ詳細パネルのビュー |
| fckeditor.php | `_scripts/fckeditor/fckeditor.php` | ソース | FCKeditorのPHPクラス |
| EVenueSelect.php | `application/views/helpers/EVenueSelect.php` | ソース | 会場選択ドロップダウンのビューヘルパー |
| common.js | `_scripts/admin/common.js` | JavaScript | 共通JavaScript関数 |
