# 画面設計書 56-会場管理画面

## 概要

本ドキュメントは、Legacy CMS管理画面における会場管理画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：イベント開催場所となる会場を一覧管理するための画面である。イベント管理において会場情報は重要な要素であり、本画面では会場の追加、編集、削除、フィルタリングなどの操作を提供する。

**画面へのアクセス方法**：管理画面のイベント管理画面（/admin/events/manage）の「Venues」ボタンをクリックするか、直接URL（/admin/events/venues）にアクセスする。

**主要な操作・処理内容**：
1. 登録済み会場を一覧表示する（ページネーション付き）
2. 都市や国でフィルタリングする
3. 「New Venue」ボタンで新規会場を作成
4. 会場名クリックで会場編集画面に遷移
5. 「Edit」リンクで会場編集画面に遷移
6. 「Delete」リンクで会場を削除

**画面遷移**：
- 遷移元: イベント管理画面（/admin/events/manage）
- 遷移先:
  - 会場編集画面（/admin/events/venue/id/{id}）
  - 会場新規作成ダイアログ
  - イベント管理画面（/admin/events/manage）

**権限による表示制御**：
- 「New Venue」ボタン: evenuenew権限を持つ場合のみ表示
- 「Delete」リンク: evenuedelete権限を持つ場合のみ表示
- 画面自体へのアクセス: eevents権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 補助機能 | 会場一覧を表示 |
| 61 | アクセス制御 | 主機能 | 管理者権限チェックと会場管理 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/events/venues`
- パラメータ:
  - `city` - 都市でフィルタ（オプション）
  - `country` - 国でフィルタ（オプション）
  - `page` - ページ番号（オプション）
- アクション: `Admin_EventsController::venuesAction()`

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 |
|--------|-------------|---------|------|------|
| 都市 | city | string | 任意 | フィルタ用の都市名（URLエンコード） |
| 国 | country | string | 任意 | フィルタ用の国名（URLエンコード） |
| ページ番号 | page | integer | 任意 | ページネーション用 |

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 会場一覧 | Paginator | 会場情報の配列（ページネーション対応） |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| Venue | 会場名 | venue_title、リンク付き |
| City | 都市名 | venue_city、フィルタリンク付き |
| Country | 国名 | venue_country、フィルタリンク付き |
| ステータス | (draft)表示 | venue_status==draft時のみ表示 |

## イベント仕様

### 1-New Venueボタン押下

会場新規作成ダイアログを表示する。

- 表示条件: evenuenew権限を持つ場合
- 動作: Ajaxダイアログを表示
- 遷移先: `/admin/events/venuenew/`

### 2-Events...ボタン押下

イベント管理画面に戻る。

- 動作: イベント管理画面に画面遷移
- 遷移先: `/admin/events/manage`

### 3-会場名リンククリック

会場編集画面に遷移する。

- 動作: 会場編集画面に画面遷移
- 遷移先: `/admin/events/venue/id/{venue_id}`

### 4-Editリンククリック

会場編集画面に遷移する。

- 動作: 会場編集画面に画面遷移
- 遷移先: `/admin/events/venue/id/{venue_id}`

### 5-Deleteリンククリック

会場削除ダイアログを表示する。

- 表示条件: evenuedelete権限を持つ場合
- 動作: Ajaxダイアログで削除確認を表示
- 遷移先: `/admin/events/venuedelete/id/{venue_id}/`

### 6-都市リンククリック

都市でフィルタリングする。

- 動作: 同じ都市の会場のみ表示
- 遷移先: `/admin/events/venues?city={venue_city}`

### 7-国リンククリック

国でフィルタリングする。

- 動作: 同じ国の会場のみ表示
- 遷移先: `/admin/events/venues?country={venue_country}`

### 8-フィルタ解除（タグクリック）

適用中のフィルタを解除する。

- 動作: フィルタパラメータをNULLにしてページを再読み込み
- 処理: クリックされたフィルタタグに対応するパラメータをクリア

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 会場一覧表示 | events_venues | SELECT | 会場情報を取得（フィルタ条件付き） |

### テーブル別更新項目詳細

#### events_venuesテーブル（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id | 全件（ID!=1） | デフォルト会場を除外 |
| SELECT | venue_title | 全件 | 会場名 |
| SELECT | venue_city | WHERE条件/全件 | 都市名、フィルタ可能 |
| SELECT | venue_country | WHERE条件/全件 | 国名、フィルタ可能 |
| SELECT | venue_status | 全件 | ステータス |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 情報 | No Venues! | 会場が1件も存在しない場合 |
| 情報 | No active filter | フィルタが適用されていない場合 |
| 確認 | Are you sure you want to delete this venue? | 削除リンククリック時 |
| 成功 | Venue Deleted | 削除処理成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 会場が存在しない | 「No Venues!」メッセージを表示 |
| 権限不足 | 権限エラー画面（privileges）にフォワード |

## 備考

- 会場ID=1（デフォルト会場）は一覧から除外されている（WHERE venue_id != 1）
- 1ページあたり15件表示、ページ範囲は5
- フィルタは都市と国の組み合わせが可能
- フィルタタグはクリックで解除可能（マウスオーバーで削除アイコン表示）
- 会場一覧はタイトル順（ASC）でソート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

会場データの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | venues.phtml | `application/modules/admin/views/scripts/events/venues.phtml` | venuesArrayの構造を確認 |

**読解のコツ**: venuesArrayはZend_Paginatorオブジェクトで、foreachでループ可能。各要素はevents_venuesテーブルのレコード（venue_id、venue_title、venue_city、venue_country、venue_status）。

#### Step 2: エントリーポイントを理解する

コントローラのvenuesActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | venuesAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **1320行目**: 権限チェック（eevents）
2. **1325行目**: レイアウトを設定
3. **1327-1329行目**: フィルタパラメータを取得（city、country）
4. **1331-1336行目**: ページ番号を取得
5. **1338-1362行目**: フィルタ条件に応じたSELECTクエリを構築（venue_id != 1を除外）
6. **1365-1368行目**: Paginatorを設定（15件/ページ、範囲5）
7. **1371行目**: ビューに会場配列を渡す

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | venues.phtml | `application/modules/admin/views/scripts/events/venues.phtml` | 表示ロジックとフィルタUIを確認 |

**主要処理フロー**:
- **33-59行目**: Functionsフィールドセット（New Venue、Events...ボタン）とFilterフィールドセット
- **51-53行目**: フィルタタグの表示（クリックで解除可能）
- **61-86行目**: 会場一覧テーブル
- **67-78行目**: 会場データのループ表示
- **72行目**: 会場名リンク（ステータスがdraftの場合は「(draft)」を付加）
- **73行目**: 編集・削除リンク（マウスオーバーで表示）
- **88-95行目**: ページネーション

### プログラム呼び出し階層図

```
リクエスト (/admin/events/venues?city=xxx&country=yyy&page=z)
    │
    └─ Admin_EventsController::venuesAction()
           │
           ├─ ACL権限チェック (eevents)
           │
           ├─ setLayout() (adminレイアウト設定)
           │
           ├─ フィルタパラメータ取得
           │      ├─ city (URLデコード)
           │      └─ country (URLデコード)
           │
           ├─ Zend_Db_Select (events_venues)
           │      ├─ WHERE venue_id != 1
           │      ├─ WHERE venue_city = ? (cityフィルタ時)
           │      ├─ WHERE venue_country = ? (countryフィルタ時)
           │      └─ ORDER BY venue_title ASC
           │
           ├─ Zend_Paginator
           │      ├─ setCurrentPageNumber()
           │      ├─ setItemCountPerPage(15)
           │      └─ setPageRange(5)
           │
           └─ ビューレンダリング
                  └─ venues.phtml
```

### データフロー図

```
[入力]                [処理]                       [出力]

リクエスト          EventsController            HTML画面
(city, country, ──▶ venuesAction() ──▶         (会場一覧)
 page)                  │
                        ▼
                 events_venues
                   テーブル
              (フィルタ条件で検索
               ID!=1を除外)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | ソース | イベント関連アクションのコントローラ |
| venues.phtml | `application/modules/admin/views/scripts/events/venues.phtml` | テンプレート | 会場一覧表示のビュー |
| default.phtml | `application/views/scripts/_pagination/default.phtml` | テンプレート | ページネーションの共通テンプレート |
| common.js | `_scripts/admin/common.js` | JavaScript | 共通JavaScript関数（getDialog, goTo, toggleVis等） |
