# 画面設計書 57-会場詳細画面

## 概要

本ドキュメントは、Legacy CMS管理画面における会場詳細画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：会場の詳細情報（ステータス）を表示し、保存・削除・公開などの操作ボタンを提供する画面である。会場編集画面内の部分ビューとして表示され、会場の状態確認と主要操作へのアクセスポイントとなる。

**画面へのアクセス方法**：会場編集画面（/admin/events/venue/id/{id}）に遷移すると、本詳細画面がContentPaneとしてAjaxで非同期に読み込まれる。

**主要な操作・処理内容**：
1. 会場のステータス（draft/published）を確認する
2. 「Publish」ボタンで会場を公開状態に変更する（未公開時のみ表示）
3. 「Save」または「Save Draft」ボタンで会場情報を保存する
4. 「Delete」ボタンで会場を削除する（権限が必要、デフォルト会場は削除不可）
5. 「Venues...」ボタンで会場管理画面に戻る
6. 「Events...」ボタンでイベント管理画面に戻る

**画面遷移**：
- 遷移元: 会場編集画面（/admin/events/venue/id/{id}）内にAjax読み込み
- 遷移先: 会場管理画面（/admin/events/venues）、イベント管理画面（/admin/events/）への遷移が可能

**権限による表示制御**：
- 「Publish」ボタン: 会場が未公開状態かつevenuepublish権限を持つ場合のみ表示
- 「Delete」ボタン: 会場IDが1以外かつevenuedelete権限を持つ場合のみ表示
- 画面自体へのアクセス: eeventsおよびevenueedit権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 補助機能 | 会場の詳細情報を表示 |

## 画面種別

詳細（会場編集画面の部分ビュー）

## URL/ルーティング

- URL: `/admin/events/venuedetails`
- パラメータ: `id` - 会場ID
- アクション: `Admin_EventsController::venuedetailsAction()`
- 読み込み方式: Ajaxによる非同期読み込み（ContentPane）

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 |
|--------|-------------|---------|------|------|
| 会場ID | id | integer | 必須 | 詳細を表示する会場のID |

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ステータス | string | 会場の公開状態（draft/published） |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| Status | 会場のステータス（Draft/Published） | venue_statusを先頭大文字化 |

## イベント仕様

### 1-Publishボタン押下

会場を公開状態に変更する処理を開始する。

- 表示条件: 会場が未公開状態（venue_status != 'published'）かつevenuepublish権限を持つ場合
- 動作: Ajaxダイアログを表示し、公開確認と公開処理を実行
- 遷移先: `/admin/events/venuepublish/id/{venue_id}/`
- 処理: 編集フォームの内容を含めて公開処理を実行

### 2-Saveボタン押下

会場の編集内容を保存する。

- 表示テキスト: 未公開時は「Save Draft」、公開時は「Save」
- 動作: 編集フォームの内容をAjax POSTで送信し、保存処理を実行
- 遷移先: `/admin/events/venuesave/id/{venue_id}/`
- 処理: FCKeditorの値を更新後、フォームデータを送信

### 3-Deleteボタン押下

会場を削除する処理を開始する。

- 表示条件: 会場IDが1以外かつevenuedelete権限を持つ場合
- 動作: Ajaxダイアログで削除確認を表示
- 遷移先: `/admin/events/venuedelete/id/{venue_id}/`
- 処理: 確認後、会場を削除し、所属イベントをデフォルト会場に移動

### 4-Venues...ボタン押下

会場管理画面に戻る。

- 動作: `/admin/events/venues`に画面遷移
- 処理: 会場一覧画面を表示

### 5-Events...ボタン押下

イベント管理画面に戻る。

- 動作: `/admin/events/`に画面遷移
- 処理: イベント一覧画面を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | events_venues | SELECT | 会場情報を取得 |

### テーブル別更新項目詳細

#### events_venuesテーブル（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id | WHERE条件 | パラメータidで指定 |
| SELECT | venue_status | 表示用 | ステータス表示に使用 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 情報 | Venue Saved | 保存処理成功時 |
| 情報 | Venue Published | 公開処理成功時 |
| 情報 | Venue Deleted | 削除処理成功時 |
| 確認 | Are you sure you want to delete this venue? | 削除ボタン押下時 |
| 確認 | Are you sure you want to publish this venue? | 公開ボタン押下時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 会場が存在しない | 上位の会場編集画面で会場管理画面にリダイレクト |
| 権限不足 | 権限エラー画面（privileges）にフォワード |
| バリデーションエラー | エラーメッセージを表示し、ダイアログ内で通知 |

## 備考

- 本画面は会場編集画面（/admin/events/venue/id/{id}）の一部として、ContentPaneによりAjaxで非同期読み込みされる
- Dojo Toolkitのdijit.form.Buttonウィジェットを使用してボタンを表示
- FCKeditorとの連携があり、保存・公開時にはMyFCKObject.UpdateEditorFormValue()でエディタの値を同期
- 会場IDが1のものはシステムデフォルト会場として削除不可
- 削除時、その会場を使用しているイベントはデフォルト会場（ID=1）に自動移動

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

会場データの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | venuedetails.phtml | `application/modules/admin/views/scripts/events/venuedetails.phtml` | venueArrayの構造（venue_id, venue_status）を確認 |

**読解のコツ**: venueArrayは連想配列で、events_venuesテーブルの1レコードが格納される。venue_id、venue_statusなどのキーでアクセスする。

#### Step 2: エントリーポイントを理解する

コントローラのvenuedetailsActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | venuedetailsAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **1423行目**: 権限チェック（eeventsとevenueedit）
2. **1425行目**: レイアウトを無効化（Ajaxレスポンスのため）
3. **1427行目**: 会場IDパラメータを取得
4. **1430-1436行目**: 会場情報をDBから取得
5. **1441行目**: ビューに会場情報を渡す

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | venuedetails.phtml | `application/modules/admin/views/scripts/events/venuedetails.phtml` | 表示ロジックと権限による表示制御を確認 |

**主要処理フロー**:
- **15行目**: ステータスの表示（ucwordsで先頭大文字化）
- **25-27行目**: Publishボタンの条件付き表示
- **28行目**: Save/Save Draftボタン
- **29-31行目**: Deleteボタンの条件付き表示
- **32行目**: Venues...ボタン
- **33行目**: Events...ボタン

### プログラム呼び出し階層図

```
Ajaxリクエスト (/admin/events/venuedetails?id={id})
    │
    └─ Admin_EventsController::venuedetailsAction()
           │
           ├─ ACL権限チェック (eevents, evenueedit)
           │
           ├─ Zend_Db_Select (events_venues)
           │      └─ DB検索処理
           │
           └─ ビューレンダリング
                  └─ venuedetails.phtml
```

### データフロー図

```
[入力]                [処理]                       [出力]

リクエスト          EventsController            HTMLレスポンス
(id=会場ID) ──▶    venuedetailsAction() ──▶    (詳細パネル)
                        │
                        ▼
                 events_venues
                   テーブル
                (ID指定で1件取得)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | ソース | イベント関連アクションのコントローラ |
| venuedetails.phtml | `application/modules/admin/views/scripts/events/venuedetails.phtml` | テンプレート | 会場詳細表示のビュー |
| venue.phtml | `application/modules/admin/views/scripts/events/venue.phtml` | テンプレート | 会場編集画面（本詳細を読み込む親画面） |
| common.js | `_scripts/admin/common.js` | JavaScript | 共通JavaScript関数（getDialog, postDialog, goTo等） |
