# 画面設計書 58-会場新規作成画面

## 概要

本ドキュメントは、Legacy CMS管理画面における会場新規作成画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：新しいイベント会場を登録するためのダイアログ画面である。イベント管理において正確な会場情報の登録は重要であり、本画面では会場名、住所、都市、国を入力し、Google Maps APIを使用して自動的に緯度・経度を取得する。

**画面へのアクセス方法**：会場管理画面（/admin/events/venues）の「New Venue」ボタンをクリックすると、Ajaxダイアログとして本画面が表示される。

**主要な操作・処理内容**：
1. 会場名を入力する
2. 住所を入力する
3. 都市名を入力する
4. 国を選択する
5. 「Create」ボタンで新規会場を作成（住所から緯度・経度を自動取得）
6. 「Cancel」ボタンでダイアログを閉じる
7. 作成成功後、会場編集画面への「Continue」ボタンが表示される

**画面遷移**：
- 遷移元: 会場管理画面（/admin/events/venues）のNew Venueボタン
- 遷移先: 作成成功後、会場編集画面（/admin/events/venue/id/{新規ID}）へ遷移可能

**権限による表示制御**：
- 画面自体へのアクセス: eeventsおよびevenuenew権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 補助機能 | 新規会場の作成処理 |
| 63 | 入力検証 | 主機能 | 会場フォームのバリデーション |

## 画面種別

登録（Ajaxダイアログ）

## URL/ルーティング

- URL: `/admin/events/venuenew`
- アクション: `Admin_EventsController::venuenewAction()`
- 表示方式: Ajaxダイアログ（dijit.Dialog）

## 入出力項目

### 入力項目

| 項目名 | パラメータ名 | データ型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|-------------|---------|------|--------|---------------|------|
| 会場名 | venuetitle | string | 必須 | - | NotEmpty | 会場の名前 |
| 住所 | venueaddress | string | 必須 | - | NotEmpty | 会場の住所 |
| 都市 | venuecity | string | 必須 | - | NotEmpty | 会場のある都市 |
| 国 | venuecountry | string | 必須 | - | NotEmpty | 会場のある国 |

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 作成結果 | HTML | 成功時は完了メッセージとContinueボタン |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| Venue Name入力フィールド | テキスト入力 | ValidationTextBox使用、必須入力 |
| Address入力フィールド | テキストエリア | SimpleTextarea使用、必須入力 |
| City入力フィールド | テキスト入力 | ValidationTextBox使用、必須入力 |
| Country選択フィールド | ドロップダウン | FilteringSelect使用、国一覧から選択 |

## イベント仕様

### 1-Createボタン押下

新規会場を作成する。

- 動作: フォームデータをAjax POSTで送信し、作成処理を実行
- 処理:
  1. 入力値のバリデーション（全項目必須）
  2. Google Maps Geocoding APIで住所から緯度・経度を取得
  3. events_venuesテーブルにINSERT
  4. 成功時は完了メッセージとContinueボタンを表示
  5. エラー時はエラーメッセージを表示しフォームを再表示

### 2-Cancelボタン押下

ダイアログを閉じる。

- 動作: Ajaxダイアログ（ajaxDialog）を非表示にする
- 処理: dijit.byId('ajaxDialog').hide()を実行

### 3-Continueボタン押下（作成成功後）

会場編集画面に遷移する。

- 表示条件: 会場作成が成功した場合
- 動作: 会場編集画面に画面遷移
- 遷移先: `/admin/events/venue/id/{新規会場ID}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 会場作成 | events_venues | INSERT | 新規会場を追加 |

### テーブル別更新項目詳細

#### events_venuesテーブル（INSERT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | venue_title | 入力された会場名 | 必須 |
| INSERT | venue_address | 入力された住所 | 必須 |
| INSERT | venue_city | 入力された都市 | 必須 |
| INSERT | venue_country | 選択された国 | 必須 |
| INSERT | venue_latitude | Geocoding APIから取得 | 自動取得 |
| INSERT | venue_longitude | Geocoding APIから取得 | 自動取得 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 成功 | Venue Created | 会場作成成功時 |
| エラー | Title is required | 会場名未入力時 |
| エラー | Address is required | 住所未入力時 |
| エラー | City is required | 都市未入力時 |
| エラー | Country is required | 国未選択時 |
| プロンプト | Input a venue name | 会場名入力フィールドのプロンプト |
| プロンプト | Enter an address | 住所入力フィールドのプロンプト |
| プロンプト | Input a town or city | 都市入力フィールドのプロンプト |
| プロンプト | Select a country | 国選択フィールドのプロンプト |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 権限不足 | 権限エラー画面（privileges）にフォワード |
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |
| Geocoding失敗 | 緯度・経度が空の状態で登録（後で編集画面で修正可能） |

## 備考

- 本画面はAjaxダイアログとして表示され、会場管理画面の上にオーバーレイ表示される
- Dojo Toolkitの各種フォームウィジェットを使用
- Google Maps Geocoding APIを使用して住所から緯度・経度を自動取得
- 国選択にはFilteringSelectを使用し、オートコンプリート機能を提供
- デフォルト国は「United Kingdom」
- 作成完了後は画面がContinueボタンに切り替わり、会場編集画面への遷移を促す
- 緯度・経度は会場編集画面でドラッグ操作により微調整可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

入力フォームと作成されるデータの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | venuenew.phtml | `application/modules/admin/views/scripts/events/venuenew.phtml` | フォーム構造とバリデーション設定を確認 |

**読解のコツ**: 入力項目はvenuetitle、venueaddress、venuecity、venuecountryの4つ。各種Dojoウィジェット（ValidationTextBox、SimpleTextarea、FilteringSelect）を使用。

#### Step 2: エントリーポイントを理解する

コントローラのvenuenewActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | venuenewAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **1526行目**: 権限チェック（eeventsとevenuenew）
2. **1528行目**: レイアウトを無効化（Ajaxダイアログのため）
3. **1531行目**: POSTリクエストかどうかを確認
4. **1537-1557行目**: バリデーション設定（全項目NotEmpty）
5. **1563-1584行目**: バリデーション成功時、Geocoding APIで緯度・経度取得、DBにINSERT
6. **1607-1617行目**: バリデーション失敗時、エラーメッセージとともにフォームを再表示

#### Step 3: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | venuenew.phtml | `application/modules/admin/views/scripts/events/venuenew.phtml` | フォーム表示とボタン動作を確認 |

**主要処理フロー**:
- **9行目**: POSTされていない場合のみフォームを表示
- **10行目**: エラーメッセージの表示（RenderMessages）
- **11-87行目**: フォーム本体
- **12-26行目**: 会場名入力フィールド（ValidationTextBox）
- **27-41行目**: 住所入力フィールド（SimpleTextarea）
- **42-56行目**: 都市入力フィールド（ValidationTextBox）
- **57-71行目**: 国選択フィールド（FilteringSelect）
- **74-79行目**: Createボタン
- **80-85行目**: Cancelボタン

### プログラム呼び出し階層図

```
Ajaxリクエスト (/admin/events/venuenew)
    │
    └─ Admin_EventsController::venuenewAction()
           │
           ├─ ACL権限チェック (eevents, evenuenew)
           │
           ├─ POSTの場合
           │      │
           │      ├─ Zend_Filter_Input (バリデーション)
           │      │      └─ NotEmpty (全4項目)
           │      │
           │      └─ バリデーション成功時
           │             │
           │             ├─ Google Maps Geocoding API
           │             │      └─ 住所から緯度・経度取得
           │             │
           │             └─ DB INSERT (events_venues)
           │
           └─ ビューレンダリング
                  └─ venuenew.phtml
```

### データフロー図

```
[入力]                [処理]                       [出力]

フォームPOST         EventsController            HTMLレスポンス
(venuetitle,    ──▶ venuenewAction() ──▶       (成功/エラー)
 venueaddress,           │
 venuecity,              ▼
 venuecountry)    バリデーション
                        │
                        ▼ (成功時)
                 Google Maps API
                 (Geocoding)
                        │
                        ▼
                  events_venues
                    テーブル
                   (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | ソース | イベント関連アクションのコントローラ |
| venuenew.phtml | `application/modules/admin/views/scripts/events/venuenew.phtml` | テンプレート | 会場新規作成フォームのビュー |
| venues.phtml | `application/modules/admin/views/scripts/events/venues.phtml` | テンプレート | 会場管理画面（本画面を呼び出す親画面） |
| ecountriesOptions.php | `application/views/helpers/ecountriesOptions.php` | ソース | 国選択ドロップダウンのビューヘルパー |
| common.js | `_scripts/admin/common.js` | JavaScript | 共通JavaScript関数（doDialog, goTo等） |
