# 画面設計書 59-会場編集画面

## 概要

本ドキュメントは、Legacy CMS管理画面における会場編集画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：登録済みの会場情報を編集するための画面である。会場名、住所、位置情報（緯度・経度）、説明文、連絡先情報などを編集できる。Google Mapsを使用して地図上で位置を視覚的に確認・調整することが可能。

**画面へのアクセス方法**：会場管理画面（/admin/events/venues）の会場名リンクまたはEditリンクをクリック、または会場新規作成後のContinueボタンをクリックして本画面に遷移する。

**主要な操作・処理内容**：
1. 会場名を編集する
2. 地図上でマーカーをドラッグして位置を微調整する
3. 緯度・経度を直接入力する
4. 住所、都市、国を編集する
5. 説明文をリッチテキストエディタ（FCKeditor）で編集する
6. リンクURL、メールアドレス、電話番号を編集する
7. 詳細パネル（会場詳細画面）のSaveボタンで保存する

**画面遷移**：
- 遷移元: 会場管理画面（/admin/events/venues）、会場新規作成画面
- 遷移先: 会場管理画面（/admin/events/venues）、イベント管理画面（/admin/events/）

**権限による表示制御**：
- 画面自体へのアクセス: eeventsおよびevenueedit権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 補助機能 | 会場情報の編集処理 |
| 63 | 入力検証 | 主機能 | 会場フォームのバリデーション |

## 画面種別

編集

## URL/ルーティング

- URL: `/admin/events/venue/id/{id}`
- パラメータ: `id` - 会場ID
- アクション: `Admin_EventsController::venueAction()`

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 |
|--------|-------------|---------|------|------|
| 会場ID | id | integer | 必須 | 編集する会場のID |

### 入力項目（フォーム）

| 項目名 | パラメータ名 | データ型 | 必須 | 最大長 | バリデーション | 説明 |
|--------|-------------|---------|------|--------|---------------|------|
| 会場名 | title | string | 必須 | - | NotEmpty | 会場の名前 |
| 緯度 | latitude | string | 必須 | - | NotEmpty | 会場の緯度 |
| 経度 | longitude | string | 必須 | - | NotEmpty | 会場の経度 |
| 住所 | address | string | 必須 | - | NotEmpty | 会場の住所 |
| 都市 | city | string | 必須 | - | NotEmpty | 会場のある都市 |
| 国 | country | string | 必須 | - | NotEmpty | 会場のある国 |
| 説明 | description | string | 任意 | - | - | 会場の説明（リッチテキスト） |
| リンク | url | string | 任意 | - | URL形式 | 会場のウェブサイトURL |
| メール | email | string | 任意 | - | Email形式 | 会場のメールアドレス |
| 電話番号 | phone | string | 任意 | - | - | 会場の電話番号 |

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 会場情報 | array | 既存会場のデータ（編集フォームの初期値） |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| Venue Name入力フィールド | テキスト入力 | ValidationTextBox使用、必須入力 |
| 地図 | Google Maps | マーカードラッグで位置調整可能 |
| Latitude入力フィールド | テキスト入力 | TextBox使用、地図と連動 |
| Longitude入力フィールド | テキスト入力 | TextBox使用、地図と連動 |
| Address入力フィールド | テキストエリア | SimpleTextarea使用、必須入力 |
| City入力フィールド | テキスト入力 | ValidationTextBox使用、必須入力 |
| Country選択フィールド | ドロップダウン | FilteringSelect使用、国一覧から選択 |
| Description入力フィールド | リッチテキスト | FCKeditor使用 |
| Link入力フィールド | テキスト入力 | ValidationTextBox使用、URL正規表現チェック |
| E-mail入力フィールド | テキスト入力 | ValidationTextBox使用、Email正規表現チェック |
| Phone入力フィールド | テキスト入力 | ValidationTextBox使用 |

## イベント仕様

### 1-Saveボタン押下（会場詳細画面から）

会場の編集内容を保存する。

- 動作: フォームデータをAjax POSTで送信し、更新処理を実行
- 処理:
  1. FCKeditorの値をフォームに同期（MyFCKObject.UpdateEditorFormValue()）
  2. 入力値のバリデーション（title, latitude, longitude, address, city, countryは必須）
  3. events_venuesテーブルをUPDATE
  4. 公開済みの場合は検索インデックスを更新
  5. 成功時は完了メッセージとCloseボタンを表示
  6. エラー時はエラーメッセージを表示

### 2-地図マーカードラッグ

地図上のマーカーをドラッグして位置を微調整する。

- 動作: マーカーの新しい位置を緯度・経度フィールドに反映
- 処理: venue.jsの処理により、マーカー位置変更時にlatitude、longitudeフィールドを更新

### 3-Publishボタン押下（会場詳細画面から）

会場を公開状態に変更する。

- 表示条件: 会場が未公開状態かつevenuepublish権限を持つ場合
- 動作: 公開確認ダイアログを表示後、公開処理を実行

### 4-Deleteボタン押下（会場詳細画面から）

会場を削除する。

- 表示条件: 会場IDが1以外かつevenuedelete権限を持つ場合
- 動作: 削除確認ダイアログを表示後、削除処理を実行

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | events_venues | SELECT | 会場情報を取得 |
| 保存 | events_venues | UPDATE | 会場情報を更新 |

### テーブル別更新項目詳細

#### events_venuesテーブル（SELECT - 画面表示時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE venue_id = ? | 全カラムを取得 |

#### events_venuesテーブル（UPDATE - 保存時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | venue_title | 入力された会場名 | 必須 |
| UPDATE | venue_description | 入力された説明（HTMLデコード） | 任意 |
| UPDATE | venue_latitude | 入力された緯度 | 必須 |
| UPDATE | venue_longitude | 入力された経度 | 必須 |
| UPDATE | venue_address | 入力された住所 | 必須 |
| UPDATE | venue_city | 入力された都市 | 必須 |
| UPDATE | venue_country | 選択された国 | 必須 |
| UPDATE | venue_url | 入力されたURL | 任意 |
| UPDATE | venue_email | 入力されたメール | 任意 |
| UPDATE | venue_phone | 入力された電話番号 | 任意 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 成功 | Venue Saved | 保存処理成功時 |
| エラー | Title is required | 会場名未入力時 |
| エラー | Latitude is required | 緯度未入力時 |
| エラー | Longitude is required | 経度未入力時 |
| エラー | Address is required | 住所未入力時 |
| エラー | City is required | 都市未入力時 |
| エラー | Country is required | 国未選択時 |
| エラー | Venue Not Specified! | 会場IDが未指定の場合 |
| 案内 | You can drag the map marker to fine tune it's location. | 地図上部に常時表示 |
| プロンプト | Enter a venue name | 会場名入力フィールドのプロンプト |
| プロンプト | Enter an address | 住所入力フィールドのプロンプト |
| プロンプト | Enter a city | 都市入力フィールドのプロンプト |
| プロンプト | Select a country | 国選択フィールドのプロンプト |
| プロンプト | Enter a URL | リンク入力フィールドのプロンプト |
| プロンプト | Enter an e-mail address | メール入力フィールドのプロンプト |
| プロンプト | Enter a phone number | 電話番号入力フィールドのプロンプト |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 会場が存在しない | 会場管理画面（/admin/events/venues）にリダイレクト |
| 権限不足 | 権限エラー画面（privileges）にフォワード |
| バリデーションエラー | エラーメッセージを表示し、ダイアログ内で通知 |

## 備考

- 本画面はTabContainerを使用し、「Venue」タブ内に編集フォームを表示
- 画面上部にはContentPaneで会場詳細画面（venuedetails）がAjax読み込みされ、操作ボタン群を提供
- Google Maps APIを使用して地図を表示し、マーカードラッグで位置調整可能
- FCKeditorを使用してリッチテキスト形式で説明文を編集可能
- Dojo Toolkitの各種フォームウィジェットを使用（ValidationTextBox、SimpleTextarea、FilteringSelect、TextBox）
- URLフィールドはhttp/https/ftp形式の正規表現バリデーション付き
- メールフィールドはメールアドレス形式の正規表現バリデーション付き
- 公開済み会場の場合、保存時に検索インデックスも更新される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

会場データの構造と入力フォームの対応を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | venue.phtml | `application/modules/admin/views/scripts/events/venue.phtml` | venueArrayの構造とフォーム項目の対応を確認 |

**読解のコツ**: venueArrayは連想配列で、events_venuesテーブルの1レコードが格納される。venue_title、venue_latitude、venue_longitude、venue_address、venue_city、venue_country、venue_description、venue_url、venue_email、venue_phoneなどのキーでアクセスする。

#### Step 2: エントリーポイントを理解する

コントローラのvenueActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | venueAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **1386行目**: 権限チェック（eeventsとevenueedit）
2. **1388行目**: レイアウトを設定
3. **1390行目**: 会場IDパラメータを取得
4. **1396-1399行目**: 会場情報をDBから取得
5. **1404行目**: ビューに会場情報を渡す
6. **1406-1408行目**: 会場が存在しない場合はvenuesにリダイレクト

#### Step 3: 保存処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | EventsController.php | `application/modules/admin/controllers/EventsController.php` | venuesaveAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **1641行目**: 権限チェック（eeventsとevenueedit）
2. **1643-1644行目**: レイアウトとビューを無効化
3. **1656-1691行目**: バリデーション設定（title, latitude, longitude, address, city, countryは必須）
4. **1699-1716行目**: バリデーション成功時、events_venuesテーブルをUPDATE
5. **1729-1746行目**: 公開済みの場合、検索インデックスを更新
6. **1749-1754行目**: 成功メッセージを出力
7. **1756-1765行目**: バリデーション失敗時、エラーメッセージを出力

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | venue.phtml | `application/modules/admin/views/scripts/events/venue.phtml` | フォーム構造と各ウィジェットの設定を確認 |

**主要処理フロー**:
- **9-31行目**: Dojoモジュールのrequireと初期化スクリプト
- **38行目**: FCKeditorのインクルード
- **40行目**: Ajaxダイアログ定義
- **42行目**: 会場詳細画面をContentPaneで読み込み
- **44-214行目**: TabContainerとVenueタブ
- **47-212行目**: 編集フォーム本体
- **51-62行目**: 会場名入力（ValidationTextBox）
- **67行目**: 地図キャンバス（Google Maps）
- **74-82行目**: 緯度入力（TextBox）
- **84-93行目**: 経度入力（TextBox）
- **96-108行目**: 住所入力（SimpleTextarea）
- **111-123行目**: 都市入力（ValidationTextBox）
- **126-139行目**: 国選択（FilteringSelect）
- **147-157行目**: 説明入力（FCKeditor）
- **162-176行目**: リンク入力（ValidationTextBox、URL正規表現）
- **179-193行目**: メール入力（ValidationTextBox、Email正規表現）
- **196-209行目**: 電話番号入力（ValidationTextBox）

### プログラム呼び出し階層図

```
リクエスト (/admin/events/venue/id/{id})
    │
    └─ Admin_EventsController::venueAction()
           │
           ├─ ACL権限チェック (eevents, evenueedit)
           │
           ├─ setLayout() (adminレイアウト設定)
           │
           ├─ Zend_Db_Select (events_venues)
           │      └─ WHERE venue_id = ?
           │
           └─ ビューレンダリング
                  └─ venue.phtml
                         │
                         ├─ ContentPane (会場詳細画面)
                         │      └─ /admin/events/venuedetails?id={id}
                         │
                         ├─ Google Maps API
                         │      └─ venue.js (マーカー操作)
                         │
                         └─ FCKeditor (説明文編集)

保存時:
Ajax POST (/admin/events/venuesave/id/{id})
    │
    └─ Admin_EventsController::venuesaveAction()
           │
           ├─ ACL権限チェック (eevents, evenueedit)
           │
           ├─ Zend_Filter_Input (バリデーション)
           │      ├─ NotEmpty (title, latitude, longitude, address, city, country)
           │      └─ allowEmpty (description, url, email, phone)
           │
           ├─ DB UPDATE (events_venues)
           │
           └─ 検索インデックス更新 (公開済みの場合)
```

### データフロー図

```
[入力]                [処理]                       [出力]

リクエスト          EventsController            HTML画面
(id=会場ID) ──▶    venueAction() ──▶          (編集フォーム)
                        │
                        ▼
                 events_venues
                   テーブル
                (ID指定で1件取得)

保存時:
フォームPOST         EventsController            HTMLレスポンス
(title,         ──▶ venuesaveAction() ──▶      (成功/エラー)
 latitude,              │
 longitude,             ▼
 address,        バリデーション
 city,                  │
 country,               ▼ (成功時)
 description,    events_venues
 url,              テーブル
 email,           (UPDATE)
 phone)                 │
                        ▼ (公開済み)
                  検索インデックス
                    (UPDATE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/admin/controllers/EventsController.php` | ソース | イベント関連アクションのコントローラ |
| venue.phtml | `application/modules/admin/views/scripts/events/venue.phtml` | テンプレート | 会場編集フォームのビュー |
| venuedetails.phtml | `application/modules/admin/views/scripts/events/venuedetails.phtml` | テンプレート | 会場詳細画面（ContentPaneで読み込み） |
| venue.js | `_scripts/admin/venue.js` | JavaScript | 地図操作用JavaScript（マーカードラッグ処理） |
| common.js | `_scripts/admin/common.js` | JavaScript | 共通JavaScript関数（postDialog, goTo等） |
| ecountriesOptions.php | `application/views/helpers/ecountriesOptions.php` | ソース | 国選択ドロップダウンのビューヘルパー |
| fckeditor.php | `_scripts/fckeditor/fckeditor.php` | ソース | FCKeditorのPHPクラス |
