# 画面設計書 6-パスワードリセット画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおけるパスワードリセット画面の設計仕様を定義する。パスワードを忘れたユーザーに新しいパスワードをメールで送信する機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：パスワードリセット画面は、パスワードを忘れたユーザーがアカウントへのアクセスを回復するための重要な機能を提供する。登録済みメールアドレスを入力することで、システムが新しいパスワードを自動生成し、メールで送信する。これにより、パスワード紛失時のサポート負荷軽減とユーザーのセルフサービス化という業務課題を解決する。

**画面へのアクセス方法**：ログイン画面の「Forgotten your password?」リンクからアクセス。URLは`/auth/password`。

**主要な操作・処理内容**：
1. パスワードリセットフォームの表示（メールアドレス入力）
2. 入力メールアドレスのバリデーション
3. 登録済みメールアドレスの存在確認
4. 新しいパスワードの自動生成（8文字、英数字）
5. パスワードのハッシュ化とデータベース更新
6. 新パスワードをメールで送信
7. 送信完了メッセージの表示

**画面遷移**：
- 遷移元：ログイン画面
- 遷移先：送信完了後は同一画面に完了メッセージ表示、ログイン画面へのリンク

**権限による表示制御**：
- 既にログイン済みの場合、ホーム画面へリダイレクト
- 未認証ユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | パスワードリセット | 主機能 | パスワードリセットメールを送信 |
| 59 | メール送信 | 補助機能 | リセットリンクをメール送信 |

## 画面種別

入力（フォーム型）

## URL/ルーティング

- URL: `/auth/password`
- コントローラー: `AuthController`
- アクション: `passwordAction`
- モジュール: `default`
- HTTPメソッド: GET（表示）/ POST（リセット実行）

## 入出力項目

### 入力項目

| 項目名 | 入力/出力 | データ型 | 必須 | バリデーション | 説明 |
|--------|----------|---------|------|---------------|------|
| email | 入力 | string | はい | メールアドレス形式、DB存在確認 | 登録済みメールアドレス |

### 出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| posted | 出力 | string | - | 処理完了フラグ（'Y'/'N'） |
| messages | 出力 | array | - | バリデーションエラーメッセージ |
| email | 出力 | string | - | エラー時の入力値保持 |

## 表示項目

### フォーム項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| E-mail address | テキストボックス（幅340px） | 登録済みメールアドレス入力 |
| Reset Password | ボタン | リセット実行 |

### サイドバー

| 項目名 | 説明 |
|--------|------|
| noaccountbox | 新規登録案内ボックス |

## イベント仕様

### 1-パスワードリセット実行

「Reset Password」ボタンをクリックすると、フォームがPOST送信され、パスワードリセット処理が実行される。

- 送信先: `/auth/password/`
- 処理フロー:
  1. 入力メールアドレスのバリデーション
  2. 登録済みメールアドレスの存在確認
  3. 新パスワード生成（8文字）
  4. パスワードハッシュ化とDB更新
  5. 新パスワードをメール送信
  6. 完了メッセージ表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リセット実行 | users | SELECT | ユーザー情報を取得 |
| リセット実行 | users_profiles | SELECT | プロファイル情報を取得（JOINで結合） |
| リセット実行 | users | UPDATE | パスワードとsaltを更新 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id, user_email, etc. | user_email = {入力email} | JOIN users_profiles |
| UPDATE | user_password | MD5(site.key + 新パスワード + 新salt) | 新しいハッシュ値 |
| UPDATE | user_salt | 自動生成（8文字） | 新しいsalt |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 成功 | Your password has been reset - You should shortly receive an e-mail containing your new password. | リセット成功時 |
| MSG-002 | エラー | Missing E-mail Address - you did not enter an e-mail address | メールアドレス未入力時 |
| MSG-003 | エラー | Invalid E-mail Address | メールアドレス形式不正時 |
| MSG-004 | エラー | Invalid E-mail Address - entered e-mail address is not associated with an existing account | メールアドレス未登録時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| バリデーションエラー | フォームにメールアドレスを保持し、エラーメッセージを表示 |
| メールアドレス未登録 | "not associated with an existing account"エラー表示 |
| メール送信失敗 | システムエラー画面へ遷移 |

## 備考

- パスワード生成：generatepassword()メソッドで8文字の英数字を生成
- 生成文字セット：abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ023456789（紛らわしい文字を除外）
- パスワードハッシュ：MD5(site.key + password + salt)
- 新saltも同様に生成
- メール内容：サイト名、新パスワード、サイトURLを含む

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パスワードリセットに関連するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（347-361行目）のuser_password, user_saltカラム |
| 1-2 | database.sql | `database.sql` | users_profilesテーブル（457-477行目）のupro_first, upro_lastカラム |

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AuthController.php | `application/modules/default/controllers/AuthController.php` | passwordAction()メソッド（160-244行目） |
| 2-2 | AuthController.php | `application/modules/default/controllers/AuthController.php` | generatepassword()メソッド（37-52行目） |

**主要処理フロー**:
1. **162行目**: POSTリクエスト判定
2. **166-180行目**: バリデーター定義（Zend_Validate_Db_RecordExists含む）
3. **182行目**: Zend_Filter_Inputでバリデーション
4. **184行目**: バリデーション成功判定
5. **189-196行目**: ユーザー情報取得（users JOIN users_profiles）
6. **200-201行目**: 新パスワードと新salt生成
7. **204-207行目**: パスワードハッシュ化とDB更新
8. **210行目**: DB更新実行
9. **212-223行目**: メール送信
10. **225行目**: posted = 'Y'設定

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | password.phtml | `application/modules/default/views/scripts/auth/password.phtml` | メインテンプレート。フォームと完了メッセージ |

**主要処理フロー**:
- **26-30行目**: posted状態に応じたタイトル切り替え
- **36行目**: RenderMessages()でエラーメッセージ表示
- **38-40行目**: posted == 'Y'時のリセット完了メッセージ表示
- **46-68行目**: パスワードリセットフォーム

### プログラム呼び出し階層図

```
HTTP Request (/auth/password)
    |
    +-- AuthController::preDispatch()
    |       |
    |       +-- 認証状態チェック
    |       +-- [認証済み] ホームへリダイレクト
    |
    +-- AuthController::passwordAction()
            |
            +-- [POST時]
            |       |
            |       +-- Zend_Filter_Input - バリデーション
            |       |       |
            |       |       +-- EmailAddressバリデーター
            |       |       +-- Zend_Validate_Db_RecordExists
            |       |
            |       +-- [バリデーション成功]
            |       |       |
            |       |       +-- SELECT users JOIN users_profiles
            |       |       +-- generatepassword() x 2 (password, salt)
            |       |       +-- MD5ハッシュ計算
            |       |       +-- UPDATE users (password, salt)
            |       |       +-- Zend_Mail::send()
            |       |       +-- posted = 'Y'
            |       |
            |       +-- [バリデーション失敗]
            |               +-- エラーメッセージ設定
            |               +-- posted = 'N'
            |
            +-- ビューレンダリング
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム送信    ───▶ AuthController       ───▶ password.phtml
(POST)               ::passwordAction()        |
  |                        |                   +──▶ 成功: 完了メッセージ
  +-- email           バリデーション            |    + メール送信
                           |                   +──▶ 失敗: エラー表示
                      DB存在確認                    + フォーム再表示
                           |
                           ▼
                   generatepassword()
                           |
                           ▼
                      UPDATE users
                           |
                           ▼
                      Zend_Mail
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/default/controllers/AuthController.php` | ソース | 認証関連のコントローラー |
| password.phtml | `application/modules/default/views/scripts/auth/password.phtml` | テンプレート | パスワードリセット画面のメインビュー |
| noaccountbox.phtml | `application/modules/default/views/scripts/_partials/noaccountbox.phtml` | テンプレート | 新規登録案内ボックス |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | テンプレート | 情報メッセージ表示 |
| database.sql | `database.sql` | スキーマ | users, users_profilesテーブル定義 |
