# 画面設計書 60-ページ管理画面

## 概要

本ドキュメントは、Legacy CMS管理画面におけるページ管理画面の設計仕様を記載したものである。

### 本画面の処理概要

**業務上の目的・背景**：サイト内の固定ページ（静的コンテンツページ）を一覧管理するための画面である。CMSにおいて固定ページは重要なコンテンツタイプであり、本画面ではページの新規作成、編集、削除、フィルタリング、ソートなどの操作を提供する。

**画面へのアクセス方法**：管理画面のナビゲーションから「Pages」を選択して本画面に遷移する。

**主要な操作・処理内容**：
1. 登録済みページを一覧表示する（ページネーション付き）
2. 作成者でフィルタリングする
3. 各カラム（ページ名、作成者、URL、日付）でソートする
4. ソート順（昇順/降順）を切り替える
5. 「New Page」ボタンで新規ページを作成
6. ページ名クリックでページ編集画面に遷移
7. 「Edit」リンクでページ編集画面に遷移
8. 「Delete」リンクでページを削除（保護されていないページのみ）

**画面遷移**：
- 遷移元: 管理画面ナビゲーション
- 遷移先:
  - ページ編集画面（/admin/pages/edit/id/{id}）
  - ページ新規作成ダイアログ

**権限による表示制御**：
- 「New Page」ボタン: ppagenew権限を持つ場合のみ表示
- 「Edit」リンク: ppageedit権限を持つ場合のみ表示
- 「Delete」リンク: ppagedelete権限を持ち、かつページが保護されていない場合のみ表示
- 画面自体へのアクセス: ppages権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | ページ管理 | 主機能 | ページ一覧表示、フィルタ、ソート |
| 61 | アクセス制御 | 主機能 | 管理者権限チェックとページ管理 |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/pages/manage`
- パラメータ:
  - `author` - 作成者でフィルタ（ユーザーID、オプション）
  - `sort` - ソート対象カラム（page/author/slug/date、オプション）
  - `order` - ソート順（asc/desc、オプション）
  - `page` - ページ番号（オプション）
- アクション: `Admin_PagesController::manageAction()`

## 入出力項目

### 入力パラメータ

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 |
|--------|-------------|---------|------|------|
| 作成者ID | author | integer | 任意 | フィルタ用の作成者ID |
| ソート対象 | sort | string | 任意 | ソート対象カラム（page/author/slug/date） |
| ソート順 | order | string | 任意 | ソート順（asc/desc） |
| ページ番号 | page | integer | 任意 | ページネーション用 |

### 出力データ

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ページ一覧 | Paginator | ページ情報の配列（ページネーション対応） |
| フィルタ情報 | array | 適用中のフィルタ条件 |

## 表示項目

| 項目 | 表示内容 | 備考 |
|------|---------|------|
| 保護アイコン | 鍵アイコン | page_protected='Y'の場合表示 |
| Page | ページ名 | page_title、リンク付き |
| ステータス | (draft)表示 | page_status==draft時のみ表示 |
| Author | 作成者名 | user_alias、フィルタリンク付き |
| URL | ページスラッグ | page_slug |
| Date | 日付 | 公開日または最終編集日 |

## イベント仕様

### 1-New Pageボタン押下

ページ新規作成ダイアログを表示する。

- 表示条件: ppagenew権限を持つ場合
- 動作: Ajaxダイアログを表示
- 遷移先: `/admin/pages/new/`

### 2-ページ名リンククリック

ページ編集画面に遷移する。

- 動作: ページ編集画面に画面遷移
- 遷移先: `/admin/pages/edit/id/{page_id}`

### 3-Editリンククリック

ページ編集画面に遷移する。

- 表示条件: ppageedit権限を持つ場合
- 動作: ページ編集画面に画面遷移
- 遷移先: `/admin/pages/edit/id/{page_id}`

### 4-Deleteリンククリック

ページ削除ダイアログを表示する。

- 表示条件: ppagedelete権限を持ち、かつページが保護されていない（page_protected != 'Y'）場合
- 動作: Ajaxダイアログで削除確認を表示
- 遷移先: `/admin/pages/delete/id/{page_id}/`

### 5-作成者リンククリック

作成者でフィルタリングする。

- 動作: 同じ作成者のページのみ表示
- 遷移先: `/admin/pages/manage?author={page_user}`

### 6-カラムヘッダクリック（ソート）

指定カラムでソートする。

- 対象カラム: Page（page_title）、Author（user_alias）、URL（page_slug）、Date（page_date）
- 動作: 指定カラムでソート（初回クリック時は降順）
- 遷移先: `/admin/pages/manage?sort={カラム名}`

### 7-ソート順切替（矢印クリック）

ソート順を昇順/降順で切り替える。

- 動作: 現在のソート順を反転
- 遷移先: `/admin/pages/manage?order={asc|desc}`

### 8-フィルタ解除（タグクリック）

適用中のフィルタを解除する。

- 動作: フィルタパラメータをNULLにしてページを再読み込み
- 処理: クリックされたフィルタタグに対応するパラメータをクリア

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ一覧表示 | pages | SELECT | ページ情報を取得（フィルタ・ソート条件付き） |
| ページ一覧表示 | users | JOIN | 作成者情報を取得 |
| 作成者フィルタ | users | SELECT | 作成者名を取得 |

### テーブル別更新項目詳細

#### pagesテーブル（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | page_id | 全件 | ページID |
| SELECT | page_title | 全件 | ページ名 |
| SELECT | page_user | WHERE条件/全件 | 作成者ID、フィルタ可能 |
| SELECT | page_slug | 全件 | ページスラッグ（URL） |
| SELECT | page_status | 全件 | ステータス（draft/published） |
| SELECT | page_protected | 全件 | 保護フラグ（Y/N） |
| SELECT | page_date | 全件 | 作成日 |
| SELECT | page_edit | 全件 | 最終編集日 |
| SELECT | page_published | 全件 | 公開日 |

#### usersテーブル（JOIN/SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| JOIN | user_alias | ON page_user = user_id | 作成者名 |
| SELECT | user_alias | WHERE user_id = ? | フィルタ用作成者名取得 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|---------------|---------------|---------|
| 情報 | No Pages! | ページが1件も存在しない場合 |
| 情報 | No active filter | フィルタが適用されていない場合 |
| 確認 | Are you sure you want to delete this page? | 削除リンククリック時 |
| 成功 | Page Deleted | 削除処理成功時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ページが存在しない | 「No Pages!」メッセージを表示 |
| 権限不足 | 権限エラー画面（privileges）にフォワード |

## 備考

- 1ページあたり15件表示、ページ範囲は5
- デフォルトソートは日付降順
- フィルタはAuthor、Sort、Orderの3種類
- フィルタタグはクリックで解除可能（マウスオーバーで削除表示に変更）
- ソート順トグルは矢印アイコンで視覚的に表示（上矢印=降順、下矢印=昇順）
- 保護されたページ（page_protected='Y'）は鍵アイコンで表示され、削除不可
- ステータスがdraftのページは「(draft)」表示
- 公開済みページは公開日、未公開ページは最終編集日を表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページデータの構造とフィルタ条件を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | manage.phtml | `application/modules/admin/views/scripts/pages/manage.phtml` | pagesArrayの構造を確認 |
| 1-2 | Pages.php | `application/models/Pages.php` | fetchPages()、getFilter()メソッドを確認 |

**読解のコツ**: pagesArrayはZend_Paginatorオブジェクトで、foreachでループ可能。各要素はpagesテーブルのレコード＋usersテーブルのuser_aliasを含む。filterはauthor、sort、order、orderoptを持つ配列。

#### Step 2: エントリーポイントを理解する

コントローラのmanageActionが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PagesController.php | `application/modules/admin/controllers/PagesController.php` | manageAction()メソッドの処理フローを確認 |

**主要処理フロー**:
1. **31行目**: 権限チェック（ppages）
2. **33-34行目**: ページネーション設定（items=15、range=5）
3. **36行目**: リクエストパラメータを取得
4. **38行目**: Pagesモデルをインスタンス化
5. **40行目**: getFilter()でフィルタ情報を取得しビューに渡す
6. **41行目**: fetchPages()でページ一覧を取得しビューに渡す

#### Step 3: モデル層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Pages.php | `application/models/Pages.php` | getFilter()とfetchPages()の処理を確認 |

**getFilter()の処理フロー（39-77行目）**:
1. **43-55行目**: authorパラメータが指定されている場合、usersテーブルから作成者名を取得
2. **57-61行目**: sortパラメータを取得（デフォルトはdate）
3. **63-74行目**: orderパラメータを取得し、orderoptを設定（トグル用）

**fetchPages()の処理フロー（84-140行目）**:
1. **86-90行目**: orderパラメータを取得（デフォルトはDESC）
2. **92-94行目**: pagesテーブルとusersテーブルをJOIN
3. **96-98行目**: authorパラメータでフィルタ
4. **100-114行目**: sortパラメータでソート順を決定
5. **116-132行目**: ページネーションパラメータを設定
6. **134-139行目**: Zend_Paginatorを作成して返却

#### Step 4: ビューテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | manage.phtml | `application/modules/admin/views/scripts/pages/manage.phtml` | 表示ロジックとフィルタUIを確認 |

**主要処理フロー**:
- **34-39行目**: Functionsフィールドセット（New Pageボタン）
- **44-52行目**: Filterフィールドセット（フィルタタグ表示）
- **58-97行目**: テーブルヘッダ（ソートリンク付き）
- **99-131行目**: ページデータのループ表示
- **104-106行目**: 保護アイコンの条件表示
- **109行目**: ページ名リンク（draftの場合は「(draft)」を付加）
- **110行目**: Edit/Deleteリンク（権限による表示制御）
- **112行目**: 作成者リンク（フィルタ用）
- **114-122行目**: 日付表示（公開日または最終編集日）
- **134-141行目**: ページネーション

### プログラム呼び出し階層図

```
リクエスト (/admin/pages/manage?author=x&sort=y&order=z&page=n)
    │
    └─ Admin_PagesController::manageAction()
           │
           ├─ ACL権限チェック (ppages)
           │
           ├─ リクエストパラメータ設定
           │      ├─ items = 15
           │      └─ range = 5
           │
           ├─ Pages::getFilter()
           │      │
           │      ├─ author指定時
           │      │      └─ users SELECT (user_alias取得)
           │      │
           │      ├─ sortパラメータ取得 (デフォルト: date)
           │      │
           │      └─ orderパラメータ取得 (デフォルト: desc)
           │             └─ orderopt設定 (トグル用)
           │
           ├─ Pages::fetchPages()
           │      │
           │      ├─ Zend_Db_Select
           │      │      ├─ FROM pages
           │      │      ├─ JOIN users
           │      │      ├─ WHERE page_user = ? (author指定時)
           │      │      └─ ORDER BY {sort} {order}
           │      │
           │      └─ Zend_Paginator
           │             ├─ setCurrentPageNumber()
           │             ├─ setItemCountPerPage(15)
           │             └─ setPageRange(5)
           │
           └─ ビューレンダリング
                  └─ manage.phtml
```

### データフロー図

```
[入力]                [処理]                       [出力]

リクエスト          PagesController            HTML画面
(author, sort, ──▶ manageAction() ──▶         (ページ一覧)
 order, page)          │
                       ├─▶ Pages::getFilter()
                       │        │
                       │        ▼
                       │    users テーブル
                       │   (作成者名取得)
                       │        │
                       │        ▼
                       │    filter配列
                       │
                       └─▶ Pages::fetchPages()
                                │
                                ▼
                          pages + users
                            テーブル
                       (JOIN, フィルタ, ソート)
                                │
                                ▼
                          Zend_Paginator
                        (ページネーション)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PagesController.php | `application/modules/admin/controllers/PagesController.php` | ソース | ページ関連アクションのコントローラ |
| Pages.php | `application/models/Pages.php` | ソース | ページ管理のモデル |
| manage.phtml | `application/modules/admin/views/scripts/pages/manage.phtml` | テンプレート | ページ一覧表示のビュー |
| default.phtml | `application/views/scripts/_pagination/default.phtml` | テンプレート | ページネーションの共通テンプレート |
| common.js | `_scripts/admin/common.js` | JavaScript | 共通JavaScript関数（getDialog, goTo, toggleVis等） |
