# 画面設計書 62-ページ新規作成画面

## 概要

本ドキュメントは、Legacy CMSの管理画面における「ページ新規作成画面」の設計仕様を定義するものである。この画面はAjaxダイアログとして表示され、新規静的ページの作成を行う。

### 本画面の処理概要

**業務上の目的・背景**：CMSにおいて新しい静的ページを追加する際の入り口となる画面である。静的ページは企業のWebサイトで「会社概要」「お問い合わせ」「プライバシーポリシー」などの固定コンテンツを管理するために使用される。本画面は最小限の入力項目（タイトルのみ）でページの骨組みを作成し、詳細な編集は編集画面で行う設計となっている。これにより、迅速なページ作成と段階的なコンテンツ追加のワークフローを実現している。

**画面へのアクセス方法**：管理画面にログイン後、ページ管理画面（/admin/pages/manage/）の「New Page」ボタンをクリックすることでAjaxダイアログとして表示される。直接URLアクセスも可能（/admin/pages/new/）だが、通常はダイアログ経由でアクセスする。

**主要な操作・処理内容**：
1. ページタイトルの入力（必須）
2. 「Create」ボタンで新規ページを作成
3. 作成成功後、編集画面へ自動遷移
4. 「Cancel」ボタンでダイアログを閉じる

**画面遷移**：ページ管理画面（manage.phtml）からAjaxダイアログとして呼び出される。作成成功後はページ編集画面（/admin/pages/edit/id/{new_page_id}/）へ遷移する。キャンセル時はダイアログが閉じてページ管理画面に留まる。

**権限による表示制御**：`ppages`権限と`ppagenew`権限の両方が必要。権限がない場合は権限エラー画面へフォワードされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | ページ新規作成 | 主機能 | 新規ページの作成処理 |
| 63 | 入力検証 | 補助機能 | ページフォームのバリデーション |
| 60 | 検索インデックス更新 | 補助機能 | 保存時に検索インデックスを更新 |
| 64 | Ajaxダイアログ | 補助機能 | アセット選択などのダイアログ表示 |

## 画面種別

登録（Ajaxダイアログ）

## URL/ルーティング

- URL: `/admin/pages/new/`
- モジュール: admin
- コントローラー: PagesController
- アクション: newAction

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|----------|------|--------|----------|------|
| タイトル | pagetitle | string | Yes | - | テキスト入力 | ValidationTextBox使用 |

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|--------------|----------|------|
| エラーメッセージ | バリデーションエラー | テキスト | RenderMessages()で表示 |

## イベント仕様

### 1-Createボタン押下

Ajaxダイアログ経由で `/admin/pages/new/` にPOSTリクエストを送信する。タイトルのバリデーション成功時はpagesテーブルに新規レコードを挿入し、作成されたページIDを取得して編集画面へリダイレクトする「Continue」ボタンを表示する。バリデーション失敗時はエラーメッセージとともにフォームを再表示する。

### 2-Cancelボタン押下

Ajaxダイアログを閉じ、呼び出し元のページ管理画面に戻る。データの送信は行われない。

### 3-Continueボタン押下（作成成功後）

新規作成されたページの編集画面（/admin/pages/edit/id/{new_page_id}/）へリダイレクトする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Createボタン押下 | pages | INSERT | 新規ページレコードを作成 |

### テーブル別更新項目詳細

#### pages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | page_title | フォーム入力値 | 必須 |
| INSERT | page_user | ログインユーザーのuser_id | 作成者 |
| INSERT | page_date | NOW() | 作成日時 |
| INSERT | page_edit | NOW() | 最終編集日時 |
| INSERT | page_status | 'draft'（デフォルト） | 初期状態は下書き |
| INSERT | page_content | NULL（デフォルト） | 編集画面で設定 |
| INSERT | page_slug | NULL（デフォルト） | 編集画面で設定 |
| INSERT | page_section | NULL（デフォルト） | 編集画面で設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | 成功 | Page Created | 作成成功時 |
| MSG002 | エラー | Title is required | タイトル未入力時 |

## 例外処理

| 例外状態 | 対応処理 |
|----------|----------|
| 権限不足（ppagesまたはppagenew権限なし） | 権限エラー画面へフォワード |
| バリデーションエラー | エラーメッセージを表示しフォームを再表示 |
| データベース挿入エラー | 例外をスロー（システムエラー画面へ） |

## 備考

- 本画面はAjaxダイアログとして設計されており、レイアウトは無効化されている（disableLayout）
- 新規作成時はタイトルのみを設定し、コンテンツ、URL、セクション等は編集画面で設定する二段階のワークフローとなっている
- 新規作成されたページのステータスは自動的に「draft」（下書き）となり、公開するには編集画面で明示的に公開操作が必要
- 作成者（page_user）には現在ログインしているユーザーのIDが自動的に設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページ新規作成時に設定されるデータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Pages.php | `application/models/Pages.php` | newPage()メソッドでINSERTされるカラムを確認 |

**読解のコツ**: newPage()メソッドは最小限のカラムのみを設定し、残りはデフォルト値またはNULLとなる点に注意。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PagesController.php | `application/modules/admin/controllers/PagesController.php` | newAction()メソッド（335-394行目）が処理の起点 |

**主要処理フロー**:
1. **337行目**: 権限チェック（ppagesとppagenew）
2. **339行目**: レイアウトを無効化（Ajaxダイアログ用）
3. **341行目**: POSTリクエストかどうかを判定
4. **343-353行目**: バリデーションルールの定義
5. **355-362行目**: バリデーション成功時の新規ページ作成
6. **368行目**: 作成されたページIDを取得してContinueボタンを表示

#### Step 3: ビューテンプレートを理解する

Ajaxダイアログとして表示されるビューファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new.phtml | `application/modules/admin/views/scripts/pages/new.phtml` | フォームUI構造、Dojo Toolkitウィジェット |

**主要処理フロー**:
- **9行目**: $this->posted == 'N'の場合のみフォームを表示
- **10行目**: エラーメッセージの表示（RenderMessages）
- **14-24行目**: タイトル入力フィールド（ValidationTextBox）
- **28-33行目**: Createボタン（doDialog()でPOST送信）
- **34-39行目**: Cancelボタン（ダイアログを閉じる）

#### Step 4: モデル層の処理を理解する

データベースへの挿入処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Pages.php | `application/models/Pages.php` | newPage()メソッド（166-181行目） |

**主要処理フロー**:
- **168行目**: タイトルと作成者IDの必須チェック
- **170-175行目**: INSERTするデータの構築（title, user, date, edit）
- **177行目**: pagesテーブルへのINSERT実行

### プログラム呼び出し階層図

```
newAction() [PagesController.php:335]
    │
    ├─ acl->isAllowed() [権限チェック]
    │
    ├─ _helper->layout->disableLayout() [レイアウト無効化]
    │
    ├─ _request->isPost() [POSTリクエスト判定]
    │      │
    │      └─ [POST時]
    │              │
    │              ├─ Zend_Filter_Input [バリデーション]
    │              │
    │              └─ Pages->newPage() [Pages.php:166]
    │                     │
    │                     └─ registry->db->insert() [DB挿入]
    │
    └─ View rendering [new.phtml]
           │
           ├─ [成功時] Continueボタン表示
           │       └─ goTo('/admin/pages/edit/id/{id}')
           │
           └─ [エラー時] フォーム再表示
                   └─ RenderMessages()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力 ─────────▶ PagesController ─────────▶ Ajaxダイアログ
(pagetitle)             newAction()                (成功: Continueボタン)
                             │                     (エラー: フォーム再表示)
                             │
                             ▼
                        Zend_Filter_Input
                        (バリデーション)
                             │
                             ▼
                        Pages->newPage()
                             │
                             └──────────▶ pagesテーブル
                                          (INSERT)
                                               │
                                               ▼
                                          lastInsertId()
                                          (新規ページID取得)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PagesController.php | `application/modules/admin/controllers/PagesController.php` | ソース | ページ管理のコントローラー |
| Pages.php | `application/models/Pages.php` | ソース | ページデータのモデル |
| new.phtml | `application/modules/admin/views/scripts/pages/new.phtml` | テンプレート | 新規作成ダイアログのビュー |
| manage.phtml | `application/modules/admin/views/scripts/pages/manage.phtml` | テンプレート | ページ管理画面（呼び出し元） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog()等の共通関数 |
| template.css | `public/_styles/admin/template.css` | スタイル | 管理画面共通スタイル |
