# 画面設計書 64-メール管理画面

## 概要

本ドキュメントは、Legacy CMSの管理画面における「メール管理画面」の設計仕様を定義するものである。この画面は送信済みメールおよび下書きメールの一覧表示と管理機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：組織のWebサイト運営において、ユーザーやメーリングリスト購読者へのメール配信は重要なコミュニケーション手段である。本画面は、管理者が過去に送信したメールや作成中の下書きメールを一覧で確認し、新規メールの作成、メーリングリストの管理を行うための中央ハブとなる。メールはメーリングリスト（グループ）宛、ロール宛、個別ユーザー宛の3種類の送信タイプをサポートしており、それぞれのフィルタリングが可能である。

**画面へのアクセス方法**：管理画面にログイン後、サイドメニューまたはダッシュボードから「Mail」を選択することでアクセスする。URLは `/admin/mail/manage/` または `/admin/mail/`（indexActionからリダイレクト）。

**主要な操作・処理内容**：
1. メール一覧の表示（件名、宛先、著者、日時）
2. 送信済み/下書きによるステータスフィルタリング
3. メーリングリスト、ロール、ユーザー、著者によるフィルタリング
4. 件名、著者、日付によるソート
5. 新規メールの作成（メーリングリスト宛/ロール宛）
6. メーリングリストの新規作成・編集・削除
7. メールの編集画面への遷移
8. メールの削除

**画面遷移**：管理ダッシュボードから遷移可能。メール編集画面、メーリングリスト編集画面へ遷移できる。新規メール作成、新規メーリングリスト作成はAjaxダイアログで表示される。

**権限による表示制御**：`mmail`権限が必要。メーリングリスト新規作成には追加で`urolenew`権限が必要。メール削除には`mmaildelete`権限が必要。メーリングリスト削除には`mlistdelete`権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 58 | メール一覧表示 | 主機能 | 送信済みメール一覧を表示 |
| 62 | ページネーション | 補助機能 | メール一覧のページ送り処理 |
| 61 | アクセス制御 | 補助機能 | 管理者権限チェック |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/mail/manage/`
- 別名: `/admin/mail/`（indexActionからリダイレクト）
- モジュール: admin
- コントローラー: MailController
- アクション: manageAction

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| ページ番号 | page | integer | No | URLパラメータ | ページネーション用 |
| ステータスフィルタ | status | string | No | URLパラメータ | 'sent'または'draft' |
| グループフィルタ | group | integer | No | URLパラメータ | メーリングリストID |
| ロールフィルタ | role | integer | No | URLパラメータ | ロールID |
| ユーザーフィルタ | user | integer | No | URLパラメータ | ユーザーID |
| 著者フィルタ | author | integer | No | URLパラメータ | 作成者のユーザーID |
| ソート項目 | sort | string | No | URLパラメータ | 'subject','author','date' |
| ソート順 | order | string | No | URLパラメータ | 'asc'または'desc' |

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|--------------|----------|------|
| 件名 | mail.mail_subject | リンク | 編集画面へのリンク |
| ステータス | mail.mail_status | テキスト | '(draft)'として表示 |
| 宛先 | mail.mail_slave, mail.mail_type | テキスト | mgetTo()で変換 |
| 著者 | users.user_alias | リンク | フィルタリンク |
| 日付 | mail.mail_date/mail_sent | d/m/Y H:i | 送信済みはmail_sent、下書きはmail_date |
| Sent件数 | COUNT(status='sent') | テキスト | ステータスフィルタ内 |
| Draft件数 | COUNT(status='draft') | テキスト | ステータスフィルタ内 |
| メーリングリスト一覧 | mail_groups | タグ形式 | 各リストの投稿数を表示 |

## イベント仕様

### 1-New Mailボタン押下（ドロップダウン）

ドロップダウンメニューが表示され、「Mailing List」または「Role」を選択できる。選択に応じてgetDialog()でそれぞれのダイアログを呼び出す。

### 2-New Mailing Listボタン押下

`urolenew`権限がある場合のみ表示。getDialog()で `/admin/mail/groupnew/` を呼び出し、メーリングリスト新規作成ダイアログを表示する。

### 3-メール件名リンク押下

該当メールの編集画面（/admin/mail/edit/id/{mail_id}/）へ遷移する。

### 4-Editリンク押下

マウスオーバーで表示される。該当メールの編集画面へ遷移する。

### 5-Deleteリンク押下

`mmaildelete`権限があり、かつメールが送信済みでない場合のみ表示。getDialog()で削除確認ダイアログを呼び出す。

### 6-ステータスフィルタ押下（Sent/Draft）

URLパラメータにstatus=sent/draftを追加してリロードし、フィルタリングを適用する。

### 7-メーリングリスト名押下

該当メーリングリストに紐づくメールのみを表示するフィルタを適用する。

### 8-メーリングリスト右クリック

コンテキストメニューが表示され、「Delete」または「Edit」を選択できる。

### 9-ソートヘッダー押下

件名、著者、日付のカラムヘッダーをクリックすると、そのカラムでソートを適用する。既にソート中の場合は昇順/降順を切り替える。

### 10-フィルタタグ押下

適用中のフィルタタグをクリックすると、そのフィルタを解除する。

## データベース更新仕様

本画面は一覧表示が主目的であり、直接的なデータベース更新は行わない。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | mail | SELECT | メール一覧を取得 |
| 画面表示 | mail_groups | SELECT | メーリングリスト一覧を取得 |
| 画面表示 | users | SELECT | 著者情報を取得（JOIN） |

### テーブル別更新項目詳細

#### mail（SELECT）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|----------|------|
| SELECT | mail_id | - | 主キー |
| SELECT | mail_subject | - | 件名 |
| SELECT | mail_status | フィルタ条件 | ステータス |
| SELECT | mail_type | - | 送信タイプ（G/R/U） |
| SELECT | mail_slave | - | 宛先ID |
| SELECT | mail_date | ORDER BY | 更新日時 |
| SELECT | mail_sent | ORDER BY | 送信日時 |
| SELECT | mail_user | JOIN条件 | 著者ID |

#### mail_groups（SELECT）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|----------|------|
| SELECT | mgroup_id | - | 主キー |
| SELECT | mgroup_title | - | タイトル |
| SELECT | mgroup_status | - | ステータス |
| SELECT | mgroup_open | - | オープン/クローズドリスト |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | 情報 | No Mail! | メール一覧が空の場合 |
| MSG002 | 情報 | No Mailing Lists! | メーリングリストが空の場合 |
| MSG003 | 情報 | No active filter | フィルタが適用されていない場合 |

## 例外処理

| 例外状態 | 対応処理 |
|----------|----------|
| 権限不足（mmail権限なし） | 権限エラー画面へフォワード |
| 不正なフィルタパラメータ | 無視して通常表示 |

## 備考

- メール送信タイプは3種類：G（グループ/メーリングリスト宛）、R（ロール宛）、U（ユーザー宛）
- メーリングリストには「オープンリスト」（誰でも購読可能）と「クローズドリスト」（管理者のみが購読を管理）がある
- 鍵アイコンはクローズドリストを示す
- ID=1のメーリングリストはシステム既定のリストであり、削除不可
- ページネーションはZend_Paginatorを使用し、1ページあたり15件表示、ページ範囲は5

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メールとメーリングリストのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mail.php | `application/models/Mail.php` | mailテーブルとmail_groupsテーブルの構造 |

**読解のコツ**: fetchMails()メソッドのSELECT文でカラム構造を確認。getFilter()メソッドでフィルタパラメータの解析処理を理解。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MailController.php | `application/modules/admin/controllers/MailController.php` | manageAction()メソッド（29-50行目） |

**主要処理フロー**:
1. **31行目**: 権限チェック（mmail）
2. **33-34行目**: ページネーション設定（15件/ページ、範囲5）
3. **36行目**: リクエストパラメータの取得
4. **38-42行目**: Mailモデルでフィルタ、メール一覧、グループ一覧を取得

#### Step 3: ビューテンプレートを理解する

一覧表示を担当するビューファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | manage.phtml | `application/modules/admin/views/scripts/mail/manage.phtml` | 一覧UI構造、フィルタ、ソート、ページネーション |

**主要処理フロー**:
- **36-48行目**: 機能ボタンエリア（New Mail、New Mailing List）
- **53-65行目**: フィルタ表示エリア
- **75-79行目**: ステータスフィルタ（Sent/Draft）
- **84-109行目**: メーリングリスト一覧
- **115-174行目**: メール一覧テーブル
- **176-183行目**: ページネーション

#### Step 4: モデル層の処理を理解する

データ取得処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Mail.php | `application/models/Mail.php` | fetchMails()、fetchGroups()、getFilter() |

**主要処理フロー**:
- **39-127行目**: getFilter() - フィルタパラメータの解析と正規化
- **134-211行目**: fetchMails() - フィルタとソートを適用したメール一覧取得
- **217-224行目**: fetchGroups() - メーリングリスト一覧取得

### プログラム呼び出し階層図

```
manageAction() [MailController.php:29]
    │
    ├─ acl->isAllowed() [権限チェック]
    │
    ├─ _request->setParam() [ページネーション設定]
    │
    ├─ Mail->getFilter() [Mail.php:39]
    │      └─ registry->db->fetchAll() [フィルタ名の取得]
    │
    ├─ Mail->fetchMails() [Mail.php:134]
    │      │
    │      ├─ Zend_Paginator::factory() [ページネーション]
    │      │
    │      └─ registry->db->select() [クエリビルダー]
    │             ├─ from('mail')
    │             ├─ join('users')
    │             ├─ where() [各種フィルタ]
    │             └─ order() [ソート]
    │
    └─ Mail->fetchGroups() [Mail.php:217]
           └─ registry->db->fetchall() [グループ一覧取得]

[ボタン/リンク押下時]
New Mail (List) ─▶ getDialog() ─▶ /admin/mail/maillist/
New Mail (Role) ─▶ getDialog() ─▶ /admin/mail/mailrole/
New Mailing List ▶ getDialog() ─▶ /admin/mail/groupnew/
Edit ────────────▶ goTo() ──────▶ /admin/mail/edit/id/{id}/
Delete ──────────▶ getDialog() ─▶ /admin/mail/delete/id/{id}/
Edit List ───────▶ goTo() ──────▶ /admin/mail/group/id/{id}/
Delete List ─────▶ getDialog() ─▶ /admin/mail/groupdelete/id/{id}/
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ─────────▶ MailController ─────────▶ HTMLレスポンス
(status, group,          manageAction()              (メール一覧画面)
 role, user,                  │
 author, sort,                │
 order, page)                 ▼
                        Mail->getFilter()
                        (フィルタ解析)
                              │
                              ▼
                        Mail->fetchMails()
                              │
                              ├──────────▶ mailテーブル
                              │            (SELECT + フィルタ)
                              │
                              └──────────▶ usersテーブル
                                           (JOIN - 著者名)
                                                │
                              ▼                 │
                        Mail->fetchGroups()     │
                              │                 │
                              └──────────▶ mail_groupsテーブル
                                           (SELECT)
                                                │
                                                ▼
                                           manage.phtml
                                           (一覧HTML生成)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MailController.php | `application/modules/admin/controllers/MailController.php` | ソース | メール管理のコントローラー |
| Mail.php | `application/models/Mail.php` | ソース | メールデータのモデル |
| manage.phtml | `application/modules/admin/views/scripts/mail/manage.phtml` | テンプレート | メール管理画面のビュー |
| maillist.phtml | `application/modules/admin/views/scripts/mail/maillist.phtml` | テンプレート | メーリングリスト宛メール作成ダイアログ |
| mailrole.phtml | `application/modules/admin/views/scripts/mail/mailrole.phtml` | テンプレート | ロール宛メール作成ダイアログ |
| groupnew.phtml | `application/modules/admin/views/scripts/mail/groupnew.phtml` | テンプレート | メーリングリスト新規作成ダイアログ |
| default.phtml | `application/modules/admin/views/scripts/_pagination/default.phtml` | テンプレート | ページネーションパーシャル |
| common.js | `public/_scripts/admin/common.js` | JavaScript | 共通ユーティリティ関数 |
| template.css | `public/_styles/admin/template.css` | スタイル | 管理画面共通スタイル |
