# 画面設計書 66-メール詳細画面

## 概要

本ドキュメントは、Legacy CMSの管理画面における「メール詳細画面」の設計仕様を定義するものである。この画面はメール編集画面内にAjax経由で読み込まれるパーシャルビューであり、メールの詳細情報と操作ボタンを表示する。

### 本画面の処理概要

**業務上の目的・背景**：メール編集画面において、ユーザーがメールの現在の状態（著者、ステータス、送信日時/最終編集日時）を一目で確認できるようにするとともに、保存・削除・送信などの主要な操作ボタンを提供する。この情報パネルにより、メール作成作業中でも基本情報を常に把握でき、適切なタイミングで操作を実行できる。特に、送信済みメールと下書きメールで操作可能なボタンが異なるため、現在のステータスを明確に表示することが重要である。

**画面へのアクセス方法**：メール編集画面（/admin/mail/edit/id/{mail_id}/）の読み込み時に、ContentPaneウィジェットにより `/admin/mail/details?id={mail_id}` からAjax経由で自動的に読み込まれる。直接URLアクセスも技術的には可能だが、レイアウトなしの部分的なHTMLが返されるため、通常は編集画面経由でのみ使用される。

**主要な操作・処理内容**：
1. メールの著者名、ステータス、送信日時/最終編集日時の表示
2. 「Save」ボタンによるメール保存処理の実行（下書き時のみ）
3. 「Delete」ボタンによるメール削除処理の実行（下書き時のみ）
4. 「Send Test」ボタンによるテストメール送信（下書き時のみ）
5. 「Send」ボタンによる本メール送信（下書き時のみ）
6. 「Mail...」ボタンによるメール管理画面への遷移

**画面遷移**：本画面自体は遷移元/遷移先を持たないパーシャルビューである。各ボタンはAjaxダイアログを表示するか、メール管理画面へリダイレクトする。

**権限による表示制御**：`uusers`権限と`uview`権限が必要。送信済みメール（mail_status = 'sent'）の場合、Save、Delete、Send Test、Sendボタンが非表示となる。Delete機能には`mmaildelete`権限、Send機能には`mmailsend`権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 58 | メール一覧表示 | 主機能 | メールの詳細情報を表示 |

## 画面種別

詳細（パーシャルビュー/Ajax読み込み）

## URL/ルーティング

- URL: `/admin/mail/details?id={mail_id}`
- モジュール: admin
- コントローラー: MailController
- アクション: detailsAction

## 入出力項目

本画面はGETパラメータのみを受け取り、表示専用である。

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| メールID | id | integer | Yes | URLパラメータ | 表示対象のメールを指定 |

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|--------------|----------|------|
| 著者名 | users.user_alias | テキスト | "Author: {著者名}" |
| ステータス | mail.mail_status | テキスト | ucwords()で整形、"Status: {ステータス}" |
| 送信日時 | mail.mail_sent | d/m/Y H:i | 送信済みの場合のみ表示、"Sent: {日時}" |
| 最終編集日時 | mail.mail_date | d/m/Y H:i | 下書き状態の場合のみ表示、"Last Edited: {日時}" |

## イベント仕様

### 1-Saveボタン押下

送信済みでない場合のみ表示。FCKeditorの内容を更新した後、postDialog()関数を使用して `/admin/mail/save/id/{mail_id}/` にPOSTリクエストを送信する。editFormの内容がフォームデータとして送信され、結果はAjaxダイアログに表示される。

### 2-Deleteボタン押下

`mmaildelete`権限があり、かつ送信済みでない場合のみ表示。getDialog()関数を使用して `/admin/mail/delete/id/{mail_id}/` を呼び出し、削除確認ダイアログを表示する。

### 3-Send Testボタン押下

`mmailsend`権限があり、かつ送信済みでない場合のみ表示。FCKeditorの内容を更新した後、getDialog()関数を使用して `/admin/mail/sendtest/id/{mail_id}/` を呼び出す。現在ログインしているユーザー宛にテストメールが送信される。

### 4-Sendボタン押下

`mmailsend`権限があり、かつ送信済みでない場合のみ表示。FCKeditorの内容を更新した後、getDialog()関数を使用して `/admin/mail/send/id/{mail_id}/` を呼び出す。確認後、本メールが送信される。

### 5-Mail...ボタン押下

goTo()関数を使用して `/admin/mail/` にリダイレクトする。メール管理画面に戻る。

## データベース更新仕様

本画面は表示専用であり、直接的なデータベース更新は行わない。ボタン押下時に呼び出される各アクション（save, delete, sendtest, send）でデータベース更新が行われる。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Saveボタン押下 | mail | - | saveActionへ遷移（本画面では更新しない） |
| Deleteボタン押下 | mail | - | deleteActionへ遷移（本画面では更新しない） |
| Send Testボタン押下 | mail | - | sendtestActionへ遷移（本画面では更新しない） |
| Sendボタン押下 | mail | - | sendActionへ遷移（本画面では更新しない） |

### テーブル別更新項目詳細

本画面ではデータベース更新は行わない。detailsAction()はSELECTのみを実行する。

#### mail（SELECT）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|----------|------|
| SELECT | mail_id | WHERE mail_id = {id} | 主キー |
| SELECT | mail_status | - | 表示用、ボタン表示制御用 |
| SELECT | mail_date | - | 最終編集日時 |
| SELECT | mail_sent | - | 送信日時 |
| SELECT | mail_user | JOIN条件 | 著者ID |

## メッセージ仕様

本画面自体はメッセージを表示しない。ボタン押下時に呼び出される各アクションでメッセージが表示される。

## 例外処理

| 例外状態 | 対応処理 |
|----------|----------|
| メールIDが未指定または無効 | 空のレスポンスを返す（エラー画面は表示しない） |
| 該当メールが存在しない | 空のレスポンスを返す |
| 権限不足（uusersまたはuview権限なし） | 権限エラー画面へフォワード |

## 備考

- 本画面はメール編集画面（edit.phtml）のContentPaneウィジェットに読み込まれるパーシャルビューである
- レイアウトは無効化されており（disableLayout）、本画面のHTMLのみが返される
- FCKeditorの更新はMyFCKObject.UpdateEditorFormValue()で行われるが、この処理は本画面ではなく編集画面側で定義されている
- 日時表示にはビューヘルパーMakeDate()を使用している
- 送信済みメールは閲覧のみ可能で、編集・削除・再送信はできない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

詳細画面で表示されるメールデータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mail.php | `application/models/Mail.php` | fetchMail()メソッドで取得されるカラムを確認 |

**読解のコツ**: fetchMail()はmailテーブルとusersテーブルをJOINしており、user_aliasも取得している点に注意。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MailController.php | `application/modules/admin/controllers/MailController.php` | detailsAction()メソッド（243-259行目） |

**主要処理フロー**:
1. **245行目**: 権限チェック（uusersとuview）
2. **247行目**: レイアウトを無効化（Ajax読み込み用）
3. **249行目**: URLパラメータからメールIDを取得
4. **251-252行目**: Mailモデルを使用してメールデータを取得
5. ビューに$mailArrayを渡してレンダリング

#### Step 3: ビューテンプレートを理解する

Ajax読み込みされるビューファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | details.phtml | `application/modules/admin/views/scripts/mail/details.phtml` | 詳細情報の表示とボタンの配置 |

**主要処理フロー**:
- **9-24行目**: 左カラム - 詳細情報（著者、ステータス、日時）
- **15行目**: 著者名の表示
- **16行目**: ステータスの表示（ucwords()で整形）
- **18-22行目**: 送信日時または最終編集日時の条件付き表示
- **26-46行目**: 右カラム - 機能ボタン
- **33行目**: 送信済みでない場合のブロック開始
- **34行目**: Saveボタン
- **35行目**: Deleteボタン（mmaildelete権限時のみ）
- **36-38行目**: Send Test、Sendボタン（mmailsend権限時のみ）
- **40行目**: Mail...ボタン

#### Step 4: 親画面との連携を理解する

詳細画面が読み込まれる親画面を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | edit.phtml | `application/modules/admin/views/scripts/mail/edit.phtml` | ContentPaneによるAjax読み込み（45行目） |

**主要処理フロー**:
- **45行目**: ContentPaneウィジェットのhref属性で詳細画面のURLを指定
- preload="true"により、編集画面の読み込み時に自動的に詳細画面を取得

### プログラム呼び出し階層図

```
edit.phtml [親画面]
    │
    └─ ContentPane [dijit.layout.ContentPane]
           │
           └─ Ajax Request: /admin/mail/details?id={mail_id}
                  │
                  ▼
           detailsAction() [MailController.php:243]
                  │
                  ├─ acl->isAllowed() [権限チェック]
                  │
                  ├─ _helper->layout->disableLayout() [レイアウト無効化]
                  │
                  └─ Mail->fetchMail() [Mail.php:270]
                         │
                         └─ registry->db->fetchall() [DB検索]
                                │
                                ▼
                         View rendering [details.phtml]

[ボタン押下時]
Save ────────▶ postDialog() ───▶ /admin/mail/save/
Delete ──────▶ getDialog() ────▶ /admin/mail/delete/
Send Test ───▶ getDialog() ────▶ /admin/mail/sendtest/
Send ────────▶ getDialog() ────▶ /admin/mail/send/
Mail... ─────▶ goTo() ─────────▶ /admin/mail/
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ─────────▶ MailController ─────────▶ HTMLレスポンス
(id={mail_id})           detailsAction()              (パーシャルビュー)
                              │
                              │
                              ▼
                         Mail->fetchMail()
                              │
                              ├──────────▶ mailテーブル
                              │            (SELECT)
                              │
                              └──────────▶ usersテーブル
                                           (JOIN - 著者名取得)
                                                │
                                                ▼
                                           details.phtml
                                           (HTML生成)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MailController.php | `application/modules/admin/controllers/MailController.php` | ソース | メール管理のコントローラー |
| Mail.php | `application/models/Mail.php` | ソース | メールデータのモデル |
| details.phtml | `application/modules/admin/views/scripts/mail/details.phtml` | テンプレート | 詳細画面のビュー |
| edit.phtml | `application/modules/admin/views/scripts/mail/edit.phtml` | テンプレート | 編集画面（親画面） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | postDialog(), getDialog(), goTo()等の共通関数 |
| template.css | `public/_styles/admin/template.css` | スタイル | 管理画面共通スタイル |
