# 画面設計書 67-グループ管理画面

## 概要

本ドキュメントは、Legacy CMSの管理画面における「グループ管理画面」（メーリングリスト編集画面）の設計仕様を定義するものである。この画面はメーリングリストの設定編集とメールテンプレート管理機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：メーリングリストは、特定のユーザーグループに対して一斉にメールを配信するための機能である。本画面は、メーリングリストのタイトル、説明文、タイプ（オープン/クローズド）、デフォルト購読設定、およびメールテンプレート（テキスト版・HTML版）を編集するための機能を提供する。オープンリストは一般ユーザーが自由に購読でき、クローズドリストは管理者のみが購読者を管理できる。また、メールテンプレートを設定することで、このリスト宛の新規メール作成時に本文が自動的に設定される。

**画面へのアクセス方法**：メール管理画面（/admin/mail/manage/）のメーリングリスト一覧から右クリックメニューで「Edit」を選択するか、リスト名を右クリックして編集画面にアクセスする。URLは `/admin/mail/group/id/{mgroup_id}/`。

**主要な操作・処理内容**：
1. メーリングリストのタイトル編集
2. 説明文の編集
3. リストタイプの変更（オープン/クローズド）
4. デフォルト購読設定の変更
5. テキストテンプレートの編集
6. HTMLテンプレートの編集（FCKeditor使用）
7. メーリングリストの保存
8. メーリングリストの削除（ID=1以外のみ）
9. メーリングリストの公開

**画面遷移**：メール管理画面から遷移してくる。保存後は同画面に留まり、削除後はメール管理画面へリダイレクトされる。「Mail...」ボタンでメール管理画面へ戻ることができる。

**権限による表示制御**：`mmail`権限と`mlistedit`権限が必要。削除には`mlistdelete`権限が必要。公開には`mlistpublish`権限が必要。ID=1のメーリングリストは削除不可（システム既定リスト）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | メール送信 | 補助機能 | メールグループの管理 |
| 61 | アクセス制御 | 主機能 | 管理者権限チェック |

## 画面種別

編集

## URL/ルーティング

- URL: `/admin/mail/group/id/{mgroup_id}/`
- モジュール: admin
- コントローラー: MailController
- アクション: groupAction

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|----------|------|--------|----------|------|
| タイトル | title | string | Yes | - | テキスト入力 | ValidationTextBox使用、英数字のみ |
| 説明 | description | text | Yes | - | テキストエリア | SimpleTextarea使用 |
| タイプ | open | string | Yes | - | セレクト | Y=オープン、N=クローズド |
| デフォルト購読 | default | string | No | - | チェックボックス | Y=デフォルトで購読 |
| テキストテンプレート | text | text | No | - | テキストエリア | SimpleTextarea使用 |
| HTMLテンプレート | html | text | No | - | FCKeditor | HTMLリッチテキスト |

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|--------------|----------|------|
| ステータス | mail_groups.mgroup_status | テキスト | ucwords()で整形 |
| 投稿数 | COUNT(mail) | リンク | MGroupCount()で取得 |
| 購読者数 | COUNT(mail_subscriptions) | テキスト | MSubscriberCount()で取得 |

## イベント仕様

### 1-保存ボタン押下

FCKeditorの内容を更新後、Ajaxダイアログ経由で `/admin/mail/groupsave/id/{mgroup_id}/` にPOSTリクエストを送信する。バリデーション成功時はmail_groupsテーブルを更新する。

### 2-削除ボタン押下

`mlistdelete`権限があり、かつID=1でない場合のみ表示。getDialog()で `/admin/mail/groupdelete/id/{mgroup_id}/` を呼び出し、削除確認ダイアログを表示する。削除時は関連するメールを既定リスト（ID=1）に移動し、購読情報を削除する。

### 3-公開ボタン押下

`mlistpublish`権限があり、かつステータスが'published'でない場合のみ表示。FCKeditorの内容を更新後、getDialog()で `/admin/mail/grouppublish/id/{mgroup_id}/` を呼び出す。確認後、ステータスを'published'に更新する。

### 4-Mail...ボタン押下

goTo()関数を使用して `/admin/mail/` にリダイレクトする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | mail_groups | UPDATE | メーリングリスト情報を更新 |
| 削除ボタン押下 | mail | UPDATE | 関連メールを既定リストに移動 |
| 削除ボタン押下 | mail_subscriptions | DELETE | 購読情報を削除 |
| 削除ボタン押下 | mail_groups | DELETE | メーリングリストを削除 |
| 公開ボタン押下 | mail_groups | UPDATE | ステータスを'published'に更新 |

### テーブル別更新項目詳細

#### mail_groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | mgroup_title | フォーム入力値 | 保存・公開時 |
| UPDATE | mgroup_description | フォーム入力値 | 保存・公開時 |
| UPDATE | mgroup_text | フォーム入力値 | 保存・公開時 |
| UPDATE | mgroup_html | フォーム入力値（html_entity_decode適用） | 保存・公開時 |
| UPDATE | mgroup_open | フォーム入力値（Y/N） | 保存・公開時 |
| UPDATE | mgroup_default | フォーム入力値（Y/N） | 保存・公開時 |
| UPDATE | mgroup_status | 'published' | 公開時のみ |
| DELETE | - | WHERE mgroup_id = {id} | 削除時 |

#### mail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | mail_slave | 1 | 削除時、関連メールを既定リストに移動 |

#### mail_subscriptions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE msub_group = {id} | 削除時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | 成功 | Mailing List Saved | 保存成功時 |
| MSG002 | 成功 | Mailing List Deleted | 削除成功時 |
| MSG003 | 成功 | Mailing List Published | 公開成功時 |
| MSG004 | 確認 | Are you sure you want to delete this mailing list? | 削除確認時 |
| MSG005 | 確認 | Are you sure you want to publish this mailing list? | 公開確認時 |
| MSG006 | エラー | Category Not Specified! | グループID未指定時 |
| MSG007 | エラー | This mailing list cannot be deleted | ID=1の削除試行時 |
| MSG008 | エラー | Title is required | タイトル未入力時 |
| MSG009 | エラー | Invalid Title | タイトルに無効な文字時 |
| MSG010 | エラー | Mailing list already exists | タイトル重複時 |
| MSG011 | エラー | Description is required | 説明未入力時 |
| MSG012 | エラー | Type is required | タイプ未選択時 |

## 例外処理

| 例外状態 | 対応処理 |
|----------|----------|
| グループIDが未指定または無効 | メール管理画面へリダイレクト |
| 該当グループが存在しない | メール管理画面へリダイレクト |
| 権限不足（mmailまたはmlistedit権限なし） | 権限エラー画面へフォワード |
| ID=1の削除試行 | エラーメッセージを表示 |
| バリデーションエラー | エラーメッセージをダイアログに表示 |

## 備考

- ID=1のメーリングリストはシステム既定リストであり、削除できない
- 削除時は関連するメールがすべて既定リスト（ID=1）に移動される
- オープンリスト（open=Y）は一般ユーザーがフロントエンドから購読可能
- クローズドリスト（open=N）は管理者のみが購読者を管理可能
- デフォルト購読（default=Y）を設定すると、新規ユーザー登録時に自動的に購読される
- テンプレートは、このリスト宛の新規メール作成時に本文として自動設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メーリングリストのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mail.php | `application/models/Mail.php` | mail_groupsテーブルのカラム構造、fetchGroup()、updateGroup() |

**読解のコツ**: mgroup_openカラム（Y/N）とmgroup_defaultカラム（Y/N）の意味を理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MailController.php | `application/modules/admin/controllers/MailController.php` | groupAction()メソッド（1163-1182行目） |

**主要処理フロー**:
1. **1165行目**: 権限チェック（mmailとmlistedit）
2. **1167行目**: URLパラメータからグループIDを取得
3. **1169-1170行目**: Mailモデルを使用してグループデータを取得
4. **1172-1174行目**: グループが存在しない場合は一覧画面へリダイレクト

#### Step 3: ビューテンプレートを理解する

編集画面のUIを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | group.phtml | `application/modules/admin/views/scripts/mail/group.phtml` | 編集フォームUI、タブ構造 |
| 3-2 | groupdetails.phtml | `application/modules/admin/views/scripts/mail/groupdetails.phtml` | 詳細・機能ボタンパネル |

**主要処理フロー**:
- **42-101行目** (group.phtml): Mailing Listタブ（タイトル、説明、タイプ、デフォルト）
- **103-132行目** (group.phtml): Templatesタブ（テキスト、HTML）
- **27行目** (groupdetails.phtml): Saveボタン
- **28-30行目** (groupdetails.phtml): Deleteボタン（条件付き）
- **31-33行目** (groupdetails.phtml): Publishボタン（条件付き）

#### Step 4: 保存処理を理解する

保存ボタン押下時の処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MailController.php | `application/modules/admin/controllers/MailController.php` | groupsaveAction()（1208-1327行目） |
| 4-2 | Mail.php | `application/models/Mail.php` | updateGroup()（424-442行目） |

**主要処理フロー**:
- **1221-1272行目**: バリデーションルールの定義
- **1282-1289行目**: グループデータの更新呼び出し

### プログラム呼び出し階層図

```
groupAction() [MailController.php:1163]
    │
    ├─ acl->isAllowed() [権限チェック]
    │
    └─ Mail->fetchGroup() [Mail.php:290]
           │
           └─ registry->db->fetchall() [DB検索]
                  │
                  ▼
           View rendering [group.phtml]
                  │
                  └─ Ajax: /admin/mail/groupdetails [groupdetails.phtml]

groupsaveAction() [MailController.php:1208]
    │
    ├─ Zend_Filter_Input [バリデーション]
    │
    └─ Mail->updateGroup() [Mail.php:424]
           └─ registry->db->update() [mail_groups更新]

groupdeleteAction() [MailController.php:1332]
    │
    └─ Mail->deleteGroup() [Mail.php:372]
           │
           ├─ [関連メール移動]
           │      └─ registry->db->update() [mail.mail_slave = 1]
           │
           ├─ [購読削除]
           │      └─ registry->db->delete() [mail_subscriptions]
           │
           └─ [グループ削除]
                  └─ registry->db->delete() [mail_groups]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力 ─────────▶ MailController ─────────▶ Ajaxダイアログ
(title, description,     groupsaveAction()           (成功/エラーメッセージ)
 open, default,               │
 text, html)                  │
                              ▼
                        Zend_Filter_Input
                        (バリデーション)
                              │
                              ▼
                        Mail->updateGroup()
                              │
                              └──────────▶ mail_groupsテーブル
                                           (UPDATE)

[削除時]
                        MailController
                        groupdeleteAction()
                              │
                              ├──────────▶ mailテーブル
                              │            (UPDATE: slave=1)
                              │
                              ├──────────▶ mail_subscriptionsテーブル
                              │            (DELETE)
                              │
                              └──────────▶ mail_groupsテーブル
                                           (DELETE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MailController.php | `application/modules/admin/controllers/MailController.php` | ソース | メール管理のコントローラー |
| Mail.php | `application/models/Mail.php` | ソース | メールデータのモデル |
| group.phtml | `application/modules/admin/views/scripts/mail/group.phtml` | テンプレート | グループ編集画面のビュー |
| groupdetails.phtml | `application/modules/admin/views/scripts/mail/groupdetails.phtml` | テンプレート | 詳細パネルのビュー |
| common.js | `public/_scripts/admin/common.js` | JavaScript | 共通ユーティリティ関数 |
| fckeditor.php | `public/_scripts/fckeditor/fckeditor.php` | ライブラリ | FCKeditorのPHPラッパー |
| template.css | `public/_styles/admin/template.css` | スタイル | 管理画面共通スタイル |
