# 画面設計書 68-グループ新規作成画面

## 概要

本ドキュメントは、Legacy CMSの管理画面における「グループ新規作成画面」（メーリングリスト新規作成ダイアログ）の設計仕様を定義するものである。この画面は新しいメーリングリストを作成するためのダイアログである。

### 本画面の処理概要

**業務上の目的・背景**：メール管理機能において、メールの配信先となるメーリングリスト（グループ）を新規に作成するための画面である。メーリングリストは、特定のユーザーグループに対して一斉にメールを配信する際の宛先として使用される。

**画面へのアクセス方法**：メール管理画面（/admin/mail/manage/）のツールバーにある「New List」ボタンをクリックすると、Ajaxダイアログとして表示される。URLは `/admin/mail/groupnew/`。

**主要な操作・処理内容**：
1. メーリングリストのタイトル入力
2. リストタイプの選択（オープン/クローズド）
3. メーリングリストの作成

**画面遷移**：メール管理画面からダイアログとして表示される。作成成功後はダイアログを閉じてメール管理画面をリロードする。

**権限による表示制御**：`mmail`権限と`mlistnew`権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | メール送信 | 補助機能 | メールグループの新規作成 |
| 61 | アクセス制御 | 主機能 | 管理者権限チェック |

## 画面種別

新規作成（ダイアログ）

## URL/ルーティング

- URL: `/admin/mail/groupnew/`
- モジュール: admin
- コントローラー: MailController
- アクション: groupnewAction

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|----------|------|--------|----------|------|
| タイトル | grouptitle | string | Yes | - | テキスト入力 | ValidationTextBox使用、英数字のみ |
| タイプ | groupopen | string | Yes | - | セレクト | Y=オープン、N=クローズド |

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|--------------|----------|------|
| なし | - | - | 新規作成画面のため表示のみの項目なし |

## イベント仕様

### 1-Createボタン押下

doDialog()関数を使用して `/admin/mail/groupnew/` にPOSTリクエストを送信する。バリデーション成功時はmail_groupsテーブルに新規レコードを挿入し、成功メッセージと「Close」ボタンを表示する。Closeボタン押下時はダイアログを閉じて画面をリロードする。

### 2-Cancelボタン押下

dijit.byId('ajaxDialog').hide()でダイアログを閉じる。データベースへの変更は行わない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Createボタン押下 | mail_groups | INSERT | 新規メーリングリストを作成 |

### テーブル別更新項目詳細

#### mail_groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | mgroup_title | フォーム入力値 | タイトル |
| INSERT | mgroup_open | フォーム入力値（Y/N） | オープン/クローズド |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | 成功 | Mailing List Created | 作成成功時 |
| MSG002 | エラー | Title is required | タイトル未入力時 |
| MSG003 | エラー | Invalid Title | タイトルに無効な文字時 |
| MSG004 | エラー | Category Already Exists | タイトル重複時 |
| MSG005 | エラー | Type is required | タイプ未選択時 |

## 例外処理

| 例外状態 | 対応処理 |
|----------|----------|
| 権限不足（mmailまたはmlistnew権限なし） | 権限エラー画面へフォワード |
| バリデーションエラー | エラーメッセージをダイアログに表示し、フォームを再表示 |

## 備考

- 新規作成時はタイトルとタイプのみ設定可能
- 説明、テンプレートなどの詳細設定はグループ管理画面（編集画面）で行う
- 作成後のステータスはデフォルト（新規作成状態）となる
- オープンリスト（open=Y）は一般ユーザーがフロントエンドから購読可能
- クローズドリスト（open=N）は管理者のみが購読者を管理可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メーリングリストのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mail.php | `application/models/Mail.php` | mail_groupsテーブルのカラム構造、newGroup() |

**読解のコツ**: newGroup()メソッドでINSERTされるカラムを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MailController.php | `application/modules/admin/controllers/MailController.php` | groupnewAction()メソッド（1520-1597行目） |

**主要処理フロー**:
1. **1522行目**: 権限チェック（mmailとmlistnew）
2. **1524行目**: レイアウトを無効化（ダイアログ用）
3. **1526行目**: POSTリクエスト判定
4. **1530-1555行目**: バリデーションルールの定義
5. **1557-1564行目**: バリデーション実行とデータ挿入

#### Step 3: ビューテンプレートを理解する

ダイアログのUIを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | groupnew.phtml | `application/modules/admin/views/scripts/mail/groupnew.phtml` | 新規作成フォームUI |

**主要処理フロー**:
- **9行目**: posted == 'N'の場合のみフォームを表示
- **11-55行目**: フォーム定義
- **14-25行目**: タイトル入力（ValidationTextBox）
- **28-38行目**: タイプ選択（FilteringSelect）
- **42-47行目**: Createボタン（doDialog呼び出し）
- **48-53行目**: Cancelボタン（ダイアログを閉じる）

#### Step 4: モデルの登録処理を理解する

新規グループの登録処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Mail.php | `application/models/Mail.php` | newGroup()メソッド（334-346行目） |

**主要処理フロー**:
- **336-342行目**: タイトルが有効な場合、mail_groupsテーブルにINSERT
- **338-340行目**: INSERT対象カラム（mgroup_title, mgroup_open）

### プログラム呼び出し階層図

```
[メール管理画面] New Listボタン
    │
    └─ getDialog() ───▶ /admin/mail/groupnew/
                              │
                              ▼
                       groupnewAction() [MailController.php:1520]
                              │
                              ├─ acl->isAllowed() [権限チェック]
                              │
                              ├─ _helper->layout->disableLayout() [レイアウト無効化]
                              │
                              └─ View rendering [groupnew.phtml]

[フォーム送信時]
Createボタン ───▶ doDialog('/admin/mail/groupnew/')
                       │
                       ▼
                groupnewAction() [MailController.php:1520]
                       │
                       ├─ Zend_Filter_Input [バリデーション]
                       │
                       └─ Mail->newGroup() [Mail.php:334]
                              │
                              └─ registry->db->insert() [mail_groups]
                                     │
                                     ▼
                              成功メッセージ + Closeボタン
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力 ─────────▶ MailController ─────────▶ Ajaxダイアログ
(grouptitle,             groupnewAction()           (成功/エラーメッセージ)
 groupopen)                   │
                              │
                              ▼
                        Zend_Filter_Input
                        (バリデーション)
                              │
                              ├─ タイトルチェック（英数字、重複）
                              │
                              ├─ タイプチェック（必須）
                              │
                              ▼
                        Mail->newGroup()
                              │
                              └──────────▶ mail_groupsテーブル
                                           (INSERT)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MailController.php | `application/modules/admin/controllers/MailController.php` | ソース | メール管理のコントローラー |
| Mail.php | `application/models/Mail.php` | ソース | メールデータのモデル |
| groupnew.phtml | `application/modules/admin/views/scripts/mail/groupnew.phtml` | テンプレート | 新規作成フォームのビュー |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog(), doDialog()等の共通関数 |
| template.css | `public/_styles/admin/template.css` | スタイル | 管理画面共通スタイル |
