# 画面設計書 69-グループ詳細画面

## 概要

本ドキュメントは、Legacy CMSの管理画面における「グループ詳細画面」（メーリングリスト詳細パネル）の設計仕様を定義するものである。この画面はメーリングリスト編集画面内にAjax経由で読み込まれるパーシャルビューであり、グループの詳細情報と操作ボタンを表示する。

### 本画面の処理概要

**業務上の目的・背景**：メーリングリスト編集画面において、ユーザーがグループの現在の状態（ステータス、投稿数、購読者数）を一目で確認できるようにするとともに、保存・削除・公開などの主要な操作ボタンを提供する。この情報パネルにより、編集作業中でも基本情報を常に把握でき、適切なタイミングで操作を実行できる。

**画面へのアクセス方法**：グループ管理画面（/admin/mail/group/id/{mgroup_id}/）の読み込み時に、ContentPaneウィジェットにより `/admin/mail/groupdetails?id={mgroup_id}` からAjax経由で自動的に読み込まれる。直接URLアクセスも技術的には可能だが、レイアウトなしの部分的なHTMLが返されるため、通常は編集画面経由でのみ使用される。

**主要な操作・処理内容**：
1. グループのステータス、投稿数、購読者数の表示
2. 「Save」ボタンによるグループ保存処理の実行
3. 「Delete」ボタンによるグループ削除処理の実行（ID=1以外のみ）
4. 「Publish」ボタンによるグループ公開処理（未公開時のみ）
5. 「Mail...」ボタンによるメール管理画面への遷移

**画面遷移**：本画面自体は遷移元/遷移先を持たないパーシャルビューである。各ボタンはAjaxダイアログを表示するか、メール管理画面へリダイレクトする。

**権限による表示制御**：`mmail`権限と`mlistedit`権限が必要。Delete機能には`mlistdelete`権限が必要。Publish機能には`mlistpublish`権限が必要。ID=1のグループはDeleteボタンが非表示。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | メール送信 | 補助機能 | メールグループの詳細表示 |
| 61 | アクセス制御 | 主機能 | 管理者権限チェック |

## 画面種別

詳細（パーシャルビュー/Ajax読み込み）

## URL/ルーティング

- URL: `/admin/mail/groupdetails?id={mgroup_id}`
- モジュール: admin
- コントローラー: MailController
- アクション: groupdetailsAction

## 入出力項目

本画面はGETパラメータのみを受け取り、表示専用である。

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| グループID | id | integer | Yes | URLパラメータ | 表示対象のグループを指定 |

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|--------------|----------|------|
| ステータス | mail_groups.mgroup_status | テキスト | ucwords()で整形、"Status: {ステータス}" |
| 投稿数 | COUNT(mail) | リンク | MGroupCount()で取得、"Posts ({件数})" |
| 購読者数 | COUNT(mail_subscriptions) | テキスト | MSubscriberCount()で取得、"Subscribers ({件数})" |

## イベント仕様

### 1-Saveボタン押下

FCKeditorの内容を更新した後、postDialog()関数を使用して `/admin/mail/groupsave/id/{mgroup_id}/` にPOSTリクエストを送信する。editFormの内容がフォームデータとして送信され、結果はAjaxダイアログに表示される。

### 2-Deleteボタン押下

`mlistdelete`権限があり、かつID=1でない場合のみ表示。getDialog()関数を使用して `/admin/mail/groupdelete/id/{mgroup_id}/` を呼び出し、削除確認ダイアログを表示する。

### 3-Publishボタン押下

`mlistpublish`権限があり、かつステータスが'published'でない場合のみ表示。FCKeditorの内容を更新した後、getDialog()関数を使用して `/admin/mail/grouppublish/id/{mgroup_id}/` を呼び出す。

### 4-Mail...ボタン押下

goTo()関数を使用して `/admin/mail/` にリダイレクトする。メール管理画面に戻る。

## データベース更新仕様

本画面は表示専用であり、直接的なデータベース更新は行わない。ボタン押下時に呼び出される各アクション（groupsave, groupdelete, grouppublish）でデータベース更新が行われる。

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Saveボタン押下 | mail_groups | - | groupsaveActionへ遷移（本画面では更新しない） |
| Deleteボタン押下 | mail_groups | - | groupdeleteActionへ遷移（本画面では更新しない） |
| Publishボタン押下 | mail_groups | - | grouppublishActionへ遷移（本画面では更新しない） |

### テーブル別更新項目詳細

本画面ではデータベース更新は行わない。groupdetailsAction()はSELECTのみを実行する。

#### mail_groups（SELECT）

| 操作 | 項目（カラム名） | 取得条件 | 備考 |
|-----|-----------------|----------|------|
| SELECT | mgroup_id | WHERE mgroup_id = {id} | 主キー |
| SELECT | mgroup_status | - | 表示用、ボタン表示制御用 |

## メッセージ仕様

本画面自体はメッセージを表示しない。ボタン押下時に呼び出される各アクションでメッセージが表示される。

## 例外処理

| 例外状態 | 対応処理 |
|----------|----------|
| グループIDが未指定または無効 | 空のレスポンスを返す（エラー画面は表示しない） |
| 該当グループが存在しない | 空のレスポンスを返す |
| 権限不足（mmailまたはmlistedit権限なし） | 権限エラー画面へフォワード |

## 備考

- 本画面はグループ管理画面（group.phtml）のContentPaneウィジェットに読み込まれるパーシャルビューである
- レイアウトは無効化されており（disableLayout）、本画面のHTMLのみが返される
- FCKeditorの更新はMyFCKObject.UpdateEditorFormValue()で行われるが、この処理は本画面ではなく編集画面側で定義されている
- MGroupCount()とMSubscriberCount()はビューヘルパーとして実装されている
- 投稿数はリンクになっており、クリックするとそのグループのメール一覧画面に遷移する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

詳細画面で表示されるグループデータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mail.php | `application/models/Mail.php` | fetchGroup()メソッドで取得されるカラムを確認 |

**読解のコツ**: fetchGroup()はmail_groupsテーブルから単一レコードを取得する。mgroup_statusカラムがボタン表示制御に使用される。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MailController.php | `application/modules/admin/controllers/MailController.php` | groupdetailsAction()メソッド（1187-1203行目） |

**主要処理フロー**:
1. **1189行目**: 権限チェック（mmailとmlistedit）
2. **1191行目**: レイアウトを無効化（Ajax読み込み用）
3. **1193行目**: URLパラメータからグループIDを取得
4. **1195-1196行目**: Mailモデルを使用してグループデータを取得
5. ビューに$groupArrayを渡してレンダリング

#### Step 3: ビューテンプレートを理解する

Ajax読み込みされるビューファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | groupdetails.phtml | `application/modules/admin/views/scripts/mail/groupdetails.phtml` | 詳細情報の表示とボタンの配置 |

**主要処理フロー**:
- **9-18行目**: 左カラム - 詳細情報（ステータス、投稿数、購読者数）
- **15行目**: ステータスの表示（ucwords()で整形）
- **16行目**: 投稿数のリンク表示
- **17行目**: 購読者数の表示
- **21-37行目**: 右カラム - 機能ボタン
- **27行目**: Saveボタン
- **28-29行目**: Deleteボタン（ID != 1 かつ mlistdelete権限時のみ）
- **31-32行目**: Publishボタン（ステータス != published かつ mlistpublish権限時のみ）
- **34行目**: Mail...ボタン

#### Step 4: 親画面との連携を理解する

詳細画面が読み込まれる親画面を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | group.phtml | `application/modules/admin/views/scripts/mail/group.phtml` | ContentPaneによるAjax読み込み（35-36行目） |

**主要処理フロー**:
- **35-36行目**: ContentPaneウィジェットのhref属性で詳細画面のURLを指定
- preload="true"により、編集画面の読み込み時に自動的に詳細画面を取得

### プログラム呼び出し階層図

```
group.phtml [親画面]
    │
    └─ ContentPane [dijit.layout.ContentPane]
           │
           └─ Ajax Request: /admin/mail/groupdetails?id={mgroup_id}
                  │
                  ▼
           groupdetailsAction() [MailController.php:1187]
                  │
                  ├─ acl->isAllowed() [権限チェック]
                  │
                  ├─ _helper->layout->disableLayout() [レイアウト無効化]
                  │
                  └─ Mail->fetchGroup() [Mail.php:290]
                         │
                         └─ registry->db->fetchall() [DB検索]
                                │
                                ▼
                         View rendering [groupdetails.phtml]

[ボタン押下時]
Save ────────▶ postDialog() ───▶ /admin/mail/groupsave/
Delete ──────▶ getDialog() ────▶ /admin/mail/groupdelete/
Publish ─────▶ getDialog() ────▶ /admin/mail/grouppublish/
Mail... ─────▶ goTo() ─────────▶ /admin/mail/
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ ─────────▶ MailController ─────────▶ HTMLレスポンス
(id={mgroup_id})         groupdetailsAction()        (パーシャルビュー)
                              │
                              │
                              ▼
                         Mail->fetchGroup()
                              │
                              └──────────▶ mail_groupsテーブル
                                           (SELECT)
                                                │
                                                ▼
                                           groupdetails.phtml
                                           (HTML生成)
                                                │
                                                ├─ MGroupCount() [投稿数]
                                                │      └─ mailテーブル COUNT
                                                │
                                                └─ MSubscriberCount() [購読者数]
                                                       └─ mail_subscriptionsテーブル COUNT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MailController.php | `application/modules/admin/controllers/MailController.php` | ソース | メール管理のコントローラー |
| Mail.php | `application/models/Mail.php` | ソース | メールデータのモデル |
| groupdetails.phtml | `application/modules/admin/views/scripts/mail/groupdetails.phtml` | テンプレート | 詳細画面のビュー |
| group.phtml | `application/modules/admin/views/scripts/mail/group.phtml` | テンプレート | 編集画面（親画面） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | postDialog(), getDialog(), goTo()等の共通関数 |
| template.css | `public/_styles/admin/template.css` | スタイル | 管理画面共通スタイル |
