# 画面設計書 7-ユーザー登録画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおけるユーザー登録画面の設計仕様を定義する。新規ユーザーアカウントの作成とメール認証による有効化プロセスを提供する。

### 本画面の処理概要

**業務上の目的・背景**：ユーザー登録画面は、新規訪問者がサイトの会員機能を利用するためのアカウント作成機能を提供する。メール認証による本人確認、CAPTCHA認証によるボット対策を実装し、セキュアなユーザー登録プロセスを実現する。これにより、会員管理とコミュニティ形成という業務課題を解決する。

**画面へのアクセス方法**：ホーム画面やログイン画面の「Register」リンクからアクセス。URLは`/auth/register`。

**主要な操作・処理内容**：
1. 登録フォームの表示（個人情報、パスワード、連絡先、所在地、購読設定）
2. CAPTCHA画像の生成と表示
3. フォーム入力値のバリデーション（エイリアス・メールの重複チェック含む）
4. CAPTCHA認証の検証
5. usersテーブルへのユーザー登録
6. users_profilesテーブルへのプロファイル登録
7. mail_subscriptionsテーブルへの購読登録
8. アカウント有効化メールの送信
9. 登録完了メッセージの表示

**画面遷移**：
- 遷移元：ホーム画面、ログイン画面
- 遷移先：登録完了後は同一画面に完了メッセージ表示、パスワードリセット画面

**権限による表示制御**：
- 既にログイン済みの場合、ホーム画面へリダイレクト
- 未認証ユーザーのみアクセス可能

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | ユーザー新規作成 | 主機能 | 新規ユーザーアカウントを作成 |
| 63 | 入力検証 | 補助機能 | 登録フォームのバリデーション |
| 59 | メール送信 | 補助機能 | アカウント有効化メールを送信 |

## 画面種別

入力（登録フォーム型）

## URL/ルーティング

- URL: `/auth/register`
- コントローラー: `AuthController`
- アクション: `registerAction`
- モジュール: `default`
- HTTPメソッド: GET（表示）/ POST（登録）

## 入出力項目

### 入力項目

| 項目名 | 入力/出力 | データ型 | 必須 | バリデーション | 説明 |
|--------|----------|---------|------|---------------|------|
| alias | 入力 | string | はい | 英数字、DB重複チェック | 公開エイリアス |
| first | 入力 | string | はい | 英字・ハイフン・アポストロフィ | 名 |
| last | 入力 | string | はい | 英字・ハイフン・アポストロフィ | 姓 |
| password | 入力 | string | はい | 8文字以上 | パスワード |
| password2 | 入力 | string | はい | passwordと一致 | パスワード確認 |
| email | 入力 | string | はい | メールアドレス形式、DB重複チェック | メールアドレス |
| country | 入力 | string | はい | 国名形式 | 国 |
| city | 入力 | string | いいえ | 市町村形式 | 市町村（オプション） |
| lists[] | 入力 | array | いいえ | - | 購読リスト選択 |
| format | 入力 | string | いいえ | text/html | メール形式 |
| captcha[input] | 入力 | string | はい | CAPTCHA検証 | 認証コード入力 |
| captcha[id] | 入力 | hidden | はい | - | CAPTCHA識別ID |

### 出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| posted | 出力 | string | - | 処理完了フラグ |
| messages | 出力 | array | - | バリデーションエラーメッセージ |
| listsArray | 出力 | array | - | 購読可能なメーリングリスト |
| captcha | 出力 | Zend_Captcha_Image | - | CAPTCHA画像オブジェクト |
| id | 出力 | string | - | 生成されたCAPTCHA ID |

## 表示項目

### フォーム項目

| セクション | 項目名 | 表示形式 | 説明 |
|-----------|--------|---------|------|
| Identity | Alias | テキストボックス（幅220px） | 公開エイリアス（Ajax重複チェック） |
| Identity | First Name | テキストボックス（幅220px） | 名（プライベート） |
| Identity | Last Name | テキストボックス（幅220px） | 姓（プライベート） |
| Password | Password | パスワードボックス | パスワード（Ajax強度チェック） |
| Password | Confirm Password | パスワードボックス | パスワード確認 |
| Contact | E-mail Address | テキストボックス（幅340px） | メールアドレス |
| Location | Country | ドロップダウン（幅200px） | 国選択（デフォルト: GB） |
| Location | City | テキストボックス（幅250px） | 市町村（オプション） |
| Subscriptions | メーリングリスト | チェックボックスリスト | 購読選択 |
| Subscriptions | Preferred Mail Format | ラジオボタン | Text Only / HTML |
| Verification | CAPTCHA画像 | 画像（180x60px） | 認証用画像 |
| Verification | Verification Code | テキストボックス（幅100px） | 認証コード入力 |

### サイドバー

| 項目名 | 説明 |
|--------|------|
| Why Register? | 登録のメリット案内 |
| Forgotten Your Password? | パスワードリセットへのリンク |

## イベント仕様

### 1-登録実行

「Register」ボタンをクリックすると、フォームがPOST送信され、ユーザー登録処理が実行される。

- 送信先: `/auth/register/`
- 処理フロー:
  1. 入力値のバリデーション
  2. CAPTCHA認証の検証
  3. usersテーブルへINSERT
  4. users_profilesテーブルへINSERT
  5. mail_subscriptionsテーブルへINSERT（選択時）
  6. アカウント有効化メール送信
  7. 完了メッセージ表示

### 2-エイリアス重複チェック（Ajax）

エイリアス入力欄からフォーカスが外れると、Ajax経由で重複チェックが実行される。

- 処理: aliasCheck(value)関数（user.js）

### 3-パスワード強度チェック（Ajax）

パスワード入力欄からフォーカスが外れると、Ajax経由で強度チェックが実行される。

- 処理: passwordCheck(value)関数（user.js）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 登録実行 | mail_groups | SELECT | 公開メーリングリストを取得 |
| 登録実行 | users | INSERT | ユーザー基本情報を登録 |
| 登録実行 | users_profiles | INSERT | ユーザープロファイルを登録 |
| 登録実行 | mail_subscriptions | INSERT | メール購読情報を登録 |

### テーブル別更新項目詳細

#### users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | user_alias | 入力値 | |
| INSERT | user_email | 入力値（小文字化） | |
| INSERT | user_password | MD5(site.key + password + salt) | |
| INSERT | user_salt | 自動生成（8文字） | |
| INSERT | user_key | MD5(email + password) | 有効化キー |
| INSERT | user_date | NOW() | 登録日時 |
| INSERT | user_mailformat | 入力値（text/html） | |
| INSERT | user_status | 'inactive' | 有効化待ち |

#### users_profiles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | upro_userid | 新規user_id | FK |
| INSERT | upro_first | 入力値 | |
| INSERT | upro_last | 入力値 | |
| INSERT | upro_country | 入力値 | |
| INSERT | upro_city | 入力値 | |
| INSERT | upro_date | NOW() | 登録日時 |

#### mail_subscriptions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | msub_group | 選択リストID | FK |
| INSERT | msub_user | 新規user_id | FK |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 成功 | Your account has been created. / You should shortly receive an e-mail containing details of how to activate it. | 登録成功時 |
| MSG-002 | エラー | Missing Alias - you did not enter an alias | エイリアス未入力時 |
| MSG-003 | エラー | Invalid Alias - letters, numbers and spaces only | エイリアス形式不正時 |
| MSG-004 | エラー | Invalid Alias - entered alias is associated with an existing account | エイリアス重複時 |
| MSG-005 | エラー | Missing E-mail Address - you did not enter an e-mail address | メールアドレス未入力時 |
| MSG-006 | エラー | Invalid E-mail Address | メールアドレス形式不正時 |
| MSG-007 | エラー | Invalid E-mail Address - entered e-mail address is associated with an existing account | メールアドレス重複時 |
| MSG-008 | エラー | Missing Password - you did not enter a password | パスワード未入力時 |
| MSG-009 | エラー | Invalid Password - passwords must be at least 8 characters long | パスワード8文字未満時 |
| MSG-010 | エラー | Invalid Password - passwords don't match | パスワード不一致時 |
| MSG-011 | エラー | Invalid Verification Code - you must enter the code exactly as displayed | CAPTCHA認証失敗時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| バリデーションエラー | フォームに入力値を保持し、エラーメッセージを表示 |
| CAPTCHA認証失敗 | 新しいCAPTCHAを生成し、エラーメッセージを表示 |
| メール送信失敗 | エラーメッセージを表示（例外キャッチ） |

## 備考

- CAPTCHA設定はcontactActionと同一
- user_keyはMD5(email + password)で生成、有効化URLのパラメータとして使用
- 初期ステータスは'inactive'、有効化後'active'に変更
- メール形式のデフォルトは'text'
- 購読リストはmgroup_open='Y'のものだけ表示
- 国選択はcountriesOptions()ヘルパーで生成

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ユーザー登録に関連するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | usersテーブル（347-361行目）の全カラム |
| 1-2 | database.sql | `database.sql` | users_profilesテーブル（457-477行目）の全カラム |
| 1-3 | database.sql | `database.sql` | mail_groups（179-189行目）、mail_subscriptions（195-200行目） |

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AuthController.php | `application/modules/default/controllers/AuthController.php` | registerAction()メソッド（253-461行目） |

**主要処理フロー**:
1. **255-265行目**: CAPTCHA生成
2. **270-276行目**: 公開メーリングリスト取得（mgroup_open='Y'）
3. **278行目**: POSTリクエスト判定
4. **288-352行目**: バリデーター定義（重複チェック含む）
5. **356行目**: バリデーション＋CAPTCHA検証
6. **360-373行目**: usersテーブルへINSERT
7. **376-378行目**: lastInsertId取得
8. **381-391行目**: users_profilesテーブルへINSERT
9. **394-410行目**: mail_subscriptionsへINSERT（ループ）
10. **412-429行目**: 有効化メール送信

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | register.phtml | `application/modules/default/views/scripts/auth/register.phtml` | メインテンプレート。各フィールドセットの配置 |

### プログラム呼び出し階層図

```
HTTP Request (/auth/register)
    |
    +-- AuthController::preDispatch()
    |       |
    |       +-- 認証状態チェック
    |       +-- [認証済み] ホームへリダイレクト
    |
    +-- AuthController::registerAction()
            |
            +-- Zend_Captcha_Image生成
            +-- SELECT mail_groups (mgroup_open='Y')
            |
            +-- [POST時]
            |       |
            |       +-- Zend_Filter_Input - バリデーション
            |       |       |
            |       |       +-- Zend_Validate_Db_NoRecordExists (alias)
            |       |       +-- Zend_Validate_Db_NoRecordExists (email)
            |       |       +-- Zend_Validate_Identical (password)
            |       |
            |       +-- captcha->isValid() - CAPTCHA検証
            |       |
            |       +-- [成功]
            |       |       |
            |       |       +-- generatepassword() (salt生成)
            |       |       +-- INSERT users
            |       |       +-- lastInsertId()
            |       |       +-- INSERT users_profiles
            |       |       +-- foreach INSERT mail_subscriptions
            |       |       +-- Zend_Mail::send() (有効化メール)
            |       |
            |       +-- [失敗] エラーメッセージ設定
            |
            +-- captcha->generate()
            +-- ビューレンダリング
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム送信    ───▶ AuthController       ───▶ register.phtml
(POST)               ::registerAction()        |
  |                        |                   +──▶ 成功: 完了メッセージ
  +-- alias           バリデーション            |    + 有効化メール送信
  +-- first                |                   +──▶ 失敗: エラー表示
  +-- last            CAPTCHA検証                   + フォーム再表示
  +-- email                |
  +-- password        DB重複チェック
  +-- country              |
  +-- city                 ▼
  +-- lists[]         INSERT users
  +-- format               |
  +-- captcha              ▼
                      INSERT users_profiles
                           |
                           ▼
                      INSERT mail_subscriptions
                           |
                           ▼
                      Zend_Mail (有効化URL)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AuthController.php | `application/modules/default/controllers/AuthController.php` | ソース | 認証関連のコントローラー |
| register.phtml | `application/modules/default/views/scripts/auth/register.phtml` | テンプレート | ユーザー登録画面のメインビュー |
| user.js | `_scripts/default/user.js` | JavaScript | エイリアス・パスワードのAjaxチェック |
| database.sql | `database.sql` | スキーマ | users, users_profiles, mail_subscriptionsテーブル定義 |
