# 画面設計書 70-メールリスト画面

## 概要

本ドキュメントは、Legacy CMSの管理画面における「メールリスト画面」（メーリングリスト宛メール新規作成ダイアログ）の設計仕様を定義するものである。この画面は特定のメーリングリスト宛に新しいメールを作成するためのダイアログである。

### 本画面の処理概要

**業務上の目的・背景**：メール管理機能において、特定のメーリングリスト（グループ）宛に一斉配信するメールを新規に作成するための画面である。メーリングリストを選択することで、そのリストに設定されているテンプレート（テキスト版・HTML版）が自動的にメール本文に設定される。

**画面へのアクセス方法**：メール管理画面（/admin/mail/manage/）のツールバーにある「New to List」ボタンをクリックすると、Ajaxダイアログとして表示される。URLは `/admin/mail/maillist/`。

**主要な操作・処理内容**：
1. 宛先メーリングリストの選択
2. メール件名の入力
3. メールの作成（グループのテンプレートを本文に適用）

**画面遷移**：メール管理画面からダイアログとして表示される。作成成功後は「Continue」ボタンでメール編集画面へ遷移する。

**権限による表示制御**：`mmail`権限と`mmailnew`権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | メール送信 | 主機能 | メールの新規作成 |
| 61 | アクセス制御 | 補助機能 | 管理者権限チェック |

## 画面種別

新規作成（ダイアログ）

## URL/ルーティング

- URL: `/admin/mail/maillist/`
- モジュール: admin
- コントローラー: MailController
- アクション: maillistAction

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 備考 |
|--------|--------|----------|------|--------|----------|------|
| 宛先リスト | slave | integer | Yes | - | セレクト | MListSelect()で選択肢を生成 |
| 件名 | subject | string | Yes | - | テキスト入力 | ValidationTextBox使用 |

## 表示項目

| 項目名 | データソース | 表示形式 | 備考 |
|--------|--------------|----------|------|
| メーリングリスト一覧 | mail_groups | セレクト | MListSelect()ビューヘルパーで生成 |

## イベント仕様

### 1-Createボタン押下

doDialog()関数を使用して `/admin/mail/maillist/` にPOSTリクエストを送信する。バリデーション成功時はmailテーブルに新規レコードを挿入し、選択されたグループのテンプレートをメール本文に設定する。成功メッセージと「Continue」ボタンを表示し、Continueボタン押下でメール編集画面へ遷移する。

### 2-Cancelボタン押下

dijit.byId('ajaxDialog').hide()でダイアログを閉じる。データベースへの変更は行わない。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Createボタン押下 | mail | INSERT | 新規メールを作成 |

### テーブル別更新項目詳細

#### mail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | mail_type | 'G' | グループ宛メール |
| INSERT | mail_slave | フォーム入力値（グループID） | 宛先グループ |
| INSERT | mail_subject | フォーム入力値 | 件名 |
| INSERT | mail_text | mail_groups.mgroup_text | グループのテキストテンプレート |
| INSERT | mail_html | mail_groups.mgroup_html | グループのHTMLテンプレート |
| INSERT | mail_user | ログインユーザーID | 作成者 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG001 | 成功 | Mail Created | 作成成功時 |
| MSG002 | エラー | To is required | 宛先リスト未選択時 |
| MSG003 | エラー | Subject is required | 件名未入力時 |

## 例外処理

| 例外状態 | 対応処理 |
|----------|----------|
| 権限不足（mmailまたはmmailnew権限なし） | 権限エラー画面へフォワード |
| バリデーションエラー | エラーメッセージをダイアログに表示し、フォームを再表示 |

## 備考

- 選択したメーリングリストに設定されているテンプレートが自動的にメール本文に設定される
- テンプレートが未設定の場合は、本文は空の状態で作成される
- mail_typeは'G'（Group）が設定される
- 作成後はContinueボタンでメール編集画面に遷移し、本文の編集や添付ファイルの追加が可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メールとメーリングリストのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mail.php | `application/models/Mail.php` | mailテーブルのカラム構造、newMail()、fetchGroup() |

**読解のコツ**: mail_typeカラムの値（G=グループ、R=ロール、U=ユーザー）とmail_slaveカラムの関係を理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MailController.php | `application/modules/admin/controllers/MailController.php` | maillistAction()メソッド（261-343行目） |

**主要処理フロー**:
1. **263行目**: 権限チェック（mmailとmmailnew）
2. **265行目**: レイアウトを無効化（ダイアログ用）
3. **267行目**: POSTリクエスト判定
4. **271-296行目**: バリデーションルールの定義
5. **300-310行目**: バリデーション成功時、グループのテンプレートを取得してメール作成

#### Step 3: ビューテンプレートを理解する

ダイアログのUIを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | maillist.phtml | `application/modules/admin/views/scripts/mail/maillist.phtml` | 新規作成フォームUI |

**主要処理フロー**:
- **9行目**: posted == 'N'の場合のみフォームを表示
- **11-54行目**: フォーム定義
- **12-22行目**: 宛先リスト選択（FilteringSelect + MListSelect）
- **24-38行目**: 件名入力（ValidationTextBox）
- **41-46行目**: Createボタン（doDialog呼び出し）
- **47-52行目**: Cancelボタン（ダイアログを閉じる）

#### Step 4: モデルの登録処理を理解する

新規メールの登録処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Mail.php | `application/models/Mail.php` | newMail()メソッド |
| 4-2 | Mail.php | `application/models/Mail.php` | fetchGroup()メソッド（290-304行目） |

**主要処理フロー**:
- **303-310行目** (MailController.php): グループのテンプレートを取得してnewMail()に渡す
- newMail()でmailテーブルにINSERT

### プログラム呼び出し階層図

```
[メール管理画面] New to Listボタン
    │
    └─ getDialog() ───▶ /admin/mail/maillist/
                              │
                              ▼
                       maillistAction() [MailController.php:261]
                              │
                              ├─ acl->isAllowed() [権限チェック]
                              │
                              ├─ _helper->layout->disableLayout() [レイアウト無効化]
                              │
                              └─ View rendering [maillist.phtml]
                                     │
                                     └─ MListSelect() [メーリングリスト選択肢生成]

[フォーム送信時]
Createボタン ───▶ doDialog('/admin/mail/maillist/')
                       │
                       ▼
                maillistAction() [MailController.php:261]
                       │
                       ├─ Zend_Filter_Input [バリデーション]
                       │
                       ├─ Mail->fetchGroup() [Mail.php:290]
                       │       └─ テンプレート取得
                       │
                       └─ Mail->newMail() [Mail.php]
                              │
                              └─ registry->db->insert() [mail]
                                     │
                                     ▼
                              成功メッセージ + Continueボタン
                                     │
                                     └─ goTo('/admin/mail/edit/id/{新規ID}/')
```

### データフロー図

```
[入力]                    [処理]                         [出力]

フォーム入力 ─────────▶ MailController ─────────▶ Ajaxダイアログ
(slave, subject)         maillistAction()           (成功/エラーメッセージ)
                              │
                              │
                              ▼
                        Zend_Filter_Input
                        (バリデーション)
                              │
                              ├─ 宛先チェック（必須）
                              │
                              ├─ 件名チェック（必須）
                              │
                              ▼
                        Mail->fetchGroup()
                              │
                              └──────────▶ mail_groupsテーブル
                                           (SELECT: テンプレート取得)
                                                │
                                                ▼
                                          Mail->newMail()
                                                │
                                                └──────────▶ mailテーブル
                                                             (INSERT)
                                                                  │
                                                                  ▼
                                                             Continueボタン
                                                                  │
                                                                  └─▶ /admin/mail/edit/id/{新規ID}/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MailController.php | `application/modules/admin/controllers/MailController.php` | ソース | メール管理のコントローラー |
| Mail.php | `application/models/Mail.php` | ソース | メールデータのモデル |
| maillist.phtml | `application/modules/admin/views/scripts/mail/maillist.phtml` | テンプレート | 新規作成フォームのビュー |
| MListSelect.php | `application/modules/admin/views/helpers/MListSelect.php` | ビューヘルパー | メーリングリスト選択肢生成 |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog(), doDialog(), goTo()等の共通関数 |
| template.css | `public/_styles/admin/template.css` | スタイル | 管理画面共通スタイル |
