# 画面設計書 72-ユーザー別メール画面

## 概要

本ドキュメントは、Legacy CMSの管理画面におけるユーザー別メール画面（mailuser.phtml）の設計仕様を記載したものです。

### 本画面の処理概要

本画面は、管理者が特定の個別ユーザーに対してメールを送信するための新規メール作成ダイアログ画面です。

**業務上の目的・背景**：システム管理者やサイト運営者が、特定のユーザーに対して個別に連絡を取る必要がある場合に使用します。例えば、「特定のユーザーにアカウント問題の通知を送る」「VIPユーザーに個別のお知らせを配信する」といったユースケースに対応します。ロール別メールやグループ別メールとは異なり、1対1のコミュニケーションを実現します。

**画面へのアクセス方法**：ユーザー詳細画面または管理画面の「Send Mail」ボタンをクリックすることで、Ajaxダイアログとして本画面が表示されます。URLパラメータ`id`で送信対象のユーザーIDが渡されます。

**主要な操作・処理内容**：
1. 宛先ユーザーの確認 - 送信対象ユーザーの名前が読み取り専用で表示されます（変更不可）
2. 件名の入力 - メールの件名を必須項目として入力します
3. メール作成の実行 - 「Create」ボタンをクリックしてメールのドラフト（下書き）を作成します
4. 作成のキャンセル - 「Cancel」ボタンでダイアログを閉じます

**画面遷移**：この画面はAjaxダイアログとして表示されます。メール作成成功後、自動的にメール編集画面（/admin/mail/edit/id/{新規メールID}/）に遷移し、本文の編集が可能になります。キャンセル時はダイアログが閉じて元の画面に戻ります。

**権限による表示制御**：本画面を利用するには「mmail」（メール管理）権限および「mmailnew」（メール新規作成）権限の両方が必要です。権限がない場合は権限エラー画面に転送されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 59 | メール送信 | 主機能 | ユーザー別メール送信設定 |
| 61 | アクセス制御 | 補助機能 | 管理者権限チェック |

## 画面種別

登録（Ajaxダイアログ）

## URL/ルーティング

- URL: `/admin/mail/mailuser/id/{ユーザーID}/`
- モジュール: admin
- コントローラー: MailController
- アクション: mailuserAction

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| ユーザーID | id | integer | 必須 | 入力（URL） | 送信対象ユーザーのID | URLパラメータから取得 |
| 件名 | subject | string | 必須 | 入力 | メールの件名 | NotEmpty, StringTrim |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| To User | ValidationTextBox (読取専用) | 宛先ユーザー名の表示 |
| Subject | ValidationTextBox | 件名入力フィールド |
| Create | Button | メール作成ボタン |
| Cancel | Button | キャンセルボタン |

## イベント仕様

### 1-Createボタン押下

1. フォームバリデーションを実行
2. `doDialog('/admin/mail/mailuser/id/{ユーザーID}/','mailuserForm','New Mail')` を呼び出し
3. Ajax経由でPOSTリクエストを送信
4. 入力値が有効な場合、Mailモデルの`newMail()`を呼び出しメールレコードを作成
5. 成功時、「Mail Created」メッセージと「Continue」ボタンを表示
6. 「Continue」ボタン押下でメール編集画面へ遷移

### 2-Cancelボタン押下

1. `dijit.byId('ajaxDialog').hide()` を呼び出し
2. ダイアログを閉じて元の画面に戻る

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Createボタン押下 | mail | INSERT | 新規メールレコードを作成 |

### テーブル別更新項目詳細

#### mail

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | mail_type | 'U' | ユーザー別メールを示す固定値 |
| INSERT | mail_slave | URLパラメータのユーザーID | id パラメータの値 |
| INSERT | mail_subject | 入力された件名 | subject パラメータの値 |
| INSERT | mail_status | 'draft' | 初期状態は下書き |
| INSERT | mail_text | NULL | 本文は後で編集 |
| INSERT | mail_html | NULL | HTML本文は後で編集 |
| INSERT | mail_user | ログインユーザーのID | 作成者 |
| INSERT | mail_date | NOW() | 作成日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | Mail Created | メール作成成功時 |
| MSG002 | エラー | Subject is required | 件名が未入力 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | privilegesアクションに転送し、権限エラー画面を表示 |
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |

## 備考

- 本画面はDojo Toolkitのdijit.Dialogとして表示されるAjax画面です
- レイアウトは無効化されており、ダイアログコンテンツのみがレンダリングされます
- 宛先ユーザーはMUserDetails()ビューヘルパーにより表示名が取得されます
- メール作成後、本文の編集はメール編集画面（edit.phtml）で行います
- ロール別メール（mail_type='R'）との違いは、特定の1ユーザーのみが対象となる点です

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、メールデータの構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mail.php | `application/models/Mail.php` | メールモデルの構造、newMail()メソッド（310-328行目）でのデータ挿入処理を確認 |

**読解のコツ**: mail_type='U'はユーザー別メールを示し、mail_slaveには対象ユーザーのIDが格納されます。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MailController.php | `application/modules/admin/controllers/MailController.php` | mailuserAction()（430-507行目）がエントリーポイント |

**主要処理フロー**:
1. **432-433行目**: 権限チェック（mmail および mmailnew）
2. **434行目**: レイアウト無効化
3. **439行目**: URLパラメータからユーザーIDを取得
4. **441行目**: POSTリクエスト判定
5. **445-450行目**: 入力フィルタ定義（件名のみ）
6. **452-458行目**: バリデータ定義
7. **461行目**: 入力検証実行
8. **463-473行目**: 検証成功時、newMail()でmail_type='U'としてメール作成
9. **475-480行目**: 成功メッセージとContinueボタン表示

#### Step 3: ビューテンプレートを理解する

画面表示のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mailuser.phtml | `application/modules/admin/views/scripts/mail/mailuser.phtml` | フォーム構造とDojo widgetの設定を確認 |

**主要処理フロー**:
- **9行目**: posted=='N'でフォーム表示判定
- **14-23行目**: ユーザー名表示ValidationTextBox（readonly）
- **27-38行目**: 件名入力ValidationTextBox
- **42-53行目**: CreateボタンとCancelボタン

### プログラム呼び出し階層図

```
[ブラウザ] Ajaxリクエスト（/admin/mail/mailuser/id/{userID}/）
    │
    ├─ MailController::mailuserAction()
    │      │
    │      ├─ ACL権限チェック
    │      │
    │      ├─ ユーザーID取得（URLパラメータ）
    │      │
    │      ├─ Zend_Filter_Input (入力検証)
    │      │
    │      └─ Mail::newMail()
    │             │
    │             └─ registry->db->insert('mail', $data)
    │                  └─ mail_type = 'U'
    │                  └─ mail_slave = userID
    │
    └─ mailuser.phtml (ビューレンダリング)
           │
           └─ MUserDetails() (ユーザー名取得)
```

### データフロー図

```
[入力]               [処理]                    [出力]

id (ユーザーID) ────┐
     (URLパラメータ)│
                   ├──▶ MailController        ┌──▶ 成功時: Mail Created
                   │    ::mailuserAction()    │    + Continueボタン
subject (件名) ────┤           │              │
                   │    Mail::newMail()       ├──▶ 失敗時: エラーメッセージ
user_id ───────────┘           │              │    + フォーム再表示
 (ログインユーザー)            ▼              │
                        mailテーブル ─────────┘
                        (mail_type='U')
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MailController.php | `application/modules/admin/controllers/MailController.php` | コントローラー | mailuserアクションの実行 |
| Mail.php | `application/models/Mail.php` | モデル | メールデータの操作 |
| mailuser.phtml | `application/modules/admin/views/scripts/mail/mailuser.phtml` | テンプレート | 画面表示 |
| admin.phtml | `application/layouts/scripts/admin.phtml` | レイアウト | 管理画面共通レイアウト（ただし無効化） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog()関数の定義 |
