# 画面設計書 73-設定画面

## 概要

本ドキュメントは、Legacy CMSの管理画面における設定画面（settings/index.phtml）の設計仕様を記載したものです。

### 本画面の処理概要

本画面は、ログイン中の管理者が自身のプロフィール情報およびパスワードを管理するための画面です。タブ形式で複数の設定セクションを切り替えて利用できます。

**業務上の目的・背景**：システム管理者は自身のアカウント情報を最新の状態に保つ必要があります。特に連絡先情報（メールアドレス、電話番号）の更新や、セキュリティ上必要なパスワードの定期変更を容易に行えるようにすることで、アカウント管理の効率化とセキュリティ向上を実現します。また、ユーザーの紹介文（Blurb）を設定することで、記事投稿時などに著者情報として表示することができます。

**画面へのアクセス方法**：管理画面のサイドメニューまたはヘッダーの「Settings」リンクをクリックしてアクセスします。URLは `/admin/settings/` です。

**主要な操作・処理内容**：
1. プロフィール情報の確認・編集 - 名前、エイリアス、メールアドレス、電話番号、紹介文の表示と編集
2. パスワードの変更 - 現在のパスワードを確認した上で、新しいパスワードを設定
3. アカウント詳細の確認 - アカウント作成日、最終更新日、投稿コメント数の確認

**画面遷移**：管理ダッシュボードからアクセスできます。プロフィール更新・パスワード変更の処理結果はAjaxダイアログで表示されます。設定画面からは他の管理画面に遷移可能です。

**権限による表示制御**：本画面を利用するには「gadmin」（管理画面アクセス）権限が必要です。ロールは読み取り専用で表示され、変更はできません。コメント一覧へのリンクは「gcomments」権限がある場合のみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | アクセス制御 | 主機能 | システム設定の一覧を表示 |

## 画面種別

編集（タブ形式）

## URL/ルーティング

- URL: `/admin/settings/`
- モジュール: admin
- コントローラー: SettingsController
- アクション: indexAction

## 入出力項目

### Profileタブ

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| 名 | first | string | 必須 | 入出力 | ユーザーの名 | NotEmpty |
| 姓 | last | string | 必須 | 入出力 | ユーザーの姓 | NotEmpty |
| エイリアス | alias | string | 必須 | 入出力 | ユーザーの表示名 | NotEmpty, Alnum, 一意性チェック |
| ロール | role | string | - | 出力 | ユーザーの役割（読取専用） | - |
| メールアドレス | email | string | 必須 | 入出力 | 連絡先メールアドレス | NotEmpty, EmailAddress, 一意性チェック |
| 電話番号 | phone | string | 任意 | 入出力 | 連絡先電話番号 | - |
| 紹介文 | blurb | text | 任意 | 入出力 | ユーザーの紹介文 | - |

### Passwordタブ

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| 現在のパスワード | oldpassword | string | 必須 | 入力 | 認証用 | NotEmpty, 8文字以上 |
| 新しいパスワード | password | string | 必須 | 入力 | 変更後のパスワード | NotEmpty, 8文字以上 |
| パスワード確認 | password2 | string | 必須 | 入力 | 確認用再入力 | NotEmpty, passwordと一致 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| First Name | ValidationTextBox | 名入力フィールド |
| Last Name | ValidationTextBox | 姓入力フィールド |
| Alias | ValidationTextBox | エイリアス入力フィールド |
| Role | FilteringSelect（読取専用） | ロール表示 |
| E-mail Address | ValidationTextBox | メールアドレス入力フィールド |
| Phone Number | ValidationTextBox | 電話番号入力フィールド |
| Blurb | SimpleTextarea | 紹介文入力エリア |
| Account Created | テキスト | アカウント作成日 |
| Last Updated | テキスト | 最終更新日時 |
| Comments | リンク | コメント数とコメント管理画面へのリンク |

## イベント仕様

### 1-Update Profileボタン押下

1. profileFormのバリデーションを実行
2. `postDialog('/admin/settings/profile/','profileForm','Update Profile','1')` を呼び出し
3. Ajax経由でPOSTリクエストを送信
4. SettingsController::profileAction()でバリデーション実行
5. 入力値が有効な場合、usersテーブルとusers_profilesテーブルを更新
6. 成功時、「Profile Updated」メッセージを表示

### 2-Change Passwordボタン押下

1. passwordFormのバリデーションを実行
2. `postDialog('/admin/settings/password/','passwordForm','Change Password','0')` を呼び出し
3. Ajax経由でPOSTリクエストを送信
4. 現在のパスワードの認証を実行
5. 認証成功時、新しいパスワードのバリデーション実行
6. 新しいパスワードをソルト付きMD5でハッシュ化して保存
7. 成功時、「Password Changed」メッセージを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Update Profileボタン押下 | users | UPDATE | エイリアス、メールアドレスを更新 |
| Update Profileボタン押下 | users_profiles | UPDATE | プロフィール情報を更新 |
| Change Passwordボタン押下 | users | UPDATE | パスワードとソルトを更新 |

### テーブル別更新項目詳細

#### users（プロフィール更新時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | user_alias | 入力されたエイリアス | 一意性チェック済み |
| UPDATE | user_email | 入力されたメールアドレス | 一意性チェック済み |

#### users_profiles（プロフィール更新時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | upro_first | 入力された名 | |
| UPDATE | upro_last | 入力された姓 | |
| UPDATE | upro_phone | 入力された電話番号 | |
| UPDATE | upro_blurb | 入力された紹介文 | |
| UPDATE | upro_date | NOW() | 更新日時 |

#### users（パスワード変更時）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | user_password | MD5(site_key + 新パスワード + ソルト) | ソルト付きハッシュ |
| UPDATE | user_salt | 新規生成されたソルト | 8文字のランダム文字列 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | Profile Updated | プロフィール更新成功時 |
| MSG002 | 成功 | Password Changed | パスワード変更成功時 |
| MSG003 | エラー | First Name is required | 名が未入力 |
| MSG004 | エラー | Last Name is required | 姓が未入力 |
| MSG005 | エラー | Alias is required | エイリアスが未入力 |
| MSG006 | エラー | Invalid Alias | エイリアスに不正な文字 |
| MSG007 | エラー | Alias in use | エイリアスが既に使用中 |
| MSG008 | エラー | E-mail Address is required | メールアドレスが未入力 |
| MSG009 | エラー | Invalid E-mail Address | メールアドレス形式不正 |
| MSG010 | エラー | E-mail Address in use | メールアドレスが既に使用中 |
| MSG011 | エラー | Invalid Current Password | 現在のパスワードが不正 |
| MSG012 | エラー | Invalid Password - passwords must be at least 8 characters | パスワードが8文字未満 |
| MSG013 | エラー | Invalid Passwords - new passwords don't match | パスワード確認が不一致 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | privilegesアクションに転送し、権限エラー画面を表示 |
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |
| 現在のパスワード不正 | エラーメッセージを表示 |

## 備考

- 本画面はDojo Toolkit TabContainerを使用したタブ形式の画面です
- プロフィール更新とパスワード変更は別々のフォームとして処理されます
- パスワードは8文字以上の長さが必要です
- パスワードのハッシュ化にはサイトキーとソルトを使用したMD5が使用されています
- ロールは表示のみで変更不可（readonly属性）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ユーザーデータの構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SettingsController.php | `application/modules/admin/controllers/SettingsController.php` | indexAction()（285-327行目）でのデータ取得クエリを確認 |

**読解のコツ**: usersテーブル、users_profilesテーブル、users_rolesテーブルの3つがJOINされてユーザー情報が取得されます。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SettingsController.php | `application/modules/admin/controllers/SettingsController.php` | indexAction()がメイン画面表示、profileAction()がプロフィール更新、passwordAction()がパスワード変更 |

**主要処理フロー（indexAction）**:
1. **287行目**: 権限チェック（gadmin）
2. **289行目**: レイアウト設定
3. **291行目**: ログインユーザーIDの取得
4. **297-302行目**: users, users_profiles, users_rolesをJOINしてデータ取得
5. **307行目**: ビューにデータを渡す

**主要処理フロー（profileAction）**:
1. **170-171行目**: 権限チェックとレイアウト無効化
2. **183-210行目**: バリデータ定義（一意性チェック含む）
3. **218-227行目**: usersテーブル更新
4. **230-239行目**: users_profilesテーブル更新

**主要処理フロー（passwordAction）**:
1. **42-45行目**: 権限チェックとレイアウト無効化
2. **57-61行目**: 現在のパスワード認証
3. **72-93行目**: 新パスワードのバリデーション
4. **99-108行目**: パスワードハッシュ化と保存

#### Step 3: ビューテンプレートを理解する

画面表示のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.phtml | `application/modules/admin/views/scripts/settings/index.phtml` | タブ構造とフォーム構成を確認 |
| 3-2 | details.phtml | `application/modules/admin/views/scripts/settings/details.phtml` | アカウント詳細情報の表示 |

**主要処理フロー（index.phtml）**:
- **39-40行目**: TabContainerの開始
- **40-161行目**: Profileタブ（プロフィールフォーム）
- **163-225行目**: Passwordタブ（パスワード変更フォーム）
- **37行目**: detailsResponse ContentPaneで詳細情報を非同期読み込み

### プログラム呼び出し階層図

```
[ブラウザ] /admin/settings/
    │
    ├─ SettingsController::indexAction()
    │      │
    │      ├─ ACL権限チェック（gadmin）
    │      │
    │      ├─ DB: SELECT users + users_profiles + users_roles
    │      │
    │      └─ index.phtml レンダリング
    │             │
    │             └─ Ajax: /admin/settings/details/
    │                    │
    │                    └─ SettingsController::detailsAction()
    │
    ├─ [Profileタブ] Update Profile ボタン
    │      │
    │      └─ Ajax POST: /admin/settings/profile/
    │             │
    │             ├─ Zend_Filter_Input (バリデーション)
    │             │
    │             ├─ DB: UPDATE users
    │             │
    │             └─ DB: UPDATE users_profiles
    │
    └─ [Passwordタブ] Change Password ボタン
           │
           └─ Ajax POST: /admin/settings/password/
                  │
                  ├─ 現在のパスワード認証
                  │
                  ├─ Zend_Filter_Input (バリデーション)
                  │
                  └─ DB: UPDATE users (password, salt)
```

### データフロー図

```
[入力]               [処理]                    [出力]

                     indexAction()
user_id ──────────▶  DB SELECT ──────────────▶ 画面表示（タブ形式）
                         │
                         └─ users
                         └─ users_profiles
                         └─ users_roles

[Profileタブ]
first, last,         profileAction()
alias, email, ──────▶  バリデーション ────────▶ DB UPDATE
phone, blurb              │                    └─ users
                          │                    └─ users_profiles
                          │
                          └─────────────────────▶ 結果表示

[Passwordタブ]
oldpassword,         passwordAction()
password, ──────────▶  認証 + バリデーション ──▶ DB UPDATE
password2                 │                    └─ users
                          │                      (password, salt)
                          └─────────────────────▶ 結果表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SettingsController.php | `application/modules/admin/controllers/SettingsController.php` | コントローラー | 設定画面の各アクションを実行 |
| index.phtml | `application/modules/admin/views/scripts/settings/index.phtml` | テンプレート | 設定画面のメイン表示 |
| details.phtml | `application/modules/admin/views/scripts/settings/details.phtml` | テンプレート | アカウント詳細情報の表示 |
| admin.phtml | `application/layouts/scripts/admin.phtml` | レイアウト | 管理画面共通レイアウト |
| user.js | `public/_scripts/admin/user.js` | JavaScript | パスワードチェック関数など |
| common.js | `public/_scripts/admin/common.js` | JavaScript | postDialog()関数の定義 |
