# 画面設計書 74-設定詳細画面

## 概要

本ドキュメントは、Legacy CMSの管理画面における設定詳細画面（settings/details.phtml）の設計仕様を記載したものです。

### 本画面の処理概要

本画面は、設定画面（index.phtml）内でAjax経由で読み込まれる部分ビューであり、ログイン中ユーザーのアカウント詳細情報を表示します。

**業務上の目的・背景**：ユーザーが自身のアカウントステータスを把握できるよう、アカウントの作成日時や最終更新日時といったメタ情報を提供します。また、投稿したコメント数へのクイックアクセスを提供することで、自身の活動履歴を簡単に確認できるようにします。

**画面へのアクセス方法**：この画面は設定画面（/admin/settings/）に埋め込まれたContentPaneとして自動的にAjax読み込みされます。URL `/admin/settings/details/` に直接アクセスすることも可能ですが、通常は設定画面の一部として表示されます。

**主要な操作・処理内容**：
1. アカウント作成日の確認 - ユーザーアカウントが作成された日時を表示
2. 最終更新日の確認 - プロフィール情報が最後に更新された日時を表示
3. コメント数の確認 - ユーザーが投稿したコメント数を表示（権限がある場合はコメント管理画面へのリンク付き）

**画面遷移**：この画面自体は部分ビューのため独立した遷移はありません。「Comments」リンクをクリックするとコメント管理画面（/admin/comments/manage/author/{user_id}/）に遷移します。

**権限による表示制御**：本画面を利用するには「gadmin」（管理画面アクセス）権限が必要です。コメント数とコメント管理画面へのリンクは「gcomments」権限がある場合のみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 61 | アクセス制御 | 主機能 | 設定項目の詳細編集 |
| 63 | 入力検証 | 補助機能 | 設定フォームのバリデーション |

## 画面種別

詳細（部分ビュー/Ajax読み込み）

## URL/ルーティング

- URL: `/admin/settings/details/`
- モジュール: admin
- コントローラー: SettingsController
- アクション: detailsAction

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| なし | - | - | - | - | 本画面は表示専用 | - |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| Account Created | テキスト（日付） | ユーザーアカウントの作成日（d/m/Y形式） |
| Last Updated | テキスト（日時） | プロフィールの最終更新日時（d/m/Y H:i形式） |
| Comments | リンク+件数 | コメント数とコメント管理画面へのリンク |

## イベント仕様

### 1-Commentsリンククリック

1. コメント管理画面（/admin/comments/manage/author/{user_id}/）へ遷移
2. 当該ユーザーが投稿したコメントの一覧が表示される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | users, users_profiles, users_roles | SELECT | ユーザー情報を取得 |

### テーブル別更新項目詳細

本画面はデータ更新を行いません（参照のみ）。

## メッセージ仕様

本画面にはメッセージ表示機能はありません。

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | privilegesアクションに転送し、権限エラー画面を表示 |

## 備考

- 本画面はレイアウトが無効化された部分ビューです
- 設定画面のContentPaneとして非同期読み込みされます
- CCount()ビューヘルパーでコメント数を取得します
- MakeDate()ビューヘルパーで日付フォーマットを行います

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ユーザーデータの構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SettingsController.php | `application/modules/admin/controllers/SettingsController.php` | detailsAction()（332-361行目）でのデータ取得クエリを確認 |

**読解のコツ**: usersテーブル、users_profilesテーブル、users_rolesテーブルの3つがJOINされてユーザー情報が取得されます。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SettingsController.php | `application/modules/admin/controllers/SettingsController.php` | detailsAction()がエントリーポイント |

**主要処理フロー（detailsAction）**:
1. **334行目**: 権限チェック（gadmin）
2. **336行目**: レイアウト無効化
3. **338行目**: ログインユーザーIDの取得
4. **344-349行目**: users, users_profiles, users_rolesをJOINしてデータ取得
5. **354行目**: ビューにデータを渡す

#### Step 3: ビューテンプレートを理解する

画面表示のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | details.phtml | `application/modules/admin/views/scripts/settings/details.phtml` | 表示内容とビューヘルパーの使用を確認 |

**主要処理フロー（details.phtml）**:
- **15行目**: MakeDate()で作成日をフォーマット（d/m/Y形式）
- **16行目**: MakeDate()で更新日時をフォーマット（d/m/Y H:i形式）
- **17行目**: gcomments権限チェック後、CCount()でコメント数を表示

### プログラム呼び出し階層図

```
[設定画面 index.phtml]
    │
    └─ ContentPane (Ajax読み込み)
           │
           └─ /admin/settings/details/
                  │
                  ├─ SettingsController::detailsAction()
                  │      │
                  │      ├─ ACL権限チェック（gadmin）
                  │      │
                  │      ├─ レイアウト無効化
                  │      │
                  │      └─ DB: SELECT users + users_profiles + users_roles
                  │
                  └─ details.phtml レンダリング
                         │
                         ├─ MakeDate() ビューヘルパー
                         │
                         └─ CCount() ビューヘルパー（gcomments権限時）
```

### データフロー図

```
[入力]               [処理]                    [出力]

                     detailsAction()
user_id ──────────▶  DB SELECT ──────────────▶ details.phtml
(セッション)              │                         │
                         │                         ├─ Account Created
                         │                         ├─ Last Updated
                         │                         └─ Comments (件数+リンク)
                         └─ users
                         └─ users_profiles
                         └─ users_roles
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SettingsController.php | `application/modules/admin/controllers/SettingsController.php` | コントローラー | detailsアクションの実行 |
| details.phtml | `application/modules/admin/views/scripts/settings/details.phtml` | テンプレート | 詳細情報の表示 |
| index.phtml | `application/modules/admin/views/scripts/settings/index.phtml` | テンプレート | 親画面（設定画面） |
