# 画面設計書 75-アセット管理画面

## 概要

本ドキュメントは、Legacy CMSの管理画面におけるアセット管理画面（assets/index.phtml）の設計仕様を記載したものです。

### 本画面の処理概要

本画面は、画像・動画・ドキュメントなどのアセットファイルをフォルダ形式で管理するためのファイルブラウザ画面です。

**業務上の目的・背景**：コンテンツ管理システムでは、記事やページに挿入する画像やドキュメントファイルを一元管理する必要があります。本画面はファイルエクスプローラーのようなUIを提供し、フォルダ構造でアセットを整理できます。また、記事編集画面からモーダルダイアログとして呼び出すことで、ファイル選択機能も提供します。

**画面へのアクセス方法**：
- 管理画面のサイドメニューから「Assets」をクリック
- 記事編集画面のWYSIWYGエディタから画像挿入時にポップアップとして表示
- URLパラメータでフォルダID、表示タイプ、コールバックメソッドなどを指定可能

**主要な操作・処理内容**：
1. フォルダ一覧表示 - 現在のフォルダ内のサブフォルダを一覧表示
2. アセット一覧表示 - 現在のフォルダ内のファイルを一覧表示（サムネイル付き）
3. フォルダ操作 - フォルダの新規作成、編集、削除、プロパティ確認
4. アセット操作 - アセットの編集、削除、プロパティ確認、ダウンロード、選択
5. 親フォルダへの移動 - パンくずナビゲーションで上位フォルダへ移動
6. アセット選択 - 記事編集時のファイル選択機能

**画面遷移**：
- フォルダクリック: 選択したフォルダ内を表示
- アップロードボタン: アップロード画面へ遷移
- 各種操作ボタン: Ajaxダイアログで操作画面を表示
- 選択完了: 呼び出し元画面へ選択結果を返却

**権限による表示制御**：本画面を利用するには「fassets」（アセット管理）権限が必要です。各操作には追加権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | ファイル管理 | 主機能 | アセットファイルの一覧を表示 |
| 61 | アクセス制御 | 補助機能 | アセット管理の権限チェック |

## 画面種別

一覧

## URL/ルーティング

- URL: `/admin/assets/`、`/admin/assets/index/folder/{folderID}/`
- モジュール: admin
- コントローラー: AssetsController
- アクション: indexAction

### URLパラメータ

| パラメータ名 | 必須 | 説明 |
|------------|------|------|
| folder | 任意 | 表示するフォルダのID（デフォルト: 0 = ルート） |
| type | 任意 | 表示タイプ（image, file など） |
| method | 任意 | 選択時のコールバックメソッド |
| field | 任意 | 選択結果を格納するフィールド名 |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| なし | - | - | - | - | 本画面は表示専用 | - |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| フォルダ一覧 | リスト | サブフォルダの一覧（アイコン+名前） |
| アセット一覧 | リスト | ファイルの一覧（サムネイル+名前） |
| パンくず | リンク | 現在のフォルダパス |
| Upload | ボタン | アップロード画面へのリンク |
| New Folder | ボタン | フォルダ新規作成ダイアログ |

### フォルダ操作ボタン

| ボタン名 | 表示条件 | 説明 |
|---------|----------|------|
| Edit | ffolderedit権限 | フォルダ名編集 |
| Properties | 常時 | フォルダプロパティ表示 |
| Delete | ffolderdelete権限 | フォルダ削除 |

### アセット操作ボタン

| ボタン名 | 表示条件 | 説明 |
|---------|----------|------|
| Edit | fassetedit権限 | アセット名編集 |
| Properties | 常時 | アセットプロパティ表示 |
| Delete | fassetdelete権限 | アセット削除 |
| Download | 常時 | ファイルダウンロード |
| Select/Insert | 選択モード時 | アセット選択 |

## イベント仕様

### 1-フォルダクリック

1. フォルダIDをパラメータとして本画面を再読み込み
2. クリックしたフォルダの内容を表示

### 2-Uploadボタン押下

1. アップロード画面（/admin/assets/upload/）へ遷移
2. 現在のフォルダID、type、method、fieldパラメータを引き継ぐ

### 3-New Folderボタン押下

1. `getDialog('/admin/assets/foldernew/parent/{folderID}/','New Folder')` を呼び出し
2. フォルダ新規作成ダイアログを表示

### 4-フォルダ/アセット操作ボタン

各ボタンに応じてAjaxダイアログを表示し、対応する操作画面を表示

### 5-Select/Insertボタン押下

1. 選択モードの場合、指定されたmethodを呼び出してアセット情報を返却
2. ウィンドウを閉じて呼び出し元画面に戻る

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | assets_folders | SELECT | フォルダ情報を取得 |
| 画面表示 | assets | SELECT | アセット情報を取得 |

### テーブル別更新項目詳細

本画面ではデータ更新を行いません（参照のみ）。各操作ダイアログで更新処理が行われます。

## メッセージ仕様

本画面にはメッセージ表示機能はありません。

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | privilegesアクションに転送し、権限エラー画面を表示 |

## 備考

- 本画面は専用レイアウト（assets.phtml）を使用します
- フォルダIDが0の場合はルートフォルダを表示します
- typeパラメータにより、表示するアセットの種類をフィルタリングできます
- methodパラメータにより、選択完了時のコールバック関数を指定できます
- アセットのサムネイルはPhpThumbFactoryライブラリで生成されます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アセットとフォルダのデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | indexAction()（59-115行目）でのデータ取得クエリを確認 |

**読解のコツ**: assets_foldersテーブルとassetsテーブルは別々に取得されます。folder_parent列で階層構造を管理しています。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | indexAction()がエントリーポイント |

**主要処理フロー（indexAction）**:
1. **61行目**: 権限チェック（fassets）
2. **63行目**: アセット専用レイアウト設定
3. **65-68行目**: URLパラメータ（type, folder, method, field）の取得
4. **70-72行目**: フォルダIDのデフォルト値設定（0=ルート）
5. **77-88行目**: 親フォルダ情報の取得（ルート以外の場合）
6. **92-96行目**: サブフォルダ一覧の取得（folder_parent条件）
7. **101-105行目**: アセット一覧の取得（asset_folder条件）

#### Step 3: ビューテンプレートを理解する

画面表示のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.phtml | `application/modules/admin/views/scripts/assets/index.phtml` | フォルダ一覧とアセット一覧の表示構造を確認 |

**主要処理フロー（index.phtml）**:
- **8-16行目**: パンくずナビゲーション（親フォルダへのリンク）
- **20-39行目**: 操作ボタン（Upload, New Folder）
- **41-99行目**: フォルダ一覧ループ（各フォルダの操作メニュー）
- **101-168行目**: アセット一覧ループ（各アセットの操作メニュー）

### プログラム呼び出し階層図

```
[ブラウザ] /admin/assets/index/folder/{folderID}/
    │
    ├─ AssetsController::indexAction()
    │      │
    │      ├─ ACL権限チェック（fassets）
    │      │
    │      ├─ setLayout('assets')
    │      │
    │      ├─ URLパラメータ取得（type, folder, method, field）
    │      │
    │      ├─ DB: SELECT assets_folders WHERE folder_id = {folderID}
    │      │      （親フォルダ情報取得）
    │      │
    │      ├─ DB: SELECT assets_folders WHERE folder_parent = {folderID}
    │      │      （サブフォルダ一覧取得）
    │      │
    │      └─ DB: SELECT assets WHERE asset_folder = {folderID}
    │             （アセット一覧取得）
    │
    └─ index.phtml レンダリング
           │
           ├─ パンくずナビゲーション
           ├─ 操作ボタン
           ├─ フォルダ一覧
           └─ アセット一覧
                  │
                  └─ サムネイル表示: /admin/assets/thumb/
```

### データフロー図

```
[入力]               [処理]                    [出力]

folder ───────────▶ indexAction()
type ─────────────▶      │
method ───────────▶      ├─ DB: assets_folders ──▶ フォルダ一覧
field ────────────▶      │                         (操作メニュー付き)
                         │
                         └─ DB: assets ───────────▶ アセット一覧
                                                    (サムネイル付き)
                                                    (操作メニュー付き)

[操作]               [処理]                    [出力]
フォルダクリック ─────▶ 画面リロード ───────────▶ サブフォルダ表示
Upload ───────────────▶ /admin/assets/upload/
New Folder ───────────▶ Ajaxダイアログ
各種操作ボタン ───────▶ Ajaxダイアログ
Select ───────────────▶ コールバック呼び出し ──▶ 呼び出し元へ返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | アセット管理の各アクションを実行 |
| index.phtml | `application/modules/admin/views/scripts/assets/index.phtml` | テンプレート | アセット管理画面のメイン表示 |
| assets.phtml | `application/layouts/scripts/assets.phtml` | レイアウト | アセット管理専用レイアウト |
| upload.phtml | `application/modules/admin/views/scripts/assets/upload.phtml` | テンプレート | アップロード画面 |
| foldernew.phtml | `application/modules/admin/views/scripts/assets/foldernew.phtml` | テンプレート | フォルダ新規作成ダイアログ |
| folder.phtml | `application/modules/admin/views/scripts/assets/folder.phtml` | テンプレート | フォルダ編集ダイアログ |
| asset.phtml | `application/modules/admin/views/scripts/assets/asset.phtml` | テンプレート | アセット編集ダイアログ |
| properties.phtml | `application/modules/admin/views/scripts/assets/properties.phtml` | テンプレート | アセットプロパティダイアログ |
| common.js | `public/_scripts/admin/common.js` | JavaScript | getDialog()関数の定義 |
