# 画面設計書 76-アップロード画面

## 概要

本ドキュメントは、Legacy CMSの管理画面におけるアップロード画面（assets/upload.phtml）の設計仕様を記載したものです。

### 本画面の処理概要

本画面は、アセット管理システムにファイルをアップロードするための画面です。Flash（SWFUpload）またはHTML5を使用した複数ファイルの一括アップロード機能を提供します。

**業務上の目的・背景**：コンテンツ管理において、複数のファイルを効率的にアップロードする必要があります。本画面はドラッグ＆ドロップによる直感的な操作と、アップロード進捗の可視化により、大量のファイルアップロード作業を効率化します。

**画面へのアクセス方法**：
- アセット管理画面（/admin/assets/）の「Upload」ボタンをクリック
- URLパラメータでアップロード先フォルダID、表示タイプ、コールバックメソッドなどを指定可能

**主要な操作・処理内容**：
1. ファイル選択 - ファイル選択ダイアログまたはドラッグ＆ドロップでアップロードファイルを選択
2. アップロード実行 - 選択したファイルを順次サーバーにアップロード
3. 進捗表示 - 各ファイルのアップロード進捗をプログレスバーで表示
4. 完了確認 - アップロード完了後、アセット管理画面に戻る

**画面遷移**：アセット管理画面から遷移します。アップロード完了後は「Back」ボタンでアセット管理画面に戻ります。

**権限による表示制御**：本画面を利用するには「fassets」（アセット管理）権限および「fassetupload」（アセットアップロード）権限の両方が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | ファイル管理 | 主機能 | アセットファイルのアップロード |
| 61 | アクセス制御 | 補助機能 | アセット管理の権限チェック |

## 画面種別

登録

## URL/ルーティング

- URL: `/admin/assets/upload/folder/{folderID}/`
- モジュール: admin
- コントローラー: AssetsController
- アクション: uploadAction

### URLパラメータ

| パラメータ名 | 必須 | 説明 |
|------------|------|------|
| folder | 任意 | アップロード先フォルダのID（デフォルト: 0 = ルート） |
| type | 任意 | 表示タイプ（image, file など） |
| method | 任意 | 選択時のコールバックメソッド |
| field | 任意 | 選択結果を格納するフィールド名 |

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| ファイル | Filedata | file | 必須 | 入力 | アップロードするファイル | ファイル形式チェック |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ファイル選択エリア | ドロップゾーン | ドラッグ＆ドロップまたはクリックでファイル選択 |
| アップロード進捗 | プログレスバー | 各ファイルのアップロード進捗 |
| ファイル一覧 | リスト | 選択されたファイルの一覧 |
| Back | ボタン | アセット管理画面へ戻る |

## イベント仕様

### 1-ファイル選択

1. ファイル選択ダイアログを開く、またはドラッグ＆ドロップを受け付け
2. 選択されたファイルをアップロードキューに追加
3. 自動的にアップロードを開始

### 2-アップロード実行

1. 各ファイルをAjax経由で`/admin/assets/receive/folder/{folderID}/`にPOST
2. サーバー側でファイルを保存し、assetsテーブルにレコードを作成
3. 成功時は「1」、失敗時は「0」をレスポンスとして返却
4. 進捗バーを更新

### 3-Backボタン押下

1. アセット管理画面（/admin/assets/index/folder/{folderID}/）へ遷移
2. type, method, fieldパラメータを引き継ぐ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アップロード実行 | assets | INSERT | 新規アセットレコードを作成 |

### テーブル別更新項目詳細

#### assets（receiveAction経由）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | asset_folder | URLパラメータのフォルダID | folder パラメータの値 |
| INSERT | asset_key | MD5(ファイルパス) | ファイル識別キー |
| INSERT | asset_name | アップロードファイルのファイル名（拡張子なし） | |
| INSERT | asset_extension | アップロードファイルの拡張子 | |
| INSERT | asset_file | サーバー上のファイルパス | tempnam()で生成 |
| INSERT | asset_mime | ファイルのMIMEタイプ | finfo_file()で判定 |
| INSERT | asset_size | ファイルサイズ（バイト） | |
| INSERT | asset_user | ログインユーザーのID | |
| INSERT | asset_date | NOW() | 作成日時 |
| INSERT | asset_modified | NOW() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | アップロード完了 | アップロード成功時（JSで表示） |
| MSG002 | エラー | 同名ファイルが存在 | 同一フォルダに同名ファイルがある場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | privilegesアクションに転送し、権限エラー画面を表示 |
| 同名ファイル重複 | レスポンス「0」を返却し、エラー表示 |
| ファイル保存失敗 | レスポンス「0」を返却し、エラー表示 |

## 備考

- 本画面は専用レイアウト（assets.phtml）を使用します
- ファイルアップロードにはSWFUploadまたはHTML5 File APIを使用します
- MIMEタイプ判定はWindows環境ではfinfo、それ以外ではfileコマンドを使用
- 同一フォルダに同名（ファイル名+拡張子）のファイルがある場合はアップロード失敗
- アップロードされたファイルはtempnam()で一時ファイル名が割り当てられ、元のファイル名はasset_name列に保存

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アセットのデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | receiveAction()（429-513行目）でのデータ挿入処理を確認 |

**読解のコツ**: assetsテーブルへの挿入処理で、asset_key（MD5ハッシュ）やasset_file（一時ファイルパス）の生成方法を理解することが重要です。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | uploadAction()（120-135行目）が画面表示、receiveAction()がファイル受信処理 |

**主要処理フロー（uploadAction）**:
1. **122行目**: 権限チェック（fassets および fassetupload）
2. **124行目**: アセット専用レイアウト設定
3. **125-128行目**: URLパラメータの取得

**主要処理フロー（receiveAction）**:
1. **431行目**: 権限チェック（fassets および fassetupload）
2. **433-434行目**: レイアウト・ビュー無効化
3. **436行目**: フォルダIDの取得
4. **440-447行目**: アップロードファイル情報の取得
5. **452-461行目**: 同名ファイルの重複チェック
6. **463-475行目**: MIMEタイプ判定
7. **477-492行目**: assetsテーブルへの挿入
8. **494行目**: 成功レスポンス「1」

#### Step 3: ビューテンプレートを理解する

画面表示のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | upload.phtml | `application/modules/admin/views/scripts/assets/upload.phtml` | SWFUpload/HTML5 File APIの設定を確認 |

**主要処理フロー（upload.phtml）**:
- **14-26行目**: ナビゲーションバー（Back to Assetsリンク）
- **28-48行目**: SWFUploadの設定（upload_url、file_post_name等）
- **50-68行目**: アップロードエリアとプログレス表示

### プログラム呼び出し階層図

```
[ブラウザ] /admin/assets/upload/folder/{folderID}/
    │
    ├─ AssetsController::uploadAction()
    │      │
    │      ├─ ACL権限チェック（fassets, fassetupload）
    │      │
    │      ├─ setLayout('assets')
    │      │
    │      └─ URLパラメータ取得
    │
    └─ upload.phtml レンダリング
           │
           └─ SWFUpload / HTML5 File API 初期化
                  │
                  └─ [アップロード実行]
                         │
                         └─ Ajax POST: /admin/assets/receive/folder/{folderID}/
                                │
                                ├─ ACL権限チェック
                                │
                                ├─ 同名ファイル重複チェック
                                │      └─ DB: SELECT assets
                                │
                                ├─ ファイル保存（move_uploaded_file）
                                │
                                ├─ MIMEタイプ判定（finfo/file）
                                │
                                └─ DB: INSERT assets
```

### データフロー図

```
[入力]               [処理]                    [出力]

folder ───────────▶ uploadAction()
type ─────────────▶      │
method ───────────▶      └─ upload.phtml ─────▶ 画面表示
field ────────────▶

[アップロード]       [処理]                    [出力]

Filedata ─────────▶ receiveAction()
folder ───────────▶      │
                         ├─ 重複チェック
                         │
                         ├─ ファイル保存
                         │      └─ tempnam()
                         │
                         ├─ MIMEタイプ判定
                         │      └─ finfo / file
                         │
                         └─ DB: INSERT assets ──▶ "1" or "0"
                               │
                               ├─ asset_key = MD5
                               ├─ asset_name
                               ├─ asset_extension
                               ├─ asset_file
                               ├─ asset_mime
                               ├─ asset_size
                               ├─ asset_user
                               └─ asset_date
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | uploadAction, receiveActionの実行 |
| upload.phtml | `application/modules/admin/views/scripts/assets/upload.phtml` | テンプレート | アップロード画面の表示 |
| assets.phtml | `application/layouts/scripts/assets.phtml` | レイアウト | アセット管理専用レイアウト |
| swfupload.js | `public/_scripts/swfupload/` | JavaScript | SWFUploadライブラリ |
| swfupload.swf | `public/_scripts/swfupload/` | Flash | SWFUploadのFlash部分 |
