# 画面設計書 77-アセット詳細画面

## 概要

本ドキュメントは、Legacy CMSの管理画面におけるアセット詳細画面（assets/asset.phtml）の設計仕様を記載したものです。

### 本画面の処理概要

本画面は、アセット（ファイル）のファイル名を編集するためのAjaxダイアログ画面です。

**業務上の目的・背景**：アップロードしたファイルの名前を変更する必要がある場合に使用します。ファイルの実体（拡張子を含む）は変更せず、表示名（asset_name）のみを編集できます。これにより、整理や命名規則の統一などの運用ニーズに対応します。

**画面へのアクセス方法**：アセット管理画面（/admin/assets/）で対象アセットの「Edit」ボタンをクリックすることで、Ajaxダイアログとして表示されます。

**主要な操作・処理内容**：
1. ファイル名の確認 - 現在のファイル名と拡張子を確認
2. ファイル名の編集 - 新しいファイル名を入力
3. 保存実行 - 「Submit」ボタンで変更を保存
4. キャンセル - 「Cancel」ボタンでダイアログを閉じる

**画面遷移**：アセット管理画面からAjaxダイアログとして呼び出されます。保存成功後は画面をリロードしてダイアログを閉じます。

**権限による表示制御**：本画面を利用するには「fassets」（アセット管理）権限および「fassetedit」（アセット編集）権限の両方が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 62 | ファイル管理 | 主機能 | アセット情報の編集 |
| 61 | アクセス制御 | 補助機能 | アセット管理の権限チェック |

## 画面種別

編集（Ajaxダイアログ）

## URL/ルーティング

- URL: `/admin/assets/asset/asset/{assetID}/`
- モジュール: admin
- コントローラー: AssetsController
- アクション: assetAction

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 入力/出力 | 説明 | バリデーション |
|--------|--------|-----|------|-----------|------|----------------|
| アセットID | asset | integer | 必須 | 入力（URL） | 編集対象アセットのID | URLパラメータから取得 |
| ファイル名 | filename | string | 必須 | 入出力 | アセットのファイル名（拡張子なし） | NotEmpty |
| 拡張子 | extension | string | - | 出力 | ファイルの拡張子（変更不可） | - |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| File Name | ValidationTextBox | ファイル名入力フィールド |
| 拡張子 | テキスト | ファイルの拡張子（読取専用） |
| Submit | Button | 保存ボタン |
| Cancel | Button | キャンセルボタン |

## イベント仕様

### 1-Submitボタン押下

1. フォームバリデーションを実行
2. `doDialog('/admin/assets/asset/asset/{assetID}/','asseteditForm','Edit Asset')` を呼び出し
3. Ajax経由でPOSTリクエストを送信
4. 入力値が有効かつ重複がない場合、assetsテーブルを更新
5. 成功時、「Asset Edited」メッセージと「Close」ボタンを表示
6. 「Close」ボタン押下で画面リロードしてダイアログを閉じる

### 2-Cancelボタン押下

1. `dijit.byId('ajaxDialog').hide()` を呼び出し
2. ダイアログを閉じる

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | assets | SELECT | アセット情報を取得 |
| Submitボタン押下 | assets | SELECT | 同名ファイル重複チェック |
| Submitボタン押下 | assets | UPDATE | アセット名を更新 |

### テーブル別更新項目詳細

#### assets

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | asset_name | 入力されたファイル名 | filename パラメータの値 |
| UPDATE | asset_modified | NOW() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG001 | 成功 | Asset Edited | アセット編集成功時 |
| MSG002 | エラー | Filename is required | ファイル名が未入力 |
| MSG003 | エラー | An asset with this filename already exists in this folder | 同一フォルダに同名ファイルが存在 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|----------|
| 権限不足 | privilegesアクションに転送し、権限エラー画面を表示 |
| バリデーションエラー | エラーメッセージを表示し、フォームを再表示 |
| 同名ファイル重複 | エラーメッセージを表示し、フォームを再表示 |

## 備考

- 本画面はDojo Toolkitのdijit.Dialogとして表示されるAjax画面です
- レイアウトは無効化されており、ダイアログコンテンツのみがレンダリングされます
- 拡張子（asset_extension）は変更できません
- 同一フォルダ内での重複チェックは、asset_folder、asset_id（自身を除く）、asset_name条件で行われます

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アセットのデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | assetAction()（518-626行目）でのデータ取得・更新処理を確認 |

**読解のコツ**: asset_nameとasset_extensionは別々に管理されています。asset_nameのみが編集対象です。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | assetAction()がエントリーポイント |

**主要処理フロー（assetAction）**:
1. **520行目**: 権限チェック（fassets および fassetedit）
2. **522行目**: レイアウト無効化
3. **524行目**: URLパラメータからアセットIDを取得
4. **528-534行目**: アセット情報の取得
5. **538-539行目**: ビューに現在のファイル名と拡張子を設定
6. **541行目**: POSTリクエスト判定
7. **547-553行目**: バリデータ定義
8. **555行目**: 入力検証実行
9. **559-567行目**: 同名ファイル重複チェック
10. **575-584行目**: 検証成功時、assetsテーブルを更新

#### Step 3: ビューテンプレートを理解する

画面表示のテンプレートを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | asset.phtml | `application/modules/admin/views/scripts/assets/asset.phtml` | フォーム構造とDojo widgetの設定を確認 |

**主要処理フロー（asset.phtml）**:
- **9行目**: posted=='N'でフォーム表示判定
- **14-30行目**: ファイル名入力ValidationTextBox
- **31-32行目**: 拡張子の表示（読取専用テキスト）
- **36-47行目**: SubmitボタンとCancelボタン

### プログラム呼び出し階層図

```
[ブラウザ] Ajaxリクエスト（/admin/assets/asset/asset/{assetID}/）
    │
    ├─ AssetsController::assetAction()
    │      │
    │      ├─ ACL権限チェック（fassets, fassetedit）
    │      │
    │      ├─ レイアウト無効化
    │      │
    │      ├─ DB: SELECT assets WHERE asset_id = {assetID}
    │      │
    │      ├─ [POST時] バリデーション
    │      │
    │      ├─ [POST時] 重複チェック
    │      │      └─ DB: SELECT assets
    │      │            WHERE asset_folder = {folder}
    │      │            AND asset_id != {assetID}
    │      │            AND asset_name = {filename}
    │      │
    │      └─ [POST時] DB: UPDATE assets
    │             └─ asset_name, asset_modified
    │
    └─ asset.phtml レンダリング
           │
           ├─ ファイル名入力フィールド
           └─ 拡張子表示（読取専用）
```

### データフロー図

```
[入力]               [処理]                    [出力]

asset (ID) ────────▶ assetAction()
                         │
                         ├─ DB: SELECT assets ────▶ 画面表示
                         │                          (ファイル名, 拡張子)
[POST]
filename ──────────▶     │
                         ├─ バリデーション
                         │
                         ├─ 重複チェック
                         │
                         └─ DB: UPDATE assets ────▶ 結果表示
                               │                    "Asset Edited"
                               ├─ asset_name
                               └─ asset_modified
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AssetsController.php | `application/modules/admin/controllers/AssetsController.php` | コントローラー | assetアクションの実行 |
| asset.phtml | `application/modules/admin/views/scripts/assets/asset.phtml` | テンプレート | アセット編集ダイアログの表示 |
| index.phtml | `application/modules/admin/views/scripts/assets/index.phtml` | テンプレート | 親画面（アセット管理画面） |
| common.js | `public/_scripts/admin/common.js` | JavaScript | doDialog()関数の定義 |
